/*
 * Decompiled with CFR 0.152.
 */
package com.irdstudio.allinapaas.executor.application.executor.core.plugin.market;

import com.alibaba.fastjson.JSON;
import com.irdstudio.allinapaas.design.console.types.MarketSource;
import com.irdstudio.allinapaas.executor.application.executor.core.dao.PaasAppsInfoDao;
import com.irdstudio.allinapaas.executor.application.executor.core.dao.PaasEnvParamDao;
import com.irdstudio.allinapaas.executor.application.executor.core.dao.PaasMarketAppinfoDao;
import com.irdstudio.allinapaas.executor.application.executor.core.dao.SrvErrorMappingDao;
import com.irdstudio.allinapaas.executor.application.executor.core.dao.domain.IsrvEvalInsert;
import com.irdstudio.allinapaas.executor.application.executor.core.dao.domain.IsrvEvalOut;
import com.irdstudio.allinapaas.executor.application.executor.core.dao.domain.IsrvEvalUpdate;
import com.irdstudio.allinapaas.executor.application.executor.core.dao.domain.IsrvSqlCond;
import com.irdstudio.allinapaas.executor.application.executor.core.dao.domain.IsrvSqlInfo;
import com.irdstudio.allinapaas.executor.application.executor.core.dao.domain.ModelFolderInfo;
import com.irdstudio.allinapaas.executor.application.executor.core.dao.domain.ModelTableField;
import com.irdstudio.allinapaas.executor.application.executor.core.dao.domain.ModelTableIndex;
import com.irdstudio.allinapaas.executor.application.executor.core.dao.domain.ModelTableInfo;
import com.irdstudio.allinapaas.executor.application.executor.core.dao.domain.OsrvArrangeSection;
import com.irdstudio.allinapaas.executor.application.executor.core.dao.domain.OsrvArrangeTable;
import com.irdstudio.allinapaas.executor.application.executor.core.dao.domain.OsrvArrangeVar;
import com.irdstudio.allinapaas.executor.application.executor.core.dao.domain.OsrvEvalIsrv;
import com.irdstudio.allinapaas.executor.application.executor.core.dao.domain.OsrvEvalVar;
import com.irdstudio.allinapaas.executor.application.executor.core.dao.domain.PaasAppsInfo;
import com.irdstudio.allinapaas.executor.application.executor.core.dao.domain.PaasAppsParam;
import com.irdstudio.allinapaas.executor.application.executor.core.dao.domain.PaasAppsProperties;
import com.irdstudio.allinapaas.executor.application.executor.core.dao.domain.PaasAppsSql;
import com.irdstudio.allinapaas.executor.application.executor.core.dao.domain.PaasMarketAppinfo;
import com.irdstudio.allinapaas.executor.application.executor.core.dao.domain.SrvErrorMapping;
import com.irdstudio.allinapaas.executor.application.executor.core.dao.domain.SrvEvalFunc;
import com.irdstudio.allinapaas.executor.application.executor.core.dao.domain.SrvModelCondition;
import com.irdstudio.allinapaas.executor.application.executor.core.dao.domain.SrvModelExpression;
import com.irdstudio.allinapaas.executor.application.executor.core.dao.domain.SrvModelExpvar;
import com.irdstudio.allinapaas.executor.application.executor.core.dao.domain.SrvModelFeature;
import com.irdstudio.allinapaas.executor.application.executor.core.dao.domain.SrvModelInfo;
import com.irdstudio.allinapaas.executor.application.executor.core.dao.domain.SrvModelInout;
import com.irdstudio.allinapaas.executor.application.executor.core.dao.domain.SrvModelPackage;
import com.irdstudio.allinapaas.executor.application.executor.core.dao.domain.SrvModelValidate;
import com.irdstudio.allinapaas.executor.application.executor.core.dao.domain.SrvTestCase;
import com.irdstudio.allinapaas.executor.application.executor.core.plugin.market.AbstractMarketTask;
import com.irdstudio.allinapaas.portal.console.types.YesOrNO;
import com.irdstudio.allinrdm.dev.console.types.DomainEvalWay;
import com.irdstudio.allinrdm.dev.console.types.FieldEvalWay;
import com.irdstudio.allinrdm.dev.console.types.SectionType;
import com.irdstudio.allinrdm.dev.console.types.SrvModelTypeEnum;
import com.irdstudio.sdk.beans.core.util.POJOUtils;
import com.irdstudio.sdk.beans.core.util.UUIDUtil;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.StringWriter;
import java.io.Writer;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.MapUtils;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang3.StringUtils;
import org.dom4j.Document;
import org.dom4j.Element;
import org.dom4j.io.SAXReader;

public class CPTransSqliteTask
extends AbstractMarketTask {
    private PaasMarketAppinfo appInfo = null;
    private Map<String, Object> extParam = null;
    private SAXReader saxReader = new SAXReader();

    @Override
    public boolean initTask(Map<String, Object> extParam, Connection conn) throws SQLException {
        this.extParam = extParam;
        PaasMarketAppinfoDao paasAppsInfoDao = new PaasMarketAppinfoDao(conn);
        this.appInfo = paasAppsInfoDao.queryPaasMarketAppinfo(MapUtils.getString(extParam, (Object)"marketAppId"));
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean execute() {
        boolean flag = true;
        Connection conn = null;
        Connection sqliteConn = null;
        try {
            PaasEnvParamDao paasEnvParamDao;
            conn = this.getConnection();
            String subsFlag = MapUtils.getString(this.extParam, (Object)"subsFlag");
            String marketSource = MapUtils.getString(this.extParam, (Object)"marketSource");
            String subsId = MapUtils.getString(this.extParam, (Object)"marketSubsId");
            ArrayList<PaasMarketAppinfo> appInfoList = new ArrayList<PaasMarketAppinfo>();
            if (StringUtils.equals((CharSequence)marketSource, (CharSequence)MarketSource.Inside.getCode())) {
                if (StringUtils.equals((CharSequence)subsFlag, (CharSequence)YesOrNO.YES.getCode())) {
                    PaasMarketAppinfoDao paasAppsInfoDao = new PaasMarketAppinfoDao(conn);
                    PaasMarketAppinfo appParam = new PaasMarketAppinfo();
                    appParam.setSubsId(subsId);
                    List<PaasMarketAppinfo> sysApps = paasAppsInfoDao.queryPaasMarketAppinfoList(appParam);
                    appInfoList.addAll(sysApps);
                } else {
                    appInfoList.add(this.appInfo);
                }
            } else {
                String respJson;
                PaasMarketAppinfo param;
                paasEnvParamDao = new PaasEnvParamDao(conn);
                String apiUrl = paasEnvParamDao.queryByCodeReturnValue("allinpaas.open.api.http.url");
                if (StringUtils.equals((CharSequence)subsFlag, (CharSequence)YesOrNO.YES.getCode())) {
                    param = new PaasMarketAppinfo();
                    param.setSubsId(subsId);
                    respJson = this.requestOpenApi(apiUrl + "/om/paas/market/appinfo/index", (Object)param);
                    if (StringUtils.isBlank((CharSequence)respJson)) {
                        boolean bl = flag = false;
                        return bl;
                    }
                    List sysApps = JSON.parseArray((String)respJson, PaasMarketAppinfo.class);
                    appInfoList.addAll(sysApps);
                } else {
                    param = new PaasMarketAppinfo();
                    param.setMarketAppId(MapUtils.getString(this.extParam, (Object)"marketAppId"));
                    respJson = this.requestOpenApi(apiUrl + "/om/paas/market/appinfo", (Object)param);
                    if (StringUtils.isBlank((CharSequence)respJson)) {
                        boolean sysApps = flag = false;
                        return sysApps;
                    }
                    PaasMarketAppinfo marketApp = (PaasMarketAppinfo)((Object)JSON.parseObject((String)respJson, PaasMarketAppinfo.class));
                    appInfoList.add(marketApp);
                }
            }
            paasEnvParamDao = new PaasEnvParamDao(conn);
            String marketUrl = paasEnvParamDao.queryByCodeReturnValue("git.market.remote.path");
            for (PaasMarketAppinfo srcApp : appInfoList) {
                if (StringUtils.equals((CharSequence)marketSource, (CharSequence)MarketSource.Inside.getCode())) {
                    this.copyAppSqlite(srcApp, marketUrl);
                } else {
                    this.copyAppSqlite(srcApp, srcApp.getMarketAppGiturl());
                }
                this.transPkId(srcApp, conn);
            }
        }
        catch (Exception e) {
            this.logger.error("\u5e94\u7528\u6570\u636e\u6e05\u6d17sqlite", (Throwable)e);
            flag = false;
        }
        finally {
            if (conn != null) {
                this.closeConnection(conn);
            }
            if (sqliteConn != null) {
                this.closeSqliteConnection(sqliteConn);
            }
        }
        return flag;
    }

    private void copyAppSqlite(PaasMarketAppinfo appInfo, String marketUrl) throws IOException {
        String version;
        String marketPath = this.getMarketPath();
        String repoPath = this.getRepoPath(marketUrl);
        File repoDir = new File(repoPath);
        String sysCode = appInfo.getSubsCode();
        String appId = appInfo.getAppId();
        File sysDir = new File(repoDir, sysCode);
        String appCode = appInfo.getAppCode();
        File srcSqliteFile = new File(sysDir, String.format("%s_%s%s.db", sysCode, appCode, version = StringUtils.isNotBlank((CharSequence)(version = appInfo.getAppVersion())) ? "_" + version : ""));
        if (!srcSqliteFile.exists()) {
            srcSqliteFile = new File(sysDir, String.format("%s%s.db", sysCode, ""));
            if (srcSqliteFile.exists()) {
                this.logger.info("\u672a\u627e\u5230\u5e94\u7528\u7684sqlite, \u4ece\u5e94\u7528\u5e02\u573a\u5e94\u7528\u7cfb\u7edf" + sysCode + " \u7684sqlite \u6587\u4ef6\u8bfb\u53d6 " + srcSqliteFile.getName());
            } else {
                throw new RuntimeException("\u5e94\u7528\u7684sqlite\u6587\u4ef6\u4e0d\u5b58\u5728");
            }
        }
        File destDir = new File(marketPath);
        File destSqliteFile = new File(destDir, String.format("%s_%s.db", appCode, appId));
        FileUtils.copyFile((File)srcSqliteFile, (File)destSqliteFile);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void transPkId(PaasMarketAppinfo srcApp, Connection conn) throws Exception {
        Connection sqliteConn = null;
        try {
            String evalFieldId;
            String srvModelId;
            String evalContent;
            String domainFieldId;
            String tableFieldId;
            String tableModelId;
            String newId;
            String objectId;
            String newId2;
            File sqliteFile = this.getSqliteFile(srcApp);
            sqliteConn = this.getSqliteConnection(sqliteFile);
            PaasAppsInfoDao paasAppsInfoDao = new PaasAppsInfoDao(sqliteConn);
            SrvErrorMappingDao srvErrorMappingDao = new SrvErrorMappingDao(sqliteConn);
            HashMap<String, String> keyMap = new HashMap<String, String>();
            keyMap.put(srcApp.getAppId(), UUIDUtil.getUUID());
            ResultSet pPackages = this.queryAll(ModelFolderInfo.class, sqliteConn);
            while (pPackages.next()) {
                ModelFolderInfo pp = (ModelFolderInfo)((Object)POJOUtils.generatePOJO((ResultSet)pPackages, ModelFolderInfo.class));
                String oldId = pp.getFolderId();
                String oldAbvId = pp.getFolderAbvId();
                String newId3 = this.getKeyMapNewId(oldId, keyMap);
                String newAbvId = this.getKeyMapNewId(oldAbvId, keyMap);
                String newProjectId = this.getKeyMapNewId(pp.getAppId(), keyMap);
                pp.setFolderId(newId3);
                pp.setFolderAbvId(newAbvId);
                pp.setAppId(newProjectId);
                this.updateByPk(pp, "packageId", oldId, sqliteConn);
            }
            pPackages.close();
            ResultSet tables = this.queryAll(ModelTableInfo.class, sqliteConn);
            while (tables.next()) {
                ModelTableInfo table = (ModelTableInfo)((Object)POJOUtils.generatePOJO((ResultSet)tables, ModelTableInfo.class));
                String oldId = table.getObjectId();
                String oldPackageId = table.getFolderId();
                newId2 = this.getKeyMapNewId(oldId, keyMap);
                String newPackageId = this.getKeyMapNewId(oldPackageId, keyMap);
                String newProjectId = this.getKeyMapNewId(table.getAppId(), keyMap);
                table.setObjectId(newId2);
                table.setFolderId(newPackageId);
                table.setAppId(newProjectId);
                this.updateByPk(table, "objectId", oldId, sqliteConn);
            }
            tables.close();
            ResultSet fieldRs = this.queryAll(ModelTableField.class, sqliteConn);
            while (fieldRs.next()) {
                ModelTableField field = (ModelTableField)((Object)POJOUtils.generatePOJO((ResultSet)fieldRs, ModelTableField.class));
                String oldId = field.getFieldId();
                newId2 = this.getKeyMapNewId(oldId, keyMap);
                objectId = this.getKeyMapNewId(field.getObjectId(), keyMap);
                field.setObjectId(objectId);
                field.setFieldId(newId2);
                this.updateByPk(field, "fieldId", oldId, sqliteConn);
            }
            fieldRs.close();
            ResultSet indexRs = this.queryAll(ModelTableIndex.class, sqliteConn);
            while (indexRs.next()) {
                ModelTableIndex indexVO = (ModelTableIndex)((Object)POJOUtils.generatePOJO((ResultSet)indexRs, ModelTableIndex.class));
                String oldId = indexVO.getObjectId();
                objectId = this.getKeyMapNewId(oldId, keyMap);
                indexVO.setObjectId(objectId);
                HashMap<String, String> pks = new HashMap<String, String>();
                pks.put("objectId", oldId);
                pks.put("indexName", indexVO.getIndexName());
                this.updateByPk(indexVO, pks, sqliteConn);
            }
            indexRs.close();
            ResultSet paasAppsInfoRs = this.queryAll(PaasAppsInfo.class, sqliteConn);
            while (paasAppsInfoRs.next()) {
                PaasAppsInfo paasApp = (PaasAppsInfo)((Object)POJOUtils.generatePOJO((ResultSet)paasAppsInfoRs, PaasAppsInfo.class));
                String oldId = paasApp.getAppId();
                String newId4 = this.getKeyMapNewId(oldId, keyMap);
                paasApp.setAppId(newId4);
                String refAppId = paasApp.getRefAppId();
                String newRefAppId = this.getKeyMapNewId(paasApp.getRefAppId(), keyMap);
                paasApp.setRefAppId(newRefAppId);
                this.updateByPk(paasApp, "appId", oldId, sqliteConn);
            }
            paasAppsInfoRs.close();
            ResultSet paasAppsParamRs = this.queryAll(PaasAppsParam.class, sqliteConn);
            while (paasAppsParamRs.next()) {
                PaasAppsParam paasAppParam = (PaasAppsParam)((Object)POJOUtils.generatePOJO((ResultSet)paasAppsParamRs, PaasAppsParam.class));
                String oldId = paasAppParam.getAppId();
                String newId5 = this.getKeyMapNewId(oldId, keyMap);
                paasAppParam.setAppId(newId5);
                HashMap<String, String> pks = new HashMap<String, String>();
                pks.put("appId", oldId);
                pks.put("paramCode", paasAppParam.getParamCode());
                this.updateByPk(paasAppParam, pks, sqliteConn);
            }
            paasAppsParamRs.close();
            ResultSet paasAppsSqlRs = this.queryAll(PaasAppsSql.class, sqliteConn);
            while (paasAppsSqlRs.next()) {
                PaasAppsSql paasAppSql = (PaasAppsSql)((Object)POJOUtils.generatePOJO((ResultSet)paasAppsSqlRs, PaasAppsSql.class));
                String oldId = paasAppSql.getRecordKeyid();
                String newId6 = this.getKeyMapNewId(oldId, keyMap);
                paasAppSql.setRecordKeyid(newId6);
                String oldAppId = paasAppSql.getAppId();
                String newAppId = this.getKeyMapNewId(oldAppId, keyMap);
                paasAppSql.setAppId(newAppId);
                this.updateByPk(paasAppSql, "recordKeyid", oldId, sqliteConn);
            }
            paasAppsSqlRs.close();
            ResultSet paasAppsPropertiesRs = this.queryAll(PaasAppsProperties.class, sqliteConn);
            while (paasAppsPropertiesRs.next()) {
                PaasAppsProperties paasAppsProp = (PaasAppsProperties)((Object)POJOUtils.generatePOJO((ResultSet)paasAppsPropertiesRs, PaasAppsProperties.class));
                String oldId = paasAppsProp.getRecordKeyid();
                String newId7 = this.getKeyMapNewId(oldId, keyMap);
                paasAppsProp.setRecordKeyid(newId7);
                String oldAppId = paasAppsProp.getAppId();
                String newAppId = this.getKeyMapNewId(oldAppId, keyMap);
                paasAppsProp.setAppId(newAppId);
                this.updateByPk(paasAppsProp, "recordKeyid", oldId, sqliteConn);
            }
            paasAppsPropertiesRs.close();
            ResultSet srvPackageRs = this.queryAll(SrvModelPackage.class, sqliteConn);
            while (srvPackageRs.next()) {
                SrvModelPackage pg = (SrvModelPackage)((Object)POJOUtils.generatePOJO((ResultSet)srvPackageRs, SrvModelPackage.class));
                String oldId = pg.getPackageId();
                String oldPId = pg.getPackageAbvId();
                newId = this.getKeyMapNewId(oldId, keyMap);
                String newPId = this.getKeyMapNewId(oldPId, keyMap);
                pg.setAppId(this.getKeyMapNewId(pg.getAppId(), keyMap));
                pg.setPackageAbvId(newPId);
                pg.setPackageId(newId);
                this.updateByPk(pg, "packageId", oldId, sqliteConn);
            }
            srvPackageRs.close();
            ResultSet srvModelRs = this.queryAll(SrvModelInfo.class, sqliteConn);
            while (srvModelRs.next()) {
                SrvModelInfo modelInfo = (SrvModelInfo)((Object)POJOUtils.generatePOJO((ResultSet)srvModelRs, SrvModelInfo.class));
                String oldId = modelInfo.getSrvModelId();
                newId = this.getKeyMapNewId(oldId, keyMap);
                String appId = this.getKeyMapNewId(modelInfo.getAppId(), keyMap);
                String packageId = this.getKeyMapNewId(modelInfo.getPackageId(), keyMap);
                tableModelId = this.getKeyMapNewId(modelInfo.getTableModelId(), keyMap);
                modelInfo.setSrvModelId(newId);
                modelInfo.setAppId(appId);
                modelInfo.setPackageId(packageId);
                modelInfo.setTableModelId(tableModelId);
                this.updateByPk(modelInfo, "srvModelId", oldId, sqliteConn);
            }
            srvModelRs.close();
            ResultSet inoutRs = this.queryAll(SrvModelInout.class, sqliteConn);
            while (inoutRs.next()) {
                SrvModelInout inout = (SrvModelInout)((Object)POJOUtils.generatePOJO((ResultSet)inoutRs, SrvModelInout.class));
                String oldId = inout.getRecordKeyId();
                String newId8 = this.getKeyMapNewId(oldId, keyMap);
                String srvModelId2 = this.getKeyMapNewId(inout.getSrvModelId(), keyMap, true);
                tableModelId = this.getKeyMapNewId(inout.getTableModelId(), keyMap, true);
                inout.setRecordKeyId(newId8);
                inout.setSrvModelId(srvModelId2);
                inout.setTableModelId(tableModelId);
                this.updateByPk(inout, "recordKeyId", oldId, sqliteConn);
            }
            inoutRs.close();
            ResultSet isrvInsertRs = this.queryAll(IsrvEvalInsert.class, sqliteConn);
            while (isrvInsertRs.next()) {
                IsrvEvalInsert evalInsert = (IsrvEvalInsert)((Object)POJOUtils.generatePOJO((ResultSet)isrvInsertRs, IsrvEvalInsert.class));
                String oldId = evalInsert.getRecordKeyid();
                String newId9 = this.getKeyMapNewId(oldId, keyMap);
                String srvModelId3 = this.getKeyMapNewId(evalInsert.getSrvModelId(), keyMap, true);
                String tableModelId2 = this.getKeyMapNewId(evalInsert.getTableModelId(), keyMap, true);
                String tableFieldId2 = this.getKeyMapNewId(evalInsert.getTableFieldId(), keyMap, true);
                String domainFieldId2 = this.getKeyMapNewId(evalInsert.getDomainFieldId(), keyMap, true);
                evalInsert.setRecordKeyid(newId9);
                evalInsert.setSrvModelId(srvModelId3);
                evalInsert.setTableModelId(tableModelId2);
                evalInsert.setTableFieldId(tableFieldId2);
                evalInsert.setDomainFieldId(domainFieldId2);
                String evalContent2 = this.transEvalContent("isrv", evalInsert.getFieldEvalWay(), evalInsert.getEvalContent(), keyMap);
                evalInsert.setEvalContent(evalContent2);
                this.updateByPk(evalInsert, "recordKeyid", oldId, sqliteConn);
            }
            isrvInsertRs.close();
            ResultSet isrvOutRs = this.queryAll(IsrvEvalOut.class, sqliteConn);
            while (isrvOutRs.next()) {
                IsrvEvalOut evalOut = (IsrvEvalOut)((Object)POJOUtils.generatePOJO((ResultSet)isrvOutRs, IsrvEvalOut.class));
                String oldId = evalOut.getRecordKeyid();
                String newId10 = this.getKeyMapNewId(oldId, keyMap);
                String srvModelId4 = this.getKeyMapNewId(evalOut.getSrvModelId(), keyMap, true);
                String tableModelId3 = this.getKeyMapNewId(evalOut.getTableModelId(), keyMap, true);
                String tableFieldId3 = this.getKeyMapNewId(evalOut.getTableFieldId(), keyMap, true);
                String domainFieldId3 = this.getKeyMapNewId(evalOut.getDomainFieldId(), keyMap, true);
                evalOut.setRecordKeyid(newId10);
                evalOut.setSrvModelId(srvModelId4);
                evalOut.setTableModelId(tableModelId3);
                evalOut.setTableFieldId(tableFieldId3);
                evalOut.setDomainFieldId(domainFieldId3);
                String evalContent3 = this.transEvalContent("isrv", evalOut.getFieldEvalWay(), evalOut.getEvalContent(), keyMap);
                evalOut.setEvalContent(evalContent3);
                this.updateByPk(evalOut, "recordKeyid", oldId, sqliteConn);
            }
            isrvOutRs.close();
            ResultSet isrvUpdateRs = this.queryAll(IsrvEvalUpdate.class, sqliteConn);
            while (isrvUpdateRs.next()) {
                IsrvEvalUpdate evalUpdate = (IsrvEvalUpdate)((Object)POJOUtils.generatePOJO((ResultSet)isrvUpdateRs, IsrvEvalUpdate.class));
                String oldId = evalUpdate.getRecordKeyid();
                String newId11 = this.getKeyMapNewId(oldId, keyMap);
                String srvModelId5 = this.getKeyMapNewId(evalUpdate.getSrvModelId(), keyMap, true);
                String tableModelId4 = this.getKeyMapNewId(evalUpdate.getTableModelId(), keyMap, true);
                tableFieldId = this.getKeyMapNewId(evalUpdate.getTableFieldId(), keyMap, true);
                domainFieldId = this.getKeyMapNewId(evalUpdate.getDomainFieldId(), keyMap, true);
                evalUpdate.setRecordKeyid(newId11);
                evalUpdate.setSrvModelId(srvModelId5);
                evalUpdate.setTableModelId(tableModelId4);
                evalUpdate.setTableFieldId(tableFieldId);
                evalUpdate.setDomainFieldId(domainFieldId);
                evalContent = this.transEvalContent("isrv", evalUpdate.getFieldEvalWay(), evalUpdate.getEvalContent(), keyMap);
                evalUpdate.setEvalContent(evalContent);
                this.updateByPk(evalUpdate, "recordKeyid", oldId, sqliteConn);
            }
            isrvUpdateRs.close();
            ResultSet isrvCondRs = this.queryAll(IsrvSqlCond.class, sqliteConn);
            while (isrvCondRs.next()) {
                IsrvSqlCond sqlCond = (IsrvSqlCond)((Object)POJOUtils.generatePOJO((ResultSet)isrvCondRs, IsrvSqlCond.class));
                String oldId = sqlCond.getCondId();
                String newId12 = this.getKeyMapNewId(oldId, keyMap);
                String srvModelId6 = this.getKeyMapNewId(sqlCond.getSrvModelId(), keyMap, true);
                tableFieldId = this.getKeyMapNewId(sqlCond.getTableFieldId(), keyMap, true);
                domainFieldId = this.getKeyMapNewId(sqlCond.getDomainFieldId(), keyMap, true);
                sqlCond.setCondId(newId12);
                sqlCond.setSrvModelId(srvModelId6);
                sqlCond.setTableFieldId(tableFieldId);
                sqlCond.setDomainFieldId(domainFieldId);
                evalContent = this.transEvalContent("isrv", sqlCond.getFieldEvalWay(), sqlCond.getEvalContent(), keyMap);
                sqlCond.setEvalContent(evalContent);
                this.updateByPk(sqlCond, "condId", oldId, sqliteConn);
            }
            isrvCondRs.close();
            ResultSet isrvSqlRs = this.queryAll(IsrvSqlInfo.class, sqliteConn);
            while (isrvSqlRs.next()) {
                IsrvSqlInfo sql = (IsrvSqlInfo)((Object)POJOUtils.generatePOJO((ResultSet)isrvSqlRs, IsrvSqlInfo.class));
                String oldId = sql.getSqlId();
                String newId13 = this.getKeyMapNewId(oldId, keyMap);
                String srvModelId7 = this.getKeyMapNewId(sql.getSrvModelId(), keyMap, true);
                sql.setSqlId(newId13);
                sql.setSrvModelId(srvModelId7);
                this.updateByPk(sql, "sqlId", oldId, sqliteConn);
            }
            isrvSqlRs.close();
            ResultSet srvModelCondRs = this.queryAll(SrvModelCondition.class, sqliteConn);
            while (srvModelCondRs.next()) {
                SrvModelCondition cond = (SrvModelCondition)((Object)POJOUtils.generatePOJO((ResultSet)srvModelCondRs, SrvModelCondition.class));
                String oldId = cond.getCondId();
                String newId14 = this.getKeyMapNewId(oldId, keyMap);
                cond.setCondId(oldId);
                String oldAppId = cond.getAppId();
                String newAppId = this.getKeyMapNewId(oldAppId, keyMap, true);
                cond.setAppId(newAppId);
                String oldSrvModelId = cond.getSrvModelId();
                String newSrvModelId = this.getKeyMapNewId(oldSrvModelId, keyMap, true);
                cond.setSrvModelId(newSrvModelId);
                String oldCondRefId = cond.getCondRefId();
                String newCondRefId = this.getKeyMapNewId(oldCondRefId, keyMap);
                cond.setCondRefId(newCondRefId);
                String leftEval = this.transEvalContent("osrv", cond.getLeftEvalWay(), cond.getLeftEvalContent(), keyMap);
                cond.setLeftEvalContent(leftEval);
                String rightEval = this.transEvalContent("osrv", cond.getRightEvalWay(), cond.getRightEvalContent(), keyMap);
                cond.setRightEvalContent(rightEval);
                this.updateByPk(cond, "condId", oldId, sqliteConn);
            }
            srvModelCondRs.close();
            ResultSet srvModelValidateRs = this.queryAll(SrvModelValidate.class, sqliteConn);
            while (srvModelValidateRs.next()) {
                SrvModelValidate rule = (SrvModelValidate)((Object)POJOUtils.generatePOJO((ResultSet)srvModelValidateRs, SrvModelValidate.class));
                String oldId = rule.getRuleId();
                String newId15 = this.getKeyMapNewId(oldId, keyMap);
                String srvModelId8 = this.getKeyMapNewId(rule.getSrvModelId(), keyMap, true);
                rule.setRuleId(newId15);
                rule.setSrvModelId(srvModelId8);
                String ruleExpression = this.transCondEvalContent("osrv", rule.getRuleExpression(), keyMap);
                rule.setRuleExpression(ruleExpression);
                this.updateByPk(rule, "ruleId", oldId, sqliteConn);
            }
            srvModelValidateRs.close();
            ResultSet osrvVarRs = this.queryAll(OsrvArrangeVar.class, sqliteConn);
            while (osrvVarRs.next()) {
                OsrvArrangeVar var = (OsrvArrangeVar)((Object)POJOUtils.generatePOJO((ResultSet)osrvVarRs, OsrvArrangeVar.class));
                String oldId = var.getDomainVarId();
                String newId16 = this.getKeyMapNewId(oldId, keyMap);
                String srvModelId9 = this.getKeyMapNewId(var.getSrvModelId(), keyMap, true);
                String tableModelId5 = this.getKeyMapNewId(var.getTableModelId(), keyMap, true);
                String tableRowId = this.getKeyMapNewId(var.getTableRowId(), keyMap);
                var.setDomainVarId(newId16);
                var.setSrvModelId(srvModelId9);
                var.setTableModelId(tableModelId5);
                var.setTableRowId(tableRowId);
                this.updateByPk(var, "domainVarId", oldId, sqliteConn);
            }
            osrvVarRs.close();
            ResultSet osrvSectionRs = this.queryAll(OsrvArrangeSection.class, sqliteConn);
            while (osrvSectionRs.next()) {
                OsrvArrangeSection section = (OsrvArrangeSection)((Object)POJOUtils.generatePOJO((ResultSet)osrvSectionRs, OsrvArrangeSection.class));
                String oldId = section.getSectionId();
                String newId17 = this.getKeyMapNewId(oldId, keyMap);
                String sectionAbvId = this.getKeyMapNewId(section.getSectionAbvId(), keyMap, true);
                String appId = this.getKeyMapNewId(section.getAppId(), keyMap, true);
                srvModelId = this.getKeyMapNewId(section.getSrvModelId(), keyMap, true);
                section.setSectionId(newId17);
                section.setSectionAbvId(sectionAbvId);
                section.setSrvModelId(srvModelId);
                section.setAppId(appId);
                String sectionContent = this.transSectionContent(section.getSectionType(), section.getSectionContent(), keyMap);
                section.setSectionContent(sectionContent);
                this.updateByPk(section, "sectionId", oldId, sqliteConn);
            }
            ResultSet osrvTableRs = this.queryAll(OsrvArrangeTable.class, sqliteConn);
            while (osrvTableRs.next()) {
                OsrvArrangeTable table = (OsrvArrangeTable)((Object)POJOUtils.generatePOJO((ResultSet)osrvTableRs, OsrvArrangeTable.class));
                String oldId = table.getTableRowId();
                String newId18 = this.getKeyMapNewId(oldId, keyMap);
                String srvModelId10 = this.getKeyMapNewId(table.getSrvModelId(), keyMap, true);
                String rowOpTargetId = this.getKeyMapNewId(table.getRowOpTargetId(), keyMap, true);
                String rowOpCopyId = this.getKeyMapNewId(table.getRowOpCopyId(), keyMap, true);
                table.setTableRowId(newId18);
                table.setSrvModelId(srvModelId10);
                table.setRowOpTargetId(rowOpTargetId);
                table.setRowOpCopyId(rowOpCopyId);
                String rowCondExpression = this.transCondEvalContent("osrv", table.getRowCondExpression(), keyMap);
                table.setRowCondExpression(rowCondExpression);
                String rowContent = this.transTableContent(table.getRowContent(), keyMap);
                table.setRowContent(rowContent);
                this.updateByPk(table, "tableRowId", oldId, sqliteConn);
            }
            osrvTableRs.close();
            ResultSet osrvEvalIsrvRs = this.queryAll(OsrvEvalIsrv.class, sqliteConn);
            while (osrvEvalIsrvRs.next()) {
                OsrvEvalIsrv isrv = (OsrvEvalIsrv)((Object)POJOUtils.generatePOJO((ResultSet)osrvEvalIsrvRs, OsrvEvalIsrv.class));
                String oldId = isrv.getRecordKeyid();
                String newId19 = this.getKeyMapNewId(oldId, keyMap);
                srvModelId = this.getKeyMapNewId(isrv.getSrvModelId(), keyMap, true);
                String tableRowId = this.getKeyMapNewId(isrv.getTableRowId(), keyMap, true);
                String isrvModelId = this.getKeyMapNewId(isrv.getIsrvModelId(), keyMap, true);
                String isrvFieldId = this.getKeyMapNewId(isrv.getIsrvFieldId(), keyMap, true);
                String evalVarId = this.getKeyMapNewId(isrv.getEvalVarId(), keyMap, true);
                String evalFieldId2 = this.getKeyMapNewId(isrv.getEvalFieldId(), keyMap, true);
                isrv.setRecordKeyid(newId19);
                isrv.setSrvModelId(srvModelId);
                isrv.setTableRowId(tableRowId);
                isrv.setIsrvModelId(isrvModelId);
                isrv.setIsrvFieldId(isrvFieldId);
                isrv.setEvalVarId(evalVarId);
                isrv.setEvalFieldId(evalFieldId2);
                String evalContent4 = this.transEvalContent("osrv", isrv.getIsrvEvalWay(), isrv.getEvalContent(), keyMap);
                isrv.setEvalContent(evalContent4);
                this.updateByPk(isrv, "recordKeyid", oldId, sqliteConn);
            }
            osrvEvalIsrvRs.close();
            ResultSet osrvEvalVarRs = this.queryAll(OsrvEvalVar.class, sqliteConn);
            while (osrvEvalVarRs.next()) {
                OsrvEvalVar var = (OsrvEvalVar)((Object)POJOUtils.generatePOJO((ResultSet)osrvEvalVarRs, OsrvEvalVar.class));
                String oldId = var.getRecordKeyid();
                String newId20 = this.getKeyMapNewId(oldId, keyMap);
                String srvModelId11 = this.getKeyMapNewId(var.getSrvModelId(), keyMap, true);
                String tableRowId = this.getKeyMapNewId(var.getTableRowId(), keyMap, true);
                String domainVarId = this.getKeyMapNewId(var.getDomainVarId(), keyMap, true);
                String domainFieldId4 = this.getKeyMapNewId(var.getDomainFieldId(), keyMap, true);
                String evalVarId = this.getKeyMapNewId(var.getEvalVarId(), keyMap, true);
                evalFieldId = this.getKeyMapNewId(var.getEvalFieldId(), keyMap, true);
                var.setRecordKeyid(newId20);
                var.setSrvModelId(srvModelId11);
                var.setTableRowId(tableRowId);
                var.setDomainVarId(domainVarId);
                var.setDomainFieldId(domainFieldId4);
                var.setEvalVarId(evalVarId);
                var.setEvalFieldId(evalFieldId);
                String evalContent5 = this.transEvalContent("osrv", var.getDomainEvalWay(), var.getEvalContent(), keyMap);
                var.setEvalContent(evalContent5);
                this.updateByPk(var, "recordKeyid", oldId, sqliteConn);
            }
            ResultSet srvModelExpressionRs = this.queryAll(SrvModelExpression.class, sqliteConn);
            while (srvModelExpressionRs.next()) {
                SrvModelExpression exp = (SrvModelExpression)((Object)POJOUtils.generatePOJO((ResultSet)srvModelExpressionRs, SrvModelExpression.class));
                String oldId = exp.getExpId();
                String newId21 = this.getKeyMapNewId(oldId, keyMap);
                exp.setExpId(oldId);
                String oldAppId = exp.getAppId();
                String newAppId = this.getKeyMapNewId(oldAppId, keyMap, true);
                exp.setAppId(newAppId);
                String oldSrvModelId = exp.getSrvModelId();
                String newSrvModelId = this.getKeyMapNewId(oldSrvModelId, keyMap, true);
                exp.setSrvModelId(newSrvModelId);
                this.updateByPk(exp, "expId", oldId, sqliteConn);
            }
            srvModelExpressionRs.close();
            ResultSet srvModelExpvarRs = this.queryAll(SrvModelExpvar.class, sqliteConn);
            while (srvModelExpvarRs.next()) {
                SrvModelExpvar exp = (SrvModelExpvar)((Object)POJOUtils.generatePOJO((ResultSet)srvModelExpressionRs, SrvModelExpvar.class));
                String oldId = exp.getExpId();
                String newId22 = this.getKeyMapNewId(oldId, keyMap);
                exp.setExpId(oldId);
                String oldExpId = exp.getExpId();
                String newExpId = this.getKeyMapNewId(oldExpId, keyMap, true);
                exp.setExpId(newExpId);
                String oldAppId = exp.getAppId();
                String newAppId = this.getKeyMapNewId(oldAppId, keyMap, true);
                exp.setAppId(newAppId);
                String oldSrvModelId = exp.getSrvModelId();
                String newSrvModelId = this.getKeyMapNewId(oldSrvModelId, keyMap, true);
                exp.setSrvModelId(newSrvModelId);
                String newContent = this.transEvalContent("osrv", exp.getEvalWay(), exp.getEvalContent(), keyMap);
                exp.setEvalContent(newContent);
                this.updateByPk(exp, "expvarId", oldId, sqliteConn);
            }
            srvModelExpvarRs.close();
            osrvEvalVarRs.close();
            ResultSet srvEvalFuncRs = this.queryAll(SrvEvalFunc.class, sqliteConn);
            while (srvEvalFuncRs.next()) {
                SrvEvalFunc evalFunc = (SrvEvalFunc)((Object)POJOUtils.generatePOJO((ResultSet)srvEvalFuncRs, SrvEvalFunc.class));
                String oldRecordKeyid = evalFunc.getTargetRecordKeyid();
                String oldFieldId = evalFunc.getFuncFieldId();
                String recordKeyid = this.getKeyMapNewId(evalFunc.getTargetRecordKeyid(), keyMap, true);
                String funcFieldId = this.getKeyMapNewId(evalFunc.getFuncFieldId(), keyMap, true);
                evalFieldId = this.getKeyMapNewId(evalFunc.getEvalFieldId(), keyMap, true);
                String funcModelId = this.getKeyMapNewId(evalFunc.getFuncModelId(), keyMap, true);
                String srvModelId12 = this.getKeyMapNewId(evalFunc.getSrvModelId(), keyMap, true);
                evalFunc.setTargetRecordKeyid(oldRecordKeyid);
                evalFunc.setFuncFieldId(funcFieldId);
                evalFunc.setEvalFieldId(evalFieldId);
                evalFunc.setFuncModelId(funcModelId);
                evalFunc.setSrvModelId(srvModelId12);
                String evalContent6 = this.transEvalContent("osrv", evalFunc.getFieldEvalWay(), evalFunc.getEvalContent(), keyMap);
                evalFunc.setEvalContent(evalContent6);
                HashMap<String, String> pks = new HashMap<String, String>();
                pks.put("targetRecordKeyid", recordKeyid);
                pks.put("funcFieldId", funcFieldId);
                this.updateByPk(evalFunc, pks, sqliteConn);
            }
            try {
                ResultSet srvModelFeatureRs = this.queryAll(SrvModelFeature.class, sqliteConn);
                while (srvModelFeatureRs.next()) {
                    SrvModelFeature modelFeature = (SrvModelFeature)((Object)POJOUtils.generatePOJO((ResultSet)srvModelFeatureRs, SrvModelFeature.class));
                    String oldSrvModelId = modelFeature.getSrvModelId();
                    String newSrvModelId = this.getKeyMapNewId(oldSrvModelId, keyMap, true);
                    String oldXml = modelFeature.getFeatureXml();
                    modelFeature.setSrvModelId(newSrvModelId);
                    try {
                        ByteArrayInputStream input = new ByteArrayInputStream(oldXml.getBytes("UTF-8"));
                        Document dom = this.saxReader.read((InputStream)input);
                        Element rule = dom.getRootElement();
                        String srvModelTypeStr = rule.attributeValue("srvModelType");
                        SrvModelTypeEnum srvModelType = SrvModelTypeEnum.getModelByType((String)srvModelTypeStr);
                        if (srvModelType != null && SrvModelTypeEnum.ExpressionRule == srvModelType) {
                            this.recursionUpdateXmlElementText(rule, "domainVarId", keyMap);
                            this.recursionUpdateXmlElementText(rule, "srvModelId", keyMap);
                            this.recursionUpdateXmlElementText(rule, "tableModelId", keyMap);
                            this.recursionUpdateXmlElementText(rule, "fieldId", keyMap);
                            StringWriter writer = new StringWriter();
                            dom.write((Writer)writer);
                            ((Writer)writer).flush();
                            modelFeature.setFeatureXml(((Object)writer).toString());
                        }
                    }
                    catch (Exception input) {
                        // empty catch block
                    }
                    this.updateByPk(modelFeature, "srvModelId", oldSrvModelId, sqliteConn);
                }
                ResultSet srvTestCaseRs = this.queryAll(SrvTestCase.class, sqliteConn);
                while (srvTestCaseRs.next()) {
                    SrvTestCase testCase = (SrvTestCase)((Object)POJOUtils.generatePOJO((ResultSet)srvTestCaseRs, SrvTestCase.class));
                    String oldCaseId = testCase.getSrvCaseId();
                    String oldSrvModelId = testCase.getSrvModelId();
                    String caseId = this.getKeyMapNewId(testCase.getSrvCaseId(), keyMap);
                    String srvModelId13 = this.getKeyMapNewId(testCase.getSrvModelId(), keyMap, true);
                    testCase.setSrvCaseId(oldCaseId);
                    testCase.setSrvModelId(srvModelId13);
                    this.updateByPk(testCase, "srvCaseId", oldCaseId, sqliteConn);
                }
                List<SrvErrorMapping> errorList = srvErrorMappingDao.queryDictErrorInfoList(srcApp.getAppId());
                for (SrvErrorMapping errorInfo : errorList) {
                    errorInfo.setAppId((String)keyMap.get(errorInfo.getAppId()));
                    srvErrorMappingDao.updateByPk(errorInfo, srcApp.getAppId());
                }
            }
            catch (Exception srvModelFeatureRs) {
                // empty catch block
            }
            PaasMarketAppinfoDao keyMapDao = new PaasMarketAppinfoDao(sqliteConn);
            keyMapDao.createKeyMap();
            keyMapDao.saveKeyMap(keyMap);
            if (sqliteConn == null) return;
        }
        catch (Throwable throwable) {
            if (sqliteConn == null) throw throwable;
            this.closeSqliteConnection(sqliteConn);
            throw throwable;
        }
        this.closeSqliteConnection(sqliteConn);
    }

    private String getKeyMapNewId(String id, Map<String, String> keyMap) {
        return this.getKeyMapNewId(id, keyMap, false);
    }

    private String getKeyMapNewId(String id, Map<String, String> keyMap, boolean noCreate) {
        if (StringUtils.isBlank((CharSequence)id)) {
            return id;
        }
        String newId = keyMap.get(id);
        if (newId == null) {
            if (!noCreate) {
                newId = UUIDUtil.getUUID();
                keyMap.put(id, newId);
            } else {
                newId = id;
            }
        }
        return newId;
    }

    private String transEvalContent(String type, String evalWay, String evalContent, Map<String, String> keyMap) {
        try {
            if (StringUtils.isBlank((CharSequence)evalContent)) {
                return evalContent;
            }
            if (DomainEvalWay.FORMULA.getCode().equals(evalWay)) {
                Map tag = (Map)JSON.parseObject((String)evalContent, Map.class);
                String expId = MapUtils.getString((Map)tag, (Object)"expId");
                String newExpId = this.getKeyMapNewId(expId, keyMap, true);
                tag.put("expId", newExpId);
                evalContent = JSON.toJSONString((Object)tag);
            } else if ((FieldEvalWay.ASSIGN.getCode().equals(evalWay) || DomainEvalWay.ASSIGN.getCode().equals(evalWay)) && "osrv".equals(type)) {
                Map map = (Map)JSON.parseObject((String)evalContent, Map.class);
                String fieldId = MapUtils.getString((Map)map, (Object)"fieldId");
                String objectId = MapUtils.getString((Map)map, (Object)"objectId");
                map.put("fieldId", this.getKeyMapNewId(fieldId, keyMap, true));
                map.put("objectId", this.getKeyMapNewId(objectId, keyMap, true));
                Map varObj = MapUtils.getMap((Map)map, (Object)"varObj");
                if (varObj != null) {
                    String domainVarId = MapUtils.getString((Map)varObj, (Object)"domainVarId");
                    String srvModelId = MapUtils.getString((Map)varObj, (Object)"srvModelId");
                    String tableModelId = MapUtils.getString((Map)varObj, (Object)"tableModelId");
                    String id = MapUtils.getString((Map)varObj, (Object)"id");
                    varObj.put("domainVarId", this.getKeyMapNewId(domainVarId, keyMap, true));
                    varObj.put("srvModelId", this.getKeyMapNewId(srvModelId, keyMap, true));
                    varObj.put("tableModelId", this.getKeyMapNewId(tableModelId, keyMap, true));
                    varObj.put("id", this.getKeyMapNewId(id, keyMap, true));
                }
                evalContent = JSON.toJSONString((Object)map);
            } else if (FieldEvalWay.ERROR.getCode().equals(evalWay)) {
                Map map = (Map)JSON.parseObject((String)evalContent, Map.class);
                String errorAppId = MapUtils.getString((Map)map, (Object)"appId");
                String errorCode = MapUtils.getString((Map)map, (Object)"errorCode");
                String appId = this.getKeyMapNewId(errorAppId, keyMap, true);
                map.put("appId", appId);
                evalContent = JSON.toJSONString((Object)map);
            } else if (FieldEvalWay.FUNC.getCode().equals(evalWay)) {
                Map evalContentMap = (Map)JSON.parseObject((String)evalContent, Map.class);
                Map func = MapUtils.getMap((Map)evalContentMap, (Object)"func");
                List parameterList = (List)evalContentMap.get("parameterList");
                if (CollectionUtils.isNotEmpty((Collection)parameterList)) {
                    for (Map param : parameterList) {
                        String newContent = this.transEvalContent("osrv", MapUtils.getString((Map)param, (Object)"evalWay"), MapUtils.getString((Map)param, (Object)"evalContent"), keyMap);
                        param.put("evalContent", newContent);
                    }
                    evalContentMap.put("parameterList", parameterList);
                }
                evalContent = JSON.toJSONString((Object)evalContentMap);
            }
        }
        catch (Exception e) {
            this.logger.error("transEvalContent error", (Throwable)e);
        }
        return evalContent;
    }

    private String transSectionContent(String sectionType, String sectionContent, Map<String, String> keyMap) {
        try {
            Map map = (Map)JSON.parseObject((String)sectionContent, Map.class);
            if (StringUtils.equals((CharSequence)SectionType.ForEachSection.getCode(), (CharSequence)sectionType)) {
                String srvModelId = MapUtils.getString((Map)map, (Object)"srvModelId");
                String domainVarId = MapUtils.getString((Map)map, (Object)"domainVarId");
                String tableModelId = MapUtils.getString((Map)map, (Object)"tableModelId");
                map.put("srvModelId", this.getKeyMapNewId(srvModelId, keyMap, true));
                map.put("domainVarId", this.getKeyMapNewId(domainVarId, keyMap, true));
                map.put("tableModelId", this.getKeyMapNewId(tableModelId, keyMap, true));
                return JSON.toJSONString((Object)map);
            }
            if (StringUtils.equals((CharSequence)SectionType.ConditionSection.getCode(), (CharSequence)sectionType)) {
                List tags = (List)map.get("tags");
                String json = JSON.toJSONString((Object)tags);
                json = this.transCondEvalContent("osrv", json, keyMap);
                tags = JSON.parseArray((String)json, Map.class);
                map.put("tags", tags);
                return JSON.toJSONString((Object)map);
            }
            return sectionContent;
        }
        catch (Exception e) {
            this.logger.error("transSectionContent error", (Throwable)e);
            return sectionContent;
        }
    }

    private String transCondEvalContent(String type, String expression, Map<String, String> keyMap) {
        try {
            if (StringUtils.isBlank((CharSequence)expression)) {
                return expression;
            }
            List tagList = JSON.parseArray((String)expression, Map.class);
            if (CollectionUtils.isNotEmpty((Collection)tagList)) {
                for (Map tag : tagList) {
                    String tdType = MapUtils.getString((Map)tag, (Object)"tdType");
                    if (!"F".equals(tdType)) continue;
                    String objectId = MapUtils.getString((Map)tag, (Object)"objectId");
                    String domainVarId = MapUtils.getString((Map)tag, (Object)"domainVarId");
                    String fieldId = MapUtils.getString((Map)tag, (Object)"fieldId");
                    tag.put("objectId", this.getKeyMapNewId(objectId, keyMap, true));
                    tag.put("domainVarId", this.getKeyMapNewId(domainVarId, keyMap, true));
                    tag.put("fieldId", this.getKeyMapNewId(fieldId, keyMap, true));
                }
                expression = JSON.toJSONString((Object)tagList);
            }
        }
        catch (Exception e) {
            this.logger.error("transCondEvalContent error", (Throwable)e);
        }
        return expression;
    }

    private String transTableContent(String rowContent, Map<String, String> keyMap) {
        try {
            if (StringUtils.isBlank((CharSequence)rowContent)) {
                return rowContent;
            }
            HashMap<String, Map> newMap = new HashMap<String, Map>();
            Map map = (Map)JSON.parseObject((String)rowContent, Map.class);
            for (Map.Entry entry : map.entrySet()) {
                if (((String)entry.getKey()).equals("targetInfo")) {
                    Map targetInfo = MapUtils.getMap((Map)map, (Object)"targetInfo");
                    if (targetInfo != null) {
                        String appId = MapUtils.getString((Map)targetInfo, (Object)"appId");
                        String srvModelId = MapUtils.getString((Map)targetInfo, (Object)"srvModelId");
                        String fieldId = MapUtils.getString((Map)targetInfo, (Object)"fieldId");
                        String packageId = MapUtils.getString((Map)targetInfo, (Object)"packageId");
                        String tableModelId = MapUtils.getString((Map)targetInfo, (Object)"tableModelId");
                        String domainVarId = MapUtils.getString((Map)targetInfo, (Object)"domainVarId");
                        String id = MapUtils.getString((Map)targetInfo, (Object)"id");
                        targetInfo.put("appId", this.getKeyMapNewId(appId, keyMap, true));
                        targetInfo.put("srvModelId", this.getKeyMapNewId(srvModelId, keyMap, true));
                        targetInfo.put("fieldId", this.getKeyMapNewId(fieldId, keyMap, true));
                        targetInfo.put("packageId", this.getKeyMapNewId(packageId, keyMap, true));
                        targetInfo.put("tableModelId", this.getKeyMapNewId(tableModelId, keyMap, true));
                        targetInfo.put("domainVarId", this.getKeyMapNewId(domainVarId, keyMap, true));
                        targetInfo.put("id", this.getKeyMapNewId(id, keyMap, true));
                    }
                    newMap.put("targetInfo", targetInfo);
                    continue;
                }
                String tableModelId = (String)entry.getKey();
                Map targetVar = (Map)entry.getValue();
                String newTableModelId = this.getKeyMapNewId(tableModelId, keyMap, true);
                String domainVarId = MapUtils.getString((Map)targetVar, (Object)"domainVarId");
                String srvModelId = MapUtils.getString((Map)targetVar, (Object)"srvModelId");
                String targetTableModelId = MapUtils.getString((Map)targetVar, (Object)"tableModelId");
                targetVar.put("domainVarId", this.getKeyMapNewId(domainVarId, keyMap, true));
                targetVar.put("srvModelId", this.getKeyMapNewId(srvModelId, keyMap, true));
                targetVar.put("tableModelId", this.getKeyMapNewId(targetTableModelId, keyMap, true));
                newMap.put(newTableModelId, targetVar);
            }
            rowContent = JSON.toJSONString(newMap);
        }
        catch (Exception e) {
            this.logger.error("transTableContent error", (Throwable)e);
        }
        return rowContent;
    }

    public static final synchronized String createUniqueKey(String prefix) {
        SimpleDateFormat sdf = new SimpleDateFormat("yyyyMMddHHmmssSSS", Locale.ENGLISH);
        try {
            Thread.sleep(30L);
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
        return prefix + sdf.format(new Date()) + ((int)(Math.random() * 900000.0) + 100000);
    }

    public void recursionUpdateXmlElementText(Element element, String qName, Map<String, String> keyMap) {
        if (element == null) {
            return;
        }
        if (element.getQualifiedName().equals(qName)) {
            String text = element.getText();
            String newId = this.getKeyMapNewId(text, keyMap, true);
            element.setText(newId);
            return;
        }
        List childrenList = element.elements();
        if (CollectionUtils.isNotEmpty((Collection)childrenList)) {
            for (Element child : childrenList) {
                this.recursionUpdateXmlElementText(child, qName, keyMap);
            }
        }
    }
}

