/*
 * Decompiled with CFR 0.152.
 */
package com.irdstudio.allinapaas.executor.application.executor.core.plugin.market;

import com.irdstudio.allinapaas.executor.application.executor.core.dao.IsrvEvalInsertDao;
import com.irdstudio.allinapaas.executor.application.executor.core.dao.IsrvEvalOutDao;
import com.irdstudio.allinapaas.executor.application.executor.core.dao.IsrvEvalUpdateDao;
import com.irdstudio.allinapaas.executor.application.executor.core.dao.IsrvSqlCondDao;
import com.irdstudio.allinapaas.executor.application.executor.core.dao.IsrvSqlInfoDao;
import com.irdstudio.allinapaas.executor.application.executor.core.dao.PaasAppsInfoDao;
import com.irdstudio.allinapaas.executor.application.executor.core.dao.PaasAppsParamDao;
import com.irdstudio.allinapaas.executor.application.executor.core.dao.PaasAppsPropertiesDao;
import com.irdstudio.allinapaas.executor.application.executor.core.dao.PaasAppsSqlDao;
import com.irdstudio.allinapaas.executor.application.executor.core.dao.SrvEvalFuncDao;
import com.irdstudio.allinapaas.executor.application.executor.core.dao.SrvModelConditionDao;
import com.irdstudio.allinapaas.executor.application.executor.core.dao.SrvModelExpressionDao;
import com.irdstudio.allinapaas.executor.application.executor.core.dao.SrvModelExpvarDao;
import com.irdstudio.allinapaas.executor.application.executor.core.dao.SrvModelInfoDao;
import com.irdstudio.allinapaas.executor.application.executor.core.dao.SrvModelInoutDao;
import com.irdstudio.allinapaas.executor.application.executor.core.dao.SrvModelValidateDao;
import com.irdstudio.allinapaas.executor.application.executor.core.dao.domain.IsrvEvalInsert;
import com.irdstudio.allinapaas.executor.application.executor.core.dao.domain.IsrvEvalOut;
import com.irdstudio.allinapaas.executor.application.executor.core.dao.domain.IsrvEvalUpdate;
import com.irdstudio.allinapaas.executor.application.executor.core.dao.domain.IsrvSqlCond;
import com.irdstudio.allinapaas.executor.application.executor.core.dao.domain.IsrvSqlInfo;
import com.irdstudio.allinapaas.executor.application.executor.core.dao.domain.PaasAppsInfo;
import com.irdstudio.allinapaas.executor.application.executor.core.dao.domain.PaasAppsParam;
import com.irdstudio.allinapaas.executor.application.executor.core.dao.domain.PaasAppsProperties;
import com.irdstudio.allinapaas.executor.application.executor.core.dao.domain.PaasAppsSql;
import com.irdstudio.allinapaas.executor.application.executor.core.dao.domain.SrvModelCondition;
import com.irdstudio.allinapaas.executor.application.executor.core.dao.domain.SrvModelExpression;
import com.irdstudio.allinapaas.executor.application.executor.core.dao.domain.SrvModelExpvar;
import com.irdstudio.allinapaas.executor.application.executor.core.dao.domain.SrvModelInfo;
import com.irdstudio.allinapaas.executor.application.executor.core.dao.domain.SrvModelInout;
import com.irdstudio.allinapaas.executor.application.executor.core.dao.domain.SrvModelValidate;
import com.irdstudio.allinapaas.executor.application.executor.core.plugin.common.SSubsInfo;
import com.irdstudio.allinapaas.executor.application.executor.core.plugin.common.SSubsInfoDao;
import com.irdstudio.allinapaas.executor.application.executor.core.plugin.market.AbstractMarketTask;
import com.irdstudio.allinrdm.dev.console.types.SrvModelCatalogEnum;
import java.io.File;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.MapUtils;

public class SysMarketCpIsrvTask
extends AbstractMarketTask {
    private Map<String, Object> extParam = null;

    @Override
    public boolean initTask(Map<String, Object> extParam, Connection conn) throws SQLException {
        this.extParam = extParam;
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean execute() {
        boolean flag = true;
        Connection conn = null;
        Connection sqliteConn = null;
        try {
            conn = this.getConnection();
            String subsId = MapUtils.getString(this.extParam, (Object)"marketSubsId");
            SSubsInfoDao sSubsInfoDao = new SSubsInfoDao(conn);
            PaasAppsInfoDao paasAppsInfoDao = new PaasAppsInfoDao(conn);
            PaasAppsParamDao paasAppsParamDao = new PaasAppsParamDao(conn);
            PaasAppsSqlDao paasAppsSqlDao = new PaasAppsSqlDao(conn);
            PaasAppsPropertiesDao paasAppsPropertiesDao = new PaasAppsPropertiesDao(conn);
            SrvModelInfoDao srvModelInfoDao = new SrvModelInfoDao(conn);
            List<PaasAppsInfo> appList = paasAppsInfoDao.queryPaasAppsInfoListBySysCode(subsId);
            if (CollectionUtils.isNotEmpty(appList)) {
                File sqliteFile = this.getSysSqliteFile(this.extParam, null);
                sqliteConn = this.getSqliteConnection(sqliteFile);
                SSubsInfoDao sqliteSSubsInfoDao = new SSubsInfoDao(sqliteConn);
                PaasAppsInfoDao sqlitePaasAppsInfoDao = new PaasAppsInfoDao(sqliteConn);
                SSubsInfo sysInfo = sSubsInfoDao.querySSubsInfoWithKeys(MapUtils.getString(this.extParam, (Object)"paasSubsId"));
                sqliteSSubsInfoDao.insertSSubsInfo(sysInfo);
                for (PaasAppsInfo appInfo : appList) {
                    sqlitePaasAppsInfoDao.insertPaasAppsInfo(appInfo);
                    PaasAppsParam paasAppsParam = new PaasAppsParam();
                    paasAppsParam.setAppId(appInfo.getAppId());
                    List<PaasAppsParam> appsParamList = paasAppsParamDao.queryPaasAppsParamList(paasAppsParam);
                    this.batchInsertPage("paas_apps_param", appsParamList, sqliteConn);
                    PaasAppsSql paasSqlParam = new PaasAppsSql();
                    paasSqlParam.setAppId(appInfo.getAppId());
                    List<PaasAppsSql> appsSqlList = paasAppsSqlDao.queryPaasAppsSqlList(paasSqlParam);
                    this.batchInsertPage("paas_apps_sql", appsSqlList, sqliteConn);
                    PaasAppsProperties paasAppsProp = new PaasAppsProperties();
                    paasAppsProp.setAppId(appInfo.getAppId());
                    List<PaasAppsProperties> appsPropList = paasAppsPropertiesDao.queryPaasAppsPropertiesList(paasAppsProp);
                    this.batchInsertPage("paas_apps_properties", appsPropList, sqliteConn);
                    SrvModelInfo srvParam = new SrvModelInfo();
                    srvParam.setAppId(appInfo.getAppId());
                    srvParam.setSrvModelCatalog(SrvModelCatalogEnum.SrvServer.getCode());
                    List<SrvModelInfo> srvModelList = srvModelInfoDao.querySrvModelInfoList(srvParam);
                    this.batchInsertPage("srv_model_info", srvModelList, sqliteConn);
                    SrvModelInoutDao srvModelInoutDao = new SrvModelInoutDao(conn);
                    IsrvEvalInsertDao isrvEvalInsertDao = new IsrvEvalInsertDao(conn);
                    IsrvEvalOutDao isrvEvalOutDao = new IsrvEvalOutDao(conn);
                    IsrvEvalUpdateDao isrvEvalUpdateDao = new IsrvEvalUpdateDao(conn);
                    IsrvSqlCondDao isrvSqlCondDao = new IsrvSqlCondDao(conn);
                    IsrvSqlInfoDao isrvSqlInfoDao = new IsrvSqlInfoDao(conn);
                    SrvModelConditionDao srvModelConditionDao = new SrvModelConditionDao(conn);
                    SrvModelValidateDao isrvValidateRuleDao = new SrvModelValidateDao(conn);
                    SrvEvalFuncDao srvEvalFuncDao = new SrvEvalFuncDao(conn);
                    SrvModelExpressionDao srvModelExpressionDao = new SrvModelExpressionDao(conn);
                    SrvModelExpvarDao srvModelExpvarDao = new SrvModelExpvarDao(conn);
                    for (SrvModelInfo modelInfo : srvModelList) {
                        SrvModelInout inoutParam = new SrvModelInout();
                        inoutParam.setSrvModelId(modelInfo.getSrvModelId());
                        List<SrvModelInout> inoutList = srvModelInoutDao.querySrvModelInoutList(inoutParam);
                        this.batchInsertPage("srv_model_inout", inoutList, sqliteConn);
                        IsrvEvalInsert insertParam = new IsrvEvalInsert();
                        insertParam.setSrvModelId(modelInfo.getSrvModelId());
                        List<IsrvEvalInsert> insertList = isrvEvalInsertDao.queryIsrvEvalInsertList(insertParam);
                        this.batchInsertPage("isrv_eval_insert", insertList, sqliteConn);
                        this.cpSrvEvalFunc(modelInfo.getSrvModelId(), IsrvEvalInsert.class, srvEvalFuncDao, sqliteConn);
                        IsrvEvalOut isrvEvalOut = new IsrvEvalOut();
                        isrvEvalOut.setSrvModelId(modelInfo.getSrvModelId());
                        List<IsrvEvalOut> outList = isrvEvalOutDao.queryIsrvEvalOutList(isrvEvalOut);
                        this.batchInsertPage("isrv_eval_out", outList, sqliteConn);
                        this.cpSrvEvalFunc(modelInfo.getSrvModelId(), IsrvEvalOut.class, srvEvalFuncDao, sqliteConn);
                        IsrvEvalUpdate isrvEvalUpdate = new IsrvEvalUpdate();
                        isrvEvalUpdate.setSrvModelId(modelInfo.getSrvModelId());
                        List<IsrvEvalUpdate> updateList = isrvEvalUpdateDao.queryIsrvEvalUpdateList(isrvEvalUpdate);
                        this.batchInsertPage("isrv_eval_update", updateList, sqliteConn);
                        this.cpSrvEvalFunc(modelInfo.getSrvModelId(), IsrvEvalUpdate.class, srvEvalFuncDao, sqliteConn);
                        IsrvSqlCond isrvSqlCond = new IsrvSqlCond();
                        isrvSqlCond.setSrvModelId(modelInfo.getSrvModelId());
                        List<IsrvSqlCond> condList = isrvSqlCondDao.queryIsrvSqlCondList(isrvSqlCond);
                        this.batchInsertPage("isrv_sql_cond", condList, sqliteConn);
                        this.cpSrvEvalFunc(modelInfo.getSrvModelId(), IsrvSqlCond.class, srvEvalFuncDao, sqliteConn);
                        IsrvSqlInfo isrvSqlInfo = new IsrvSqlInfo();
                        isrvSqlInfo.setSrvModelId(modelInfo.getSrvModelId());
                        List<IsrvSqlInfo> sqlInfoList = isrvSqlInfoDao.queryIsrvSqlInfoList(isrvSqlInfo);
                        this.batchInsertPage("isrv_sql_info", sqlInfoList, sqliteConn);
                        SrvModelCondition srvCond = new SrvModelCondition();
                        srvCond.setSrvModelId(modelInfo.getSrvModelId());
                        List<SrvModelCondition> srvCondList = srvModelConditionDao.querySrvModelConditionList(srvCond);
                        this.batchInsertPage("srv_model_condition", srvCondList, sqliteConn);
                        SrvModelValidate isrvValidateRule = new SrvModelValidate();
                        isrvValidateRule.setSrvModelId(modelInfo.getSrvModelId());
                        List<SrvModelValidate> validateRuleList = isrvValidateRuleDao.queryIsrvValidateRuleList(isrvValidateRule);
                        this.batchInsertPage("srv_model_validate", validateRuleList, sqliteConn);
                        SrvModelExpression srvModelExpression = new SrvModelExpression();
                        srvModelExpression.setSrvModelId(modelInfo.getSrvModelId());
                        List<SrvModelExpression> expressionList = srvModelExpressionDao.queryList(srvModelExpression);
                        this.batchInsertPage("srv_model_expression", validateRuleList, sqliteConn);
                        SrvModelExpvar srvModelExpvar = new SrvModelExpvar();
                        srvModelExpvar.setSrvModelId(modelInfo.getSrvModelId());
                        List<SrvModelExpvar> expvarList = srvModelExpvarDao.queryList(srvModelExpvar);
                        this.batchInsertPage("srv_model_expression", validateRuleList, sqliteConn);
                    }
                }
            }
        }
        catch (Exception e) {
            this.logger.error("\u590d\u5236\u9886\u57df\u670d\u52a1\u5230sqlite", (Throwable)e);
            flag = false;
        }
        finally {
            if (conn != null) {
                this.closeConnection(conn);
            }
            if (sqliteConn != null) {
                this.closeSqliteConnection(sqliteConn);
            }
        }
        return flag;
    }
}

