/*
 * Decompiled with CFR 0.152.
 */
package com.irdstudio.allinapaas.executor.application.executor.core.plugin.market;

import com.irdstudio.allinapaas.executor.application.executor.core.dao.PaasAppsInfoDao;
import com.irdstudio.allinapaas.executor.application.executor.core.dao.SrvModelInfoDao;
import com.irdstudio.allinapaas.executor.application.executor.core.dao.SrvTestCaseDao;
import com.irdstudio.allinapaas.executor.application.executor.core.dao.domain.PaasAppsInfo;
import com.irdstudio.allinapaas.executor.application.executor.core.dao.domain.SrvModelInfo;
import com.irdstudio.allinapaas.executor.application.executor.core.dao.domain.SrvTestCase;
import com.irdstudio.allinapaas.executor.application.executor.core.plugin.market.AbstractMarketTask;
import com.irdstudio.allinrdm.dev.console.types.SrvModelCatalogEnum;
import java.io.File;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.MapUtils;

public class SysMarketCpTestCaseTask
extends AbstractMarketTask {
    private Map<String, Object> extParam = null;

    @Override
    public boolean initTask(Map<String, Object> extParam, Connection conn) throws SQLException {
        this.extParam = extParam;
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean execute() {
        boolean flag = true;
        Connection conn = null;
        Connection sqliteConn = null;
        try {
            conn = this.getConnection();
            String subsId = MapUtils.getString(this.extParam, (Object)"marketSubsId");
            PaasAppsInfoDao paasAppsInfoDao = new PaasAppsInfoDao(conn);
            List<PaasAppsInfo> appList = paasAppsInfoDao.queryPaasAppsInfoListBySysCode(subsId);
            if (CollectionUtils.isNotEmpty(appList)) {
                SrvModelInfoDao srvModelInfoDao = new SrvModelInfoDao(conn);
                SrvTestCaseDao srvTestCaseDao = new SrvTestCaseDao(conn);
                File sqliteFile = this.getSysSqliteFile(this.extParam, null);
                sqliteConn = this.getSqliteConnection(sqliteFile);
                for (PaasAppsInfo appInfo : appList) {
                    SrvModelInfo srvParam = new SrvModelInfo();
                    srvParam.setAppId(appInfo.getAppId());
                    List<SrvModelInfo> srvModelList = srvModelInfoDao.querySrvModelInfoList(srvParam, Arrays.asList(SrvModelCatalogEnum.ComponentServer.getCode(), SrvModelCatalogEnum.TradeServer.getCode(), SrvModelCatalogEnum.BackServer.getCode(), SrvModelCatalogEnum.SrvServer.getCode(), SrvModelCatalogEnum.SdkServer.getCode()));
                    for (SrvModelInfo modelInfo : srvModelList) {
                        SrvTestCase caseParam = new SrvTestCase();
                        caseParam.setSrvModelId(modelInfo.getSrvModelId());
                        List<SrvTestCase> testCaseList = srvTestCaseDao.querySrvTestCaseList(caseParam);
                        this.batchInsertPage("srv_test_case", testCaseList, sqliteConn);
                    }
                }
            }
        }
        catch (Exception e) {
            this.logger.error("\u590d\u5236\u670d\u52a1\u6d4b\u8bd5\u6848\u4f8b\u5230sqlite", (Throwable)e);
            flag = false;
        }
        finally {
            if (conn != null) {
                this.closeConnection(conn);
            }
            if (sqliteConn != null) {
                this.closeSqliteConnection(sqliteConn);
            }
        }
        return flag;
    }
}

