/*
 * Decompiled with CFR 0.152.
 */
package com.irdstudio.allinapaas.executor.application.executor.core.plugin.migrate.dao;

import com.irdstudio.allinapaas.executor.application.executor.core.plugin.migrate.dao.MigrateDictMapping;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.List;

public class MigrateDictMappingDao {
    Connection conn = null;

    public MigrateDictMappingDao(Connection conn) {
        this.conn = conn;
    }

    public List<MigrateDictMapping> queryMigrateDictRelationWithAll() throws SQLException {
        ArrayList<MigrateDictMapping> dcList = new ArrayList<MigrateDictMapping>();
        PreparedStatement ps = null;
        ResultSet rs = null;
        MigrateDictMapping dc = null;
        try {
            ps = this.conn.prepareStatement("SELECT * FROM migrate_dict_mapping");
            rs = ps.executeQuery();
            while (rs.next()) {
                dc = new MigrateDictMapping();
                dc.setMappingId(rs.getString("mapping_id"));
                dc.setRelationId(rs.getString("relation_id"));
                dc.setSourceOptionCode(rs.getString("source_option_code"));
                dc.setSourceOptionName(rs.getString("source_option_name"));
                dc.setTargetOptionCode(rs.getString("target_option_code"));
                dc.setTargetOptionName(rs.getString("target_option_name"));
                dcList.add(dc);
            }
            this.close(rs, null, ps);
        }
        catch (SQLException e) {
            try {
                throw new SQLException("queryMigrateCheckRuleWithAll is Wrong!" + e.getMessage());
            }
            catch (Throwable throwable) {
                this.close(rs, null, ps);
                throw throwable;
            }
        }
        return dcList;
    }

    public List<MigrateDictMapping> queryMigrateDictRelationWithCond(String szCondition, String szOrderBy) throws SQLException {
        ArrayList<MigrateDictMapping> dcList = new ArrayList<MigrateDictMapping>();
        PreparedStatement ps = null;
        ResultSet rs = null;
        try {
            ps = this.conn.prepareStatement("SELECT * FROM migrate_dict_mapping " + szCondition + " " + szOrderBy);
            rs = ps.executeQuery();
            while (rs.next()) {
                MigrateDictMapping dc = new MigrateDictMapping();
                dc.setMappingId(rs.getString("mapping_id"));
                dc.setRelationId(rs.getString("relation_id"));
                dc.setSourceOptionCode(rs.getString("source_option_code"));
                dc.setSourceOptionName(rs.getString("source_option_name"));
                dc.setTargetOptionCode(rs.getString("target_option_code"));
                dc.setTargetOptionName(rs.getString("target_option_name"));
                dcList.add(dc);
            }
            this.close(rs, null, ps);
        }
        catch (SQLException e) {
            try {
                throw new SQLException("queryMigrateCheckRuleWithCond is Wrong!" + e.getMessage());
            }
            catch (Throwable throwable) {
                this.close(rs, null, ps);
                throw throwable;
            }
        }
        return dcList;
    }

    public List<MigrateDictMapping> queryDictionaryTransformRelationalFieldOptionRecordCollection(StringBuffer relationId) throws SQLException {
        String dictMapping = "where relation_id in " + relationId.substring(0, relationId.length() - 1) + ")";
        return this.queryMigrateDictRelationWithCond(dictMapping, "");
    }

    protected void close(ResultSet theRs, Statement theStmt, PreparedStatement thePs) {
        try {
            if (theRs != null) {
                theRs.close();
            }
            if (theStmt != null) {
                theStmt.close();
            }
            if (thePs != null) {
                thePs.close();
            }
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
    }
}

