/*
 * Decompiled with CFR 0.152.
 */
package com.irdstudio.allinapaas.executor.application.executor.core.dao;

import com.irdstudio.allinapaas.executor.application.executor.core.dao.domain.SrvErrorMapping;
import com.irdstudio.allinapaas.executor.application.executor.core.util.db.ProxySQL;
import com.irdstudio.sdk.beans.core.util.POJOUtils;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SrvErrorMappingDao {
    private static final Logger logger = LoggerFactory.getLogger(SrvErrorMappingDao.class);
    Connection conn = null;

    public SrvErrorMappingDao(Connection conn) {
        this.conn = conn;
    }

    public List<SrvErrorMapping> queryDictErrorInfoList(final String appId) throws Exception {
        final ArrayList param = new ArrayList();
        String sql = new ProxySQL(){
            {
                this.SELECT("*");
                this.FROM("`allinrdm_db`.srv_error_mapping");
                this.WHERE("app_id = ?");
                param.add(appId);
            }
        }.toString();
        PreparedStatement ps = null;
        ResultSet rs = null;
        ArrayList<SrvErrorMapping> list = new ArrayList<SrvErrorMapping>();
        try {
            ps = this.conn.prepareStatement(sql);
            for (int i = 0; i < param.size(); ++i) {
                ps.setObject(i + 1, param.get(i));
            }
            rs = ps.executeQuery();
            while (rs.next()) {
                SrvErrorMapping bean = (SrvErrorMapping)((Object)POJOUtils.generatePOJO((ResultSet)rs, SrvErrorMapping.class));
                list.add(bean);
            }
        }
        catch (Exception e) {
            throw new RuntimeException("query queryDictErrorInfoList is wrong", e);
        }
        return list;
    }

    public List<SrvErrorMapping> queryDictErrorInfoList(final SrvErrorMapping paramVO) throws Exception {
        final ArrayList param = new ArrayList();
        String sql = new ProxySQL(){
            {
                this.SELECT("*");
                this.FROM("`allinrdm_db`.srv_error_mapping");
                List vals = POJOUtils.getPOJOValues((Object)((Object)paramVO));
                for (Object[] val : vals) {
                    this.WHERE(String.format("%s = ?", val[0].toString()));
                    param.add(val[1]);
                }
            }
        }.toString();
        PreparedStatement ps = null;
        ResultSet rs = null;
        ArrayList<SrvErrorMapping> list = new ArrayList<SrvErrorMapping>();
        try {
            ps = this.conn.prepareStatement(sql);
            for (int i = 0; i < param.size(); ++i) {
                ps.setObject(i + 1, param.get(i));
            }
            rs = ps.executeQuery();
            while (rs.next()) {
                SrvErrorMapping bean = (SrvErrorMapping)((Object)POJOUtils.generatePOJO((ResultSet)rs, SrvErrorMapping.class));
                list.add(bean);
            }
        }
        catch (Exception e) {
            throw new RuntimeException("query queryDictErrorInfoList is wrong", e);
        }
        return list;
    }

    public boolean updateByPk(final SrvErrorMapping paramVO, final String oldAppId) {
        final ArrayList param = new ArrayList();
        String sql = new ProxySQL(){
            {
                this.UPDATE("`allinrdm_db`.srv_error_mapping");
                List vals = POJOUtils.getPOJOValues((Object)((Object)paramVO));
                for (Object[] val : vals) {
                    this.SET(String.format("%s = ?", val[0].toString()));
                    param.add(val[1]);
                }
                this.WHERE("app_id = ?");
                param.add(oldAppId);
                this.WHERE("error_code = ?");
                param.add(paramVO.getErrorCode());
            }
        }.toString();
        PreparedStatement ps = null;
        try {
            int i;
            ps = this.conn.prepareStatement(sql);
            for (i = 0; i < param.size(); ++i) {
                ps.setObject(i + 1, param.get(i));
            }
            i = ps.executeUpdate();
        }
        catch (Exception e) {
            throw new RuntimeException("update by pk is wrong", e);
        }
        return true;
    }

    public int deleteByAppId(final String appId) throws SQLException {
        final ArrayList param = new ArrayList();
        String sql = new ProxySQL(){
            {
                this.DELETE_FROM("`allinrdm_db`.srv_error_mapping");
                this.WHERE("app_id = ?");
                param.add(appId);
            }
        }.toString();
        PreparedStatement ps = null;
        Object rs = null;
        try {
            ps = this.conn.prepareStatement(sql);
            for (int i = 0; i < param.size(); ++i) {
                ps.setObject(i + 1, param.get(i));
            }
            int re = ps.executeUpdate();
            return re;
        }
        catch (Exception e) {
            throw new RuntimeException("deleteByAppId is wrong", e);
        }
    }
}

