/*
 * Decompiled with CFR 0.152.
 */
package com.irdstudio.allinapaas.executor.application.executor.core.plugin.deploy;

import com.irdstudio.allinapaas.executor.application.executor.core.dao.PaasAppsInfoDao;
import com.irdstudio.allinapaas.executor.application.executor.core.dao.PaasEnvParamDao;
import com.irdstudio.allinapaas.executor.application.executor.core.dao.domain.PaasAppsInfo;
import com.irdstudio.allinapaas.executor.application.executor.core.plugin.AbstractPlugin;
import com.irdstudio.allinapaas.executor.application.executor.core.plugin.apps.SdEnvUtil;
import com.irdstudio.allinapaas.executor.application.executor.core.plugin.deploy.MavenRunner;
import com.irdstudio.allinapaas.executor.application.executor.core.plugin.devops.maven.MavenConf;
import com.irdstudio.sdk.beans.core.util.PropertiesUtil;
import java.io.File;
import java.sql.Connection;
import java.sql.SQLException;

public class MavenBuildCommonPlugin
extends AbstractPlugin {
    private PaasAppsInfo appInfo = null;
    private MavenConf mavenConf = null;

    @Override
    protected boolean doReadConfigureFromDB(Connection conn, String szConfIdentify) throws SQLException {
        String batchSerialNo = this.context.getSzBatchSn();
        PaasAppsInfoDao paasAppsInfoDao = new PaasAppsInfoDao(conn);
        this.appInfo = paasAppsInfoDao.queryByBatchSerialNo(batchSerialNo);
        PaasEnvParamDao paasEnvParamDao = new PaasEnvParamDao(conn);
        this.mavenConf = new MavenConf();
        this.mavenConf.setMavenSettings(PropertiesUtil.getPropertyByKey((String)"application", (String)"tdp.maven.settings.path"));
        this.mavenConf.setMavenHome(PropertiesUtil.getPropertyByKey((String)"application", (String)"tdp.maven.path"));
        String localPath = this.context.getVv().getValue("local.path");
        String local = null;
        local = localPath.equals("build") ? SdEnvUtil.BUILD_PATH : (localPath.equals("template") ? SdEnvUtil.TEMPLATE_PATH : SdEnvUtil.PROJECT_PATH);
        String remotePath = this.appInfo.getAppCode();
        this.mavenConf.setLocalPath(local + File.separator + remotePath);
        String mavenParam = this.context.getVv().getValue("maven.param");
        this.mavenConf.setMavenParam(mavenParam);
        if (this.mavenConf.getMavenHome() == null || this.mavenConf.getLocalPath() == null || this.mavenConf.getMavenSettings() == null) {
            this.context.setSzLastErrorMsg("\u672a\u8bfb\u53d6\u5230\u914d\u7f6e\u6807\u8bc6\u4e3a\uff1a" + szConfIdentify + "\u7684\u6570\u636eMySQL\u914d\u7f6e!");
            return false;
        }
        return true;
    }

    @Override
    public boolean execute() {
        this.logger.info("\u8c03\u7528Maven\u7f16\u8bd1\u63d2\u4ef6\uff0c\u7f16\u8bd1\u5e94\u7528: " + this.mavenConf.getLocalPath());
        MavenRunner mavenRunner = new MavenRunner(this.mavenConf.getMavenParam(), this.mavenConf.getLocalPath(), this.logger);
        mavenRunner.setMavenHome(SdEnvUtil.MAVEN_PATH);
        mavenRunner.setJavaHome(PropertiesUtil.getPropertyByKey((String)"application", (String)"tdp.maven.java.home.path"));
        mavenRunner.setSetting(this.mavenConf.getMavenSettings());
        return mavenRunner.run();
    }
}

