/*
 * Decompiled with CFR 0.152.
 */
package com.irdstudio.allinapaas.executor.application.executor.core.plugin.docs.gendoc;

import com.alibaba.excel.EasyExcel;
import com.alibaba.excel.ExcelWriter;
import com.alibaba.excel.write.metadata.WriteSheet;
import com.irdstudio.allinapaas.executor.application.executor.core.dao.BatInstBatchDao;
import com.irdstudio.allinapaas.executor.application.executor.core.dao.PaasAppsInfoDao;
import com.irdstudio.allinapaas.executor.application.executor.core.dao.domain.PaasAppsInfo;
import com.irdstudio.allinapaas.executor.application.executor.core.dao.domain.PaasDocTemplate;
import com.irdstudio.allinapaas.executor.application.executor.core.plugin.common.SSubsInfo;
import com.irdstudio.allinapaas.executor.application.executor.core.plugin.common.SSubsInfoDao;
import com.irdstudio.allinapaas.executor.application.executor.core.plugin.docs.gendoc.DocGenerate;
import com.irdstudio.allinapaas.executor.application.executor.core.plugin.docs.git.queue.DocTemplateRepoPullQueueExecutor;
import com.irdstudio.allinapaas.executor.application.executor.core.tinycore.jdbc.dbcp.base.IConnPool;
import com.irdstudio.allinapaas.executor.application.executor.core.util.date.CurrentDateUtil;
import com.irdstudio.allinrdm.dev.console.facade.AppResourceService;
import com.irdstudio.allinrdm.dev.console.facade.dto.AppResourceDTO;
import com.irdstudio.sdk.beans.core.util.BeanUtility;
import com.irdstudio.sdk.beans.core.util.SpringContextUtils;
import java.io.File;
import java.sql.Connection;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;

public class GenNcdpaasAppsMenuExcel
implements DocGenerate {
    @Override
    public List<File> generateDoc(PaasDocTemplate template, String subsId, File baseDir, IConnPool connTool, Map<String, Object> extParams) {
        return null;
    }

    public void ncdpaasAppMenuData(ExcelWriter excelWriter, WriteSheet sheet, String appId) {
        AppResourceService appResourceService = (AppResourceService)SpringContextUtils.getBean(AppResourceService.class);
        AppResourceDTO param = new AppResourceDTO();
        param.setAppId(appId);
        List<AppResourceDTO> rows = appResourceService.queryList((Object)param);
        if (CollectionUtils.isEmpty((Collection)rows)) {
            rows = Collections.emptyList();
        }
        ArrayList<AppResourceDTO> list = new ArrayList<AppResourceDTO>(rows.size());
        ArrayList<AppResourceDTO> root = new ArrayList<AppResourceDTO>(rows.size());
        HashMap<String, Object> menuMap = new HashMap<String, Object>(rows.size());
        for (AppResourceDTO resource : rows) {
            menuMap.put(resource.getResourceid(), resource);
        }
        for (AppResourceDTO resource : rows) {
            AppResourceDTO parent = (AppResourceDTO)menuMap.get(resource.getParentid());
            if (parent == null) {
                root.add(resource);
                continue;
            }
            ArrayList<AppResourceDTO> child = (ArrayList<AppResourceDTO>)menuMap.get(parent.getResourceid() + "children");
            if (CollectionUtils.isEmpty((Collection)child)) {
                child = new ArrayList<AppResourceDTO>();
                menuMap.put(parent.getResourceid() + "children", child);
            }
            child.add(resource);
        }
        for (AppResourceDTO resource : root) {
            list.add(resource);
            this.recursionFind(resource, list, menuMap);
        }
        excelWriter.fill(list, sheet);
    }

    private void recursionFind(AppResourceDTO resource, List<AppResourceDTO> list, Map<String, Object> menuMap) {
        String parentId = resource.getResourceid();
        List child = (List)menuMap.get(parentId + "children");
        if (CollectionUtils.isNotEmpty((Collection)child)) {
            for (AppResourceDTO c : child) {
                list.add(c);
                this.recursionFind(c, list, menuMap);
            }
        }
    }

    @Override
    public File generateAppDoc(PaasDocTemplate template, String appId, File baseDir, IConnPool connTool, Map<String, Object> extParams) {
        Connection conn = null;
        try {
            String moduleCode = "ncdpaas";
            conn = connTool.getConnection();
            File currentFile = this.getDocDirPath(template, baseDir, conn);
            if (!currentFile.exists()) {
                currentFile.mkdirs();
            }
            BatInstBatchDao batInstBatchDao = new BatInstBatchDao(conn);
            PaasAppsInfoDao paasAppsInfoDao = new PaasAppsInfoDao(conn);
            SSubsInfoDao sSubsInfoDao = new SSubsInfoDao(conn);
            PaasAppsInfo appInfo = paasAppsInfoDao.queryByAppId(appId);
            SSubsInfo subsInfo = sSubsInfoDao.querySSubsInfoWithKeys(appInfo.getSubsId());
            String subsId = subsInfo.getSubsId();
            String subsCode = subsInfo.getSubsCode();
            String subsName = subsInfo.getSubsName();
            String userId = template.getLoginUserId();
            String today = CurrentDateUtil.getTodayDate();
            String todayTime = CurrentDateUtil.getTodayDateEx2();
            Map subsInfoMap = BeanUtility.bean2Map((Object)((Object)subsInfo));
            Map appInfoMap = BeanUtility.bean2Map((Object)((Object)appInfo));
            appInfoMap.put("today", today);
            appInfoMap.put("todayTime", todayTime);
            appInfoMap.putAll(subsInfoMap);
            String fileName = template.getDocName();
            if (StringUtils.isNotBlank((CharSequence)template.getDocNameTemplate())) {
                fileName = this.renderDocName(template.getDocNameTemplate(), appInfoMap);
            }
            String excelTemplatePath = DocTemplateRepoPullQueueExecutor.getDocTemplatePath();
            File templateFile = new File(excelTemplatePath, template.getDocFile());
            File targetFile = new File(currentFile, fileName);
            ExcelWriter excelWriter = EasyExcel.write((File)targetFile).withTemplate(templateFile).build();
            WriteSheet sheet = EasyExcel.writerSheet((Integer)0, null).build();
            this.ncdpaasAppMenuData(excelWriter, sheet, appId);
            excelWriter.finish();
            File file = targetFile;
            return file;
        }
        catch (Exception e) {
            logger.error("\u524d\u7aef\u5e94\u7528\u83dc\u5355\u5bfc\u51fa\u5f02\u5e38 " + e.getMessage(), (Throwable)e);
            throw new RuntimeException("\u524d\u7aef\u5e94\u7528\u83dc\u5355\u5bfc\u51fa\u5f02\u5e38 " + e.getMessage(), e);
        }
        finally {
            connTool.releaseConnection(conn);
        }
    }
}

