/*
 * Decompiled with CFR 0.152.
 */
package com.irdstudio.allinapaas.executor.application.executor.core.plugin.ftp;

import com.irdstudio.allinapaas.executor.application.executor.core.plugin.AbstractPlugin;
import com.irdstudio.allinapaas.executor.application.executor.core.plugin.ftp.FtpClient;
import com.irdstudio.allinapaas.executor.application.executor.core.plugin.ftp.FtpPluginContants;
import com.irdstudio.allinapaas.executor.application.executor.core.plugin.ftp.PluginFtpConf;
import com.irdstudio.allinapaas.executor.application.executor.core.plugin.ftp.PluginFtpConfDao;
import com.irdstudio.allinapaas.executor.application.executor.core.plugin.ftp.SftpClient;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.List;

public class FtpPlugin
extends AbstractPlugin {
    private List<PluginFtpConf> ftpList = null;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean execute() {
        this.logger.info("........................................................................");
        boolean flag = true;
        SftpClient sc = null;
        FtpClient fc = null;
        try {
            for (PluginFtpConf pfc : this.ftpList) {
                pfc.setRemoteFileName(this.context.toParseSysVariable(pfc.getRemoteFileName()));
                pfc.setFtpFilePath(this.context.toParseSysVariable(pfc.getFtpFilePath()));
                pfc.setLocalFileName(this.context.toParseSysVariable(pfc.getLocalFileName()));
                pfc.setLocalFilePath(this.context.toParseSysVariable(pfc.getLocalFilePath()));
                String serverType = pfc.getServerType();
                String sftpServerIp = pfc.getSftpServerIp();
                int ftpServerPort = pfc.getFtpServerPort();
                String ftpServerUser = pfc.getFtpServerUser();
                String ftpServerPwd = pfc.getFtpServerPwd();
                String loadType = pfc.getLoadType();
                String remoteFileName = pfc.getRemoteFileName();
                String localFileName = pfc.getLocalFileName();
                String ftpFilePath = pfc.getFtpFilePath();
                String localFilePath = pfc.getLocalFilePath();
                if (FtpPluginContants.SERVER_SFTP.equals(serverType)) {
                    sc = new SftpClient(sftpServerIp, ftpServerPort, ftpServerUser, ftpServerPwd, this.logger);
                    if (FtpPluginContants.UPLOAD.equals(loadType)) {
                        this.logger.info("\u6587\u4ef6[" + localFilePath + localFileName + "]\u4e0a\u4f20\uff0c\u670d\u52a1\u5668[" + ftpFilePath + "]\u5f00\u59cb");
                        sc.upLoad(localFileName, ftpFilePath, localFilePath);
                        continue;
                    }
                    if (FtpPluginContants.DOWNLOAD.equals(loadType)) {
                        this.logger.info("\u6587\u4ef6[" + localFilePath + localFileName + "]\u4e0b\u8f7d\uff0c\u670d\u52a1\u5668[" + ftpFilePath + "]\u5f00\u59cb");
                        sc.downLoad(remoteFileName, ftpFilePath, localFilePath);
                        continue;
                    }
                    throw new Exception("\u6587\u4ef6\u64cd\u4f5c\u7c7b\u578b\u4e3a\u7a7a\uff01\uff01\uff01\uff01");
                }
                if (!FtpPluginContants.SERVER_FTP.equals(serverType)) continue;
                fc = new FtpClient();
                fc.openSession(sftpServerIp, ftpServerPort, ftpServerUser, ftpServerPwd);
                if (FtpPluginContants.UPLOAD.equals(loadType)) {
                    this.logger.info("\u6587\u4ef6[" + localFilePath + localFileName + "]\u4e0a\u4f20\uff0c\u670d\u52a1\u5668[" + ftpFilePath + "]\u5f00\u59cb");
                    fc.uploadFile(localFilePath + localFileName, ftpFilePath);
                    continue;
                }
                if (FtpPluginContants.DOWNLOAD.equals(loadType)) {
                    this.logger.info("\u6587\u4ef6[" + localFilePath + localFileName + "]\u4e0b\u8f7d\uff0c\u670d\u52a1\u5668[" + ftpFilePath + "]\u5f00\u59cb");
                    fc.downloadFile(ftpFilePath + remoteFileName, localFilePath);
                    continue;
                }
                throw new Exception("\u6587\u4ef6\u64cd\u4f5c\u7c7b\u578b\u4e3a\u7a7a\uff01\uff01\uff01\uff01");
            }
        }
        catch (Exception e) {
            flag = false;
            this.logger.error("FTP\u63d2\u4ef6\u6267\u884c\u5931\u8d25\uff1a" + e.getMessage(), e);
            this.context.setSzLastErrorMsg(e.getMessage());
            this.logger.info("\u9519\u8bef\u4fe1\u606f\uff1a" + e);
        }
        return flag;
    }

    @Override
    protected boolean doReadConfigureFromDB(Connection conn, String szConfIdentify) throws SQLException {
        PluginFtpConfDao pfcDao = new PluginFtpConfDao(conn);
        this.ftpList = pfcDao.queryWithCond(" where plugin_conf_id='" + szConfIdentify + "'", "order by conf_sort");
        if (this.ftpList.size() < 1) {
            this.context.setSzLastErrorMsg("\u672a\u8bfb\u53d6\u5230\u914d\u7f6e\u6807\u8bc6\u4e3a\uff1a" + szConfIdentify + "\u7684\u6570\u636eFTP\u914d\u7f6e!");
            return false;
        }
        return true;
    }
}

