/*
 * Decompiled with CFR 0.152.
 */
package com.irdstudio.allinapaas.executor.application.executor.core.plugin.market;

import com.alibaba.fastjson.JSON;
import com.irdstudio.allinapaas.design.console.types.MarketSource;
import com.irdstudio.allinapaas.executor.application.executor.core.dao.PaasAppsInfoDao;
import com.irdstudio.allinapaas.executor.application.executor.core.dao.PaasEnvParamDao;
import com.irdstudio.allinapaas.executor.application.executor.core.dao.PaasMarketAppinfoDao;
import com.irdstudio.allinapaas.executor.application.executor.core.dao.SrvErrorMappingDao;
import com.irdstudio.allinapaas.executor.application.executor.core.dao.domain.ModelFolderInfo;
import com.irdstudio.allinapaas.executor.application.executor.core.dao.domain.ModelTableField;
import com.irdstudio.allinapaas.executor.application.executor.core.dao.domain.ModelTableIndex;
import com.irdstudio.allinapaas.executor.application.executor.core.dao.domain.ModelTableInfo;
import com.irdstudio.allinapaas.executor.application.executor.core.dao.domain.PaasAppsInfo;
import com.irdstudio.allinapaas.executor.application.executor.core.dao.domain.PaasAppsParam;
import com.irdstudio.allinapaas.executor.application.executor.core.dao.domain.PaasAppsProperties;
import com.irdstudio.allinapaas.executor.application.executor.core.dao.domain.PaasAppsSql;
import com.irdstudio.allinapaas.executor.application.executor.core.dao.domain.PaasMarketAppinfo;
import com.irdstudio.allinapaas.executor.application.executor.core.dao.domain.SrvErrorMapping;
import com.irdstudio.allinapaas.executor.application.executor.core.dao.domain.SrvModelInfo;
import com.irdstudio.allinapaas.executor.application.executor.core.dao.domain.SrvModelInout;
import com.irdstudio.allinapaas.executor.application.executor.core.dao.domain.SrvModelPackage;
import com.irdstudio.allinapaas.executor.application.executor.core.plugin.market.AbstractMarketTask;
import com.irdstudio.allinapaas.portal.console.types.YesOrNO;
import com.irdstudio.allinrdm.dev.console.types.DomainEvalWay;
import com.irdstudio.allinrdm.dev.console.types.FieldEvalWay;
import com.irdstudio.allinrdm.dev.console.types.SectionType;
import com.irdstudio.sdk.beans.core.util.POJOUtils;
import com.irdstudio.sdk.beans.core.util.UUIDUtil;
import java.io.File;
import java.io.IOException;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.MapUtils;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang3.StringUtils;
import org.dom4j.Element;

public class CPNCPTransSqliteTask
extends AbstractMarketTask {
    private PaasMarketAppinfo appInfo = null;
    private Map<String, Object> extParam = null;

    @Override
    public boolean initTask(Map<String, Object> extParam, Connection conn) throws SQLException {
        this.extParam = extParam;
        PaasMarketAppinfoDao paasAppsInfoDao = new PaasMarketAppinfoDao(conn);
        this.appInfo = paasAppsInfoDao.queryPaasMarketAppinfo(MapUtils.getString(extParam, (Object)"marketAppId"));
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean execute() {
        boolean flag = true;
        Connection conn = null;
        Connection sqliteConn = null;
        try {
            PaasEnvParamDao paasEnvParamDao;
            conn = this.getConnection();
            String subsFlag = MapUtils.getString(this.extParam, (Object)"subsFlag");
            String marketSource = MapUtils.getString(this.extParam, (Object)"marketSource");
            String subsId = MapUtils.getString(this.extParam, (Object)"marketSubsId");
            ArrayList<PaasMarketAppinfo> appInfoList = new ArrayList<PaasMarketAppinfo>();
            if (StringUtils.equals((CharSequence)marketSource, (CharSequence)MarketSource.Inside.getCode())) {
                if (StringUtils.equals((CharSequence)subsFlag, (CharSequence)YesOrNO.YES.getCode())) {
                    PaasMarketAppinfoDao paasAppsInfoDao = new PaasMarketAppinfoDao(conn);
                    PaasMarketAppinfo appParam = new PaasMarketAppinfo();
                    appParam.setSubsId(subsId);
                    List<PaasMarketAppinfo> sysApps = paasAppsInfoDao.queryPaasMarketAppinfoList(appParam);
                    appInfoList.addAll(sysApps);
                } else {
                    appInfoList.add(this.appInfo);
                }
            } else {
                String respJson;
                PaasMarketAppinfo param;
                paasEnvParamDao = new PaasEnvParamDao(conn);
                String apiUrl = paasEnvParamDao.queryByCodeReturnValue("allinpaas.open.api.http.url");
                if (StringUtils.equals((CharSequence)subsFlag, (CharSequence)YesOrNO.YES.getCode())) {
                    param = new PaasMarketAppinfo();
                    param.setSubsId(subsId);
                    respJson = this.requestOpenApi(apiUrl + "/om/paas/market/appinfo/index", (Object)param);
                    if (StringUtils.isBlank((CharSequence)respJson)) {
                        boolean bl = flag = false;
                        return bl;
                    }
                    List sysApps = JSON.parseArray((String)respJson, PaasMarketAppinfo.class);
                    appInfoList.addAll(sysApps);
                } else {
                    param = new PaasMarketAppinfo();
                    param.setMarketAppId(MapUtils.getString(this.extParam, (Object)"marketAppId"));
                    respJson = this.requestOpenApi(apiUrl + "/om/paas/market/appinfo", (Object)param);
                    if (StringUtils.isBlank((CharSequence)respJson)) {
                        boolean sysApps = flag = false;
                        return sysApps;
                    }
                    PaasMarketAppinfo marketApp = (PaasMarketAppinfo)((Object)JSON.parseObject((String)respJson, PaasMarketAppinfo.class));
                    appInfoList.add(marketApp);
                }
            }
            paasEnvParamDao = new PaasEnvParamDao(conn);
            String marketUrl = paasEnvParamDao.queryByCodeReturnValue("git.market.remote.path");
            for (PaasMarketAppinfo srcApp : appInfoList) {
                if (StringUtils.equals((CharSequence)marketSource, (CharSequence)MarketSource.Inside.getCode())) {
                    this.copyAppSqlite(srcApp, marketUrl);
                } else {
                    this.copyAppSqlite(srcApp, srcApp.getMarketAppGiturl());
                }
                this.transPkId(srcApp, conn);
            }
        }
        catch (Exception e) {
            this.logger.error("\u5e94\u7528\u6570\u636e\u6e05\u6d17sqlite", (Throwable)e);
            flag = false;
        }
        finally {
            if (conn != null) {
                this.closeConnection(conn);
            }
            if (sqliteConn != null) {
                this.closeSqliteConnection(sqliteConn);
            }
        }
        return flag;
    }

    private void copyAppSqlite(PaasMarketAppinfo appInfo, String marketUrl) throws IOException {
        String marketPath = this.getMarketPath();
        String repoPath = this.getRepoPath(marketUrl);
        File repoDir = new File(repoPath);
        String sysCode = appInfo.getSubsCode();
        String appId = appInfo.getAppId();
        String appCode = appInfo.getAppCode();
        String version = appInfo.getAppVersion();
        version = StringUtils.isNotBlank((CharSequence)version) ? "_" + version : "";
        File sysDir = new File(repoDir, sysCode);
        File srcSqliteFile = null;
        srcSqliteFile = StringUtils.isNotBlank((CharSequence)sysCode) ? new File(sysDir, String.format("%s_%s%s.db", sysCode, appCode, version)) : new File(sysDir, String.format("%s%s.db", appCode, version));
        File destDir = new File(marketPath);
        File destSqliteFile = new File(destDir, String.format("%s_%s.db", appCode, appId));
        FileUtils.copyFile((File)srcSqliteFile, (File)destSqliteFile);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void transPkId(PaasMarketAppinfo srcApp, Connection conn) throws Exception {
        Connection sqliteConn = null;
        try {
            String tableModelId;
            String newId;
            String objectId;
            String newId2;
            File sqliteFile = this.getSqliteFile(srcApp);
            sqliteConn = this.getSqliteConnection(sqliteFile);
            PaasAppsInfoDao paasAppsInfoDao = new PaasAppsInfoDao(sqliteConn);
            SrvErrorMappingDao srvErrorMappingDao = new SrvErrorMappingDao(sqliteConn);
            HashMap<String, String> keyMap = new HashMap<String, String>();
            keyMap.put(srcApp.getAppId(), UUIDUtil.getUUID());
            ResultSet pPackages = this.queryAll(ModelFolderInfo.class, sqliteConn);
            while (pPackages.next()) {
                ModelFolderInfo pp = (ModelFolderInfo)((Object)POJOUtils.generatePOJO((ResultSet)pPackages, ModelFolderInfo.class));
                String oldId = pp.getFolderId();
                String oldAbvId = pp.getFolderAbvId();
                String newId3 = this.getKeyMapNewId(oldId, keyMap);
                String newAbvId = this.getKeyMapNewId(oldAbvId, keyMap);
                String newProjectId = this.getKeyMapNewId(pp.getAppId(), keyMap);
                pp.setFolderId(newId3);
                pp.setFolderAbvId(newAbvId);
                pp.setAppId(newProjectId);
                this.updateByPk(pp, "packageId", oldId, sqliteConn);
            }
            pPackages.close();
            ResultSet tables = this.queryAll(ModelTableInfo.class, sqliteConn);
            while (tables.next()) {
                ModelTableInfo table = (ModelTableInfo)((Object)POJOUtils.generatePOJO((ResultSet)tables, ModelTableInfo.class));
                String oldId = table.getObjectId();
                String oldPackageId = table.getFolderId();
                newId2 = this.getKeyMapNewId(oldId, keyMap);
                String newPackageId = this.getKeyMapNewId(oldPackageId, keyMap);
                String newProjectId = this.getKeyMapNewId(table.getAppId(), keyMap);
                table.setObjectId(newId2);
                table.setFolderId(newPackageId);
                table.setAppId(newProjectId);
                this.updateByPk(table, "objectId", oldId, sqliteConn);
            }
            tables.close();
            ResultSet fieldRs = this.queryAll(ModelTableField.class, sqliteConn);
            while (fieldRs.next()) {
                ModelTableField field = (ModelTableField)((Object)POJOUtils.generatePOJO((ResultSet)fieldRs, ModelTableField.class));
                String oldId = field.getFieldId();
                newId2 = this.getKeyMapNewId(oldId, keyMap);
                objectId = this.getKeyMapNewId(field.getObjectId(), keyMap);
                field.setObjectId(objectId);
                field.setFieldId(newId2);
                this.updateByPk(field, "fieldId", oldId, sqliteConn);
            }
            fieldRs.close();
            ResultSet indexRs = this.queryAll(ModelTableIndex.class, sqliteConn);
            while (indexRs.next()) {
                ModelTableIndex indexVO = (ModelTableIndex)((Object)POJOUtils.generatePOJO((ResultSet)indexRs, ModelTableIndex.class));
                String oldId = indexVO.getObjectId();
                objectId = this.getKeyMapNewId(oldId, keyMap);
                indexVO.setObjectId(objectId);
                HashMap<String, String> pks = new HashMap<String, String>();
                pks.put("objectId", oldId);
                pks.put("indexName", indexVO.getIndexName());
                this.updateByPk(indexVO, pks, sqliteConn);
            }
            indexRs.close();
            ResultSet paasAppsInfoRs = this.queryAll(PaasAppsInfo.class, sqliteConn);
            while (paasAppsInfoRs.next()) {
                PaasAppsInfo paasApp = (PaasAppsInfo)((Object)POJOUtils.generatePOJO((ResultSet)paasAppsInfoRs, PaasAppsInfo.class));
                String oldId = paasApp.getAppId();
                String newId4 = this.getKeyMapNewId(oldId, keyMap);
                paasApp.setAppId(newId4);
                this.updateByPk(paasApp, "appId", oldId, sqliteConn);
            }
            paasAppsInfoRs.close();
            ResultSet paasAppsParamRs = this.queryAll(PaasAppsParam.class, sqliteConn);
            while (paasAppsParamRs.next()) {
                PaasAppsParam paasAppParam = (PaasAppsParam)((Object)POJOUtils.generatePOJO((ResultSet)paasAppsParamRs, PaasAppsParam.class));
                String oldId = paasAppParam.getAppId();
                String newId5 = this.getKeyMapNewId(oldId, keyMap);
                paasAppParam.setAppId(newId5);
                HashMap<String, String> pks = new HashMap<String, String>();
                pks.put("appId", oldId);
                pks.put("paramCode", paasAppParam.getParamCode());
                this.updateByPk(paasAppParam, pks, sqliteConn);
            }
            paasAppsParamRs.close();
            ResultSet paasAppsSqlRs = this.queryAll(PaasAppsSql.class, sqliteConn);
            while (paasAppsSqlRs.next()) {
                PaasAppsSql paasAppSql = (PaasAppsSql)((Object)POJOUtils.generatePOJO((ResultSet)paasAppsSqlRs, PaasAppsSql.class));
                String oldId = paasAppSql.getRecordKeyid();
                String newId6 = this.getKeyMapNewId(oldId, keyMap);
                paasAppSql.setRecordKeyid(newId6);
                String oldAppId = paasAppSql.getAppId();
                String newAppId = this.getKeyMapNewId(oldAppId, keyMap);
                paasAppSql.setAppId(newAppId);
                this.updateByPk(paasAppSql, "recordKeyid", oldId, sqliteConn);
            }
            paasAppsSqlRs.close();
            ResultSet paasAppsPropertiesRs = this.queryAll(PaasAppsProperties.class, sqliteConn);
            while (paasAppsPropertiesRs.next()) {
                PaasAppsProperties paasAppsProp = (PaasAppsProperties)((Object)POJOUtils.generatePOJO((ResultSet)paasAppsPropertiesRs, PaasAppsProperties.class));
                String oldId = paasAppsProp.getRecordKeyid();
                String newId7 = this.getKeyMapNewId(oldId, keyMap);
                paasAppsProp.setRecordKeyid(newId7);
                String oldAppId = paasAppsProp.getAppId();
                String newAppId = this.getKeyMapNewId(oldAppId, keyMap);
                paasAppsProp.setAppId(newAppId);
                this.updateByPk(paasAppsProp, "recordKeyid", oldId, sqliteConn);
            }
            paasAppsPropertiesRs.close();
            ResultSet srvPackageRs = this.queryAll(SrvModelPackage.class, sqliteConn);
            while (srvPackageRs.next()) {
                SrvModelPackage pg = (SrvModelPackage)((Object)POJOUtils.generatePOJO((ResultSet)srvPackageRs, SrvModelPackage.class));
                String oldId = pg.getPackageId();
                String oldPId = pg.getPackageAbvId();
                newId = this.getKeyMapNewId(oldId, keyMap);
                String newPId = this.getKeyMapNewId(oldPId, keyMap);
                pg.setAppId(this.getKeyMapNewId(pg.getAppId(), keyMap));
                pg.setPackageAbvId(newPId);
                pg.setPackageId(newId);
                this.updateByPk(pg, "packageId", oldId, sqliteConn);
            }
            srvPackageRs.close();
            ResultSet srvModelRs = this.queryAll(SrvModelInfo.class, sqliteConn);
            while (srvModelRs.next()) {
                SrvModelInfo modelInfo = (SrvModelInfo)((Object)POJOUtils.generatePOJO((ResultSet)srvModelRs, SrvModelInfo.class));
                String oldId = modelInfo.getSrvModelId();
                newId = this.getKeyMapNewId(oldId, keyMap);
                String appId = this.getKeyMapNewId(modelInfo.getAppId(), keyMap);
                String packageId = this.getKeyMapNewId(modelInfo.getPackageId(), keyMap);
                tableModelId = this.getKeyMapNewId(modelInfo.getTableModelId(), keyMap);
                modelInfo.setSrvModelId(newId);
                modelInfo.setAppId(appId);
                modelInfo.setPackageId(packageId);
                modelInfo.setTableModelId(tableModelId);
                this.updateByPk(modelInfo, "srvModelId", oldId, sqliteConn);
            }
            srvModelRs.close();
            ResultSet inoutRs = this.queryAll(SrvModelInout.class, sqliteConn);
            while (inoutRs.next()) {
                SrvModelInout inout = (SrvModelInout)((Object)POJOUtils.generatePOJO((ResultSet)inoutRs, SrvModelInout.class));
                String oldId = inout.getRecordKeyId();
                String newId8 = this.getKeyMapNewId(oldId, keyMap);
                String srvModelId = this.getKeyMapNewId(inout.getSrvModelId(), keyMap, true);
                tableModelId = this.getKeyMapNewId(inout.getTableModelId(), keyMap, true);
                inout.setRecordKeyId(newId8);
                inout.setSrvModelId(srvModelId);
                inout.setTableModelId(tableModelId);
                this.updateByPk(inout, "recordKeyId", oldId, sqliteConn);
            }
            inoutRs.close();
            List<SrvErrorMapping> errorList = srvErrorMappingDao.queryDictErrorInfoList(srcApp.getAppId());
            for (SrvErrorMapping errorInfo : errorList) {
                errorInfo.setAppId((String)keyMap.get(errorInfo.getAppId()));
                srvErrorMappingDao.updateByPk(errorInfo, srcApp.getAppId());
            }
            PaasMarketAppinfoDao keyMapDao = new PaasMarketAppinfoDao(sqliteConn);
            keyMapDao.createKeyMap();
            keyMapDao.saveKeyMap(keyMap);
            if (sqliteConn == null) return;
        }
        catch (Throwable throwable) {
            if (sqliteConn == null) throw throwable;
            this.closeSqliteConnection(sqliteConn);
            throw throwable;
        }
        this.closeSqliteConnection(sqliteConn);
    }

    private String getKeyMapNewId(String id, Map<String, String> keyMap) {
        return this.getKeyMapNewId(id, keyMap, false);
    }

    private String getKeyMapNewId(String id, Map<String, String> keyMap, boolean noCreate) {
        if (StringUtils.isBlank((CharSequence)id)) {
            return id;
        }
        String newId = keyMap.get(id);
        if (newId == null) {
            if (!noCreate) {
                newId = UUIDUtil.getUUID();
                keyMap.put(id, newId);
            } else {
                newId = id;
            }
        }
        return newId;
    }

    private String transEvalContent(String type, String evalWay, String evalContent, Map<String, String> keyMap) {
        try {
            if (StringUtils.isBlank((CharSequence)evalContent)) {
                return evalContent;
            }
            if (DomainEvalWay.FORMULA.getCode().equals(evalWay)) {
                List tagList = JSON.parseArray((String)evalContent, Map.class);
                if (CollectionUtils.isNotEmpty((Collection)tagList)) {
                    for (Map tag : tagList) {
                        String tdType = MapUtils.getString((Map)tag, (Object)"tdType");
                        if (!"F".equals(tdType)) continue;
                        String objectId = MapUtils.getString((Map)tag, (Object)"objectId");
                        String domainVarId = MapUtils.getString((Map)tag, (Object)"domainVarId");
                        String fieldId = MapUtils.getString((Map)tag, (Object)"fieldId");
                        tag.put("objectId", this.getKeyMapNewId(objectId, keyMap, true));
                        tag.put("domainVarId", this.getKeyMapNewId(domainVarId, keyMap, true));
                        tag.put("fieldId", this.getKeyMapNewId(fieldId, keyMap, true));
                    }
                    evalContent = JSON.toJSONString((Object)tagList);
                }
            } else if ((FieldEvalWay.ASSIGN.getCode().equals(evalWay) || DomainEvalWay.ASSIGN.getCode().equals(evalWay)) && "osrv".equals(type)) {
                Map map = (Map)JSON.parseObject((String)evalContent, Map.class);
                String fieldId = MapUtils.getString((Map)map, (Object)"fieldId");
                String objectId = MapUtils.getString((Map)map, (Object)"objectId");
                map.put("fieldId", this.getKeyMapNewId(fieldId, keyMap, true));
                map.put("objectId", this.getKeyMapNewId(objectId, keyMap, true));
                Map varObj = MapUtils.getMap((Map)map, (Object)"varObj");
                if (varObj != null) {
                    String domainVarId = MapUtils.getString((Map)varObj, (Object)"domainVarId");
                    String srvModelId = MapUtils.getString((Map)varObj, (Object)"srvModelId");
                    String tableModelId = MapUtils.getString((Map)varObj, (Object)"tableModelId");
                    String id = MapUtils.getString((Map)varObj, (Object)"id");
                    varObj.put("domainVarId", this.getKeyMapNewId(domainVarId, keyMap, true));
                    varObj.put("srvModelId", this.getKeyMapNewId(srvModelId, keyMap, true));
                    varObj.put("tableModelId", this.getKeyMapNewId(tableModelId, keyMap, true));
                    varObj.put("id", this.getKeyMapNewId(id, keyMap, true));
                }
                evalContent = JSON.toJSONString((Object)map);
            } else if (FieldEvalWay.ERROR.getCode().equals(evalWay)) {
                Map map = (Map)JSON.parseObject((String)evalContent, Map.class);
                String errorAppId = MapUtils.getString((Map)map, (Object)"appId");
                String errorCode = MapUtils.getString((Map)map, (Object)"errorCode");
                String appId = this.getKeyMapNewId(errorAppId, keyMap, true);
                map.put("appId", appId);
                evalContent = JSON.toJSONString((Object)map);
            } else if (FieldEvalWay.FUNC.getCode().equals(evalWay)) {
                Map map = (Map)JSON.parseObject((String)evalContent, Map.class);
                String appId = MapUtils.getString((Map)map, (Object)"appId");
                String srvModelId = MapUtils.getString((Map)map, (Object)"srvModelId");
                String newAppId = this.getKeyMapNewId(appId, keyMap, true);
                String newSrvModelId = this.getKeyMapNewId(srvModelId, keyMap, true);
                map.put("appId", newAppId);
                map.put("srvModelId", newSrvModelId);
                evalContent = JSON.toJSONString((Object)map);
            }
        }
        catch (Exception e) {
            this.logger.error("transEvalContent error", (Throwable)e);
        }
        return evalContent;
    }

    private String transSectionContent(String sectionType, String sectionContent, Map<String, String> keyMap) {
        try {
            Map map = (Map)JSON.parseObject((String)sectionContent, Map.class);
            if (StringUtils.equals((CharSequence)SectionType.ForEachSection.getCode(), (CharSequence)sectionType)) {
                String srvModelId = MapUtils.getString((Map)map, (Object)"srvModelId");
                String domainVarId = MapUtils.getString((Map)map, (Object)"domainVarId");
                String tableModelId = MapUtils.getString((Map)map, (Object)"tableModelId");
                map.put("srvModelId", this.getKeyMapNewId(srvModelId, keyMap, true));
                map.put("domainVarId", this.getKeyMapNewId(domainVarId, keyMap, true));
                map.put("tableModelId", this.getKeyMapNewId(tableModelId, keyMap, true));
                return JSON.toJSONString((Object)map);
            }
            if (StringUtils.equals((CharSequence)SectionType.ConditionSection.getCode(), (CharSequence)sectionType)) {
                List tags = (List)map.get("tags");
                String json = JSON.toJSONString((Object)tags);
                json = this.transCondEvalContent("osrv", json, keyMap);
                tags = JSON.parseArray((String)json, Map.class);
                map.put("tags", tags);
                return JSON.toJSONString((Object)map);
            }
            return sectionContent;
        }
        catch (Exception e) {
            this.logger.error("transSectionContent error", (Throwable)e);
            return sectionContent;
        }
    }

    private String transCondEvalContent(String type, String expression, Map<String, String> keyMap) {
        try {
            if (StringUtils.isBlank((CharSequence)expression)) {
                return expression;
            }
            List tagList = JSON.parseArray((String)expression, Map.class);
            if (CollectionUtils.isNotEmpty((Collection)tagList)) {
                for (Map tag : tagList) {
                    String tdType = MapUtils.getString((Map)tag, (Object)"tdType");
                    if (!"F".equals(tdType)) continue;
                    String objectId = MapUtils.getString((Map)tag, (Object)"objectId");
                    String domainVarId = MapUtils.getString((Map)tag, (Object)"domainVarId");
                    String fieldId = MapUtils.getString((Map)tag, (Object)"fieldId");
                    tag.put("objectId", this.getKeyMapNewId(objectId, keyMap, true));
                    tag.put("domainVarId", this.getKeyMapNewId(domainVarId, keyMap, true));
                    tag.put("fieldId", this.getKeyMapNewId(fieldId, keyMap, true));
                }
                expression = JSON.toJSONString((Object)tagList);
            }
        }
        catch (Exception e) {
            this.logger.error("transCondEvalContent error", (Throwable)e);
        }
        return expression;
    }

    private String transTableContent(String rowContent, Map<String, String> keyMap) {
        try {
            if (StringUtils.isBlank((CharSequence)rowContent)) {
                return rowContent;
            }
            HashMap<String, Map> newMap = new HashMap<String, Map>();
            Map map = (Map)JSON.parseObject((String)rowContent, Map.class);
            for (Map.Entry entry : map.entrySet()) {
                if (((String)entry.getKey()).equals("targetInfo")) {
                    Map targetInfo = MapUtils.getMap((Map)map, (Object)"targetInfo");
                    if (targetInfo != null) {
                        String appId = MapUtils.getString((Map)targetInfo, (Object)"appId");
                        String srvModelId = MapUtils.getString((Map)targetInfo, (Object)"srvModelId");
                        String fieldId = MapUtils.getString((Map)targetInfo, (Object)"fieldId");
                        String packageId = MapUtils.getString((Map)targetInfo, (Object)"packageId");
                        String tableModelId = MapUtils.getString((Map)targetInfo, (Object)"tableModelId");
                        String domainVarId = MapUtils.getString((Map)targetInfo, (Object)"domainVarId");
                        String id = MapUtils.getString((Map)targetInfo, (Object)"id");
                        targetInfo.put("appId", this.getKeyMapNewId(appId, keyMap, true));
                        targetInfo.put("srvModelId", this.getKeyMapNewId(srvModelId, keyMap, true));
                        targetInfo.put("fieldId", this.getKeyMapNewId(fieldId, keyMap, true));
                        targetInfo.put("packageId", this.getKeyMapNewId(packageId, keyMap, true));
                        targetInfo.put("tableModelId", this.getKeyMapNewId(tableModelId, keyMap, true));
                        targetInfo.put("domainVarId", this.getKeyMapNewId(domainVarId, keyMap, true));
                        targetInfo.put("id", this.getKeyMapNewId(id, keyMap, true));
                    }
                    newMap.put("targetInfo", targetInfo);
                    continue;
                }
                String tableModelId = (String)entry.getKey();
                Map targetVar = (Map)entry.getValue();
                String newTableModelId = this.getKeyMapNewId(tableModelId, keyMap, true);
                String domainVarId = MapUtils.getString((Map)targetVar, (Object)"domainVarId");
                String srvModelId = MapUtils.getString((Map)targetVar, (Object)"srvModelId");
                String targetTableModelId = MapUtils.getString((Map)targetVar, (Object)"tableModelId");
                targetVar.put("domainVarId", this.getKeyMapNewId(domainVarId, keyMap, true));
                targetVar.put("srvModelId", this.getKeyMapNewId(srvModelId, keyMap, true));
                targetVar.put("tableModelId", this.getKeyMapNewId(targetTableModelId, keyMap, true));
                newMap.put(newTableModelId, targetVar);
            }
            rowContent = JSON.toJSONString(newMap);
        }
        catch (Exception e) {
            this.logger.error("transTableContent error", (Throwable)e);
        }
        return rowContent;
    }

    public static final synchronized String createUniqueKey(String prefix) {
        SimpleDateFormat sdf = new SimpleDateFormat("yyyyMMddHHmmssSSS", Locale.ENGLISH);
        try {
            Thread.sleep(30L);
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
        return prefix + sdf.format(new Date()) + ((int)(Math.random() * 900000.0) + 100000);
    }

    public void recursionUpdateXmlElementText(Element element, String qName, Map<String, String> keyMap) {
        if (element == null) {
            return;
        }
        if (element.getQualifiedName().equals(qName)) {
            String text = element.getText();
            String newId = this.getKeyMapNewId(text, keyMap, true);
            element.setText(newId);
            return;
        }
        List childrenList = element.elements();
        if (CollectionUtils.isNotEmpty((Collection)childrenList)) {
            for (Element child : childrenList) {
                this.recursionUpdateXmlElementText(child, qName, keyMap);
            }
        }
    }
}

