/*
 * Decompiled with CFR 0.152.
 */
package com.irdstudio.allinapaas.executor.application.executor.core.plugin.maven;

import com.irdstudio.allinapaas.admin.console.facade.PaasSubsToolService;
import com.irdstudio.allinapaas.admin.console.facade.dto.PaasSubsToolDTO;
import com.irdstudio.allinapaas.executor.application.executor.core.dao.BatInstBatchDao;
import com.irdstudio.allinapaas.executor.application.executor.core.dao.PaasAppsInfoDao;
import com.irdstudio.allinapaas.executor.application.executor.core.dao.domain.BatInstBatch;
import com.irdstudio.allinapaas.executor.application.executor.core.dao.domain.PaasAppsInfo;
import com.irdstudio.allinapaas.executor.application.executor.core.dao.domain.PaasEnvInfo;
import com.irdstudio.allinapaas.executor.application.executor.core.plugin.AbstractPlugin;
import com.irdstudio.allinapaas.executor.application.executor.core.plugin.common.SSubsInfo;
import com.irdstudio.allinapaas.executor.application.executor.core.plugin.common.SSubsInfoDao;
import com.irdstudio.allinapaas.executor.facade.dto.ValidateRtnDTO;
import com.irdstudio.sdk.beans.core.util.CurrentDateUtil;
import com.irdstudio.sdk.beans.core.util.PropertiesUtil;
import com.irdstudio.sdk.beans.core.util.SpringContextUtils;
import com.irdstudio.sdk.beans.ssh.io.SSHOutputPrinter;
import com.irdstudio.sdk.beans.ssh.utils.RemoteSSHClient;
import java.io.File;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;

public class RepositoryUploadPlugin
extends AbstractPlugin {
    protected BatInstBatch batchInst = null;
    protected PaasAppsInfo appInfo = null;
    protected SSubsInfo sSubsInfo = null;
    protected PaasEnvInfo envInfo = null;
    protected Map<String, Object> extParam;
    private final String cbaCode = "paas-tool-ftp";
    protected SSHOutputPrinter sshPrinter = new SSHOutputPrinter(){

        public void print(String line) {
            if (RepositoryUploadPlugin.this.logger != null) {
                RepositoryUploadPlugin.this.logger.info(line);
            } else {
                System.out.println(line);
            }
        }

        public void printError(String line) {
            if (RepositoryUploadPlugin.this.logger != null) {
                RepositoryUploadPlugin.this.logger.error(line);
            } else {
                System.err.println(line);
            }
        }
    };

    @Override
    public boolean validate(String batchId, String taskId, ValidateRtnDTO message) {
        PaasSubsToolService paasSubsToolService = (PaasSubsToolService)SpringContextUtils.getBean(PaasSubsToolService.class);
        PaasSubsToolDTO ftpToolInfo = new PaasSubsToolDTO();
        ftpToolInfo.setCbaCode("paas-tool-ftp");
        ftpToolInfo.setEnvId("peds");
        List ftpInfos = paasSubsToolService.queryListByPage((Object)ftpToolInfo);
        return !CollectionUtils.isEmpty((Collection)ftpInfos);
    }

    @Override
    public boolean copyConfig(String batchId, String taskId, String newTaskId) {
        return true;
    }

    @Override
    protected boolean doReadConfigureFromDB(Connection conn, String szConfIdentify) throws SQLException {
        String batchSerialNo = this.context.getSzBatchSn();
        PaasAppsInfoDao paasAppsInfoDao = new PaasAppsInfoDao(conn);
        BatInstBatchDao batInstBatchDao = new BatInstBatchDao(conn);
        SSubsInfoDao sSubsInfoDao = new SSubsInfoDao(conn);
        this.batchInst = batInstBatchDao.queryByBatchSerialNo(batchSerialNo);
        this.appInfo = paasAppsInfoDao.queryByAppId(this.batchInst.getAppId());
        this.sSubsInfo = sSubsInfoDao.querySSubsInfoWithKeys(this.appInfo.getSubsId());
        this.extParam = batInstBatchDao.getExtParam(this.batchInst);
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean execute() {
        this.logger.info("\u4e0a\u4f20\u6d41\u6c34\u7ebf\u5236\u54c1:" + this.appInfo.getAppCode());
        Connection conn = null;
        try {
            File uploadFolder;
            PaasSubsToolService paasSubsToolService = (PaasSubsToolService)SpringContextUtils.getBean(PaasSubsToolService.class);
            String currEnvId = this.batchInst.getEnvId();
            String subsId = this.batchInst.getSubsId();
            String rootPath = PropertiesUtil.getPropertyByKey((String)"application", (String)"tdp.ftp.path");
            if (StringUtils.isBlank((CharSequence)rootPath)) {
                rootPath = "/tdpaas/ftp/";
            }
            PaasSubsToolDTO ftpToolInfo = new PaasSubsToolDTO();
            ftpToolInfo.setCbaCode("paas-tool-ftp");
            ftpToolInfo.setEnvId("peds");
            List ftpInfos = paasSubsToolService.queryListByPage((Object)ftpToolInfo);
            if (CollectionUtils.isEmpty((Collection)ftpInfos)) {
                throw new RuntimeException("\u7ec4\u4ef6\u5bf9\u5e94\u5de5\u5177\u672a\u914d\u7f6e");
            }
            ftpToolInfo = (PaasSubsToolDTO)ftpInfos.get(0);
            RemoteSSHClient sshClient = new RemoteSSHClient(ftpToolInfo.getToolUrl(), ftpToolInfo.getToolUserId(), ftpToolInfo.getToolPwd());
            boolean loginFlag = sshClient.connect();
            if (!loginFlag) {
                this.logger.error("\u767b\u9646\u670d\u52a1\u5668\u5931\u8d25");
            }
            if (!(uploadFolder = new File(this.context.getBatBatchSource().getRepoLocalPath(), "uploadFolder")).exists()) {
                uploadFolder.mkdirs();
            }
            this.uploadDir(uploadFolder, rootPath + subsId + "/" + CurrentDateUtil.getTodayDate(), sshClient);
        }
        catch (Exception e) {
            this.logger.error(e.getMessage(), e);
            boolean bl = false;
            return bl;
        }
        finally {
            if (conn != null) {
                this.closePluginConnection(conn);
            }
        }
        return true;
    }

    private void uploadDir(File root, String targetPath, RemoteSSHClient sshClient) throws Exception {
        if (root.isDirectory()) {
            File[] subFiles;
            for (File subFile : subFiles = root.listFiles()) {
                if (subFile.getName().equals(".git")) continue;
                if (subFile.isDirectory()) {
                    this.uploadDir(subFile, targetPath + "/" + subFile.getName(), sshClient);
                    continue;
                }
                if (!sshClient.fileExists(targetPath)) {
                    sshClient.executeCommand("mkdir -p " + targetPath, this.sshPrinter);
                }
                sshClient.uploadQuietly(subFile.getAbsolutePath(), targetPath + "/" + subFile.getName());
            }
        } else {
            if (!sshClient.fileExists(targetPath)) {
                sshClient.executeCommand("mkdir -p " + targetPath, this.sshPrinter);
            }
            sshClient.upload(root.getAbsolutePath(), targetPath + "/" + root.getName());
        }
    }
}

