/*
 * Decompiled with CFR 0.152.
 */
package com.irdstudio.allinapaas.executor.application.executor.core.plugin.monitor;

import com.irdstudio.allinapaas.executor.application.executor.core.dao.PaasEnvParamDao;
import com.irdstudio.allinapaas.executor.application.executor.core.plugin.AbstractPlugin;
import com.irdstudio.allinapaas.executor.application.executor.core.plugin.apps.SdEnvUtil;
import com.irdstudio.allinapaas.executor.application.executor.core.plugin.devops.maven.MavenConf;
import com.irdstudio.sdk.beans.core.util.PropertiesUtil;
import java.io.File;
import java.io.IOException;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Properties;
import org.apache.commons.lang3.StringUtils;
import org.apache.maven.shared.invoker.DefaultInvocationRequest;
import org.apache.maven.shared.invoker.DefaultInvoker;
import org.apache.maven.shared.invoker.InvocationOutputHandler;
import org.apache.maven.shared.invoker.InvocationRequest;
import org.apache.maven.shared.invoker.InvocationResult;
import org.apache.maven.shared.invoker.InvokerLogger;
import org.apache.maven.shared.invoker.MavenInvocationException;
import org.apache.maven.shared.invoker.PrintStreamLogger;

public class MonitorMavenPlugin
extends AbstractPlugin {
    private String pluginName = null;
    private MavenConf mavenConf = null;
    private String taskName = null;

    @Override
    protected boolean doReadConfigureFromDB(Connection conn, String szConfIdentify) throws SQLException {
        this.pluginName = this.context.getSzPluginName();
        String batchSerialNo = this.context.getSzBatchSn();
        this.mavenConf = new MavenConf();
        this.mavenConf.setMavenParam("mvn clean package -DskipTests=true");
        this.mavenConf.setMavenSettings(PropertiesUtil.getPropertyByKey((String)"application", (String)"tdp.maven.settings.path"));
        this.mavenConf.setMavenHome(PropertiesUtil.getPropertyByKey((String)"application", (String)"tdp.maven.path"));
        PaasEnvParamDao paasEnvParamDao = new PaasEnvParamDao(conn);
        String gitUrl = paasEnvParamDao.queryByCodeReturnValue("git.worker.remote.path");
        int firstIndex = gitUrl.lastIndexOf("/");
        int lastIndex = gitUrl.lastIndexOf(".");
        String moduleName = gitUrl.substring(firstIndex, lastIndex);
        this.mavenConf.setLocalPath(SdEnvUtil.BUILD_PATH + moduleName);
        if (this.mavenConf.getMavenHome() == null || this.mavenConf.getLocalPath() == null || this.mavenConf.getMavenSettings() == null) {
            this.context.setSzLastErrorMsg("\u672a\u8bfb\u53d6\u5230\u914d\u7f6e\u6807\u8bc6\u4e3a\uff1a" + szConfIdentify + "\u7684\u6570\u636eMySQL\u914d\u7f6e!");
            return false;
        }
        return true;
    }

    @Override
    public boolean execute() {
        String[] commands;
        this.logger.info("\u8c03\u7528Maven\u7f16\u8bd1\u63d2\u4ef6\uff0c\u7f16\u8bd1\u5e94\u7528: " + this.taskName);
        String projectPomPath = this.mavenConf.getLocalPath() + File.separator + "pom.xml";
        this.logger.info("pom\u6587\u4ef6\uff1a" + projectPomPath);
        DefaultInvocationRequest request = new DefaultInvocationRequest();
        if (StringUtils.isNotBlank((CharSequence)this.mavenConf.getMavenSettings())) {
            request.setUserSettingsFile(new File(this.mavenConf.getMavenSettings()));
        }
        request.setPomFile(new File(projectPomPath));
        ArrayList<String> goals = new ArrayList<String>();
        ArrayList profiles = new ArrayList();
        Properties buildProps = new Properties();
        if (StringUtils.isBlank((CharSequence)this.mavenConf.getMavenParam())) {
            goals.add("clean");
            goals.add("install");
        }
        for (String command : commands = StringUtils.split((String)this.mavenConf.getMavenParam(), (String)" ")) {
            if ("mvn".equals(command)) continue;
            if (StringUtils.startsWith((CharSequence)command, (CharSequence)"-D")) {
                String _command = command.replace("-D", "");
                String[] bps = StringUtils.split((String)_command, (String)"=");
                String key = bps[0];
                String val = bps.length > 1 ? bps[1] : "";
                buildProps.put(key, val);
                continue;
            }
            if (StringUtils.equals((CharSequence)"-U", (CharSequence)command) || StringUtils.equals((CharSequence)"--update-snapshots", (CharSequence)command)) {
                request.setUpdateSnapshots(true);
                continue;
            }
            goals.add(command);
        }
        request.setGoals(goals);
        request.setProperties(buildProps);
        request.setProfiles(profiles);
        DefaultInvoker invoker = new DefaultInvoker();
        invoker.setMavenHome(new File(this.mavenConf.getMavenHome()));
        invoker.setLogger((InvokerLogger)new PrintStreamLogger(System.err, 2){});
        invoker.setOutputHandler(new InvocationOutputHandler(){

            public void consumeLine(String s) throws IOException {
                System.out.println(s);
                MonitorMavenPlugin.this.logger.info(s);
            }
        });
        boolean flag = true;
        InvocationResult result = null;
        try {
            result = invoker.execute((InvocationRequest)request);
            flag = true;
        }
        catch (MavenInvocationException e) {
            e.printStackTrace();
            this.logger.error((Object)e);
            this.context.setSzLastErrorMsg(e.getMessage());
            flag = false;
        }
        if (flag) {
            if (result.getExitCode() == 0) {
                this.logger.info("maven plugin build success");
                flag = true;
            } else {
                this.logger.info("maven plugin build error");
                this.context.setSzLastErrorMsg("Maven\u7f16\u8bd1\u5931\u8d25");
                flag = false;
            }
        }
        invoker = null;
        return flag;
    }
}

