/*
 * Decompiled with CFR 0.152.
 */
package com.irdstudio.allinapaas.executor.application.executor.core.util.db.plugin;

import com.alibaba.druid.util.StringUtils;
import com.irdstudio.allinapaas.executor.application.executor.core.dao.ModelTableFieldDao;
import com.irdstudio.allinapaas.executor.application.executor.core.dao.ModelTableInfoDao;
import com.irdstudio.allinapaas.executor.application.executor.core.dao.PubDbmsDatatypeDao;
import com.irdstudio.allinapaas.executor.application.executor.core.dao.domain.ModelTableField;
import com.irdstudio.allinapaas.executor.application.executor.core.dao.domain.ModelTableInfo;
import com.irdstudio.allinapaas.executor.application.executor.core.dao.domain.PubDbmsDatatype;
import com.irdstudio.allinapaas.executor.application.executor.core.util.db.plugin.ISQLScriptPlugin;
import java.sql.Connection;
import java.util.HashMap;
import java.util.List;

public class MysqlScriptPlugin
implements ISQLScriptPlugin {
    @Override
    public String generateDDLScript(String objectId, boolean genDrop, Connection con) {
        try {
            ModelTableInfoDao modelTableInfoDao = new ModelTableInfoDao(con);
            ModelTableInfo mtiv = modelTableInfoDao.queryModelTableInfo(objectId);
            return this.generateDDLScript(mtiv, genDrop, con);
        }
        catch (Exception e) {
            e.printStackTrace();
            return "-- " + e.getMessage() + "\n";
        }
    }

    @Override
    public String generateDDLScript(ModelTableInfo mtiv, boolean genDrop, Connection con) {
        try {
            ModelTableFieldDao modelTableFieldDao = new ModelTableFieldDao(con);
            PubDbmsDatatypeDao pubDbmsDatatypeDao = new PubDbmsDatatypeDao(con);
            List<ModelTableField> mtfvList = modelTableFieldDao.queryModelTableFieldList(mtiv.getObjectId());
            List<PubDbmsDatatype> dbmsTypes = pubDbmsDatatypeDao.queryDbmsTypeByAppId(mtiv.getAppId());
            HashMap<String, PubDbmsDatatype> dbmsTypeMap = new HashMap<String, PubDbmsDatatype>();
            for (PubDbmsDatatype dt : dbmsTypes) {
                dbmsTypeMap.put(dt.getDbmsDatatypeCode(), dt);
            }
            StringBuffer ddl = new StringBuffer();
            StringBuffer keyFields = new StringBuffer();
            ddl.append("DROP TABLE IF EXISTS ").append(mtiv.getObjectCode()).append(";\n");
            ddl.append("CREATE TABLE IF NOT EXISTS ").append(mtiv.getObjectCode()).append("(\n");
            for (ModelTableField field : mtfvList) {
                String fieldCode = field.getFieldCode().toUpperCase();
                if ("Y".equals(field.getIsPk())) {
                    keyFields.append(fieldCode).append(",");
                }
                ddl.append('\t').append(fieldCode).append(" ").append(field.getFieldType());
                PubDbmsDatatype dtype = (PubDbmsDatatype)((Object)dbmsTypeMap.get(field.getFieldType()));
                if (dtype != null && StringUtils.equals((String)dtype.getIsNeedLength(), (String)"N")) {
                    field.setFieldLength(0);
                }
                if (field.getFieldLength() > 0) {
                    ddl.append("(").append(field.getFieldLength());
                    if (field.getFieldPrecision() != null && field.getFieldPrecision() > 0) {
                        ddl.append(",").append(field.getFieldPrecision());
                    }
                    ddl.append(")");
                }
                if ("Y".equals(field.getIsPk())) {
                    ddl.append(" NOT NULL");
                } else {
                    ddl.append(" NULL");
                }
                ddl.append(" COMMENT '").append(field.getFieldName()).append("',\n");
            }
            if (keyFields.lastIndexOf(",") != -1) {
                ddl.append("\tPRIMARY KEY (").append(keyFields.deleteCharAt(keyFields.length() - 1)).append("))\n");
            }
            if (ddl.length() > 11) {
                ddl.deleteCharAt(ddl.length() - 2);
            }
            ddl.append(") ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='").append(mtiv.getObjectName()).append("';\n");
            return ddl.toString().toLowerCase();
        }
        catch (Exception e) {
            e.printStackTrace();
            return "-- " + e.getMessage() + "\n";
        }
    }

    @Override
    public String generateInsertScript(String objectId, Connection con) {
        return null;
    }

    @Override
    public String generateUpdateScript(String objectId, Connection con) {
        return null;
    }

    @Override
    public String generateDeleteScript(String objectId, Connection con) {
        return null;
    }
}

