/*
 * Decompiled with CFR 0.152.
 */
package com.irdstudio.allinapaas.executor.application.executor.rest.job.message;

import com.alibaba.fastjson.JSON;
import com.irdstudio.allinapaas.executor.application.executor.core.dao.domain.SSrvsCronConf;
import com.irdstudio.allinapaas.executor.application.executor.core.util.parse.ExpressionUtil;
import com.irdstudio.allinapaas.executor.application.executor.rest.job.ScheduleJob;
import com.irdstudio.allinapaas.portal.console.types.YesOrNO;
import com.irdstudio.allinrdm.admin.console.facade.RdmMessageConfService;
import com.irdstudio.allinrdm.admin.console.facade.RdmMessageInfoService;
import com.irdstudio.allinrdm.admin.console.facade.RdmWeeklyInfoService;
import com.irdstudio.allinrdm.admin.console.facade.RdmWexinSubscribeService;
import com.irdstudio.allinrdm.admin.console.facade.dto.RdmMessageConfDTO;
import com.irdstudio.allinrdm.admin.console.facade.dto.RdmMessageInfoDTO;
import com.irdstudio.allinrdm.admin.console.facade.dto.RdmWeeklyInfoDTO;
import com.irdstudio.allinrdm.admin.console.facade.dto.RdmWexinSubscribeDTO;
import com.irdstudio.allintpaas.admin.facade.AllinCloudPortalClient;
import com.irdstudio.allintpaas.admin.facade.WxService;
import com.irdstudio.allintpaas.admin.facade.dto.SUserDTO;
import com.irdstudio.allintpaas.admin.facade.dto.wx.WXSendSubscribe;
import com.irdstudio.sdk.beans.core.util.CurrentDateUtil;
import com.irdstudio.sdk.beans.core.util.SpringContextUtils;
import com.irdstudio.sdk.beans.core.util.UUIDUtil;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.MapUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PushRdmMessageJob
implements ScheduleJob {
    private static final Logger logger = LoggerFactory.getLogger(PushRdmMessageJob.class);
    private String messageId = "MSG0000001";
    private RdmMessageInfoService rdmMessageInfoService;
    private RdmWeeklyInfoService rdmWeeklyInfoService;
    private RdmWexinSubscribeService rdmWexinSubscribeService;
    private WxService wxService;

    @Override
    public void doExecute(Connection conn, SSrvsCronConf conf) throws SQLException {
        AllinCloudPortalClient portalClient = (AllinCloudPortalClient)SpringContextUtils.getBean(AllinCloudPortalClient.class);
        RdmMessageConfService rdmMessageConfService = (RdmMessageConfService)SpringContextUtils.getBean(RdmMessageConfService.class);
        this.rdmMessageInfoService = (RdmMessageInfoService)SpringContextUtils.getBean(RdmMessageInfoService.class);
        this.rdmWeeklyInfoService = (RdmWeeklyInfoService)SpringContextUtils.getBean(RdmWeeklyInfoService.class);
        this.rdmWexinSubscribeService = (RdmWexinSubscribeService)SpringContextUtils.getBean(RdmWexinSubscribeService.class);
        this.wxService = (WxService)SpringContextUtils.getBean(WxService.class);
        RdmMessageConfDTO msgConf = new RdmMessageConfDTO();
        msgConf.setMsgTypeId(this.messageId);
        msgConf = (RdmMessageConfDTO)rdmMessageConfService.queryByPk((Object)msgConf);
        if (msgConf != null) {
            SUserDTO userParam = new SUserDTO();
            userParam.setState("1");
            try {
                List userList = portalClient.querySUserList(userParam);
                if (CollectionUtils.isNotEmpty((Collection)userList)) {
                    for (SUserDTO user : userList) {
                        HashMap<String, Object> rootData = new HashMap<String, Object>();
                        rootData.put("msgConf", msgConf);
                        rootData.put("user", user);
                        RdmWeeklyInfoDTO summaryParam = new RdmWeeklyInfoDTO();
                        summaryParam.setLoginUserId(user.getActorno());
                        List summary = this.rdmWeeklyInfoService.queryMessageSummary(summaryParam);
                        if (CollectionUtils.isNotEmpty((Collection)summary)) {
                            HashMap data = new HashMap();
                            rootData.put("data", data);
                            for (Map map : summary) {
                                data.put(MapUtils.getString((Map)map, (Object)"name"), map.get("num"));
                            }
                        }
                        if (StringUtils.equals((CharSequence)YesOrNO.YES.getCode(), (CharSequence)msgConf.getPushLocalFlag())) {
                            this.pushLocal(user, rootData, msgConf, conn);
                            continue;
                        }
                        if (!StringUtils.equals((CharSequence)YesOrNO.YES.getCode(), (CharSequence)msgConf.getPushSpFlag())) continue;
                        this.pushSp(user, rootData, msgConf, conn);
                    }
                }
            }
            catch (Exception e) {
                logger.error("\u63a8\u9001\u6d88\u606f[{}] \u5f02\u5e38 {}", new Object[]{this.messageId, e.getMessage(), e});
            }
        }
    }

    private void pushLocal(SUserDTO user, Map<String, Object> rootData, RdmMessageConfDTO msgConf, Connection conn) {
        String titleTemplate = msgConf.getMsgTitleTemplate();
        String textTemplate = msgConf.getMsgTextTemplate();
        RdmMessageInfoDTO msg = new RdmMessageInfoDTO();
        msg.setMsgTitle(ExpressionUtil.parse(titleTemplate, rootData));
        msg.setMsgText(ExpressionUtil.parse(textTemplate, rootData));
        this.saveMessageInfo(msg, user, msgConf);
    }

    private void pushSp(SUserDTO user, Map<String, Object> rootData, RdmMessageConfDTO msgConf, Connection conn) {
        String titleTemplate = msgConf.getMsgTitleTemplate();
        String textTemplate = msgConf.getMsgTextTemplate();
        String templateId = msgConf.getSpTemplateId();
        RdmMessageInfoDTO msg = new RdmMessageInfoDTO();
        msg.setMsgTitle(ExpressionUtil.parse(titleTemplate, rootData));
        msg.setMsgText(ExpressionUtil.parse(textTemplate, rootData));
        if (StringUtils.isBlank((CharSequence)user.getWexinOpenid())) {
            logger.info("\u7528\u6237{}\u672a\u7ed1\u5b9a\u5fae\u4fe1", (Object)user.getActorname());
            return;
        }
        RdmWexinSubscribeDTO rdmWexinSubscribe = new RdmWexinSubscribeDTO();
        rdmWexinSubscribe.setActorno(user.getActorno());
        rdmWexinSubscribe.setWexinOpenid(user.getWexinOpenid());
        rdmWexinSubscribe.setTemplateId(templateId);
        rdmWexinSubscribe = (RdmWexinSubscribeDTO)this.rdmWexinSubscribeService.queryByPk((Object)rdmWexinSubscribe);
        if (rdmWexinSubscribe != null && rdmWexinSubscribe.getSubscribe() != null && rdmWexinSubscribe.getSubscribe() > 0) {
            try {
                WXSendSubscribe sendParam = new WXSendSubscribe();
                sendParam.setTemplate_id(templateId);
                sendParam.setPage("pages/developTask/developTask");
                sendParam.setTouser(user.getWexinOpenid());
                HashMap data = new HashMap();
                HashMap<String, String> taskId = new HashMap<String, String>();
                taskId.put("value", msg.getMsgText());
                data.put("thing2", taskId);
                HashMap<String, String> taskName = new HashMap<String, String>();
                taskName.put("value", user.getActorno());
                data.put("character_string1", taskName);
                sendParam.setData(data);
                String res = this.wxService.sendSubscribe(sendParam);
                Map wxRes = (Map)JSON.parseObject((String)res, Map.class);
                String errcode = MapUtils.getString((Map)wxRes, (Object)"errcode");
                logger.info("\u7ed9{}\u53d1\u9001\u5c0f\u7a0b\u5e8f\u6d88\u606f{} {}", new Object[]{user.getActorno(), msg.getMsgTitle(), JSON.toJSON((Object)wxRes)});
            }
            catch (Exception e) {
                logger.error("\u7ed9{}\u53d1\u9001\u5c0f\u7a0b\u5e8f\u6d88\u606f{} \u5931\u8d25 {}", new Object[]{user.getActorno(), msg.getMsgTitle(), e.getMessage()});
            }
            this.saveMessageInfo(msg, user, msgConf);
            rdmWexinSubscribe.setSubscribe(Integer.valueOf(rdmWexinSubscribe.getSubscribe() - 1));
            this.rdmWexinSubscribeService.updateByPk((Object)rdmWexinSubscribe);
        }
    }

    private void saveMessageInfo(RdmMessageInfoDTO msg, SUserDTO user, RdmMessageConfDTO msgConf) {
        msg.setMsgId(UUIDUtil.getUUID());
        msg.setMsgTime(CurrentDateUtil.getTodayDateEx2());
        msg.setMsgRead(YesOrNO.NO.getCode());
        msg.setUserId(user.getActorno());
        msg.setMsgTypeId(msgConf.getMsgTypeId());
        msg.setMsgTypeName(msgConf.getMsgTypeName());
        msg.setMsgGroupId(msgConf.getMsgGroupId());
        this.rdmMessageInfoService.insert((Object)msg);
    }
}

