/*
 * Decompiled with CFR 0.152.
 */
package com.irdstudio.allinapaas.executor.application.executor.core.dao;

import com.irdstudio.allinapaas.executor.application.executor.core.dao.OsrvArrangeTableDao;
import com.irdstudio.allinapaas.executor.application.executor.core.dao.domain.IsrvSqlCond;
import com.irdstudio.allinapaas.executor.application.executor.core.util.db.ProxySQL;
import com.irdstudio.sdk.beans.core.util.POJOUtils;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class IsrvSqlCondDao {
    private static final Logger logger = LoggerFactory.getLogger(OsrvArrangeTableDao.class);
    Connection conn = null;

    public IsrvSqlCondDao(Connection conn) {
        this.conn = conn;
    }

    public List<IsrvSqlCond> queryIsrvSqlCondList(final IsrvSqlCond paramVO) {
        final ArrayList param = new ArrayList();
        String sql = new ProxySQL(){
            {
                this.SELECT("*");
                this.FROM("`allinrdm_db`.isrv_sql_cond");
                this.WHERE("srv_model_id = ?");
                param.add(paramVO.getSrvModelId());
                this.ORDER_BY("cond_id asc");
            }
        }.toString();
        PreparedStatement ps = null;
        ResultSet rs = null;
        ArrayList<IsrvSqlCond> list = new ArrayList<IsrvSqlCond>();
        try {
            ps = this.conn.prepareStatement(sql);
            for (int i = 0; i < param.size(); ++i) {
                ps.setObject(i + 1, param.get(i));
            }
            rs = ps.executeQuery();
            while (rs.next()) {
                IsrvSqlCond bean = (IsrvSqlCond)((Object)POJOUtils.generatePOJO((ResultSet)rs, IsrvSqlCond.class));
                list.add(bean);
            }
        }
        catch (Exception e) {
            throw new RuntimeException("query queryIsrvSqlCondList is wrong", e);
        }
        return list;
    }

    public List<IsrvSqlCond> queryIsrvSqlCondWithSrvModelIds(List<String> srvModelIds) {
        String querySql = "select * from `allinrdm_db`.isrv_sql_cond where srv_model_id in(" + srvModelIds.stream().map(s -> "?").collect(Collectors.joining(",")) + ");";
        PreparedStatement ps = null;
        ResultSet rs = null;
        ArrayList<IsrvSqlCond> list = new ArrayList<IsrvSqlCond>();
        try {
            ps = this.conn.prepareStatement(querySql);
            for (int i = 0; i < srvModelIds.size(); ++i) {
                ps.setObject(i + 1, srvModelIds.get(i));
            }
            rs = ps.executeQuery();
            while (rs.next()) {
                IsrvSqlCond bean = (IsrvSqlCond)((Object)POJOUtils.generatePOJO((ResultSet)rs, IsrvSqlCond.class));
                list.add(bean);
            }
        }
        catch (Exception e) {
            throw new RuntimeException("query queryIsrvSqlCondList is wrong", e);
        }
        return list;
    }
}

