/*
 * Decompiled with CFR 0.152.
 */
package com.irdstudio.allinapaas.executor.application.executor.core.dao;

import com.irdstudio.allinapaas.executor.application.executor.core.dao.domain.PaasDeployInfo;
import com.irdstudio.allinapaas.executor.application.executor.core.dao.domain.PaasEnvInfo;
import com.irdstudio.allinapaas.executor.application.executor.core.util.db.ProxySQL;
import com.irdstudio.sdk.beans.core.util.POJOUtils;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PaasDeployInfoDao {
    private static final Logger logger = LoggerFactory.getLogger(PaasDeployInfoDao.class);
    Connection conn = null;

    public PaasDeployInfoDao(Connection conn) {
        this.conn = conn;
    }

    public PaasDeployInfo queryByPk(final PaasDeployInfo paasDeployInfo) throws SQLException {
        final ArrayList param = new ArrayList();
        String sql = new ProxySQL(){
            {
                this.SELECT("*");
                this.FROM("`allinpaas_db`.paas_deploy_info");
                this.WHERE("app_deploy_id = ?");
                param.add(paasDeployInfo.getAppDeployId());
            }
        }.toString();
        PreparedStatement ps = null;
        ResultSet rs = null;
        ArrayList<PaasDeployInfo> list = new ArrayList<PaasDeployInfo>();
        try {
            ps = this.conn.prepareStatement(sql);
            for (int i = 0; i < param.size(); ++i) {
                ps.setObject(i + 1, param.get(i));
            }
            rs = ps.executeQuery();
            if (rs.next()) {
                PaasDeployInfo bean = (PaasDeployInfo)((Object)POJOUtils.generatePOJO((ResultSet)rs, PaasDeployInfo.class));
                list.add(bean);
            }
        }
        catch (Exception e) {
            throw new RuntimeException("query queryByPk is wrong", e);
        }
        return list.isEmpty() ? null : (PaasDeployInfo)((Object)list.get(0));
    }

    public PaasDeployInfo queryByAppId(final String appId, final String envId) throws SQLException {
        final ArrayList param = new ArrayList();
        String sql = new ProxySQL(){
            {
                this.SELECT("*");
                this.FROM("`allinpaas_db`.paas_deploy_info");
                this.WHERE("app_id = ?");
                param.add(appId);
                this.WHERE("env_id = ?");
                param.add(envId);
            }
        }.toString();
        PreparedStatement ps = null;
        ResultSet rs = null;
        ArrayList<PaasDeployInfo> list = new ArrayList<PaasDeployInfo>();
        try {
            ps = this.conn.prepareStatement(sql);
            for (int i = 0; i < param.size(); ++i) {
                ps.setObject(i + 1, param.get(i));
            }
            rs = ps.executeQuery();
            if (rs.next()) {
                PaasDeployInfo bean = (PaasDeployInfo)((Object)POJOUtils.generatePOJO((ResultSet)rs, PaasDeployInfo.class));
                list.add(bean);
            }
        }
        catch (Exception e) {
            throw new RuntimeException("query queryByPk is wrong", e);
        }
        return list.isEmpty() ? null : (PaasDeployInfo)((Object)list.get(0));
    }

    public Integer queryMaxAppPort(final PaasDeployInfo paasDeployInfo) throws SQLException {
        final ArrayList param = new ArrayList();
        String sql = new ProxySQL(){
            {
                this.SELECT("max(app_port)  as app_port");
                this.FROM("`allinpaas_db`.paas_deploy_info");
                this.WHERE("ecs_ip = ?");
                param.add(paasDeployInfo.getEcsIp());
            }
        }.toString();
        PreparedStatement ps = null;
        ResultSet rs = null;
        Integer maxPort = null;
        try {
            ps = this.conn.prepareStatement(sql);
            for (int i = 0; i < param.size(); ++i) {
                ps.setObject(i + 1, param.get(i));
            }
            rs = ps.executeQuery();
            if (rs.next()) {
                maxPort = rs.getInt("app_port");
            }
        }
        catch (Exception e) {
            throw new RuntimeException("query queryByPk is wrong", e);
        }
        return maxPort;
    }

    public boolean insertPaasDeployInfo(final PaasDeployInfo paasDeployInfo) throws SQLException {
        final ArrayList param = new ArrayList();
        String sql = new ProxySQL(){
            {
                this.INSERT_INTO("`allinpaas_db`.paas_deploy_info");
                List vals = POJOUtils.getPOJOValues((Object)((Object)paasDeployInfo));
                for (Object[] val : vals) {
                    this.VALUES(val[0].toString(), "?");
                    param.add(val[1]);
                }
            }
        }.toString();
        PreparedStatement ps = null;
        Object rs = null;
        try {
            ps = this.conn.prepareStatement(sql);
            for (int i = 0; i < param.size(); ++i) {
                ps.setObject(i + 1, param.get(i));
            }
            int re = ps.executeUpdate();
            if (re == 1) {
                return true;
            }
        }
        catch (Exception e) {
            throw new RuntimeException("query queryByPk is wrong", e);
        }
        return false;
    }

    public List<PaasDeployInfo> queryAllByCondition(final PaasDeployInfo paasDeployInfo) throws SQLException {
        final ArrayList param = new ArrayList();
        String sql = new ProxySQL(){
            {
                this.SELECT("*");
                this.FROM("`allinpaas_db`.paas_deploy_info");
                List vals = POJOUtils.getPOJOValues((Object)((Object)paasDeployInfo));
                for (Object[] val : vals) {
                    this.WHERE(String.format("%s = ?", val[0].toString()));
                    param.add(val[1]);
                }
            }
        }.toString();
        PreparedStatement ps = null;
        ResultSet rs = null;
        ArrayList<PaasDeployInfo> list = new ArrayList<PaasDeployInfo>();
        try {
            ps = this.conn.prepareStatement(sql);
            for (int i = 0; i < param.size(); ++i) {
                ps.setObject(i + 1, param.get(i));
            }
            rs = ps.executeQuery();
            if (rs.next()) {
                PaasDeployInfo bean = (PaasDeployInfo)((Object)POJOUtils.generatePOJO((ResultSet)rs, PaasDeployInfo.class));
                list.add(bean);
            }
        }
        catch (Exception e) {
            throw new RuntimeException("query queryAllByCondition is wrong", e);
        }
        return list;
    }

    public Integer batchDeleteByAppIds(final List<String> batchList) throws SQLException {
        final ArrayList param = new ArrayList();
        String sql = new ProxySQL(){
            {
                this.DELETE_FROM("`allinpaas_db`.paas_deploy_info");
                ArrayList<String> qus = new ArrayList<String>();
                for (String val : batchList) {
                    qus.add("?");
                    param.add(val);
                }
                this.WHERE(String.format("app_id in ( %s )", StringUtils.join((Object[])qus.toArray(new String[0]), (String)",")));
            }
        }.toString();
        PreparedStatement ps = null;
        Object rs = null;
        try {
            ps = this.conn.prepareStatement(sql);
            for (int i = 0; i < param.size(); ++i) {
                ps.setObject(i + 1, param.get(i));
            }
            int re = ps.executeUpdate();
            return re;
        }
        catch (Exception e) {
            throw new RuntimeException("query queryByPk is wrong", e);
        }
    }

    public int deleteByAppId(final String appId) throws SQLException {
        final ArrayList param = new ArrayList();
        String sql = new ProxySQL(){
            {
                this.DELETE_FROM("`allinpaas_db`.paas_deploy_info");
                this.WHERE("app_id = ?");
                param.add(appId);
            }
        }.toString();
        PreparedStatement ps = null;
        Object rs = null;
        try {
            ps = this.conn.prepareStatement(sql);
            for (int i = 0; i < param.size(); ++i) {
                ps.setObject(i + 1, param.get(i));
            }
            int re = ps.executeUpdate();
            return re;
        }
        catch (Exception e) {
            throw new RuntimeException("deleteByAppId is wrong", e);
        }
    }

    public int deleteByEcsId(final String ecsId) throws SQLException {
        final ArrayList param = new ArrayList();
        String sql = new ProxySQL(){
            {
                this.DELETE_FROM("`allinpaas_db`.paas_deploy_info");
                this.WHERE("ecs_id = ?");
                param.add(ecsId);
            }
        }.toString();
        PreparedStatement ps = null;
        Object rs = null;
        try {
            ps = this.conn.prepareStatement(sql);
            for (int i = 0; i < param.size(); ++i) {
                ps.setObject(i + 1, param.get(i));
            }
            int re = ps.executeUpdate();
            return re;
        }
        catch (Exception e) {
            throw new RuntimeException("deleteByAppId is wrong", e);
        }
    }

    public boolean updateByPk(final PaasDeployInfo ecs) {
        final ArrayList param = new ArrayList();
        String sql = new ProxySQL(){
            {
                this.UPDATE("`allinpaas_db`.paas_deploy_info");
                List vals = POJOUtils.getPOJOValues((Object)((Object)ecs));
                for (Object[] val : vals) {
                    if (val[0].toString().equals("app_deploy_id")) continue;
                    this.SET(String.format("%s = ?", val[0].toString()));
                    param.add(val[1]);
                }
                this.WHERE("app_deploy_id = ?");
                param.add(ecs.getAppDeployId());
            }
        }.toString();
        PreparedStatement ps = null;
        try {
            int i;
            ps = this.conn.prepareStatement(sql);
            for (i = 0; i < param.size(); ++i) {
                ps.setObject(i + 1, param.get(i));
            }
            i = ps.executeUpdate();
        }
        catch (Exception e) {
            throw new RuntimeException("update by pk is wrong", e);
        }
        return true;
    }

    public boolean updatePaasEnvInfoByPk(final PaasEnvInfo paramVO) throws Exception {
        int rs;
        final ArrayList param = new ArrayList();
        String sql = new ProxySQL(){
            {
                this.UPDATE("paas_env_info");
                List vals = POJOUtils.getPOJOValues((Object)((Object)paramVO));
                for (Object[] val : vals) {
                    if (val[0].toString().equals("env_id")) continue;
                    this.SET(String.format("%s = ?", val[0].toString()));
                    param.add(val[1]);
                }
                this.WHERE("env_id = ? ");
                param.add(paramVO.getEnvId());
            }
        }.toString();
        PreparedStatement ps = null;
        try {
            ps = this.conn.prepareStatement(sql);
            for (int i = 0; i < param.size(); ++i) {
                ps.setObject(i + 1, param.get(i));
            }
            rs = ps.executeUpdate();
        }
        catch (Exception e) {
            throw new RuntimeException("query updateByPk is wrong", e);
        }
        return rs == 1;
    }
}

