/*
 * Decompiled with CFR 0.152.
 */
package com.irdstudio.allinapaas.executor.application.executor.core.dao;

import com.irdstudio.allinapaas.executor.application.executor.core.dao.domain.PaasEcsInfo;
import com.irdstudio.allinapaas.executor.application.executor.core.util.db.ProxySQL;
import com.irdstudio.sdk.beans.core.util.POJOUtils;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PaasEcsInfoDao {
    private static final Logger logger = LoggerFactory.getLogger(PaasEcsInfoDao.class);
    Connection conn = null;

    public PaasEcsInfoDao(Connection conn) {
        this.conn = conn;
    }

    public List<PaasEcsInfo> queryPaasEcsInfo(final PaasEcsInfo paasEcsInfo) throws SQLException {
        final ArrayList param = new ArrayList();
        String sql = new ProxySQL(){
            {
                this.SELECT("*");
                this.FROM("`allinpaas_db`.paas_ecs_info");
                List vals = POJOUtils.getPOJOValues((Object)((Object)paasEcsInfo));
                for (Object[] val : vals) {
                    this.WHERE(String.format("%s = ?", val[0].toString()));
                    param.add(val[1]);
                }
            }
        }.toString();
        PreparedStatement ps = null;
        ResultSet rs = null;
        ArrayList<PaasEcsInfo> list = new ArrayList<PaasEcsInfo>();
        try {
            ps = this.conn.prepareStatement(sql);
            for (int i = 0; i < param.size(); ++i) {
                ps.setObject(i + 1, param.get(i));
            }
            rs = ps.executeQuery();
            while (rs.next()) {
                PaasEcsInfo bean = (PaasEcsInfo)((Object)POJOUtils.generatePOJO((ResultSet)rs, PaasEcsInfo.class));
                list.add(bean);
            }
        }
        catch (Exception e) {
            throw new RuntimeException("query queryPaasEcsInfoList is wrong", e);
        }
        return list;
    }

    public List<PaasEcsInfo> queryPaasEcsInfoNotApp(final PaasEcsInfo paasEcsInfo) throws SQLException {
        final ArrayList param = new ArrayList();
        String sql = new ProxySQL(){
            {
                this.SELECT("*");
                this.FROM("`allinpaas_db`.paas_ecs_info");
                List vals = POJOUtils.getPOJOValues((Object)((Object)paasEcsInfo));
                for (Object[] val : vals) {
                    this.WHERE(String.format("%s = ?", val[0].toString()));
                    param.add(val[1]);
                }
                this.WHERE("ifnull(app_id, '') = ''");
            }
        }.toString();
        PreparedStatement ps = null;
        ResultSet rs = null;
        ArrayList<PaasEcsInfo> list = new ArrayList<PaasEcsInfo>();
        try {
            ps = this.conn.prepareStatement(sql);
            for (int i = 0; i < param.size(); ++i) {
                ps.setObject(i + 1, param.get(i));
            }
            rs = ps.executeQuery();
            while (rs.next()) {
                PaasEcsInfo bean = (PaasEcsInfo)((Object)POJOUtils.generatePOJO((ResultSet)rs, PaasEcsInfo.class));
                list.add(bean);
            }
        }
        catch (Exception e) {
            throw new RuntimeException("query queryPaasEcsInfoList is wrong", e);
        }
        return list;
    }

    public PaasEcsInfo queryByPk(final String ecsId) throws SQLException {
        final ArrayList param = new ArrayList();
        String sql = new ProxySQL(){
            {
                this.SELECT("*");
                this.FROM("`allinpaas_db`.paas_ecs_info");
                this.WHERE("ecs_id = ?");
                param.add(ecsId);
            }
        }.toString();
        PreparedStatement ps = null;
        ResultSet rs = null;
        ArrayList<PaasEcsInfo> list = new ArrayList<PaasEcsInfo>();
        try {
            ps = this.conn.prepareStatement(sql);
            for (int i = 0; i < param.size(); ++i) {
                ps.setObject(i + 1, param.get(i));
            }
            rs = ps.executeQuery();
            while (rs.next()) {
                PaasEcsInfo bean = (PaasEcsInfo)((Object)POJOUtils.generatePOJO((ResultSet)rs, PaasEcsInfo.class));
                list.add(bean);
            }
        }
        catch (Exception e) {
            throw new RuntimeException("query queryPaasEcsInfoList is wrong", e);
        }
        return list.isEmpty() ? null : (PaasEcsInfo)((Object)list.get(0));
    }

    public boolean updateByPk(final PaasEcsInfo ecs) {
        final ArrayList param = new ArrayList();
        String sql = new ProxySQL(){
            {
                this.UPDATE("`allinpaas_db`.paas_ecs_info");
                List vals = POJOUtils.getPOJOValues((Object)((Object)ecs));
                for (Object[] val : vals) {
                    if (val[0].toString().equals("ecs_id")) continue;
                    this.SET(String.format("%s = ?", val[0].toString()));
                    param.add(val[1]);
                }
                this.WHERE("ecs_id = ?");
                param.add(ecs.getEcsId());
            }
        }.toString();
        PreparedStatement ps = null;
        try {
            int i;
            ps = this.conn.prepareStatement(sql);
            for (i = 0; i < param.size(); ++i) {
                ps.setObject(i + 1, param.get(i));
            }
            i = ps.executeUpdate();
        }
        catch (Exception e) {
            throw new RuntimeException("update by pk is wrong", e);
        }
        return true;
    }

    public List<PaasEcsInfo> queryPaasEcsInfoWithAppDu(final PaasEcsInfo paasEcsInfo) throws SQLException {
        final ArrayList param = new ArrayList();
        String sql = new ProxySQL(){
            {
                this.SELECT("ecs.*");
                this.FROM("`allinpaas_db`.paas_ecs_info ecs left join `allinpaas_db`.paas_apps_du du on ecs.app_id = du.app_id and ecs.paas_du_id = du.paas_du_id ");
                List vals = POJOUtils.getPOJOValues((Object)((Object)paasEcsInfo));
                for (Object[] val : vals) {
                    this.WHERE(String.format("ecs.%s = ?", val[0].toString()));
                    param.add(val[1]);
                }
            }
        }.toString();
        PreparedStatement ps = null;
        ResultSet rs = null;
        ArrayList<PaasEcsInfo> list = new ArrayList<PaasEcsInfo>();
        try {
            ps = this.conn.prepareStatement(sql);
            for (int i = 0; i < param.size(); ++i) {
                ps.setObject(i + 1, param.get(i));
            }
            rs = ps.executeQuery();
            while (rs.next()) {
                PaasEcsInfo bean = (PaasEcsInfo)((Object)POJOUtils.generatePOJO((ResultSet)rs, PaasEcsInfo.class));
                list.add(bean);
            }
        }
        catch (Exception e) {
            throw new RuntimeException("query queryPaasEcsInfoList is wrong", e);
        }
        return list;
    }
}

