/*
 * Decompiled with CFR 0.152.
 */
package com.irdstudio.allinapaas.executor.application.executor.core.dao;

import com.irdstudio.allinapaas.executor.application.executor.core.dao.domain.SrvModelInout;
import com.irdstudio.allinapaas.executor.application.executor.core.util.db.ProxySQL;
import com.irdstudio.sdk.beans.core.util.POJOUtils;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SrvModelInoutDao {
    private static final Logger logger = LoggerFactory.getLogger(SrvModelInoutDao.class);
    Connection conn = null;

    public SrvModelInoutDao(Connection conn) {
        this.conn = conn;
    }

    public List<SrvModelInout> querySrvModelInoutList(final SrvModelInout paramVO) throws Exception {
        final ArrayList param = new ArrayList();
        String sql = new ProxySQL(){
            {
                this.SELECT("*");
                this.FROM("`allinrdm_db`.srv_model_inout");
                if (paramVO.getSrvModelId() != null) {
                    this.WHERE("srv_model_id = ?");
                    param.add(paramVO.getSrvModelId());
                }
                if (paramVO.getTableModelId() != null) {
                    this.WHERE("table_model_id = ?");
                    param.add(paramVO.getTableModelId());
                }
                if (paramVO.getTableModelCode() != null) {
                    this.WHERE("table_model_code = ?");
                    param.add(paramVO.getTableModelCode());
                }
                if (paramVO.getIoType() != null) {
                    this.WHERE("io_type = ?");
                    param.add(paramVO.getIoType());
                }
            }
        }.toString();
        PreparedStatement ps = null;
        ResultSet rs = null;
        ArrayList<SrvModelInout> list = new ArrayList<SrvModelInout>();
        try {
            ps = this.conn.prepareStatement(sql);
            for (int i = 0; i < param.size(); ++i) {
                ps.setObject(i + 1, param.get(i));
            }
            rs = ps.executeQuery();
            while (rs.next()) {
                SrvModelInout bean = (SrvModelInout)((Object)POJOUtils.generatePOJO((ResultSet)rs, SrvModelInout.class));
                list.add(bean);
            }
        }
        catch (Exception e) {
            throw new RuntimeException("query querySrvModelInoutList is wrong", e);
        }
        return list;
    }

    public SrvModelInout querySrvModelInout(final String srvModelId, final String tableModelId, final String ioType) throws Exception {
        final ArrayList param = new ArrayList();
        String sql = new ProxySQL(){
            {
                this.SELECT("*");
                this.FROM("`allinrdm_db`.srv_model_inout");
                if (srvModelId != null) {
                    this.WHERE("srv_model_id = ?");
                    param.add(srvModelId);
                }
                this.WHERE("table_model_id = ?");
                param.add(tableModelId);
                this.WHERE("io_type = ?");
                param.add(ioType);
            }
        }.toString();
        PreparedStatement ps = null;
        ResultSet rs = null;
        ArrayList<SrvModelInout> list = new ArrayList<SrvModelInout>();
        try {
            ps = this.conn.prepareStatement(sql);
            for (int i = 0; i < param.size(); ++i) {
                ps.setObject(i + 1, param.get(i));
            }
            rs = ps.executeQuery();
            while (rs.next()) {
                SrvModelInout bean = (SrvModelInout)((Object)POJOUtils.generatePOJO((ResultSet)rs, SrvModelInout.class));
                list.add(bean);
            }
        }
        catch (Exception e) {
            throw new RuntimeException("query querySrvModelInoutList is wrong", e);
        }
        return list.isEmpty() ? null : (SrvModelInout)((Object)list.get(0));
    }

    public SrvModelInout queryOsrvArrangeVarMapInout(final String srvModelId, final Integer tableRowNo) throws Exception {
        final ArrayList param = new ArrayList();
        String sql = new ProxySQL(){
            {
                this.SELECT("*");
                this.FROM("`allinrdm_db`.srv_model_inout");
                this.WHERE("srv_model_id in ( select row_op_target_id from `allinrdm_db`.osrv_arrange_table where srv_model_id = ? and table_row_no = ? )");
                param.add(srvModelId);
                param.add(tableRowNo);
                this.WHERE("io_type = 'O'");
            }
        }.toString();
        PreparedStatement ps = null;
        ResultSet rs = null;
        ArrayList<SrvModelInout> list = new ArrayList<SrvModelInout>();
        try {
            ps = this.conn.prepareStatement(sql);
            for (int i = 0; i < param.size(); ++i) {
                ps.setObject(i + 1, param.get(i));
            }
            rs = ps.executeQuery();
            while (rs.next()) {
                SrvModelInout bean = (SrvModelInout)((Object)POJOUtils.generatePOJO((ResultSet)rs, SrvModelInout.class));
                list.add(bean);
            }
        }
        catch (Exception e) {
            throw new RuntimeException("query querySrvModelInoutList is wrong", e);
        }
        return list.isEmpty() ? null : (SrvModelInout)((Object)list.get(0));
    }

    public int countByTableModelId(final String appId, final String tableModelId) throws Exception {
        final ArrayList param = new ArrayList();
        String sql = new ProxySQL(){
            {
                this.SELECT("count(1) as num");
                this.FROM("`allinrdm_db`.srv_model_inout si");
                this.WHERE("exists ( select srv_model_id from `allinrdm_db`.srv_model_info srv where srv.app_id = ? and  si.srv_model_id = srv.srv_model_id and srv_model_catalog = 'D')");
                param.add(appId);
                this.WHERE("table_model_id = ? ");
                param.add(tableModelId);
            }
        }.toString();
        PreparedStatement ps = null;
        ResultSet rs = null;
        int count = 0;
        try {
            ps = this.conn.prepareStatement(sql);
            for (int i = 0; i < param.size(); ++i) {
                ps.setObject(i + 1, param.get(i));
            }
            rs = ps.executeQuery();
            while (rs.next()) {
                count = rs.getInt(1);
            }
        }
        catch (Exception e) {
            throw new RuntimeException("query countByAppId is wrong", e);
        }
        return count;
    }

    public boolean insert(final SrvModelInout obj) throws SQLException {
        final ArrayList param = new ArrayList();
        String sql = new ProxySQL(){
            {
                this.INSERT_INTO("`allinrdm_db`.srv_model_inout");
                List vals = POJOUtils.getPOJOValues((Object)((Object)obj));
                for (Object[] val : vals) {
                    this.VALUES(val[0].toString(), "?");
                    param.add(val[1]);
                }
            }
        }.toString();
        PreparedStatement ps = null;
        Object rs = null;
        try {
            ps = this.conn.prepareStatement(sql);
            for (int i = 0; i < param.size(); ++i) {
                ps.setObject(i + 1, param.get(i));
            }
            int re = ps.executeUpdate();
            if (re == 1) {
                return true;
            }
        }
        catch (Exception e) {
            throw new RuntimeException("insert is wrong", e);
        }
        return false;
    }

    public int deleteByPk(final String recordKeyId) throws SQLException {
        final ArrayList param = new ArrayList();
        String sql = new ProxySQL(){
            {
                this.DELETE_FROM("`allinrdm_db`.srv_model_inout");
                this.WHERE("record_key_id = ?");
                param.add(recordKeyId);
            }
        }.toString();
        PreparedStatement ps = null;
        Object rs = null;
        try {
            ps = this.conn.prepareStatement(sql);
            for (int i = 0; i < param.size(); ++i) {
                ps.setObject(i + 1, param.get(i));
            }
            int re = ps.executeUpdate();
            return re;
        }
        catch (Exception e) {
            throw new RuntimeException("insert is wrong", e);
        }
    }

    public int updateByPk(final SrvModelInout field) throws SQLException {
        final ArrayList param = new ArrayList();
        String sql = new ProxySQL(){
            {
                this.UPDATE("`allinrdm_db`.srv_model_inout");
                List vals = POJOUtils.getPOJOValues((Object)((Object)field));
                for (Object[] val : vals) {
                    if (val[0].toString().equals("record_key_id")) continue;
                    this.SET(String.format("%s = ?", val[0].toString()));
                    param.add(val[1]);
                }
                this.WHERE("record_key_id = ?");
                param.add(field.getRecordKeyId());
            }
        }.toString();
        if (param.size() < 2) {
            return 0;
        }
        PreparedStatement ps = null;
        Object rs = null;
        int result = 0;
        try {
            ps = this.conn.prepareStatement(sql);
            for (int i = 0; i < param.size(); ++i) {
                ps.setObject(i + 1, param.get(i));
            }
            result = ps.executeUpdate();
        }
        catch (Exception e) {
            throw new RuntimeException("updateByPk is wrong", e);
        }
        return result;
    }

    public List<SrvModelInout> batchQueryBySrvModelIds(List<String> srvModelIds) throws Exception {
        String querySql = "select * from `allinrdm_db`.srv_model_inout where srv_model_id in(" + srvModelIds.stream().map(s -> "?").collect(Collectors.joining(",")) + ")";
        PreparedStatement ps = null;
        ResultSet rs = null;
        ArrayList<SrvModelInout> list = new ArrayList<SrvModelInout>();
        try {
            ps = this.conn.prepareStatement(querySql);
            for (int i = 0; i < srvModelIds.size(); ++i) {
                ps.setObject(i + 1, srvModelIds.get(i));
            }
            rs = ps.executeQuery();
            while (rs.next()) {
                SrvModelInout bean = (SrvModelInout)((Object)POJOUtils.generatePOJO((ResultSet)rs, SrvModelInout.class));
                list.add(bean);
            }
        }
        catch (Exception e) {
            throw new RuntimeException("query querySrvModelInoutList is wrong", e);
        }
        return list;
    }
}

