/*
 * Decompiled with CFR 0.152.
 */
package com.irdstudio.allinapaas.executor.application.executor.core.plugin.check;

import com.irdstudio.allinapaas.executor.application.executor.core.dao.ModelTableFieldDao;
import com.irdstudio.allinapaas.executor.application.executor.core.dao.ModelTableInfoDao;
import com.irdstudio.allinapaas.executor.application.executor.core.dao.domain.AppsCheckLog;
import com.irdstudio.allinapaas.executor.application.executor.core.dao.domain.ModelTableField;
import com.irdstudio.allinapaas.executor.application.executor.core.dao.domain.ModelTableInfo;
import com.irdstudio.allinapaas.executor.application.executor.core.plugin.check.AbstractCheckPlugin;
import com.irdstudio.allinapaas.quality.console.types.CheckResult;
import com.irdstudio.allinrdm.dam.console.types.ObjectType;
import java.sql.Connection;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.MapUtils;

public class ModelTableCheckPlugin
extends AbstractCheckPlugin {
    private static final Pattern codeReg = Pattern.compile("^[a-zA-Z]+[a-zA-Z0-9\\-\\_]*$");
    private static final Pattern nameReg = Pattern.compile("^[a-zA-Z\\u4e00-\\u9fa5]+[a-zA-Z0-9\\-\\_\\u4e00-\\u9fa5\\(\\)\\%]*$");

    public String getSwitchKey() {
        return "checkModelTable";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public boolean execute() {
        Connection conn;
        boolean flag;
        block19: {
            flag = true;
            conn = null;
            Boolean checkSwitch = MapUtils.getBoolean((Map)this.extParam, (Object)this.getSwitchKey(), (Boolean)Boolean.TRUE);
            if (checkSwitch.booleanValue()) break block19;
            this.logger.info("\u672c\u6b21\u4e0d\u8fdb\u884c\u9886\u57df\u6a21\u578b\u6821\u9a8c\uff0c \u4efb\u52a1\u7f6e\u8fc7!");
            boolean bl = true;
            if (conn == null) return bl;
            this.closePluginConnection(conn);
            return bl;
        }
        try {
            List<ModelTableInfo> list;
            List<ModelTableField> list2;
            List<ModelTableInfo> list3;
            List<ModelTableField> duplicateFields;
            String objectId = MapUtils.getString((Map)this.extParam, (Object)"objectId");
            conn = this.getPluginConnection();
            ModelTableInfoDao modelTableInfoDao = new ModelTableInfoDao(conn);
            ModelTableFieldDao modelTableFieldDao = new ModelTableFieldDao(conn);
            String projectId = this.appInfo.getAppId();
            List<String> duplicateTableNames = modelTableInfoDao.queryDuplicateTable(projectId);
            if (CollectionUtils.isNotEmpty(duplicateTableNames)) {
                for (String string : duplicateTableNames) {
                    AppsCheckLog appsCheckLog = new AppsCheckLog();
                    appsCheckLog.setCheckRuleId("R0001");
                    appsCheckLog.setCheckResult(CheckResult.Fail.getCode());
                    appsCheckLog.setCheckDesc(String.format("\u5b58\u5728\u76f8\u540c\u7684\u8868\u6a21\u578b\uff0c%s!", string));
                    this.saveAppsCheckLog(appsCheckLog, conn);
                }
            }
            if (CollectionUtils.isNotEmpty(duplicateFields = modelTableFieldDao.queryDuplicateField(projectId))) {
                for (ModelTableField modelTableField : duplicateFields) {
                    AppsCheckLog appsCheckLog = new AppsCheckLog();
                    appsCheckLog.setCheckRuleId("R0002");
                    ModelTableInfo table = modelTableInfoDao.queryModelTableInfo(modelTableField.getObjectId());
                    appsCheckLog.setObjectCode(table.getObjectCode());
                    appsCheckLog.setObjectName(table.getObjectName());
                    appsCheckLog.setObjectId(table.getObjectId());
                    appsCheckLog.setCheckResult(CheckResult.Fail.getCode());
                    appsCheckLog.setCheckDesc(String.format("%s\u4e2d\u5b58\u5728\u76f8\u540c\u7684\u5b57\u6bb5,%s!", table.getObjectName(), modelTableField.getFieldCode()));
                    this.saveAppsCheckLog(appsCheckLog, conn);
                }
            }
            if (CollectionUtils.isNotEmpty(list3 = modelTableInfoDao.queryWithoutPkTable(projectId))) {
                for (ModelTableInfo modelTableInfo : list3) {
                    if (!modelTableInfo.getObjectType().equals(ObjectType.Table.getIntCode())) continue;
                    AppsCheckLog checkLog = new AppsCheckLog();
                    checkLog.setCheckRuleId("R0003");
                    checkLog.setObjectCode(modelTableInfo.getObjectCode());
                    checkLog.setObjectName(modelTableInfo.getObjectName());
                    checkLog.setObjectId(modelTableInfo.getObjectId());
                    checkLog.setCheckResult(CheckResult.Fail.getCode());
                    checkLog.setCheckDesc(String.format("%s\u6ca1\u6709\u4e3b\u952e\u5b57\u6bb5!", modelTableInfo.getObjectName()));
                    this.saveAppsCheckLog(checkLog, conn);
                }
            }
            if (CollectionUtils.isNotEmpty(list2 = modelTableFieldDao.queryFieldWithoutFieldLength(projectId))) {
                for (ModelTableField field : list2) {
                    AppsCheckLog checkLog = new AppsCheckLog();
                    checkLog.setCheckRuleId("R0004");
                    ModelTableInfo table = modelTableInfoDao.queryModelTableInfo(field.getObjectId());
                    checkLog.setObjectCode(table.getObjectCode());
                    checkLog.setObjectName(table.getObjectName());
                    checkLog.setObjectId(table.getObjectId());
                    checkLog.setCheckResult(CheckResult.Fail.getCode());
                    checkLog.setCheckDesc(String.format("%s[%s]\u5b57\u6bb5%s[%s]\u9700\u8981\u5b57\u6bb5\u957f\u5ea6!", field.getObjectName(), field.getObjectCode(), field.getFieldName(), field.getFieldCode()));
                    this.saveAppsCheckLog(checkLog, conn);
                }
            }
            if (CollectionUtils.isNotEmpty(list = modelTableInfoDao.queryModelTableInfoList(projectId))) {
                for (ModelTableInfo table : list) {
                    AppsCheckLog checkLog;
                    if (!nameReg.matcher(table.getObjectName()).matches()) {
                        checkLog = new AppsCheckLog();
                        checkLog.setCheckRuleId("R0005");
                        checkLog.setObjectCode(table.getObjectCode());
                        checkLog.setObjectName(table.getObjectName());
                        checkLog.setObjectId(table.getObjectId());
                        checkLog.setCheckResult(CheckResult.Fail.getCode());
                        checkLog.setCheckDesc(String.format("%s[%s]\u8868\u6a21\u578b\u540d\u79f0\u975e\u6cd5!", table.getObjectName(), table.getObjectCode()));
                        this.saveAppsCheckLog(checkLog, conn);
                    }
                    if (!codeReg.matcher(table.getObjectCode()).matches()) {
                        checkLog = new AppsCheckLog();
                        checkLog.setCheckRuleId("R0005");
                        checkLog.setObjectCode(table.getObjectCode());
                        checkLog.setObjectName(table.getObjectName());
                        checkLog.setObjectId(table.getObjectId());
                        checkLog.setCheckResult(CheckResult.Fail.getCode());
                        checkLog.setCheckDesc(String.format("%s[%s]\u8868\u6a21\u578b\u4ee3\u7801\u975e\u6cd5!", table.getObjectName(), table.getObjectCode()));
                        this.saveAppsCheckLog(checkLog, conn);
                    }
                    List<ModelTableField> tableFieldList = modelTableFieldDao.queryModelTableFieldList(table.getObjectId());
                    if (!CollectionUtils.isNotEmpty(list)) continue;
                    for (ModelTableField field : tableFieldList) {
                        AppsCheckLog checkLog2;
                        if (field.getFieldName() == null || !nameReg.matcher(field.getFieldName()).matches()) {
                            checkLog2 = new AppsCheckLog();
                            checkLog2.setCheckRuleId("R0006");
                            checkLog2.setObjectCode(table.getObjectCode());
                            checkLog2.setObjectName(table.getObjectName());
                            checkLog2.setObjectId(table.getObjectId());
                            checkLog2.setCheckResult(CheckResult.Fail.getCode());
                            checkLog2.setCheckDesc(String.format("%s[%s]\u8868\u6a21\u578b\u5b57\u6bb5%s[%s]\u540d\u79f0\u975e\u6cd5!", table.getObjectName(), table.getObjectCode(), field.getFieldName(), field.getFieldCode()));
                            this.saveAppsCheckLog(checkLog2, conn);
                        }
                        if (codeReg.matcher(field.getFieldCode()).matches()) continue;
                        checkLog2 = new AppsCheckLog();
                        checkLog2.setCheckRuleId("R0006");
                        checkLog2.setObjectCode(table.getObjectCode());
                        checkLog2.setObjectName(table.getObjectName());
                        checkLog2.setObjectId(table.getObjectId());
                        checkLog2.setCheckResult(CheckResult.Fail.getCode());
                        checkLog2.setCheckDesc(String.format("%s[%s]\u8868\u6a21\u578b\u5b57\u6bb5%s[%s]\u4ee3\u7801\u975e\u6cd5!", table.getObjectName(), table.getObjectCode(), field.getFieldName(), field.getFieldCode()));
                        this.saveAppsCheckLog(checkLog2, conn);
                    }
                }
            }
            if (conn == null) return flag;
        }
        catch (Exception e) {
            try {
                this.logger.error("\u9886\u57df\u6a21\u578b\u6821\u9a8c " + e.getMessage(), e);
                flag = false;
                if (conn == null) return flag;
            }
            catch (Throwable throwable) {
                if (conn == null) throw throwable;
                this.closePluginConnection(conn);
                throw throwable;
            }
            this.closePluginConnection(conn);
            return flag;
        }
        this.closePluginConnection(conn);
        return flag;
    }
}

