/*
 * Decompiled with CFR 0.152.
 */
package com.irdstudio.allinapaas.executor.application.executor.core.plugin.dataload;

import com.irdstudio.allinapaas.executor.application.executor.core.plugin.dataload.ImportFromTxt;
import com.irdstudio.allinapaas.executor.application.executor.core.plugin.dataload.PluginLoadConf;
import com.irdstudio.allinapaas.executor.application.executor.core.plugin.dataload.PluginLoadResult;
import com.irdstudio.allinapaas.executor.application.executor.core.tinycore.jdbc.meta.MetaTable;
import com.irdstudio.allinapaas.executor.application.executor.core.tinycore.jdbc.util.TableUtil;
import com.irdstudio.allinapaas.executor.application.executor.core.tinycore.log.ILogger;
import com.irdstudio.allinapaas.executor.application.executor.core.util.date.CurrentDateUtil;
import java.io.File;
import java.math.BigDecimal;
import java.sql.Connection;
import java.sql.SQLException;
import java.sql.Statement;

public class DataImportExecutor {
    private Connection loadConn = null;
    private PluginLoadConf loadConf = null;
    private ILogger logger = null;
    private PluginLoadResult loadResult = null;

    public DataImportExecutor(PluginLoadConf loadConf, Connection conn, ILogger logger) {
        this.loadConf = loadConf;
        this.loadConn = conn;
        this.logger = logger;
    }

    public boolean init() {
        return true;
    }

    public boolean beforeLoad() {
        block10: {
            String[] sqls;
            block9: {
                MetaTable table = MetaTable.getInstWithTable(this.loadConn, this.loadConf.getTableName());
                if (!table.isTableExist()) {
                    this.logger.info("\u8868\u4e0d\u5b58\u5728," + this.loadConf.getTableName());
                    String tableDDL = this.loadConf.getCreateTableDdl();
                    if (tableDDL != null && !"".equals(tableDDL)) {
                        if (!TableUtil.createTable(this.loadConn, this.loadConf.getCreateTableDdl())) {
                            this.logger.error("\u81ea\u52a8\u5efa\u8868[" + this.loadConf.getTableName() + "]\u5931\u8d25!");
                            return false;
                        }
                        this.logger.info("\u81ea\u52a8\u5efa\u8868[" + this.loadConf.getTableName() + "]\u6210\u529f!");
                    } else {
                        this.logger.error("\u8868\u4e0d\u5b58\u5728!" + this.loadConf.getTableName());
                        return false;
                    }
                }
                if (!"1".equals(this.loadConf.getTableLoadMode())) break block9;
                if (!"".equals(this.loadConf.getBeforeLoadSql())) {
                    sqls = this.loadConf.getBeforeLoadSql().split(";");
                    for (int i = 0; i < sqls.length; ++i) {
                        String sql = sqls[i];
                        if (this.executeSql(sql)) continue;
                        return false;
                    }
                } else if (!this.executeSql("truncate table " + this.loadConf.getTableName())) {
                    return false;
                }
                break block10;
            }
            if ("".equals(this.loadConf.getBeforeLoadSql())) break block10;
            sqls = this.loadConf.getBeforeLoadSql().split(";");
            for (int i = 0; i < sqls.length; ++i) {
                String sql = sqls[i];
                if (this.executeSql(sql)) continue;
                return false;
            }
        }
        return true;
    }

    public boolean afterLoad() {
        if (this.loadConf.getAfterLoadSql() == null || "".equals(this.loadConf.getAfterLoadSql())) {
            return true;
        }
        String[] indexes = this.loadConf.getAfterLoadSql().split(";");
        for (int i = 0; i < indexes.length; ++i) {
            this.logger.info("\u88c5\u8f7d\u540e\u6267\u884c\u8bed\u53e5:" + indexes[i]);
            if (!this.executeSql(indexes[i])) continue;
            this.logger.error("\u88c5\u8f7d\u540e\u6267\u884c\u7684\u8bed\u53e5\u5931\u8d25:" + indexes[i]);
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean executeSql(String sql) {
        boolean flag = true;
        Statement st = null;
        try {
            st = this.loadConn.createStatement();
            st.execute(sql);
        }
        catch (SQLException e) {
            flag = false;
            this.logger.error("\u6267\u884cSQL\u9519\u8bef:" + sql, e);
        }
        finally {
            if (st != null) {
                try {
                    st.close();
                    st = null;
                }
                catch (SQLException e) {
                    this.logger.error("\u5173\u95edst\u9519\u8bef:" + sql, e);
                }
            }
        }
        return flag;
    }

    public PluginLoadResult run() {
        this.loadResult = new PluginLoadResult();
        this.logger.info("\u8868\u540d:" + this.loadConf.getTableName());
        this.logger.info("\u6587\u4ef6:" + this.loadConf.getLoadFromFile());
        this.loadResult.setLoadFromFile(this.loadConf.getLoadFromFile());
        this.loadResult.setStartTime(CurrentDateUtil.getTodayDateEx2());
        this.loadResult.setTableName(this.loadConf.getTableName());
        this.loadResult.setTableCnname(this.loadConf.getTableCnname());
        this.loadResult.setTableType(this.loadConf.getTableType());
        this.loadResult.setUpSysname(this.loadConf.getUpSysname());
        this.loadResult.setTableLoadMode(this.loadConf.getTableLoadMode());
        File file = new File(this.loadConf.getLoadFromFile());
        if (file == null || !file.exists() || !file.isFile()) {
            this.logger.info("\u627e\u4e0d\u5230\u8981\u5bfc\u5165\u7684\u6587\u4ef6:" + this.loadConf.getLoadFromFile());
            this.loadResult.setLoadResult("3");
            this.loadResult.setRemark("\u627e\u4e0d\u5230\u8981\u5bfc\u5165\u7684\u6587\u4ef6:" + this.loadConf.getLoadFromFile());
            return this.loadResult;
        }
        if (!this.beforeLoad()) {
            this.loadResult.setLoadResult("3");
            return this.loadResult;
        }
        BigDecimal fileSize = new BigDecimal(file.length()).divide(BigDecimal.valueOf(1048576.0));
        this.logger.info("[\u6587\u4ef6\u5927\u5c0f(M)]:" + fileSize.toString());
        this.loadResult.setFileSize(fileSize);
        if (file.length() < 1L) {
            this.loadResult.setLoadRows(0);
            this.loadResult.setReadRows(0);
            this.loadResult.setRejectRows(0);
            if ("Y".equals(this.loadConf.getFileRowFlag())) {
                this.loadResult.setLoadResult("1");
            } else {
                this.loadResult.setLoadResult("3");
            }
            return this.loadResult;
        }
        this.logger.info("\u5f00\u59cb\u88c5\u8f7d...");
        ImportFromTxt txtImport = new ImportFromTxt(this.loadConf, this.logger, this.loadConn);
        boolean impResult = txtImport.run();
        this.loadResult.setReadRows(txtImport.getFileRecordCount());
        this.loadResult.setRejectRows(txtImport.getFaildRecordCount());
        this.loadResult.setLoadRows(this.loadResult.getReadRows() - this.loadResult.getRejectRows());
        if (!impResult) {
            this.loadResult.setLoadResult("3");
            return this.loadResult;
        }
        if (this.loadResult.getRejectRows() > 0 && this.loadResult.getRejectRows() >= this.loadResult.getLoadRows()) {
            this.loadResult.setLoadResult("3");
        } else if (this.loadResult.getRejectRows() > 0 && this.loadResult.getRejectRows() < this.loadResult.getLoadRows()) {
            this.loadResult.setLoadResult("3");
        } else {
            this.loadResult.setLoadResult("1");
        }
        if (!this.afterLoad()) {
            this.loadResult.setLoadResult("3");
            return this.loadResult;
        }
        return this.loadResult;
    }
}

