/*
 * Decompiled with CFR 0.152.
 */
package com.irdstudio.allinapaas.executor.application.executor.core.plugin.datapack;

import com.irdstudio.allinapaas.executor.application.executor.core.plugin.datapack.PluginDatapackConf;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PluginDatapackConfDao {
    private static final Logger logger = LoggerFactory.getLogger(PluginDatapackConfDao.class);
    Connection conn = null;

    public PluginDatapackConfDao(Connection conn) {
        this.conn = conn;
    }

    public PluginDatapackConf queryPluginDatapackConfWithKeys(String pluginConfId, int confSort) throws SQLException {
        PluginDatapackConf dc = null;
        PreparedStatement ps = null;
        ResultSet rs = null;
        try {
            ps = this.conn.prepareStatement("SELECT * FROM urps.plugin_datapack_conf WHERE plugin_conf_id=?,conf_sort=? with ur");
            ps.setString(1, pluginConfId);
            ps.setInt(2, confSort);
            rs = ps.executeQuery();
            if (rs.next()) {
                dc = new PluginDatapackConf();
                dc.setPluginConfId(rs.getString("plugin_conf_id"));
                dc.setConfSort(rs.getInt("conf_sort"));
                dc.setPackDesc(rs.getString("pack_desc"));
                dc.setPackConfigFile(rs.getString("pack_config_file"));
                dc.setPackFileEncoding(rs.getString("pack_file_encoding"));
                dc.setPackFileType(rs.getString("pack_file_type"));
                dc.setPackGenerateFile(rs.getString("pack_generate_file"));
                dc.setRsvOption(rs.getString("rsv_option"));
                dc.setValidDate(rs.getString("valid_date"));
                dc.setInvalidDate(rs.getString("invalid_date"));
                dc.setLastModifyDate(rs.getString("last_modify_date"));
            }
            this.close(rs, null, ps);
        }
        catch (SQLException e) {
            try {
                throw new SQLException("queryPluginDatapackConfWithKeys is Wrong!" + e.getMessage());
            }
            catch (Throwable throwable) {
                this.close(rs, null, ps);
                throw throwable;
            }
        }
        return dc;
    }

    public List<PluginDatapackConf> queryPluginDatapackConfWithPluginConfId(String pluginConfId) throws SQLException {
        ArrayList<PluginDatapackConf> dcList = new ArrayList<PluginDatapackConf>();
        PluginDatapackConf dc = null;
        PreparedStatement ps = null;
        ResultSet rs = null;
        try {
            ps = this.conn.prepareStatement("SELECT * FROM urps.plugin_datapack_conf WHERE plugin_conf_id=? order by conf_sort with ur");
            ps.setString(1, pluginConfId);
            rs = ps.executeQuery();
            while (rs.next()) {
                dc = new PluginDatapackConf();
                dc.setPluginConfId(rs.getString("plugin_conf_id"));
                dc.setConfSort(rs.getInt("conf_sort"));
                dc.setPackDesc(rs.getString("pack_desc"));
                dc.setPackConfigFile(rs.getString("pack_config_file"));
                dc.setPackFileEncoding(rs.getString("pack_file_encoding"));
                dc.setPackFileType(rs.getString("pack_file_type"));
                dc.setPackGenerateFile(rs.getString("pack_generate_file"));
                dc.setRsvOption(rs.getString("rsv_option"));
                dc.setValidDate(rs.getString("valid_date"));
                dc.setInvalidDate(rs.getString("invalid_date"));
                dc.setLastModifyDate(rs.getString("last_modify_date"));
                dcList.add(dc);
            }
            this.close(rs, null, ps);
        }
        catch (SQLException e) {
            try {
                throw new SQLException("queryPluginDatapackConfWithKeys is Wrong!" + e.getMessage());
            }
            catch (Throwable throwable) {
                this.close(rs, null, ps);
                throw throwable;
            }
        }
        return dcList;
    }

    protected void close(ResultSet theRs, Statement theStmt, PreparedStatement thePs) {
        try {
            if (theRs != null) {
                theRs.close();
            }
            if (theStmt != null) {
                theStmt.close();
            }
            if (thePs != null) {
                thePs.close();
            }
        }
        catch (SQLException e) {
            logger.error(e.getMessage());
        }
    }
}

