/*
 * Decompiled with CFR 0.152.
 */
package com.irdstudio.allinapaas.executor.application.executor.core.plugin.deploy;

import com.alibaba.fastjson.JSON;
import com.irdstudio.allinapaas.deliver.console.facade.BatBatchInfoConfigService;
import com.irdstudio.allinapaas.deliver.console.facade.PaasEnvInfoService;
import com.irdstudio.allinapaas.deliver.console.facade.PaasEnvParamService;
import com.irdstudio.allinapaas.deliver.console.facade.PluginDeployJavaService;
import com.irdstudio.allinapaas.deliver.console.facade.dto.BatBatchInfoConfigDTO;
import com.irdstudio.allinapaas.deliver.console.facade.dto.PaasEnvInfoDTO;
import com.irdstudio.allinapaas.deliver.console.facade.dto.PaasEnvParamDTO;
import com.irdstudio.allinapaas.deliver.console.facade.dto.PluginDeployJavaDTO;
import com.irdstudio.allinapaas.design.console.facade.PaasAppsInfoService;
import com.irdstudio.allinapaas.design.console.facade.PaasAppsParamPortalService;
import com.irdstudio.allinapaas.design.console.facade.PaasAppsPropertiesService;
import com.irdstudio.allinapaas.design.console.facade.PaasAppsVariablesService;
import com.irdstudio.allinapaas.design.console.facade.dto.PaasAppsInfoDTO;
import com.irdstudio.allinapaas.design.console.facade.dto.PaasAppsPropertiesDTO;
import com.irdstudio.allinapaas.design.console.facade.dto.PaasAppsVariablesDTO;
import com.irdstudio.allinapaas.executor.application.executor.core.dao.BatInstBatchDao;
import com.irdstudio.allinapaas.executor.application.executor.core.dao.PaasAppsInfoDao;
import com.irdstudio.allinapaas.executor.application.executor.core.dao.PaasAppsParamDao;
import com.irdstudio.allinapaas.executor.application.executor.core.dao.PaasEcsInfoDao;
import com.irdstudio.allinapaas.executor.application.executor.core.dao.PaasEnvInfoDao;
import com.irdstudio.allinapaas.executor.application.executor.core.dao.PaasEnvParamDao;
import com.irdstudio.allinapaas.executor.application.executor.core.dao.domain.BatInstBatch;
import com.irdstudio.allinapaas.executor.application.executor.core.dao.domain.PaasAppsInfo;
import com.irdstudio.allinapaas.executor.application.executor.core.dao.domain.PaasEcsInfo;
import com.irdstudio.allinapaas.executor.application.executor.core.dao.domain.PaasEnvInfo;
import com.irdstudio.allinapaas.executor.application.executor.core.dao.domain.PaasEnvParam;
import com.irdstudio.allinapaas.executor.application.executor.core.plugin.AbstractPlugin;
import com.irdstudio.allinapaas.executor.application.executor.core.plugin.apps.SdEnvUtil;
import com.irdstudio.allinapaas.executor.application.executor.core.plugin.db.TdpAgentCommonUtil;
import com.irdstudio.allinapaas.executor.application.executor.core.util.parse.ExpressionUtil;
import com.irdstudio.allinapaas.executor.facade.dto.ValidateRtnDTO;
import com.irdstudio.allinapaas.portal.console.types.PropSource;
import com.irdstudio.sdk.beans.core.util.BeanUtility;
import com.irdstudio.sdk.beans.core.util.SpringContextUtils;
import com.irdstudio.sdk.beans.core.util.TmModelUtil;
import com.irdstudio.sdk.beans.core.util.UUIDUtil;
import com.irdstudio.sdk.beans.core.vo.FilterItem;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.MapUtils;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;
import org.yaml.snakeyaml.DumperOptions;
import org.yaml.snakeyaml.Yaml;

public class AppConfigFilePlugin
extends AbstractPlugin {
    protected PaasAppsInfo appInfo = null;
    protected BatInstBatch batInst = null;
    private Pattern configReg = Pattern.compile("\\s*([\\S\\.]+?)[\\=|\\:]++\\s*\\S*+\\s*.*");
    private Pattern xmlReg = Pattern.compile("\\s*<.*?>(.+)<\\/.*?>");
    private final String SAAS_SUBS_ID = "S11021";

    @Override
    public boolean validate(String batchId, String taskId, ValidateRtnDTO message) {
        PaasAppsPropertiesService paasAppsPropertiesService = (PaasAppsPropertiesService)SpringContextUtils.getBean(PaasAppsPropertiesService.class);
        BatBatchInfoConfigService batBatchInfoConfigService = (BatBatchInfoConfigService)SpringContextUtils.getBean(BatBatchInfoConfigService.class);
        PaasEnvInfoService paasEnvInfoService = (PaasEnvInfoService)SpringContextUtils.getBean(PaasEnvInfoService.class);
        PaasAppsParamPortalService paasAppsParamService = (PaasAppsParamPortalService)SpringContextUtils.getBean(PaasAppsParamPortalService.class);
        PaasAppsVariablesService paasAppsVariablesService = (PaasAppsVariablesService)SpringContextUtils.getBean(PaasAppsVariablesService.class);
        PaasEnvParamService paasEnvParamService = (PaasEnvParamService)SpringContextUtils.getBean(PaasEnvParamService.class);
        PaasAppsInfoService paasAppsInfoService = (PaasAppsInfoService)SpringContextUtils.getBean(PaasAppsInfoService.class);
        BatBatchInfoConfigDTO batchParam = new BatBatchInfoConfigDTO();
        batchParam.setBatchId(batchId);
        String appId = "";
        batchParam = (BatBatchInfoConfigDTO)batBatchInfoConfigService.queryByPk((Object)batchParam);
        if (batchParam != null) {
            appId = batchParam.getAppId();
        }
        PaasAppsInfoDTO appInfo = new PaasAppsInfoDTO();
        appInfo.setAppId(appId);
        appInfo = (PaasAppsInfoDTO)paasAppsInfoService.queryByPk((Object)appInfo);
        String envId = batchParam.getEnvId();
        HashMap<String, Object> root = new HashMap<String, Object>();
        PaasEnvInfoDTO envInfo = new PaasEnvInfoDTO();
        envInfo.setEnvId(envId);
        envInfo = (PaasEnvInfoDTO)paasEnvInfoService.queryByPk((Object)envInfo);
        root.put("env", BeanUtility.bean2Map((Object)envInfo));
        PaasEnvParamDTO loggingFile = paasEnvParamService.queryEnvParamByCodeReturnValue("logging_path", envId);
        if (loggingFile == null) {
            loggingFile = new PaasEnvParamDTO();
            loggingFile.setParamCode("logging_path");
            loggingFile.setEnvId(envId);
            loggingFile.setParamValue("/var/tmp/logs/");
        }
        root.put("logging_path", loggingFile.getParamValue());
        PaasAppsVariablesDTO variablesParam = new PaasAppsVariablesDTO();
        variablesParam.setSubsId(appInfo.getSubsId());
        variablesParam.setEnvId(envId);
        List varList = paasAppsVariablesService.queryList((Object)variablesParam);
        if (CollectionUtils.isNotEmpty((Collection)varList)) {
            varList.forEach(var -> root.put(var.getVarCode(), var.getVarRealVal()));
        }
        PaasAppsVariablesDTO saasVarParam = new PaasAppsVariablesDTO();
        saasVarParam.setEnvId(envId);
        saasVarParam.setSubsId("S11021");
        List saasVarList = paasAppsVariablesService.queryList((Object)saasVarParam);
        HashMap<String, Object> saasRoot = new HashMap<String, Object>();
        if (CollectionUtils.isNotEmpty((Collection)saasVarList)) {
            saasVarList.forEach(var -> saasRoot.put(var.getVarCode(), var.getVarRealVal()));
        }
        Map appsParam = paasAppsParamService.queryAppParamMap(appId, envId);
        root.putAll(appsParam);
        PaasAppsPropertiesDTO propParam = new PaasAppsPropertiesDTO();
        propParam.setAppId(appId);
        List propList = paasAppsPropertiesService.queryList((Object)propParam);
        message.setErrorMsgSuffix("\u7b49\u914d\u7f6e\u5b58\u5728\u65e0\u6548\u7684\u73af\u5883\u53d8\u91cf");
        boolean valid = true;
        if (CollectionUtils.isNotEmpty((Collection)propList)) {
            for (PaasAppsPropertiesDTO prop : propList) {
                if (StringUtils.isBlank((CharSequence)prop.getPropValue())) {
                    valid = false;
                    message.getMessage().add(prop.getPropDesc());
                }
                try {
                    String string;
                    if (StringUtils.equals((CharSequence)PropSource.Saas.getCode(), (CharSequence)prop.getPropSource())) {
                        string = ExpressionUtil.parse(prop.getPropValue(), saasRoot);
                        continue;
                    }
                    string = ExpressionUtil.parse(prop.getPropValue(), root);
                }
                catch (Exception e) {
                    valid = false;
                    message.getMessage().add(prop.getPropDesc());
                }
            }
        }
        return valid;
    }

    @Override
    public boolean copyConfig(String batchId, String taskId, String newTaskId) {
        PaasAppsPropertiesService paasAppsPropertiesService = (PaasAppsPropertiesService)SpringContextUtils.getBean(PaasAppsPropertiesService.class);
        BatBatchInfoConfigService batBatchInfoConfigService = (BatBatchInfoConfigService)SpringContextUtils.getBean(BatBatchInfoConfigService.class);
        PaasAppsPropertiesDTO param = new PaasAppsPropertiesDTO();
        param.setPluginConfId(taskId);
        List list = paasAppsPropertiesService.queryList((Object)param);
        if (CollectionUtils.isNotEmpty((Collection)list)) {
            BatBatchInfoConfigDTO batchParam = new BatBatchInfoConfigDTO();
            batchParam.setBatchId(newTaskId.substring(0, newTaskId.length() - 3));
            String appId = "";
            batchParam = (BatBatchInfoConfigDTO)batBatchInfoConfigService.queryByPk((Object)batchParam);
            if (batchParam != null) {
                appId = batchParam.getAppId();
            }
            for (PaasAppsPropertiesDTO prop : list) {
                prop.setAppId(appId);
                prop.setRecordKeyid(UUIDUtil.getUUID());
                prop.setPluginConfId(appId);
            }
            int re = paasAppsPropertiesService.batchInsert(list);
            return re > 0;
        }
        return super.copyConfig(batchId, taskId, newTaskId);
    }

    @Override
    protected boolean doReadConfigureFromDB(Connection conn, String szConfIdentify) throws SQLException {
        String batchSerialNo = this.context.getSzBatchSn();
        BatInstBatchDao batInstBatchDao = new BatInstBatchDao(conn);
        this.batInst = batInstBatchDao.queryByBatchSerialNo(batchSerialNo);
        PaasAppsInfoDao paasAppsInfoDao = new PaasAppsInfoDao(conn);
        this.appInfo = paasAppsInfoDao.queryByAppId(this.batInst.getAppId());
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean execute() {
        this.logger.info("\u81ea\u5b9a\u4e49\u5e94\u7528\u914d\u7f6e");
        boolean flag = true;
        Connection conn = null;
        try {
            String envId = this.batInst.getEnvId();
            conn = this.getPluginConnection();
            PaasEcsInfoDao paasEcsInfoDao = new PaasEcsInfoDao(conn);
            PaasAppsVariablesService paasAppsVariablesService = (PaasAppsVariablesService)SpringContextUtils.getBean(PaasAppsVariablesService.class);
            PaasAppsPropertiesService paasAppsPropertiesService = (PaasAppsPropertiesService)SpringContextUtils.getBean(PaasAppsPropertiesService.class);
            HashMap<String, Object> root = new HashMap<String, Object>();
            String currEnvId = this.batInst.getEnvId();
            PaasEnvInfoDao paasEnvInfoDao = new PaasEnvInfoDao(conn);
            PaasEnvParamDao paasEnvParamDao = new PaasEnvParamDao(conn);
            PaasEnvInfo envInfo = paasEnvInfoDao.queryByPk(currEnvId);
            root.put("env", BeanUtility.bean2Map((Object)((Object)envInfo)));
            PaasEnvParam loggingFile = paasEnvParamDao.queryByCode("logging_path", currEnvId);
            if (loggingFile == null) {
                loggingFile = new PaasEnvParam();
                loggingFile.setParamCode("logging_path");
                loggingFile.setEnvId(currEnvId);
                loggingFile.setParamValue("/var/tmp/logs/");
            }
            root.put("logging_path", loggingFile.getParamValue());
            PaasAppsParamDao paasAppsParamDao = new PaasAppsParamDao(conn);
            PaasAppsVariablesDTO variablesParam = new PaasAppsVariablesDTO();
            variablesParam.setSubsId(this.appInfo.getSubsId());
            variablesParam.setEnvId(currEnvId);
            List varList = paasAppsVariablesService.queryList((Object)variablesParam);
            if (CollectionUtils.isNotEmpty((Collection)varList)) {
                varList.forEach(var -> root.put(var.getVarCode(), var.getVarRealVal()));
            }
            Map<String, Object> appsParam = paasAppsParamDao.queryAppParamMap(this.appInfo.getAppId(), currEnvId);
            String database_name = TdpAgentCommonUtil.getAppDatabaseName(this.appInfo, appsParam);
            appsParam.put("database_name", database_name);
            root.putAll(appsParam);
            PaasEcsInfo envEcsParam = new PaasEcsInfo();
            envEcsParam.setEnvId(currEnvId);
            envEcsParam.setAppId(this.appInfo.getAppId());
            List<PaasEcsInfo> ecsList = paasEcsInfoDao.queryPaasEcsInfo(envEcsParam);
            if (CollectionUtils.isNotEmpty(ecsList)) {
                for (PaasEcsInfo ecs : ecsList) {
                    Map ecsMap = BeanUtility.bean2Map((Object)((Object)ecs));
                    HashMap ecsParamMap = new HashMap();
                    for (Map.Entry entry : ecsMap.entrySet()) {
                        String key = TmModelUtil.propertyToField((String)((String)entry.getKey())).toUpperCase();
                        ecsParamMap.put(key, entry.getValue());
                    }
                    root.put(ecs.getPaasDuId(), ecsParamMap);
                }
                root.put("client_host_url", String.format("http://%s:%s", ecsList.get(0).getEcsOutIp(), ecsList.get(0).getEcsPort()));
            }
            PluginDeployJavaService pluginDeployJavaService = (PluginDeployJavaService)SpringContextUtils.getBean(PluginDeployJavaService.class);
            PluginDeployJavaDTO pluginDeployParam = new PluginDeployJavaDTO();
            FilterItem deployParamFilter = new FilterItem();
            deployParamFilter.setKey("pluginConfId");
            deployParamFilter.setValues(Arrays.asList(this.batInst.getBatchId()));
            deployParamFilter.setOp(FilterItem.FilterOpEnum.Like.getCode());
            pluginDeployParam.setFilterCond(JSON.toJSONString(Arrays.asList(deployParamFilter)));
            List pluginDeploys = pluginDeployJavaService.queryListByPage((Object)pluginDeployParam);
            if (CollectionUtils.isNotEmpty((Collection)pluginDeploys)) {
                PluginDeployJavaDTO pluginDeploy = (PluginDeployJavaDTO)pluginDeploys.get(0);
                root.put("integer_type", pluginDeploy.getIntegerType());
                root.put("cas_server_url", this.generateValue(pluginDeploy.getCasServerUrl(), root));
                root.put("e4a_logo_url", this.generateValue(pluginDeploy.getLogoUrl(), root));
                if (StringUtils.equals((CharSequence)pluginDeploy.getIntegerType(), (CharSequence)"U") && (StringUtils.indexOf((CharSequence)envInfo.getEnvCasServer(), (CharSequence)"demo.irdstudio") >= 0 || StringUtils.indexOf((CharSequence)envInfo.getEnvCasServer(), (CharSequence)"allincloud.irdstudio") >= 0)) {
                    root.put("client_host_url", envInfo.getEnvCasServer().replace("cas", ""));
                }
            }
            PaasAppsVariablesDTO saasVarParam = new PaasAppsVariablesDTO();
            saasVarParam.setEnvId(envId);
            saasVarParam.setSubsId("S11021");
            List saasVarList = paasAppsVariablesService.queryList((Object)saasVarParam);
            HashMap<String, Object> saasRoot = new HashMap<String, Object>();
            if (CollectionUtils.isNotEmpty((Collection)saasVarList)) {
                saasVarList.forEach(var -> saasRoot.put(var.getVarCode(), var.getVarRealVal()));
            }
            PaasAppsPropertiesDTO appPropParam = new PaasAppsPropertiesDTO();
            appPropParam.setAppId(this.appInfo.getAppId());
            ArrayList propConfigList = paasAppsPropertiesService.queryList((Object)appPropParam);
            if (CollectionUtils.isEmpty((Collection)propConfigList)) {
                propConfigList = new ArrayList();
            }
            ArrayList<Object> propList = new ArrayList<Object>();
            propList.addAll(this.fillE4AProperties());
            propList.addAll(propConfigList);
            HashMap<String, Map<String, PaasAppsPropertiesDTO>> configFileNameMap = new HashMap<String, Map<String, PaasAppsPropertiesDTO>>();
            if (CollectionUtils.isNotEmpty(propList)) {
                for (PaasAppsPropertiesDTO paasAppsPropertiesDTO : propList) {
                    String value;
                    String fileName = paasAppsPropertiesDTO.getFileName();
                    HashMap<String, PaasAppsPropertiesDTO> propMap = (HashMap<String, PaasAppsPropertiesDTO>)configFileNameMap.get(fileName);
                    if (propMap == null) {
                        propMap = new HashMap<String, PaasAppsPropertiesDTO>();
                        configFileNameMap.put(fileName, propMap);
                    }
                    if (propMap.get(paasAppsPropertiesDTO.getPropName()) != null) continue;
                    if (StringUtils.equals((CharSequence)PropSource.Saas.getCode(), (CharSequence)paasAppsPropertiesDTO.getPropSource())) {
                        value = this.generateValue(paasAppsPropertiesDTO.getPropValue(), saasRoot);
                        paasAppsPropertiesDTO.setPropValue(value);
                    } else {
                        value = this.generateValue(paasAppsPropertiesDTO.getPropValue(), root);
                        paasAppsPropertiesDTO.setPropValue(value);
                    }
                    propMap.put(paasAppsPropertiesDTO.getPropName(), paasAppsPropertiesDTO);
                }
            }
            String appCode = SdEnvUtil.wrapperAppCode(this.appInfo.getAppCode());
            String string = this.context.getBatBatchSource().getRepoLocalPath();
            File localBuildFile = new File(string);
            File[] subFiles = localBuildFile.listFiles();
            if (subFiles != null) {
                for (File file : subFiles) {
                    if (file.getName().equals(".git") || file.getName().equals(".svn")) continue;
                    this.dealWithConfigFile(file, configFileNameMap);
                }
            }
            this.logger.info("\u81ea\u5b9a\u4e49\u5e94\u7528\u914d\u7f6e \u66ff\u6362\u5b8c\u6210");
        }
        catch (Exception e) {
            this.logger.error("\u81ea\u5b9a\u4e49\u5e94\u7528\u914d\u7f6e " + e.getMessage(), e);
            flag = false;
        }
        finally {
            if (conn != null) {
                this.closePluginConnection(conn);
            }
        }
        return flag;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void dealWithConfigFile(File file, Map<String, Map<String, PaasAppsPropertiesDTO>> configFileNameMap) {
        block18: {
            File[] subFiles;
            block19: {
                block20: {
                    if (!file.exists()) break block18;
                    if (!file.isFile()) break block19;
                    String fileName = file.getName();
                    if (configFileNameMap.get(fileName) == null) break block20;
                    Map<String, PaasAppsPropertiesDTO> propFileConfigMap = configFileNameMap.get(fileName);
                    FileInputStream configInputStream = null;
                    List<String> configs = null;
                    try {
                        configInputStream = new FileInputStream(file);
                        configs = IOUtils.readLines((InputStream)configInputStream, (String)"UTF-8");
                    }
                    catch (Exception e) {
                        try {
                            this.logger.error(String.format("\u8bfb\u53d6\u914d\u7f6e\u6587\u4ef6%s\u6d41\u5931\u8d25", fileName), e);
                        }
                        catch (Throwable throwable) {
                            IOUtils.closeQuietly(configInputStream);
                            throw throwable;
                        }
                        IOUtils.closeQuietly((InputStream)configInputStream);
                    }
                    IOUtils.closeQuietly((InputStream)configInputStream);
                    if (configs == null) {
                        this.logger.error(String.format("\u8bfb\u53d6%s\u5931\u8d25", fileName));
                        return;
                    }
                    boolean hasYmlFind = false;
                    int count = 0;
                    if (fileName.endsWith(".yml")) {
                        String ymlContent = StringUtils.join((Iterable)configs, (String)"\n");
                        Yaml yaml = new Yaml();
                        Map root = (Map)yaml.loadAs(ymlContent, Map.class);
                        Map<String, String> map = this.convertYamlToProperties(root);
                        for (Map.Entry<String, String> entry : map.entrySet()) {
                            String keyName = entry.getKey();
                            if (propFileConfigMap.get(keyName) == null) continue;
                            PaasAppsPropertiesDTO prop = propFileConfigMap.get(keyName);
                            this.setYmlMapVal(root, keyName, prop.getPropValue());
                            hasYmlFind = true;
                            ++count;
                        }
                        if (hasYmlFind) {
                            String yml = yaml.dumpAs((Object)root, null, DumperOptions.FlowStyle.BLOCK);
                            configs = Arrays.asList(StringUtils.split((String)yml, (String)"\n"));
                        }
                    }
                    if (!hasYmlFind) {
                        block9: for (int i = 0; i < configs.size(); ++i) {
                            String string;
                            String line = (String)configs.get(i);
                            if (fileName.endsWith(".xml")) {
                                for (Map.Entry entry : propFileConfigMap.entrySet()) {
                                    if (!line.contains((CharSequence)entry.getKey())) continue;
                                    Matcher xmlM = this.xmlReg.matcher(line);
                                    if (!xmlM.matches()) continue block9;
                                    String value = xmlM.group(1);
                                    line = line.replace(value, ((PaasAppsPropertiesDTO)entry.getValue()).getPropValue());
                                    configs.set(i, line);
                                    ++count;
                                    continue block9;
                                }
                                continue;
                            }
                            Matcher matcher = this.configReg.matcher(line);
                            if (!matcher.matches() || propFileConfigMap.get(string = matcher.group(1)) == null) continue;
                            PaasAppsPropertiesDTO prop = propFileConfigMap.get(string);
                            String split = StringUtils.equals((CharSequence)prop.getFileType(), (CharSequence)"properties") ? "=" : (StringUtils.equals((CharSequence)prop.getFileType(), (CharSequence)"yml") ? ": " : " ");
                            line = line.substring(0, line.indexOf(string)) + String.format("%s%s%s", string, split, prop.getPropValue());
                            configs.set(i, line);
                            ++count;
                        }
                    }
                    if (count <= 0) break block18;
                    FileOutputStream configOutStream = null;
                    try {
                        FileUtils.forceDelete((File)file);
                        configOutStream = new FileOutputStream(file);
                        IOUtils.writeLines((Collection)configs, (String)System.lineSeparator(), (OutputStream)configOutStream, (String)"UTF-8");
                    }
                    catch (Exception e) {
                        try {
                            this.logger.error(String.format("\u4fee\u6539\u914d\u7f6e\u6587\u4ef6%s\u5199\u5165\u5931\u8d25", fileName), e);
                        }
                        catch (Throwable throwable) {
                            IOUtils.closeQuietly(configOutStream);
                            throw throwable;
                        }
                        IOUtils.closeQuietly((OutputStream)configOutStream);
                        break block18;
                    }
                    IOUtils.closeQuietly((OutputStream)configOutStream);
                    break block18;
                }
                return;
            }
            if (file.isDirectory() && (subFiles = file.listFiles()) != null) {
                for (File subFile : subFiles) {
                    this.dealWithConfigFile(subFile, configFileNameMap);
                }
            }
        }
    }

    public String generateValue(String valueTemplate, Map<String, Object> param) {
        if (StringUtils.isBlank((CharSequence)valueTemplate)) {
            return "";
        }
        try {
            String alDesc = ExpressionUtil.parse(valueTemplate, param);
            return alDesc;
        }
        catch (Exception e) {
            this.logger.error("\u4ea4\u4ed8\u73af\u5883\u53d8\u91cf\u89e3\u6790\u5f02\u5e38:" + e.getMessage());
            return "";
        }
    }

    private Map<String, String> convertYamlToProperties(Map<String, Object> root) {
        HashMap<String, String> prop = new HashMap<String, String>();
        if (root != null && root.size() > 0) {
            for (Map.Entry<String, Object> entry : root.entrySet()) {
                if (entry.getValue() == null) {
                    prop.put(entry.getKey(), null);
                    continue;
                }
                if (entry.getValue() instanceof Map) {
                    this.recursionConvert(prop, entry.getKey(), (Map)entry.getValue());
                    continue;
                }
                if (entry.getValue() instanceof List) {
                    List list = (List)entry.getValue();
                    if (!CollectionUtils.isNotEmpty((Collection)list)) continue;
                    for (int i = 0; i < list.size(); ++i) {
                        String key = String.format("%s[%s]", entry.getKey(), i);
                        Map value = (Map)list.get(i);
                        this.recursionConvert(prop, key, value);
                    }
                    continue;
                }
                prop.put(entry.getKey(), entry.getValue().toString());
            }
        }
        return prop;
    }

    private void recursionConvert(Map<String, String> prop, String parentKey, Map<String, Object> parentValue) {
        if (parentValue != null && parentValue.size() > 0) {
            for (Map.Entry<String, Object> entry : parentValue.entrySet()) {
                if (entry.getValue() == null) {
                    prop.put(parentKey + "." + entry.getKey(), null);
                    continue;
                }
                if (entry.getValue() instanceof Map) {
                    this.recursionConvert(prop, parentKey + "." + entry.getKey(), (Map)entry.getValue());
                    continue;
                }
                if (entry.getValue() instanceof List) {
                    List list = (List)entry.getValue();
                    if (!CollectionUtils.isNotEmpty((Collection)list)) continue;
                    for (int i = 0; i < list.size(); ++i) {
                        String key = String.format("%s[%s]", parentKey + "." + entry.getKey(), i);
                        Object value = list.get(i);
                        if (value == null || !(value instanceof Map)) continue;
                        this.recursionConvert(prop, key, (Map)value);
                    }
                    continue;
                }
                prop.put(parentKey + "." + entry.getKey(), entry.getValue().toString());
            }
        }
    }

    private void setYmlMapVal(Map<String, Object> root, String keyPath, String value) {
        try {
            String[] paths = StringUtils.split((String)keyPath, (String)".");
            if (paths != null && paths.length > 0) {
                Map current = root;
                for (int i = 0; i < paths.length - 1; ++i) {
                    current = MapUtils.getMap(current, (Object)paths[i]);
                }
                if (current != null) {
                    current.put(paths[paths.length - 1], value);
                }
            }
        }
        catch (Exception e) {
            this.logger.error(String.format("\u66f4\u65b0 yml \u914d\u7f6e\u6587\u4ef6 key %s \u5f02\u5e38 %s", keyPath, e.getMessage()), e);
        }
    }

    public List<PaasAppsPropertiesDTO> fillE4AProperties() {
        PaasAppsPropertiesDTO integerType = new PaasAppsPropertiesDTO();
        integerType.setAppId(this.appInfo.getAppId());
        integerType.setFileName("application.properties");
        integerType.setFileType("properties");
        integerType.setPropName("e4a.integer.type");
        integerType.setPropValue("${integer_type}");
        PaasAppsPropertiesDTO casServerUrl = new PaasAppsPropertiesDTO();
        casServerUrl.setAppId(this.appInfo.getAppId());
        casServerUrl.setFileName("application.properties");
        casServerUrl.setFileType("properties");
        casServerUrl.setPropName("cas.server-url-prefix");
        casServerUrl.setPropValue("${cas_server_url}");
        PaasAppsPropertiesDTO casClientHostUrl = new PaasAppsPropertiesDTO();
        casClientHostUrl.setAppId(this.appInfo.getAppId());
        casClientHostUrl.setFileName("application.properties");
        casClientHostUrl.setFileType("properties");
        casClientHostUrl.setPropName("cas.client-host-url");
        casClientHostUrl.setPropValue("${client_host_url}");
        PaasAppsPropertiesDTO logoUrl = new PaasAppsPropertiesDTO();
        logoUrl.setAppId(this.appInfo.getAppId());
        logoUrl.setFileName("application.properties");
        logoUrl.setFileType("properties");
        logoUrl.setPropName("e4a.logo.url");
        logoUrl.setPropValue("${e4a_logo_url}");
        return Arrays.asList(integerType, casServerUrl, casClientHostUrl, logoUrl);
    }
}

