/*
 * Decompiled with CFR 0.152.
 */
package com.irdstudio.allinapaas.executor.application.executor.core.plugin.deploy;

import com.irdstudio.allinapaas.executor.application.executor.core.tinycore.log.ILogger;
import com.irdstudio.sdk.beans.core.util.PropertiesUtil;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Properties;
import org.apache.commons.lang3.StringUtils;
import org.apache.maven.shared.invoker.DefaultInvocationRequest;
import org.apache.maven.shared.invoker.DefaultInvoker;
import org.apache.maven.shared.invoker.InvocationOutputHandler;
import org.apache.maven.shared.invoker.InvocationRequest;
import org.apache.maven.shared.invoker.InvocationResult;
import org.apache.maven.shared.invoker.InvokerLogger;
import org.apache.maven.shared.invoker.MavenInvocationException;
import org.apache.maven.shared.invoker.PrintStreamLogger;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MavenRunner {
    private String command;
    private String location;
    private String mavenHome;
    private String javaHome;
    private String setting;
    private ILogger logger;
    private static final Logger slf4jLogger = LoggerFactory.getLogger(MavenRunner.class);
    private StringBuffer errorSb = new StringBuffer();

    private MavenRunner() {
        this.mavenHome = PropertiesUtil.getPropertyByKey((String)"application", (String)"tdp.maven.path");
        this.setting = PropertiesUtil.getPropertyByKey((String)"application", (String)"tdp.maven.settings.path");
        this.javaHome = PropertiesUtil.getPropertyByKey((String)"application", (String)"tdp.maven.java.home.path");
    }

    public MavenRunner(String command, String location, ILogger logger) {
        this();
        this.command = command;
        this.location = location;
        this.logger = logger;
    }

    public boolean run() {
        String[] commands;
        this.info("\u8c03\u7528Maven\u7f16\u8bd1: " + this.location, new Object[0]);
        String projectPomPath = this.location + File.separator + "pom.xml";
        this.info("pom\u6587\u4ef6\uff1a" + projectPomPath, new Object[0]);
        this.info("maven \u7f16\u8bd1\u547d\u4ee4\uff1a" + this.command, new Object[0]);
        DefaultInvocationRequest request = new DefaultInvocationRequest();
        if (StringUtils.isNotBlank((CharSequence)this.setting)) {
            request.setUserSettingsFile(new File(this.setting));
        }
        request.setPomFile(new File(projectPomPath));
        ArrayList<String> goals = new ArrayList<String>();
        ArrayList profiles = new ArrayList();
        Properties buildProps = new Properties();
        if (StringUtils.isBlank((CharSequence)this.command)) {
            goals.add("clean");
            goals.add("install");
        }
        for (String command : commands = StringUtils.split((String)this.command, (String)" ")) {
            if ("mvn".equals(command)) continue;
            if (StringUtils.startsWith((CharSequence)command, (CharSequence)"-D")) {
                String _command = command.replace("-D", "");
                String[] bps = StringUtils.split((String)_command, (String)"=");
                String key = bps[0];
                String val = bps.length > 1 ? bps[1] : "";
                buildProps.put(key, val);
                continue;
            }
            if (StringUtils.equals((CharSequence)"-U", (CharSequence)command) || StringUtils.equals((CharSequence)"--update-snapshots", (CharSequence)command)) {
                request.setUpdateSnapshots(true);
                continue;
            }
            goals.add(command);
        }
        request.setGoals(goals);
        request.setProperties(buildProps);
        request.setProfiles(profiles);
        if (StringUtils.isNotBlank((CharSequence)this.javaHome)) {
            request.setJavaHome(new File(this.javaHome));
        }
        DefaultInvoker invoker = new DefaultInvoker();
        invoker.setMavenHome(new File(this.mavenHome));
        invoker.setLogger((InvokerLogger)new PrintStreamLogger(System.err, 2){});
        invoker.setOutputHandler(new InvocationOutputHandler(){

            public void consumeLine(String s) throws IOException {
                MavenRunner.this.info(s, new Object[0]);
            }
        });
        boolean flag = true;
        InvocationResult result = null;
        try {
            result = invoker.execute((InvocationRequest)request);
            flag = true;
        }
        catch (MavenInvocationException e) {
            this.logger.error(e.getMessage(), e);
            this.errorSb.append(e.getMessage()).append("\n");
            flag = false;
        }
        if (flag) {
            if (result.getExitCode() == 0) {
                this.info("maven plugin build success", new Object[0]);
                flag = true;
            } else {
                this.error("maven plugin build error", new Object[0]);
                this.errorSb.append("Maven\u7f16\u8bd1\u5931\u8d25").append("\n");
                flag = false;
            }
        }
        invoker = null;
        return flag;
    }

    public String getMavenHome() {
        return this.mavenHome;
    }

    public void setMavenHome(String mavenHome) {
        this.mavenHome = mavenHome;
    }

    public String getJavaHome() {
        return this.javaHome;
    }

    public void setJavaHome(String javaHome) {
        this.javaHome = javaHome;
    }

    public String getSetting() {
        return this.setting;
    }

    public void setSetting(String setting) {
        this.setting = setting;
    }

    public String getCommand() {
        return this.command;
    }

    public void setCommand(String command) {
        this.command = command;
    }

    public String getLocation() {
        return this.location;
    }

    public void setLocation(String location) {
        this.location = location;
    }

    public String getErrorMeg() {
        return this.errorSb.toString();
    }

    public void info(String format, Object ... argArray) {
        if (this.logger == null) {
            slf4jLogger.info(format, argArray);
        } else {
            this.logger.info(String.format(format, argArray));
        }
    }

    public void error(String format, Object ... argArray) {
        if (this.logger == null) {
            slf4jLogger.error(format, argArray);
        } else if (argArray.length > 0) {
            Object throwable = argArray[argArray.length - 1];
            if (throwable instanceof Throwable) {
                this.logger.error(String.format(format, argArray), (Throwable)throwable);
            } else {
                this.logger.error(String.format(format, argArray));
            }
        } else {
            this.logger.error(format);
        }
    }
}

