/*
 * Decompiled with CFR 0.152.
 */
package com.irdstudio.allinapaas.executor.application.executor.core.plugin.deploy;

import com.irdstudio.allinapaas.deliver.console.facade.PluginMavenConfService;
import com.irdstudio.allinapaas.deliver.console.facade.dto.PluginMavenConfDTO;
import com.irdstudio.allinapaas.executor.application.executor.core.dao.PaasAppsInfoDao;
import com.irdstudio.allinapaas.executor.application.executor.core.dao.PaasAppsParamDao;
import com.irdstudio.allinapaas.executor.application.executor.core.dao.domain.PaasAppsInfo;
import com.irdstudio.allinapaas.executor.application.executor.core.dao.domain.PaasAppsParam;
import com.irdstudio.allinapaas.executor.application.executor.core.plugin.AbstractPlugin;
import com.irdstudio.allinapaas.executor.application.executor.core.plugin.deploy.MavenRunner;
import com.irdstudio.allinapaas.executor.application.executor.core.plugin.devops.maven.MavenConf;
import com.irdstudio.allinapaas.executor.facade.dto.ValidateRtnDTO;
import com.irdstudio.sdk.beans.core.util.PropertiesUtil;
import com.irdstudio.sdk.beans.core.util.SpringContextUtils;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.Collection;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;

public class ProdMavenPlugin
extends AbstractPlugin {
    protected String pluginName = null;
    protected MavenConf mavenConf = null;
    protected PaasAppsInfo appInfo = null;
    protected String taskName = null;

    @Override
    public boolean validate(String batchId, String taskId, ValidateRtnDTO message) {
        PluginMavenConfService service = (PluginMavenConfService)SpringContextUtils.getBean(PluginMavenConfService.class);
        PluginMavenConfDTO param = new PluginMavenConfDTO();
        param.setPluginConfId(taskId);
        param = (PluginMavenConfDTO)service.queryByPk((Object)param);
        if (param == null) {
            return false;
        }
        message.getMessage().addAll(param.validate());
        return CollectionUtils.isEmpty((Collection)message.getMessage());
    }

    @Override
    public boolean copyConfig(String batchId, String taskId, String newTaskId) {
        PluginMavenConfService service = (PluginMavenConfService)SpringContextUtils.getBean(PluginMavenConfService.class);
        PluginMavenConfDTO param = new PluginMavenConfDTO();
        param.setPluginConfId(taskId);
        param = (PluginMavenConfDTO)service.queryByPk((Object)param);
        if (param == null) {
            return true;
        }
        param.setPluginConfId(newTaskId);
        int re = service.insert((Object)param);
        return re == 1;
    }

    @Override
    protected boolean doReadConfigureFromDB(Connection conn, String szConfIdentify) throws SQLException {
        this.pluginName = this.context.getSzPluginName();
        String batchSerialNo = this.context.getSzBatchSn();
        PaasAppsInfoDao paasAppsInfoDao = new PaasAppsInfoDao(conn);
        this.appInfo = paasAppsInfoDao.queryByBatchSerialNo(batchSerialNo);
        this.mavenConf = new MavenConf();
        PaasAppsParamDao paasAppsParamDao = new PaasAppsParamDao(conn);
        PaasAppsParam paasAppsParam = new PaasAppsParam();
        paasAppsParam.setAppId(this.appInfo.getAppId());
        paasAppsParam.setParamGroup("CPL");
        paasAppsParam.setParamCode("maven_compiler");
        List<PaasAppsParam> paasAppsParamList = paasAppsParamDao.queryPaasAppsParamList(paasAppsParam);
        if (CollectionUtils.isNotEmpty(paasAppsParamList)) {
            this.mavenConf.setMavenParam(paasAppsParamList.get(0).getParamValue());
        } else {
            this.mavenConf.setMavenParam("mvn clean package -DskipTests=true");
        }
        this.mavenConf.setMavenSettings(PropertiesUtil.getPropertyByKey((String)"application", (String)"tdp.maven.settings.path"));
        this.mavenConf.setMavenHome(PropertiesUtil.getPropertyByKey((String)"application", (String)"tdp.maven.path"));
        this.mavenConf.setLocalPath(this.context.getBatBatchSource().getRepoLocalPath());
        PluginMavenConfService service = (PluginMavenConfService)SpringContextUtils.getBean(PluginMavenConfService.class);
        PluginMavenConfDTO param = new PluginMavenConfDTO();
        param.setPluginConfId(this.context.getSzTaskId());
        param = (PluginMavenConfDTO)service.queryByPk((Object)param);
        if (param != null) {
            this.mavenConf.setMavenParam(param.getMavenCompiler());
            if (StringUtils.isNotBlank((CharSequence)param.getMavenSettings())) {
                this.mavenConf.setMavenSettings(param.getMavenSettings());
            }
        }
        if (this.mavenConf.getMavenHome() == null || this.mavenConf.getLocalPath() == null || this.mavenConf.getMavenSettings() == null) {
            this.context.setSzLastErrorMsg("\u672a\u8bfb\u53d6\u5230\u914d\u7f6e\u6807\u8bc6\u4e3a\uff1a" + szConfIdentify + "\u7684\u6570\u636eMySQL\u914d\u7f6e!");
            return false;
        }
        return true;
    }

    @Override
    public boolean execute() {
        this.logger.info(String.format("\u7f16\u8bd1\u5e94\u7528 %s %s", this.appInfo.getAppCode(), this.appInfo.getAppName()));
        MavenRunner mavenRunner = new MavenRunner(this.mavenConf.getMavenParam(), this.mavenConf.getLocalPath(), this.logger);
        mavenRunner.setMavenHome(this.mavenConf.getMavenHome());
        mavenRunner.setJavaHome(PropertiesUtil.getPropertyByKey((String)"application", (String)"tdp.maven.java.home.path"));
        mavenRunner.setSetting(this.mavenConf.getMavenSettings());
        return mavenRunner.run();
    }
}

