/*
 * Decompiled with CFR 0.152.
 */
package com.irdstudio.allinapaas.executor.application.executor.core.plugin.docs.gendoc;

import com.irdstudio.allinapaas.executor.application.executor.core.dao.PaasDocDirectoryDao;
import com.irdstudio.allinapaas.executor.application.executor.core.dao.domain.PaasDocDirectory;
import com.irdstudio.allinapaas.executor.application.executor.core.dao.domain.PaasDocTemplate;
import com.irdstudio.allinapaas.executor.application.executor.core.dao.domain.WikiSubsPage;
import com.irdstudio.allinapaas.executor.application.executor.core.tinycore.jdbc.dbcp.base.IConnPool;
import com.irdstudio.allinapaas.executor.application.executor.core.util.parse.ExpressionUtil;
import com.irdstudio.allinapaas.executor.feign.facade.FspApiService;
import com.irdstudio.allinapaas.manager.console.facade.PaasDocDirectoryService;
import com.irdstudio.allinapaas.manager.console.facade.dto.PaasDocDirectoryDTO;
import com.irdstudio.allinrdm.wiki.console.facade.WikiService;
import com.irdstudio.allinrdm.wiki.console.facade.dto.WikiSubsDirectoryDTO;
import com.irdstudio.allinrdm.wiki.console.facade.dto.WikiSubsPageDTO;
import com.irdstudio.sdk.beans.core.util.BeanUtility;
import com.irdstudio.sdk.beans.core.util.SpringContextUtils;
import com.irdstudio.sdk.beans.core.vo.ResponseData;
import java.io.File;
import java.io.IOException;
import java.sql.Connection;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public interface DocGenerate {
    public static final Logger logger = LoggerFactory.getLogger(DocGenerate.class);

    public List<File> generateDoc(PaasDocTemplate var1, String var2, File var3, IConnPool var4, @Nullable Map<String, Object> var5);

    public File generateAppDoc(PaasDocTemplate var1, String var2, File var3, IConnPool var4, Map<String, Object> var5);

    default public File generateGroupDoc(PaasDocTemplate template, String subsId, String groupName, File baseDir, IConnPool connTool, Map<String, Object> extParams) {
        return null;
    }

    default public String renderDocName(String template, Map<String, Object> context) {
        return ExpressionUtil.parse(template, context);
    }

    default public File getDocDirPathAndMkdirs(PaasDocTemplate template, File baseDir, Connection conn) {
        File docDirPath = this.getDocDirPath(template, baseDir, conn);
        if (!docDirPath.exists()) {
            try {
                FileUtils.forceMkdir((File)docDirPath);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
        return docDirPath;
    }

    default public File getDocDirPath(PaasDocTemplate template, File baseDir, Connection conn) {
        File result = null;
        try {
            PaasDocDirectoryDao paasDocDirectoryDao = new PaasDocDirectoryDao(conn);
            ArrayList<String> paths = new ArrayList<String>();
            PaasDocDirectory dir = paasDocDirectoryDao.queryByPk(template.getDirId());
            if (StringUtils.isBlank((CharSequence)template.getDirId()) || dir == null) {
                return baseDir;
            }
            paths.add(dir.getDirName());
            while (dir != null) {
                if ((dir = paasDocDirectoryDao.queryByPk(dir.getDirAbvId())) == null) continue;
                paths.add(dir.getDirName());
            }
            Object[] pathA = paths.toArray(new String[0]);
            CollectionUtils.reverseArray((Object[])pathA);
            String path = StringUtils.join((Object[])pathA, (String)File.separator);
            return new File(baseDir, path);
        }
        catch (Exception e) {
            logger.error(e.getMessage(), (Throwable)e);
            return result;
        }
    }

    default public String getDocDirPath(PaasDocTemplate template) {
        String result = null;
        try {
            PaasDocDirectoryService paasDocDirectoryService = (PaasDocDirectoryService)SpringContextUtils.getBean(PaasDocDirectoryService.class);
            ArrayList<String> paths = new ArrayList<String>();
            PaasDocDirectoryDTO dir = new PaasDocDirectoryDTO();
            dir.setDirId(template.getDirId());
            dir = (PaasDocDirectoryDTO)paasDocDirectoryService.queryByPk((Object)dir);
            paths.add(dir.getDirName());
            PaasDocDirectoryDTO abvParam = new PaasDocDirectoryDTO();
            while (dir != null) {
                abvParam.setDirId(dir.getDirAbvId());
                dir = (PaasDocDirectoryDTO)paasDocDirectoryService.queryByPk((Object)abvParam);
                if (dir == null) continue;
                paths.add(dir.getDirName());
            }
            Object[] pathA = paths.toArray(new String[0]);
            CollectionUtils.reverseArray((Object[])pathA);
            String path = StringUtils.join((Object[])pathA, (String)File.separator);
            return path;
        }
        catch (Exception e) {
            logger.error(e.getMessage(), (Throwable)e);
            return result;
        }
    }

    default public boolean saveToWikiConsole(String subsId, PaasDocTemplate template, File file, WikiSubsPage page, Connection conn) {
        WikiService wikiService = (WikiService)SpringContextUtils.getBean(WikiService.class);
        String dirId = this.queryDesignDir(subsId, template, conn);
        page.setDirId(dirId);
        try {
            WikiSubsPageDTO pageVo = new WikiSubsPageDTO();
            BeanUtility.beanCopy((Object)((Object)page), (Object)pageVo);
            pageVo.setWikiId(subsId);
            FspApiService fspApiService = (FspApiService)SpringContextUtils.getBean(FspApiService.class);
            String fileId = fspApiService.upload("FSP00008", "allinrdm", null, subsId, page.getAppId(), null, subsId, page.getLoginUserId(), file);
            pageVo.setDocId(fileId);
            ResponseData saveResp = wikiService.saveSubPage(pageVo);
            logger.info("\u4fdd\u5b58\u6587\u6863\u5230wiki " + page.toString());
            boolean success = saveResp.isSuccess();
            return success;
        }
        catch (Exception e) {
            logger.error(e.getMessage(), (Throwable)e);
            return true;
        }
    }

    default public String queryDesignDir(String subsId, PaasDocTemplate template, Connection conn) {
        WikiService wikiService = (WikiService)SpringContextUtils.getBean(WikiService.class);
        try {
            PaasDocDirectoryDao paasDocDirectoryDao = new PaasDocDirectoryDao(conn);
            PaasDocDirectory paasDocDir = paasDocDirectoryDao.queryByPk(template.getDirId());
            PaasDocDirectory parent = paasDocDirectoryDao.queryByPk(paasDocDir.getDirAbvId());
            WikiSubsDirectoryDTO param = new WikiSubsDirectoryDTO();
            param.setWikiId(subsId);
            ResponseData dirResp = wikiService.queryWikiSubsDirectoryAndCheck(param);
            List rows = (List)dirResp.getRows();
            String targetDir = null;
            if (rows != null) {
                for (WikiSubsDirectoryDTO dir : rows) {
                    String dirName = dir.getDirName();
                    String dirId = dir.getDirId();
                    String dirPid = dir.getDirPid();
                    String dirPName = dir.getDirPName();
                    if (!StringUtils.equals((CharSequence)dirName, (CharSequence)paasDocDir.getDirName())) continue;
                    if (parent != null) {
                        if (!StringUtils.equals((CharSequence)parent.getDirName(), (CharSequence)dirPName)) continue;
                        targetDir = dirId;
                        break;
                    }
                    targetDir = dirId;
                    break;
                }
            }
            return targetDir;
        }
        catch (Exception e) {
            logger.error(e.getMessage(), (Throwable)e);
            return null;
        }
    }
}

