/*
 * Decompiled with CFR 0.152.
 */
package com.irdstudio.allinapaas.executor.application.executor.core.plugin.docs.gendoc;

import com.alibaba.excel.EasyExcel;
import com.alibaba.excel.ExcelWriter;
import com.alibaba.excel.write.metadata.WriteSheet;
import com.irdstudio.allinapaas.executor.application.executor.core.dao.BatInstBatchDao;
import com.irdstudio.allinapaas.executor.application.executor.core.dao.PaasAppsInfoDao;
import com.irdstudio.allinapaas.executor.application.executor.core.dao.domain.PaasDocTemplate;
import com.irdstudio.allinapaas.executor.application.executor.core.plugin.common.SSubsInfo;
import com.irdstudio.allinapaas.executor.application.executor.core.plugin.common.SSubsInfoDao;
import com.irdstudio.allinapaas.executor.application.executor.core.plugin.docs.gendoc.DocGenerate;
import com.irdstudio.allinapaas.executor.application.executor.core.plugin.docs.git.queue.DocTemplateRepoPullQueueExecutor;
import com.irdstudio.allinapaas.executor.application.executor.core.tinycore.jdbc.dbcp.base.IConnPool;
import com.irdstudio.allinapaas.executor.application.executor.core.util.date.CurrentDateUtil;
import com.irdstudio.allintpaas.sdk.bi.facade.operation.RdmModuleInfoService;
import com.irdstudio.allintpaas.sdk.bi.facade.operation.dto.RdmModuleInfoDTO;
import com.irdstudio.allintpaas.sdk.types.ModuleLevelEnum;
import com.irdstudio.sdk.beans.core.util.BeanUtility;
import com.irdstudio.sdk.beans.core.util.SpringContextUtils;
import java.io.File;
import java.sql.Connection;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.MapUtils;
import org.apache.commons.lang3.StringUtils;

public class GenRdmModuleExcel
implements DocGenerate {
    @Override
    public List<File> generateDoc(PaasDocTemplate template, String subsId, File baseDir, IConnPool connTool, Map<String, Object> extParams) {
        Connection conn = null;
        try {
            conn = connTool.getConnection();
            File currentFile = this.getDocDirPath(template, baseDir, conn);
            if (!currentFile.exists()) {
                currentFile.mkdirs();
            }
            BatInstBatchDao batInstBatchDao = new BatInstBatchDao(conn);
            PaasAppsInfoDao paasAppsInfoDao = new PaasAppsInfoDao(conn);
            SSubsInfoDao sSubsInfoDao = new SSubsInfoDao(conn);
            SSubsInfo subsInfo = sSubsInfoDao.querySSubsInfoWithKeys(subsId);
            if (subsInfo == null) {
                subsInfo = new SSubsInfo();
            }
            String subsCode = subsInfo.getSubsCode();
            String subsName = subsInfo.getSubsName();
            String userId = template.getLoginUserId();
            String projectId = MapUtils.getString(extParams, (Object)"projectId");
            String projectName = MapUtils.getString(extParams, (Object)"projectName");
            if (StringUtils.isNotBlank((CharSequence)projectId)) {
                subsInfo.setSubsId(projectId);
                subsInfo.setSubsName(projectName);
            }
            String today = CurrentDateUtil.getTodayDate();
            String todayTime = CurrentDateUtil.getTodayDateEx2();
            Map subsInfoMap = BeanUtility.bean2Map((Object)((Object)subsInfo));
            subsInfoMap.put("today", today);
            subsInfoMap.put("todayTime", todayTime);
            String fileName = template.getDocName();
            if (StringUtils.isNotBlank((CharSequence)template.getDocNameTemplate())) {
                fileName = this.renderDocName(template.getDocNameTemplate(), subsInfoMap);
            }
            DocTemplateRepoPullQueueExecutor.syncRun();
            String excelTemplatePath = DocTemplateRepoPullQueueExecutor.getDocTemplatePath();
            File templateFile = new File(excelTemplatePath, template.getDocFile());
            File targetFile = new File(currentFile, fileName);
            ExcelWriter excelWriter = EasyExcel.write((File)targetFile).withTemplate(templateFile).build();
            WriteSheet sheet = EasyExcel.writerSheet((Integer)0, null).build();
            this.fillModuleList(excelWriter, sheet, subsId, projectId);
            excelWriter.finish();
            List<File> list = Arrays.asList(targetFile);
            return list;
        }
        catch (Exception e) {
            logger.error("\u6a21\u5757\u5bfc\u51fa\u5f02\u5e38 " + e.getMessage(), (Throwable)e);
            throw new RuntimeException("\u6a21\u5757\u5bfc\u51fa\u5f02\u5e38 " + e.getMessage(), e);
        }
        finally {
            connTool.releaseConnection(conn);
        }
    }

    public void fillModuleList(ExcelWriter excelWriter, WriteSheet sheet, String subsId, String projectId) {
        RdmModuleInfoService rdmModuleInfoService = (RdmModuleInfoService)SpringContextUtils.getBean(RdmModuleInfoService.class);
        RdmModuleInfoDTO param = new RdmModuleInfoDTO();
        param.setSubsId(subsId);
        param.setProjectId(projectId);
        List<RdmModuleInfoDTO> rows = rdmModuleInfoService.queryList((Object)param);
        if (CollectionUtils.isEmpty((Collection)rows)) {
            rows = Collections.emptyList();
        } else {
            for (RdmModuleInfoDTO m : rows) {
                m.setModuleLevel(ModuleLevelEnum.nameByCode((String)m.getModuleLevel()));
            }
        }
        excelWriter.fill(rows, sheet);
    }

    @Override
    public File generateAppDoc(PaasDocTemplate template, String appId, File baseDir, IConnPool connTool, Map<String, Object> extParams) {
        Connection conn = null;
        try {
            File file = null;
            return file;
        }
        catch (Exception e) {
            logger.error("\u6a21\u5757\u5bfc\u51fa\u5f02\u5e38 " + e.getMessage(), (Throwable)e);
            throw new RuntimeException("\u6a21\u5757\u5bfc\u51fa\u5f02\u5e38 " + e.getMessage(), e);
        }
        finally {
            connTool.releaseConnection(conn);
        }
    }
}

