/*
 * Decompiled with CFR 0.152.
 */
package com.irdstudio.allinapaas.executor.application.executor.core.plugin.docs.gendoc;

import com.alibaba.excel.EasyExcel;
import com.alibaba.excel.ExcelWriter;
import com.alibaba.excel.write.metadata.WriteSheet;
import com.irdstudio.allinapaas.executor.application.executor.core.dao.BatInstBatchDao;
import com.irdstudio.allinapaas.executor.application.executor.core.dao.PaasAppsInfoDao;
import com.irdstudio.allinapaas.executor.application.executor.core.dao.domain.PaasAppsInfo;
import com.irdstudio.allinapaas.executor.application.executor.core.dao.domain.PaasDocTemplate;
import com.irdstudio.allinapaas.executor.application.executor.core.plugin.common.SSubsInfo;
import com.irdstudio.allinapaas.executor.application.executor.core.plugin.common.SSubsInfoDao;
import com.irdstudio.allinapaas.executor.application.executor.core.plugin.docs.gendoc.DocGenerate;
import com.irdstudio.allinapaas.executor.application.executor.core.plugin.docs.git.queue.DocTemplateRepoPullQueueExecutor;
import com.irdstudio.allinapaas.executor.application.executor.core.tinycore.jdbc.dbcp.base.IConnPool;
import com.irdstudio.allinapaas.executor.application.executor.core.util.date.CurrentDateUtil;
import com.irdstudio.allinrdm.sam.console.facade.RdmMenuInfoService;
import com.irdstudio.allinrdm.sam.console.facade.dto.RdmMenuInfoDTO;
import com.irdstudio.sdk.beans.core.util.BeanUtility;
import com.irdstudio.sdk.beans.core.util.SpringContextUtils;
import java.io.File;
import java.sql.Connection;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.MapUtils;
import org.apache.commons.lang3.StringUtils;

public class GenSamFnMenuExcel
implements DocGenerate {
    @Override
    public List<File> generateDoc(PaasDocTemplate template, String subsId, File baseDir, IConnPool connTool, Map<String, Object> extParams) {
        Connection conn = null;
        try {
            conn = connTool.getConnection();
            File currentFile = this.getDocDirPath(template, baseDir, conn);
            if (!currentFile.exists()) {
                currentFile.mkdirs();
            }
            BatInstBatchDao batInstBatchDao = new BatInstBatchDao(conn);
            PaasAppsInfoDao paasAppsInfoDao = new PaasAppsInfoDao(conn);
            SSubsInfoDao sSubsInfoDao = new SSubsInfoDao(conn);
            SSubsInfo subsInfo = new SSubsInfo();
            subsInfo = sSubsInfoDao.querySSubsInfoWithKeys(subsId);
            String subsCode = subsInfo.getSubsCode();
            String subsName = subsInfo.getSubsName();
            String userId = template.getLoginUserId();
            String appId = MapUtils.getString(extParams, (Object)"appId");
            String comId = MapUtils.getString(extParams, (Object)"comId");
            String today = CurrentDateUtil.getTodayDate();
            String todayTime = CurrentDateUtil.getTodayDateEx2();
            Map subsInfoMap = BeanUtility.bean2Map((Object)((Object)subsInfo));
            subsInfoMap.put("today", today);
            subsInfoMap.put("todayTime", todayTime);
            String fileName = template.getDocName();
            if (StringUtils.isNotBlank((CharSequence)template.getDocNameTemplate())) {
                fileName = this.renderDocName(template.getDocNameTemplate(), subsInfoMap);
            }
            DocTemplateRepoPullQueueExecutor.syncRun();
            String excelTemplatePath = DocTemplateRepoPullQueueExecutor.getDocTemplatePath();
            File templateFile = new File(excelTemplatePath, template.getDocFile());
            File targetFile = new File(currentFile, fileName);
            ExcelWriter excelWriter = EasyExcel.write((File)targetFile).withTemplate(templateFile).build();
            WriteSheet sheet = EasyExcel.writerSheet((Integer)0, null).build();
            this.fillSdmFnMenuList(excelWriter, sheet, subsId, appId, comId);
            excelWriter.finish();
            List<File> list = Arrays.asList(targetFile);
            return list;
        }
        catch (Exception e) {
            logger.error("\u524d\u7aef\u5e94\u7528\u83dc\u5355\u5bfc\u51fa\u5f02\u5e38 " + e.getMessage(), (Throwable)e);
            throw new RuntimeException("\u524d\u7aef\u5e94\u7528\u83dc\u5355\u5bfc\u51fa\u5f02\u5e38 " + e.getMessage(), e);
        }
        finally {
            connTool.releaseConnection(conn);
        }
    }

    public void fillSdmFnMenuList(ExcelWriter excelWriter, WriteSheet sheet, String subsId, String appId, String comId) {
        RdmMenuInfoService rdmMenuInfoService = (RdmMenuInfoService)SpringContextUtils.getBean(RdmMenuInfoService.class);
        RdmMenuInfoDTO param = new RdmMenuInfoDTO();
        param.setSubsId(subsId);
        param.setAppId(appId);
        param.setComId(comId);
        List rows = rdmMenuInfoService.queryList((Object)param);
        if (CollectionUtils.isEmpty((Collection)rows)) {
            rows = Collections.emptyList();
        }
        excelWriter.fill(rows, sheet);
    }

    @Override
    public File generateAppDoc(PaasDocTemplate template, String appId, File baseDir, IConnPool connTool, Map<String, Object> extParams) {
        Connection conn = null;
        try {
            String moduleCode = "allinpaas-rdm";
            conn = connTool.getConnection();
            File currentFile = this.getDocDirPath(template, baseDir, conn);
            if (!currentFile.exists()) {
                currentFile.mkdirs();
            }
            BatInstBatchDao batInstBatchDao = new BatInstBatchDao(conn);
            PaasAppsInfoDao paasAppsInfoDao = new PaasAppsInfoDao(conn);
            SSubsInfoDao sSubsInfoDao = new SSubsInfoDao(conn);
            PaasAppsInfo appInfo = paasAppsInfoDao.queryByAppId(appId);
            SSubsInfo subsInfo = new SSubsInfo();
            if (appInfo != null) {
                subsInfo = sSubsInfoDao.querySSubsInfoWithKeys(appInfo.getSubsId());
            } else {
                appInfo = new PaasAppsInfo();
            }
            String subsId = subsInfo.getSubsId();
            String subsCode = subsInfo.getSubsCode();
            String subsName = subsInfo.getSubsName();
            String userId = template.getLoginUserId();
            String comId = MapUtils.getString(extParams, (Object)"comId");
            String today = CurrentDateUtil.getTodayDate();
            String todayTime = CurrentDateUtil.getTodayDateEx2();
            Map subsInfoMap = BeanUtility.bean2Map((Object)((Object)subsInfo));
            Map appInfoMap = BeanUtility.bean2Map((Object)((Object)appInfo));
            appInfoMap.put("today", today);
            appInfoMap.put("todayTime", todayTime);
            appInfoMap.putAll(subsInfoMap);
            String fileName = template.getDocName();
            if (StringUtils.isNotBlank((CharSequence)template.getDocNameTemplate())) {
                fileName = this.renderDocName(template.getDocNameTemplate(), appInfoMap);
            }
            DocTemplateRepoPullQueueExecutor.syncRun();
            String excelTemplatePath = DocTemplateRepoPullQueueExecutor.getDocTemplatePath();
            File templateFile = new File(excelTemplatePath, template.getDocFile());
            File targetFile = new File(currentFile, fileName);
            ExcelWriter excelWriter = EasyExcel.write((File)targetFile).withTemplate(templateFile).build();
            WriteSheet sheet = EasyExcel.writerSheet((Integer)0, null).build();
            this.fillSdmFnMenuList(excelWriter, sheet, appInfo.getSubsId(), appId, comId);
            excelWriter.finish();
            File file = targetFile;
            return file;
        }
        catch (Exception e) {
            logger.error("\u524d\u7aef\u5e94\u7528\u83dc\u5355\u5bfc\u51fa\u5f02\u5e38 " + e.getMessage(), (Throwable)e);
            throw new RuntimeException("\u524d\u7aef\u5e94\u7528\u83dc\u5355\u5bfc\u51fa\u5f02\u5e38 " + e.getMessage(), e);
        }
        finally {
            connTool.releaseConnection(conn);
        }
    }
}

