/*
 * Decompiled with CFR 0.152.
 */
package com.irdstudio.allinapaas.executor.application.executor.core.plugin.docs.git.queue;

import com.alibaba.fastjson.JSON;
import com.irdstudio.allinapaas.deliver.console.facade.PaasEnvParamService;
import com.irdstudio.allinapaas.deliver.console.facade.dto.PaasEnvParamDTO;
import com.irdstudio.allinapaas.executor.application.executor.core.dao.PaasEnvParamDao;
import com.irdstudio.allinapaas.executor.application.executor.core.dao.SUserDao;
import com.irdstudio.allinapaas.executor.application.executor.core.dao.SUserProfileDao;
import com.irdstudio.allinapaas.executor.application.executor.core.dao.domain.SUser;
import com.irdstudio.allinapaas.executor.application.executor.core.dao.domain.SUserProfile;
import com.irdstudio.allinapaas.executor.application.executor.core.plugin.apps.SdEnvUtil;
import com.irdstudio.allinapaas.executor.application.executor.core.plugin.common.SSubsInfo;
import com.irdstudio.allinapaas.executor.application.executor.core.plugin.common.SSubsInfoDao;
import com.irdstudio.allinapaas.executor.application.executor.core.plugin.docs.git.queue.WikiRepoPushTask;
import com.irdstudio.allinapaas.executor.application.executor.core.plugin.git.JGitUtil;
import com.irdstudio.allinapaas.executor.application.executor.core.plugin.git.PluginGitConf;
import com.irdstudio.allinapaas.executor.application.executor.core.plugin.git.TerminalExecUtil;
import com.irdstudio.allintpaas.admin.facade.GiteeService;
import com.irdstudio.allintpaas.admin.facade.dto.GiteeRequestVO;
import com.irdstudio.allintpaas.admin.facade.dto.GiteeResponseVO;
import com.irdstudio.sdk.beans.core.util.SpringContextUtils;
import java.io.File;
import java.sql.Connection;
import java.util.Collection;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang3.StringUtils;
import org.gitlab4j.api.GitLabApi;
import org.gitlab4j.api.GitLabApiException;
import org.gitlab4j.api.GroupApi;
import org.gitlab4j.api.ProjectApi;
import org.gitlab4j.api.models.AccessLevel;
import org.gitlab4j.api.models.Group;
import org.gitlab4j.api.models.GroupParams;
import org.gitlab4j.api.models.Member;
import org.gitlab4j.api.models.Project;
import org.gitlab4j.api.models.User;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WikiRepoPushTaskImpl
implements WikiRepoPushTask {
    private static Logger logger = LoggerFactory.getLogger(WikiRepoPushTaskImpl.class);
    private String sysCode = null;
    private String loginUserId = null;
    private File file = null;
    private String repoPath = null;
    private String commitComment = null;

    public WikiRepoPushTaskImpl(String sysCode, String loginUserId, File file, String repoPath, String commitComment) {
        this.sysCode = sysCode;
        this.loginUserId = loginUserId;
        this.file = file;
        this.repoPath = repoPath;
        this.commitComment = commitComment;
    }

    @Override
    public void execute() {
        Connection conn = null;
        try {
            PaasEnvParamService paasEnvParamService = (PaasEnvParamService)SpringContextUtils.getBean(PaasEnvParamService.class);
            PluginGitConf pluginParam = new PluginGitConf();
            pluginParam.setGitUserName(paasEnvParamService.queryEnvParamByCodeReturnValue("git.username").getParamValue());
            pluginParam.setGitPassword(paasEnvParamService.queryEnvParamByCodeReturnValue("git.password").getParamValue());
            pluginParam.setGitBranchName(paasEnvParamService.queryEnvParamByCodeReturnValue("git.push.branch.name").getParamValue());
            String pushUrl = paasEnvParamService.queryEnvParamByCodeReturnValue("git.push.remote.path").getParamValue();
            if (!pushUrl.endsWith("/")) {
                pushUrl = pushUrl + "/";
            }
            pluginParam.setGitRemotePath(String.format("%s%s.git", pushUrl, SdEnvUtil.wrapperAppCode(this.sysCode)));
            String repoName = this.sysCode;
            String access_token = paasEnvParamService.queryEnvParamByCodeReturnValue("git.open.api.access_token").getParamValue();
            if (pluginParam == null) {
                throw new RuntimeException("\u672a\u8bfb\u53d6\u5230Git\u914d\u7f6e!");
            }
            SSubsInfoDao sSubsInfoDao = new SSubsInfoDao(conn);
            SSubsInfo sysInfo = sSubsInfoDao.querySSubsInfoWithKeys(this.sysCode);
            PaasEnvParamDTO envParam = new PaasEnvParamDTO();
            envParam.setEnvId("paas");
            envParam.setParamGroup("git.user");
            List gitParamList = paasEnvParamService.queryList((Object)envParam);
            boolean checkResult = false;
            if (CollectionUtils.isNotEmpty((Collection)gitParamList)) {
                String gitType = this.getEnvParamByCode("git.type", gitParamList);
                String gitHostUrl = this.getEnvParamByCode("git.host.url", gitParamList);
                String accessToken = this.getEnvParamByCode("git.open.api.access_token", gitParamList);
                if (gitHostUrl.endsWith("/")) {
                    gitHostUrl = gitHostUrl.substring(0, gitHostUrl.length() - 1);
                }
                String subsGitGroup = String.format("%s/%s", gitHostUrl, sysInfo.getSubsCode());
                logger.info(String.format("\u5f53\u524d\u4ed3\u5e93\u5bf9\u63a5\u662f %s", gitType));
                if (StringUtils.equals((CharSequence)"gitee", (CharSequence)gitType)) {
                    checkResult = this.giteeHandler(sysInfo.getSubsCode(), this.loginUserId, gitHostUrl, accessToken, sysInfo.getSubsName() + "wiki", conn);
                } else if (StringUtils.equals((CharSequence)"gitlab", (CharSequence)gitType)) {
                    checkResult = this.gitlabHandler(sysInfo.getSubsCode(), this.loginUserId, gitHostUrl, accessToken, sysInfo.getSubsName() + "wiki", conn);
                }
            }
            if (!checkResult) {
                throw new RuntimeException(this.sysCode + " wiki\u6587\u6863\u4ed3\u5e93\u68c0\u67e5\u521b\u5efa\u7ed3\u679c\u5931\u8d25");
            }
            this.commit(conn);
        }
        catch (Exception e) {
            logger.error("\u6267\u884c\u63a8\u9001\u5931\u8d25" + e.getMessage(), (Throwable)e);
            throw new RuntimeException("\u6267\u884c\u63a8\u9001\u5931\u8d25" + e.getMessage(), e);
        }
    }

    private String getEnvParamByCode(String paramCode, List<PaasEnvParamDTO> paramList) {
        if (CollectionUtils.isNotEmpty(paramList)) {
            for (PaasEnvParamDTO param : paramList) {
                if (!param.getParamCode().equals(paramCode)) continue;
                return param.getParamValue();
            }
        }
        return null;
    }

    private boolean gitlabHandler(String subsGitGroup, String currentUserId, String gitHostUrl, String accessToken, String desc, Connection conn) throws Exception {
        boolean result;
        block25: {
            result = true;
            try {
                SUserDao sUserDao = new SUserDao(conn);
                String group = subsGitGroup;
                GitLabApi gitLabApi = new GitLabApi(gitHostUrl, accessToken);
                User gitUserInfo = null;
                try {
                    gitUserInfo = gitLabApi.getUserApi().getUser(currentUserId);
                }
                catch (GitLabApiException gitLabApiException) {
                    // empty catch block
                }
                if (gitUserInfo == null) {
                    SUser sUser = new SUser();
                    sUser.setActorno(currentUserId);
                    sUser = sUserDao.queryByPk(sUser);
                    gitUserInfo = new User();
                    gitUserInfo.setName(currentUserId);
                    gitUserInfo.setUsername(currentUserId);
                    gitUserInfo.setEmail(sUser.getUsermail());
                    try {
                        gitUserInfo = gitLabApi.getUserApi().createUser(gitUserInfo, (CharSequence)(currentUserId + currentUserId), false);
                    }
                    catch (GitLabApiException gitLabApiException) {
                        // empty catch block
                    }
                }
                GroupApi groupApi = gitLabApi.getGroupApi();
                Group namespace = null;
                try {
                    namespace = groupApi.getGroup((Object)group);
                }
                catch (GitLabApiException e) {
                    logger.error(String.format("\u4ed3\u5e93\u7ec4%s\u672a\u521b\u5efa", group));
                    namespace = null;
                }
                if (namespace == null) {
                    try {
                        GroupParams createGroupParam = new GroupParams();
                        createGroupParam.withName(group);
                        createGroupParam.withPath(group);
                        createGroupParam.withDescription(desc);
                        namespace = groupApi.createGroup(createGroupParam);
                        logger.info("\u4ed3\u5e93\u521b\u5efa\u6210 \u5c06\u5f53\u524d\u7528\u6237\u6dfb\u52a0\u4e3a\u4ed3\u5e93\u6210\u5458");
                        try {
                            Member member = groupApi.addMember((Object)group, gitUserInfo.getId(), AccessLevel.MAINTAINER);
                            if (member != null) {
                                logger.info("\u4ed3\u5e93\u7ec4\u6210\u5458\u6dfb\u52a0\u6210\u529f");
                            }
                        }
                        catch (GitLabApiException member) {}
                    }
                    catch (GitLabApiException e) {
                        logger.error(String.format("\u4ed3\u5e93\u7ec4%s\u672a\u521b\u5efa", group));
                        result = false;
                        return result;
                    }
                }
                String projectName = subsGitGroup + "-wiki";
                ProjectApi prjApi = gitLabApi.getProjectApi();
                Project prj = null;
                try {
                    prj = prjApi.getProject(group, projectName);
                }
                catch (GitLabApiException gitLabApiException) {
                    // empty catch block
                }
                if (prj == null || prj.getId() == null || prj.getId() < 0L) {
                    prj = new Project();
                    prj.setName(projectName);
                    prj.setPath(projectName);
                    prj.setDescription(desc);
                    Project newPrj = null;
                    try {
                        newPrj = prjApi.createProject(namespace.getId(), prj);
                    }
                    catch (GitLabApiException gitLabApiException) {
                        // empty catch block
                    }
                    if (newPrj != null) {
                        logger.info("\u77e5\u8bc6\u5e93 \u4ed3\u5e93\u521b\u5efa\u6210 \u5c06\u5f53\u524d\u7528\u6237\u6dfb\u52a0\u4e3a\u4ed3\u5e93\u6210\u5458");
                        try {
                            Member member = prjApi.addMember((Object)newPrj, gitUserInfo.getId(), AccessLevel.MAINTAINER);
                            if (member != null) {
                                logger.info("\u77e5\u8bc6\u5e93 \u4ed3\u5e93\u6210\u5458\u6dfb\u52a0\u6210\u529f");
                            }
                            break block25;
                        }
                        catch (GitLabApiException gitLabApiException) {}
                        break block25;
                    }
                    logger.info("\u77e5\u8bc6\u5e93 \u4ed3\u5e93\u521b\u5efa\u5931\u8d25\u4e86");
                    result = false;
                    break block25;
                }
                logger.info("\u77e5\u8bc6\u5e93 \u4ed3\u5e93\u5df2\u5b58\u5728");
                result = true;
            }
            catch (Exception e) {
                logger.error("\u8c03\u7528gitlab api \u5f02\u5e38 " + e.getMessage(), (Throwable)e);
                result = false;
            }
        }
        return result;
    }

    private boolean giteeHandler(String subsGitGroup, String currentUserId, String gitHostUrl, String accessToken, String desc, Connection conn) throws Exception {
        GiteeService giteeService = (GiteeService)SpringContextUtils.getBean(GiteeService.class);
        boolean result = true;
        String type = "org";
        String ownName = subsGitGroup;
        GiteeRequestVO requestParam = new GiteeRequestVO();
        requestParam.setAccess_token(accessToken);
        GiteeResponseVO response = giteeService.queryOrg(subsGitGroup, requestParam);
        if (response == null || StringUtils.isBlank((CharSequence)response.getUrl())) {
            GiteeRequestVO createOrgParam = new GiteeRequestVO();
            createOrgParam.setAccess_token(accessToken);
            createOrgParam.setName(subsGitGroup);
            createOrgParam.setOrg(subsGitGroup);
            response = giteeService.createOrg(createOrgParam);
            logger.info("gitee \u521b\u5efa\u7ec4\u7ec7\u4ed3\u5e93\u8fd4\u56de\u62a5\u6587 " + JSON.toJSONString((Object)response));
        }
        String projectName = subsGitGroup + "-wiki";
        requestParam = new GiteeRequestVO();
        requestParam.setAccess_token(accessToken);
        requestParam.setName(projectName);
        requestParam.setOrg(subsGitGroup);
        requestParam.setHas_issues(Boolean.valueOf(true));
        requestParam.setHas_wiki(Boolean.valueOf(true));
        requestParam.setCan_comment(Boolean.valueOf(true));
        response = giteeService.createOrgRepo(type + "s", subsGitGroup, requestParam);
        logger.info(String.format("\u521b\u5efa\u77e5\u8bc6\u5e93 %s \u8fd4\u56de %s", projectName, JSON.toJSON((Object)response)));
        return result;
    }

    public boolean repositoryCreate(String localPath, String remotePath, String username, String password, String branchName) {
        if (TerminalExecUtil.isWindows()) {
            JGitUtil.shallowClone(localPath, remotePath, username, password, branchName, arg_0 -> ((Logger)logger).info(arg_0));
            return true;
        }
        JGitUtil jGitUtil = new JGitUtil(localPath, remotePath, username, password);
        try {
            jGitUtil.pull(branchName);
        }
        catch (Exception e) {
            try {
                jGitUtil.cloneBranch(branchName);
            }
            catch (Exception e1) {
                jGitUtil.close();
                File localRepoFile = new File(localPath);
                if (localRepoFile.exists()) {
                    FileUtils.deleteQuietly((File)localRepoFile);
                }
                try {
                    jGitUtil = new JGitUtil(localPath, remotePath, username, password);
                    jGitUtil.cloneBranch(branchName);
                }
                catch (Exception e2) {
                    logger.error("git \u62c9\u53d6\u4ed3\u5e93\u5931\u8d25" + e2.getMessage(), (Throwable)e2);
                    e2.printStackTrace();
                    return false;
                }
            }
        }
        jGitUtil.close();
        return true;
    }

    public boolean repositoryPush(String localPath, String remotePath, String username, String password, String branchName) {
        JGitUtil jGitUtil = new JGitUtil(localPath, remotePath, username, password);
        try {
            jGitUtil.addAll();
            jGitUtil.commit(this.commitComment + "");
            jGitUtil.push(remotePath, false);
        }
        catch (Exception e) {
            logger.error("\u63d0\u4ea4\u4ee3\u7801\u5f02\u5e38 " + e.getMessage(), (Throwable)e);
            return false;
        }
        jGitUtil.close();
        return true;
    }

    private boolean commit(Connection conn) throws Exception {
        PaasEnvParamDao paasEnvParamDao = new PaasEnvParamDao(conn);
        SUserProfileDao sUserProfileDao = new SUserProfileDao(conn);
        SUserDao sUserDao = new SUserDao(conn);
        String currentUserId = this.loginUserId;
        SUserProfile userProfile = sUserProfileDao.queryByPk(currentUserId);
        if (userProfile == null || StringUtils.isBlank((CharSequence)userProfile.getGitUsername()) || !StringUtils.isNotBlank((CharSequence)userProfile.getGitPassword()) && !StringUtils.isNotBlank((CharSequence)userProfile.getGitAccessToken())) {
            logger.error("************************************\u8bf7\u5728\u4e2a\u4eba\u8bbe\u7f6e\u5173\u8054git\u8d26\u53f7\u4fe1\u606f\uff01************************************");
            return false;
        }
        String userEmail = "";
        SUser user = new SUser();
        user.setActorno(currentUserId);
        user = sUserDao.queryByPk(user);
        userEmail = user != null && StringUtils.isNotBlank((CharSequence)user.getUsermail()) ? user.getUsermail() : String.format("%s@%s.com", currentUserId, "irdstudio");
        SSubsInfoDao sSubsInfoDao = new SSubsInfoDao(conn);
        SSubsInfo sysInfo = sSubsInfoDao.querySSubsInfoWithKeys(this.sysCode);
        PluginGitConf pluginParam = new PluginGitConf();
        pluginParam.setGitUserName(userProfile.getGitUsername());
        if (StringUtils.isNotBlank((CharSequence)userProfile.getGitAccessToken())) {
            pluginParam.setGitPassword(userProfile.getGitAccessToken());
        } else {
            pluginParam.setGitPassword(userProfile.getGitPassword());
        }
        pluginParam.setGitBranchName(paasEnvParamDao.queryByCodeReturnValue("git.push.branch.name"));
        String gitHostUrl = paasEnvParamDao.queryByCodeReturnValue("git.host.url");
        String remoteUrl = String.format("%s/%s/%s-wiki.git", gitHostUrl, sysInfo.getSubsCode(), sysInfo.getSubsCode());
        pluginParam.setGitRemotePath(remoteUrl);
        if (pluginParam == null) {
            return false;
        }
        String docsRootPath = SdEnvUtil.DOCS_PATH;
        boolean flag = true;
        String suffix = "-remote";
        String gitLocalPath = docsRootPath + File.separator + this.sysCode;
        String remoteRepoPath = gitLocalPath + suffix;
        try {
            flag = this.repositoryCreate(remoteRepoPath, pluginParam.getGitRemotePath(), pluginParam.getGitUserName(), pluginParam.getGitPassword(), pluginParam.getGitBranchName());
            if (!flag) {
                logger.info("\u8fdc\u7a0b\u4ed3\u5e93\u4e0d\u5b58\u5728\uff0c \u8def\u5f84\u4e3a\uff1a" + pluginParam.getGitRemotePath());
                return flag;
            }
            if (StringUtils.isBlank((CharSequence)this.repoPath)) {
                this.repoPath = "";
            }
            File remoteRepoDir = new File(remoteRepoPath, this.repoPath);
            File targetFile = new File(remoteRepoDir, this.file.getName());
            FileUtils.copyFile((File)this.file, (File)targetFile);
            flag = this.repositoryPush(remoteRepoPath, pluginParam.getGitRemotePath(), pluginParam.getGitUserName(), pluginParam.getGitPassword(), pluginParam.getGitBranchName());
            if (flag) {
                logger.info("\u4ee3\u7801\u66f4\u65b0\u6210\u529f\uff0c\u672c\u5730\u66f4\u65b0\u8def\u5f84:" + gitLocalPath + "\n\u8fdc\u7a0b\u8def\u5f84\u4e3a\uff1a" + pluginParam.getGitRemotePath());
            } else {
                logger.info("\u4ee3\u7801\u66f4\u65b0\u5931\u8d25\uff0c\u672c\u5730\u66f4\u65b0\u8def\u5f84:" + gitLocalPath + "\n\u8fdc\u7a0b\u8def\u5f84\u4e3a\uff1a" + pluginParam.getGitRemotePath());
            }
            return flag;
        }
        catch (Exception e) {
            flag = false;
            return flag;
        }
    }
}

