/*
 * Decompiled with CFR 0.152.
 */
package com.irdstudio.allinapaas.executor.application.executor.core.plugin.market;

import com.alibaba.fastjson.JSON;
import com.irdstudio.allinapaas.design.console.types.AppType;
import com.irdstudio.allinapaas.design.console.types.MarketSource;
import com.irdstudio.allinapaas.executor.application.executor.core.dao.DictItemInfoDao;
import com.irdstudio.allinapaas.executor.application.executor.core.dao.DictOptionEnumDao;
import com.irdstudio.allinapaas.executor.application.executor.core.dao.DictOptionInfoDao;
import com.irdstudio.allinapaas.executor.application.executor.core.dao.ModelFolderInfoDao;
import com.irdstudio.allinapaas.executor.application.executor.core.dao.ModelTableFieldDao;
import com.irdstudio.allinapaas.executor.application.executor.core.dao.ModelTableIndexDao;
import com.irdstudio.allinapaas.executor.application.executor.core.dao.ModelTableInfoDao;
import com.irdstudio.allinapaas.executor.application.executor.core.dao.OsrvArrangeTableDao;
import com.irdstudio.allinapaas.executor.application.executor.core.dao.OsrvArrangeVarDao;
import com.irdstudio.allinapaas.executor.application.executor.core.dao.OsrvEvalIsrvDao;
import com.irdstudio.allinapaas.executor.application.executor.core.dao.OsrvEvalVarDao;
import com.irdstudio.allinapaas.executor.application.executor.core.dao.PaasAppsInfoDao;
import com.irdstudio.allinapaas.executor.application.executor.core.dao.PaasAppsParamDao;
import com.irdstudio.allinapaas.executor.application.executor.core.dao.PaasAppsPropertiesDao;
import com.irdstudio.allinapaas.executor.application.executor.core.dao.PaasAppsSqlDao;
import com.irdstudio.allinapaas.executor.application.executor.core.dao.PaasEnvParamDao;
import com.irdstudio.allinapaas.executor.application.executor.core.dao.PaasMarketAppinfoDao;
import com.irdstudio.allinapaas.executor.application.executor.core.dao.SrvEvalFuncDao;
import com.irdstudio.allinapaas.executor.application.executor.core.dao.SrvFieldFlagDao;
import com.irdstudio.allinapaas.executor.application.executor.core.dao.SrvModelFeatureDao;
import com.irdstudio.allinapaas.executor.application.executor.core.dao.SrvModelInfoDao;
import com.irdstudio.allinapaas.executor.application.executor.core.dao.SrvModelInoutDao;
import com.irdstudio.allinapaas.executor.application.executor.core.dao.SrvModelPackageDao;
import com.irdstudio.allinapaas.executor.application.executor.core.dao.domain.DictItemInfo;
import com.irdstudio.allinapaas.executor.application.executor.core.dao.domain.DictOptionEnum;
import com.irdstudio.allinapaas.executor.application.executor.core.dao.domain.DictOptionInfo;
import com.irdstudio.allinapaas.executor.application.executor.core.dao.domain.ModelFolderInfo;
import com.irdstudio.allinapaas.executor.application.executor.core.dao.domain.ModelTableField;
import com.irdstudio.allinapaas.executor.application.executor.core.dao.domain.ModelTableIndex;
import com.irdstudio.allinapaas.executor.application.executor.core.dao.domain.ModelTableInfo;
import com.irdstudio.allinapaas.executor.application.executor.core.dao.domain.PaasAppsInfo;
import com.irdstudio.allinapaas.executor.application.executor.core.dao.domain.PaasAppsParam;
import com.irdstudio.allinapaas.executor.application.executor.core.dao.domain.PaasAppsProperties;
import com.irdstudio.allinapaas.executor.application.executor.core.dao.domain.PaasAppsSql;
import com.irdstudio.allinapaas.executor.application.executor.core.dao.domain.PaasMarketAppinfo;
import com.irdstudio.allinapaas.executor.application.executor.core.dao.domain.SrvFieldFlag;
import com.irdstudio.allinapaas.executor.application.executor.core.dao.domain.SrvModelInfo;
import com.irdstudio.allinapaas.executor.application.executor.core.dao.domain.SrvModelInout;
import com.irdstudio.allinapaas.executor.application.executor.core.dao.domain.SrvModelPackage;
import com.irdstudio.allinapaas.executor.application.executor.core.plugin.common.SSubsInfoDao;
import com.irdstudio.allinapaas.executor.application.executor.core.plugin.market.AbstractMarketTask;
import com.irdstudio.allinapaas.executor.application.executor.core.util.date.CurrentDateUtil;
import com.irdstudio.allinapaas.portal.console.types.AppCreateWay;
import com.irdstudio.allinapaas.portal.console.types.YesOrNO;
import java.io.File;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.beanutils.BeanUtils;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.MapUtils;
import org.apache.commons.lang3.StringUtils;

public class CPSqliteRefCpnTask
extends AbstractMarketTask {
    private PaasMarketAppinfo appInfo = null;
    private Map<String, Object> extParam = null;

    @Override
    public boolean initTask(Map<String, Object> extParam, Connection conn) throws SQLException {
        this.extParam = extParam;
        PaasMarketAppinfoDao paasAppsInfoDao = new PaasMarketAppinfoDao(conn);
        this.appInfo = paasAppsInfoDao.queryPaasMarketAppinfo(MapUtils.getString(extParam, (Object)"marketAppId"));
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean execute() {
        boolean flag = true;
        Connection conn = null;
        Connection sqliteConn = null;
        try {
            conn = this.getConnection();
            PaasEnvParamDao paasEnvParamDao = new PaasEnvParamDao(conn);
            String subsFlag = MapUtils.getString(this.extParam, (Object)"subsFlag");
            String marketSource = MapUtils.getString(this.extParam, (Object)"marketSource");
            String subsId = MapUtils.getString(this.extParam, (Object)"marketSubsId");
            ArrayList<PaasMarketAppinfo> appInfoList = new ArrayList<PaasMarketAppinfo>();
            if (StringUtils.equals((CharSequence)marketSource, (CharSequence)MarketSource.Inside.getCode())) {
                if (StringUtils.equals((CharSequence)subsFlag, (CharSequence)YesOrNO.YES.getCode())) {
                    PaasMarketAppinfoDao paasAppsInfoDao = new PaasMarketAppinfoDao(conn);
                    PaasMarketAppinfo appParam = new PaasMarketAppinfo();
                    appParam.setSubsId(subsId);
                    List<PaasMarketAppinfo> sysApps = paasAppsInfoDao.queryPaasMarketAppinfoList(appParam);
                    appInfoList.addAll(sysApps);
                } else {
                    appInfoList.add(this.appInfo);
                }
            } else {
                String respJson;
                PaasMarketAppinfo param;
                String apiUrl = paasEnvParamDao.queryByCodeReturnValue("allinpaas.open.api.http.url");
                if (StringUtils.equals((CharSequence)subsFlag, (CharSequence)YesOrNO.YES.getCode())) {
                    param = new PaasMarketAppinfo();
                    param.setSubsId(subsId);
                    respJson = this.requestOpenApi(apiUrl + "/om/paas/market/appinfo/index", (Object)param);
                    if (StringUtils.isBlank((CharSequence)respJson)) {
                        boolean bl = flag = false;
                        return bl;
                    }
                    List sysApps = JSON.parseArray((String)respJson, PaasMarketAppinfo.class);
                    appInfoList.addAll(sysApps);
                } else {
                    param = new PaasMarketAppinfo();
                    param.setMarketAppId(MapUtils.getString(this.extParam, (Object)"marketAppId"));
                    respJson = this.requestOpenApi(apiUrl + "/om/paas/market/appinfo", (Object)param);
                    if (StringUtils.isBlank((CharSequence)respJson)) {
                        boolean sysApps = flag = false;
                        return sysApps;
                    }
                    PaasMarketAppinfo marketApp = (PaasMarketAppinfo)((Object)JSON.parseObject((String)respJson, PaasMarketAppinfo.class));
                    appInfoList.add(marketApp);
                }
            }
            List<String> cpnAppTypes = Arrays.asList(AppType.A10.getCode());
            for (PaasMarketAppinfo srcApp : appInfoList) {
                if (cpnAppTypes.indexOf(srcApp.getAppType()) < 0) continue;
                File sqliteFile = null;
                if (StringUtils.equals((CharSequence)subsFlag, (CharSequence)YesOrNO.YES.getCode())) {
                    String marketUrl = paasEnvParamDao.queryByCodeReturnValue("git.market.remote.path");
                    sqliteFile = this.getIMPSysSqliteFile(this.extParam, marketUrl, null);
                } else {
                    sqliteFile = this.getSqliteFile(srcApp);
                }
                sqliteConn = this.getSqliteConnection(sqliteFile);
                PaasMarketAppinfoDao keyMapDao = new PaasMarketAppinfoDao(sqliteConn);
                String appId = keyMapDao.queryKeyMap(srcApp.getAppId());
                String refAppId = keyMapDao.queryKeyMap(srcApp.getRefAppId());
                PaasAppsInfoDao real_ProjectTmInfoDao = new PaasAppsInfoDao(conn);
                ModelTableInfoDao modelTableInfoDao = new ModelTableInfoDao(conn);
                ModelTableFieldDao modelTableFieldDao = new ModelTableFieldDao(conn);
                DictOptionInfoDao descDB_dictOptionInfoDao = new DictOptionInfoDao(conn);
                if (srcApp != null) {
                    ModelFolderInfoDao sqlite_projectTmPackageDao = new ModelFolderInfoDao(sqliteConn);
                    ModelFolderInfo packageParam = new ModelFolderInfo();
                    packageParam.setAppId(appId);
                    List<ModelFolderInfo> packageList = sqlite_projectTmPackageDao.queryModelFolderInfo(packageParam);
                    this.batchInsert("`allinrdm_db`.model_folder_info", packageList, conn);
                    ModelTableInfoDao sqlite_modelTableInfoDao = new ModelTableInfoDao(sqliteConn);
                    List<ModelTableInfo> tables = sqlite_modelTableInfoDao.queryModelTableInfoList(appId);
                    this.batchInsertPage("`allinrdm_db`.model_table_info", tables, conn);
                    ModelTableIndexDao sqlite_modelTableIndexDao = new ModelTableIndexDao(sqliteConn);
                    List<ModelTableIndex> indexs = sqlite_modelTableIndexDao.queryModelTableInfos(appId);
                    this.batchInsertPage("`allinrdm_db`.model_table_index", indexs, conn);
                    ModelTableFieldDao sqlite_modelTableFieldDao = new ModelTableFieldDao(sqliteConn);
                    List<ModelTableField> fields = sqlite_modelTableFieldDao.queryFieldByAppId(appId);
                    this.batchInsertPage("`allinrdm_db`.model_table_field", fields, conn);
                    SrvFieldFlagDao srvFieldFlagDao = new SrvFieldFlagDao(sqliteConn);
                    List<SrvFieldFlag> fieldFlags = srvFieldFlagDao.queryFieldFlagByAppId(appId);
                    this.batchInsertPage("`allinrdm_db`.srv_field_flag", fieldFlags, conn);
                    DictItemInfoDao dictItemInfoDao = new DictItemInfoDao(sqliteConn);
                    DictItemInfoDao destDBDictItemInfoDao = new DictItemInfoDao(conn);
                    List<DictItemInfo> items = dictItemInfoDao.queryDictItemInfoList(appId);
                    if (CollectionUtils.isNotEmpty(items)) {
                        ArrayList<DictItemInfo> needItems = new ArrayList<DictItemInfo>(items.size());
                        for (DictItemInfo item : items) {
                            if (destDBDictItemInfoDao.queryByPk(item.getItemId()) != null) continue;
                            needItems.add(item);
                        }
                        this.batchInsertPage("`allinrdm_db`.dict_item_info", needItems, conn);
                    }
                    DictOptionInfoDao dictOptionInfoDao = new DictOptionInfoDao(sqliteConn);
                    DictOptionEnumDao dictOptionEnumDao = new DictOptionEnumDao(sqliteConn);
                    HashMap<String, DictOptionInfo> optionInfoMap = new HashMap<String, DictOptionInfo>();
                    ArrayList<DictOptionInfo> optionInfoList = new ArrayList<DictOptionInfo>();
                    ArrayList<DictOptionEnum> optionEnumList = new ArrayList<DictOptionEnum>();
                    List<ModelTableField> optionsList = modelTableFieldDao.queryModelTableFieldAllOptions(appId);
                    if (CollectionUtils.isNotEmpty(optionsList)) {
                        ArrayList codeBoList = new ArrayList(optionsList.size());
                        for (ModelTableField option : optionsList) {
                            if (StringUtils.isBlank((CharSequence)option.getDictId()) || optionInfoMap.get(option.getDictId()) != null) continue;
                            List<DictOptionEnum> dicts = dictOptionEnumDao.queryDictOptionEnumListByDictId(option.getDictId());
                            DictOptionInfo optionInfo = dictOptionInfoDao.queryByPk(option.getDictId());
                            if (descDB_dictOptionInfoDao.queryByPk(optionInfo.getDictId()) != null) continue;
                            optionInfoMap.put(optionInfo.getDictId(), optionInfo);
                            optionInfoList.add(optionInfo);
                            optionEnumList.addAll(dicts);
                        }
                    }
                    this.batchInsertPage("`allinrdm_db`.dict_option_info", optionInfoList, conn);
                    this.batchInsertPage("`allinrdm_db`.dict_option_enum", optionEnumList, conn);
                }
                PaasAppsInfoDao paasAppsInfoDao = new PaasAppsInfoDao(conn);
                SrvModelInfoDao real_srvModelInfoDao = new SrvModelInfoDao(conn);
                SrvModelPackageDao real_srvModelPackageDao = new SrvModelPackageDao(conn);
                SSubsInfoDao sSubsInfoDao = new SSubsInfoDao(conn);
                String createTime = CurrentDateUtil.getTodayDateEx2();
                PaasAppsInfoDao sqlitePaasAppsInfoDao = new PaasAppsInfoDao(sqliteConn);
                PaasAppsInfo existsApp = paasAppsInfoDao.queryByAppId(refAppId);
                if (existsApp == null) {
                    PaasAppsInfo sqliteSrcApp = sqlitePaasAppsInfoDao.queryByAppId(refAppId);
                    PaasAppsInfo destApp = new PaasAppsInfo();
                    BeanUtils.copyProperties((Object)((Object)destApp), (Object)((Object)srcApp));
                    BeanUtils.copyProperties((Object)((Object)destApp), (Object)((Object)sqliteSrcApp));
                    destApp.setAppId(refAppId);
                    destApp.setCreateTime(createTime);
                    destApp.setLastUpdateTime(createTime);
                    destApp.setAppAdminType(sqliteSrcApp.getAppAdminType());
                    destApp.setAppCreateWay(AppCreateWay.BaseOnMarket.getCode());
                    destApp.setRefMarketAppid(srcApp.getMarketAppId());
                    paasAppsInfoDao.insertPaasAppsInfo(destApp);
                    PaasAppsParamDao paasAppsParamDao = new PaasAppsParamDao(sqliteConn);
                    PaasAppsSqlDao paasAppsSqlDao = new PaasAppsSqlDao(sqliteConn);
                    PaasAppsPropertiesDao paasAppsPropertiesDao = new PaasAppsPropertiesDao(sqliteConn);
                    SrvModelInfoDao srvModelInfoDao = new SrvModelInfoDao(sqliteConn);
                    SrvModelInoutDao srvModelInoutDao = new SrvModelInoutDao(sqliteConn);
                    SrvModelPackageDao srvModelPackageDao = new SrvModelPackageDao(sqliteConn);
                    OsrvArrangeTableDao osrvArrangeTableDao = new OsrvArrangeTableDao(sqliteConn);
                    OsrvArrangeVarDao osrvArrangeVarDao = new OsrvArrangeVarDao(sqliteConn);
                    OsrvEvalIsrvDao osrvEvalIsrvDao = new OsrvEvalIsrvDao(sqliteConn);
                    OsrvEvalVarDao osrvEvalVarDao = new OsrvEvalVarDao(sqliteConn);
                    SrvEvalFuncDao srvEvalFuncDao = new SrvEvalFuncDao(sqliteConn);
                    SrvModelFeatureDao srvModelFeatureDao = new SrvModelFeatureDao(sqliteConn);
                    PaasAppsParam paasAppsParam = new PaasAppsParam();
                    paasAppsParam.setAppId(refAppId);
                    List<PaasAppsParam> appsParamList = paasAppsParamDao.queryPaasAppsParamList(paasAppsParam);
                    this.batchInsertPage("`allinpaas_db`.paas_apps_param", appsParamList, conn);
                    PaasAppsSql paasSqlParam = new PaasAppsSql();
                    paasSqlParam.setAppId(refAppId);
                    List<PaasAppsSql> appsSqlList = paasAppsSqlDao.queryPaasAppsSqlList(paasSqlParam);
                    this.batchInsertPage("`allinpaas_db`.paas_apps_sql", appsSqlList, conn);
                    PaasAppsProperties paasAppsProp = new PaasAppsProperties();
                    paasAppsProp.setAppId(refAppId);
                    List<PaasAppsProperties> appsPropList = paasAppsPropertiesDao.queryPaasAppsPropertiesList(paasAppsProp);
                    this.batchInsertPage("`allinpaas_db`.paas_apps_properties", appsPropList, conn);
                    SrvModelInfo srvParam = new SrvModelInfo();
                    srvParam.setAppId(refAppId);
                    List<SrvModelInfo> srvModelList = srvModelInfoDao.querySrvModelInfoList(srvParam);
                    this.batchInsertPage("`allinrdm_db`.srv_model_info", srvModelList, conn);
                    SrvModelPackage srvModelPackage = new SrvModelPackage();
                    srvModelPackage.setAppId(refAppId);
                    List<SrvModelPackage> packageList = srvModelPackageDao.querySrvModelPackageList(srvModelPackage);
                    this.batchInsertPage("`allinrdm_db`.srv_model_package", packageList, conn);
                    for (SrvModelInfo modelInfo : srvModelList) {
                        SrvModelInout inoutParam = new SrvModelInout();
                        inoutParam.setSrvModelId(modelInfo.getSrvModelId());
                        List<SrvModelInout> inoutList = srvModelInoutDao.querySrvModelInoutList(inoutParam);
                        this.batchInsertPage("`allinrdm_db`.srv_model_inout", inoutList, conn);
                    }
                }
                this.closeSqliteConnection(sqliteConn);
            }
        }
        catch (Exception e) {
            this.logger.error("\u4ecesqlite\u590d\u5236\u7ec4\u5408\u670d\u52a1\u5230\u5e73\u53f0", (Throwable)e);
            flag = false;
        }
        finally {
            if (conn != null) {
                this.closeConnection(conn);
            }
            if (sqliteConn != null) {
                this.closeSqliteConnection(sqliteConn);
            }
        }
        return flag;
    }
}

