/*
 * Decompiled with CFR 0.152.
 */
package com.irdstudio.allinapaas.executor.application.executor.core.plugin.market;

import com.irdstudio.allinapaas.design.console.types.MarketType;
import com.irdstudio.allinapaas.executor.application.executor.core.dao.ModelTableInfoDao;
import com.irdstudio.allinapaas.executor.application.executor.core.dao.PaasAppsInfoDao;
import com.irdstudio.allinapaas.executor.application.executor.core.dao.PaasEnvParamDao;
import com.irdstudio.allinapaas.executor.application.executor.core.dao.PaasMarketAppinfoDao;
import com.irdstudio.allinapaas.executor.application.executor.core.dao.PaasMarketSysinfoDao;
import com.irdstudio.allinapaas.executor.application.executor.core.dao.SrvModelInfoDao;
import com.irdstudio.allinapaas.executor.application.executor.core.dao.domain.PaasAppsInfo;
import com.irdstudio.allinapaas.executor.application.executor.core.dao.domain.PaasMarketAppinfo;
import com.irdstudio.allinapaas.executor.application.executor.core.dao.domain.PaasMarketSysinfo;
import com.irdstudio.allinapaas.executor.application.executor.core.plugin.common.SSubsInfo;
import com.irdstudio.allinapaas.executor.application.executor.core.plugin.common.SSubsInfoDao;
import com.irdstudio.allinapaas.executor.application.executor.core.plugin.market.AbstractMarketTask;
import com.irdstudio.allinapaas.executor.application.executor.core.util.date.CurrentDateUtil;
import com.irdstudio.allinapaas.executor.application.executor.core.util.pub.UUIDUtil;
import com.irdstudio.allinapaas.portal.console.types.IndustryType;
import com.irdstudio.allinrdm.dev.console.types.SrvModelCatalogEnum;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.List;
import java.util.Map;
import org.apache.commons.beanutils.BeanUtils;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.MapUtils;

public class SysMarketSaveDBTask
extends AbstractMarketTask {
    private Map<String, Object> extParam = null;

    @Override
    public boolean initTask(Map<String, Object> extParam, Connection conn) throws SQLException {
        this.extParam = extParam;
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean execute() {
        boolean flag = true;
        Connection conn = null;
        try {
            conn = this.getConnection();
            String subsId = MapUtils.getString(this.extParam, (Object)"paasSubsId");
            String subsCode = MapUtils.getString(this.extParam, (Object)"paasSubsCode");
            SSubsInfoDao sSubsInfoDao = new SSubsInfoDao(conn);
            PaasAppsInfoDao paasAppsInfoDao = new PaasAppsInfoDao(conn);
            ModelTableInfoDao modelTableInfoDao = new ModelTableInfoDao(conn);
            SrvModelInfoDao srvModelInfoDao = new SrvModelInfoDao(conn);
            PaasMarketSysinfoDao paasMarketSysinfoDao = new PaasMarketSysinfoDao(conn);
            PaasMarketAppinfoDao paasMarketAppinfoDao = new PaasMarketAppinfoDao(conn);
            PaasEnvParamDao paasEnvParamDao = new PaasEnvParamDao(conn);
            SSubsInfo sSubsInfo = sSubsInfoDao.querySSubsInfoWithKeys(subsId);
            PaasMarketSysinfo paasMarketSysinfo = paasMarketSysinfoDao.queryPaasMarketSysinfo(subsId);
            if (paasMarketSysinfo == null) {
                paasMarketSysinfo = new PaasMarketSysinfo();
                BeanUtils.copyProperties((Object)((Object)paasMarketSysinfo), (Object)((Object)sSubsInfo));
                paasMarketSysinfo.setSubsId(sSubsInfo.getSubsId());
                paasMarketSysinfo.setSubsCode(sSubsInfo.getSubsCode());
                paasMarketSysinfo.setSubsName(sSubsInfo.getSubsName());
                paasMarketSysinfo.setSysVersion("1.0.0");
                paasMarketSysinfo.setMarketType(MarketType.Original.getCode());
                paasMarketSysinfo.setIndustryType(IndustryType.ALL.getCode());
                paasMarketSysinfoDao.insertPaasMarketSysinfo(paasMarketSysinfo);
            }
            List<PaasAppsInfo> appList = paasAppsInfoDao.queryPaasAppsInfoListBySysCode(subsId);
            paasMarketAppinfoDao.deletePaasMarketAppinfoBySysCode(subsId);
            if (CollectionUtils.isNotEmpty(appList)) {
                for (PaasAppsInfo appInfo : appList) {
                    PaasMarketAppinfo paasMarketAppinfo = new PaasMarketAppinfo();
                    BeanUtils.copyProperties((Object)((Object)paasMarketAppinfo), (Object)((Object)appInfo));
                    int modelCount = modelTableInfoDao.countByProjectId(appInfo.getAppId());
                    int srvI01Count = srvModelInfoDao.countByAppId(appInfo.getAppId(), SrvModelCatalogEnum.SrvServer.getCode());
                    int srvA01Count = srvModelInfoDao.countByAppId(appInfo.getAppId(), SrvModelCatalogEnum.ComponentServer.getCode());
                    int srvInfCount = srvModelInfoDao.countByAppId(appInfo.getAppId(), SrvModelCatalogEnum.TradeServer.getCode());
                    int srvBackCount = srvModelInfoDao.countByAppId(appInfo.getAppId(), SrvModelCatalogEnum.BackServer.getCode());
                    String today = CurrentDateUtil.getTodayDate();
                    paasMarketAppinfo.setAppTableCount(modelCount);
                    paasMarketAppinfo.setAppIsrvCount(srvI01Count);
                    paasMarketAppinfo.setAppOsrvCount(srvA01Count + srvInfCount + srvBackCount);
                    paasMarketAppinfo.setAppPublishTime(today);
                    paasMarketAppinfo.setMarketType(MarketType.Original.getCode());
                    String marketAppGiturl = paasEnvParamDao.queryByCodeReturnValue("git.market.remote.path");
                    paasMarketAppinfo.setMarketAppGiturl(marketAppGiturl);
                    paasMarketAppinfo.setSubsId(subsId);
                    paasMarketAppinfo.setSubsCode(subsCode);
                    paasMarketAppinfo.setSubsName(paasMarketSysinfo.getSubsName());
                    paasMarketAppinfo.setAppAdminType(appInfo.getAppAdminType());
                    paasMarketAppinfo.setMarketAppId(UUIDUtil.getUUID());
                    paasMarketAppinfo.setIndustryType(IndustryType.ALL.getCode());
                    paasMarketAppinfoDao.insertPaasMarketAppinfo(paasMarketAppinfo);
                }
            }
        }
        catch (Exception e) {
            this.logger.error("\u63d0\u4ea4\u5e94\u7528\u4fe1\u606f\u5230\u5e94\u7528\u5e02\u573a\u5931\u8d25", (Throwable)e);
            flag = false;
        }
        finally {
            if (conn != null) {
                this.closeConnection(conn);
            }
        }
        return flag;
    }
}

