/*
 * Decompiled with CFR 0.152.
 */
package com.irdstudio.allinapaas.executor.application.executor.core.plugin.scan;

import com.irdstudio.allinapaas.design.console.facade.PaasAppsInfoService;
import com.irdstudio.allinapaas.design.console.facade.PaasAppsMeasureService;
import com.irdstudio.allinapaas.design.console.facade.dto.PaasAppsInfoDTO;
import com.irdstudio.allinapaas.design.console.facade.dto.PaasAppsMeasureDTO;
import com.irdstudio.allinapaas.executor.application.executor.core.batch.AppRepoPullTask;
import com.irdstudio.allinapaas.executor.application.executor.core.dao.BatInstBatchDao;
import com.irdstudio.allinapaas.executor.application.executor.core.dao.domain.BatInstBatch;
import com.irdstudio.allinapaas.executor.application.executor.core.plugin.AbstractPlugin;
import com.irdstudio.allinapaas.executor.application.executor.core.plugin.deploy.MavenRunner;
import com.irdstudio.allinapaas.executor.application.executor.core.plugin.scan.CheckstyleReportParser;
import com.irdstudio.allinapaas.executor.application.executor.core.tinycore.log.ILogger;
import com.irdstudio.allinapaas.executor.application.executor.core.tinycore.log.LoggerFactory;
import com.irdstudio.allinapaas.executor.facade.dto.ValidateRtnDTO;
import com.irdstudio.allinapaas.executor.types.ExecutorInstInfo;
import com.irdstudio.allinapaas.portal.console.facade.SummaryService;
import com.irdstudio.allinapaas.portal.console.types.YesOrNO;
import com.irdstudio.allinapaas.quality.console.facade.PluginCheckstyleRptService;
import com.irdstudio.allinapaas.quality.console.facade.dto.PluginCheckstyleRptDTO;
import com.irdstudio.allinrdm.sam.console.facade.CheckstyleTemplateInfoService;
import com.irdstudio.allinrdm.sam.console.facade.dto.CheckstyleTemplateInfoDTO;
import com.irdstudio.sdk.beans.core.util.CurrentDateUtil;
import com.irdstudio.sdk.beans.core.util.PropertiesUtil;
import com.irdstudio.sdk.beans.core.util.SpringContextUtils;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.Writer;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.MapUtils;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;
import org.dom4j.Document;
import org.dom4j.DocumentHelper;
import org.dom4j.Element;
import org.dom4j.Namespace;
import org.dom4j.QName;
import org.dom4j.io.OutputFormat;
import org.dom4j.io.XMLWriter;

public class CodeStdScanPlugin
extends AbstractPlugin {
    protected BatInstBatch batchInst = null;
    protected Map<String, Object> extParam;
    PaasAppsMeasureService paasAppsMeasureService;
    PaasAppsInfoService paasAppsInfoService;
    SummaryService summaryService;
    PluginCheckstyleRptService pluginCheckstyleRptService;
    CheckstyleTemplateInfoService checkstyleTemplateInfoService;

    @Override
    protected boolean doReadConfigureFromDB(Connection conn, String szConfIdentify) throws SQLException {
        String batchSerialNo = this.context.getSzBatchSn();
        BatInstBatchDao batInstBatchDao = new BatInstBatchDao(conn);
        this.batchInst = batInstBatchDao.queryByBatchSerialNo(batchSerialNo);
        this.extParam = batInstBatchDao.getExtParam(this.batchInst);
        return true;
    }

    @Override
    public boolean execute() {
        String reportId = MapUtils.getString(this.extParam, (Object)"reportId");
        String userId = MapUtils.getString(this.extParam, (Object)"createUserId");
        String codeTempId = MapUtils.getString(this.extParam, (Object)"codeTempId");
        String now = CurrentDateUtil.getTodayDateEx2();
        String appId = this.batchInst.getAppId();
        this.paasAppsMeasureService = (PaasAppsMeasureService)SpringContextUtils.getBean(PaasAppsMeasureService.class);
        this.paasAppsInfoService = (PaasAppsInfoService)SpringContextUtils.getBean(PaasAppsInfoService.class);
        this.summaryService = (SummaryService)SpringContextUtils.getBean(SummaryService.class);
        this.pluginCheckstyleRptService = (PluginCheckstyleRptService)SpringContextUtils.getBean(PluginCheckstyleRptService.class);
        PaasAppsInfoDTO appInfo = new PaasAppsInfoDTO();
        appInfo.setAppId(appId);
        appInfo = (PaasAppsInfoDTO)this.paasAppsInfoService.queryByPk((Object)appInfo);
        String appRepoPath = "";
        if (this.context.getBatBatchSource() == null) {
            AppRepoPullTask appRepoPullTask = new AppRepoPullTask(appId);
            appRepoPullTask.syncRun();
            appRepoPath = appRepoPullTask.getAppPath();
            String fullLogFileName = ExecutorInstInfo.BATCH_LOG_PATH + File.separator + reportId + ".log";
            this.logger.info("\u63d2\u4ef6\u8c03\u7528\u65b9\u5f0f\uff0c\u8f93\u51fa\u65e5\u5fd7\u5230 " + fullLogFileName);
            ILogger newLogger = LoggerFactory.makeTxtFileLogger(fullLogFileName, true);
            this.setPluginContext(this.context, newLogger);
        } else {
            appRepoPath = this.context.getBatBatchSource().getRepoLocalPath();
        }
        File appRepoDir = new File(appRepoPath);
        if (!appRepoDir.exists()) {
            this.logger.error("\u5e94\u7528\u4ed3\u5e93\u62c9\u53d6\u5931\u8d25");
            return false;
        }
        this.logger.info("\u8bfb\u53d6\u5230\u4ed3\u5e93\u5730\u5740\uff1a" + appRepoPath);
        if (StringUtils.isNotBlank((CharSequence)codeTempId)) {
            this.checkstyleTemplateInfoService = (CheckstyleTemplateInfoService)SpringContextUtils.getBean(CheckstyleTemplateInfoService.class);
            CheckstyleTemplateInfoDTO checkstyleXml = new CheckstyleTemplateInfoDTO();
            checkstyleXml.setCodeTempId(codeTempId);
            checkstyleXml = (CheckstyleTemplateInfoDTO)this.checkstyleTemplateInfoService.queryByPk((Object)checkstyleXml);
            if (checkstyleXml != null && StringUtils.isNotBlank((CharSequence)checkstyleXml.getCodeTempContext())) {
                File appXmlFile = new File(appRepoPath, "checkstyle.xml");
                try (FileOutputStream out = new FileOutputStream(appXmlFile);){
                    IOUtils.write((String)checkstyleXml.getCodeTempContext(), (OutputStream)out, (Charset)StandardCharsets.UTF_8);
                }
                catch (Exception e) {
                    this.logger.error("\u5199\u5165\u4ee3\u7801\u89c4\u8303\u914d\u7f6e\u6587\u4ef6\u5931\u8d25", e);
                    return false;
                }
            }
        }
        this.logger.info("\u4ee3\u7801\u89c4\u8303\u626b\u63cf\u5f00\u59cb");
        File rootPomFile = new File(appRepoPath, "pom.xml");
        if (!rootPomFile.exists()) {
            this.logger.error("\u672a\u627e\u5230pom.xml \u9000\u51fa\u626b\u63cf");
        }
        try (FileInputStream input = new FileInputStream(rootPomFile);){
            Element plugins;
            String xmlString = IOUtils.toString((InputStream)input);
            Document document = DocumentHelper.parseText((String)xmlString);
            Element reporting = document.getRootElement().element("reporting");
            if (reporting == null) {
                reporting = DocumentHelper.createElement((QName)DocumentHelper.createQName((String)"reporting", (Namespace)DocumentHelper.createNamespace((String)"", (String)"http://maven.apache.org/POM/4.0.0")));
                document.getRootElement().add(reporting);
            }
            if ((plugins = reporting.element("plugins")) == null) {
                plugins = DocumentHelper.createElement((QName)DocumentHelper.createQName((String)"plugins", (Namespace)DocumentHelper.createNamespace((String)"", (String)"http://maven.apache.org/POM/4.0.0")));
                reporting.add(plugins);
            }
            List pluginList = plugins.elements("plugin");
            boolean findFlag = false;
            if (CollectionUtils.isNotEmpty((Collection)pluginList)) {
                for (Element plugin : pluginList) {
                    Element artifactIdDom = plugin.element("artifactId");
                    if (artifactIdDom == null || !StringUtils.equals((CharSequence)"maven-checkstyle-plugin", (CharSequence)artifactIdDom.getText())) continue;
                    findFlag = true;
                    break;
                }
            } else {
                findFlag = false;
            }
            if (!findFlag) {
                Document pluginDom = DocumentHelper.parseText((String)"<plugin xmlns=\"http://maven.apache.org/POM/4.0.0\">\n                <groupId xmlns=\"http://maven.apache.org/POM/4.0.0\">org.apache.maven.plugins</groupId>\n                <artifactId xmlns=\"http://maven.apache.org/POM/4.0.0\">maven-checkstyle-plugin</artifactId>\n                <version xmlns=\"http://maven.apache.org/POM/4.0.0\">3.4.0</version>\n                <inherited xmlns=\"http://maven.apache.org/POM/4.0.0\">true</inherited>\n                <configuration>\n                    <configLocation>checkstyle.xml</configLocation>\n                    <encoding>UTF-8</encoding>\n                    <consoleOutput>true</consoleOutput>\n                    <failsOnError>true</failsOnError>\n                    <linkXRef>false</linkXRef>\n                    <skip>true</skip>\n                </configuration>\n                <reportSets>\n                    <reportSet>\n                        <reports>\n                            <report>checkstyle</report>\n                        </reports>\n                    </reportSet>\n                </reportSets>\n            </plugin>");
                plugins.add(pluginDom.getRootElement());
                OutputFormat format = OutputFormat.createPrettyPrint();
                format.setIndentSize(4);
                format.setSuppressDeclaration(true);
                format.setEncoding("UTF-8");
                try (PrintWriter pw = new PrintWriter(rootPomFile);){
                    XMLWriter writer = new XMLWriter((Writer)pw, format);
                    writer.write(document);
                    pw.flush();
                }
            }
            MavenRunner mavenRunner = new MavenRunner("mvn -Dcheckstyle.skip=false checkstyle:checkstyle-aggregate", appRepoDir.getAbsolutePath(), this.logger);
            mavenRunner.setMavenHome(PropertiesUtil.getPropertyByKey((String)"application", (String)"tdp.maven.path"));
            mavenRunner.setJavaHome(PropertiesUtil.getPropertyByKey((String)"application", (String)"tdp.maven.java.home.path"));
            mavenRunner.setSetting(PropertiesUtil.getPropertyByKey((String)"application", (String)"tdp.maven.settings.path"));
            mavenRunner.run();
            File reportFile = new File(appRepoPath, "target/reports/checkstyle-aggregate.html");
            PluginCheckstyleRptDTO reportInfo = CheckstyleReportParser.parse(reportId, appId, appRepoDir, reportFile, this.logger);
            if (reportInfo != null) {
                reportInfo.setReportId(reportId);
                reportInfo.setTskNm(String.format("%s-checkstyle", appInfo.getAppName()));
                reportInfo.setNowFileRte("checkstyle-aggregate.html");
                reportInfo.setGitUrl(appInfo.getAppGitUrl());
                reportInfo.setNowVer("master");
                reportInfo.setDelInd("0");
                reportInfo.setAppId(appInfo.getAppId());
                reportInfo.setAppName(appInfo.getAppName());
                reportInfo.setSubsId(appInfo.getSubsId());
                reportInfo.setSubsName(appInfo.getSubsName());
                reportInfo.setCreateUser(userId);
                reportInfo.setCreateTime(now);
                reportInfo.setLatestFlag(YesOrNO.YES.getCode());
                this.pluginCheckstyleRptService.insert((Object)reportInfo);
                PaasAppsMeasureDTO measure = new PaasAppsMeasureDTO();
                measure.setAppId(appId);
                measure.setCodeChkFiles(reportInfo.getChkFiles());
                measure.setCodeChkInfo(reportInfo.getChkInf());
                measure.setCodeChkWarn(reportInfo.getChkWrns());
                measure.setCodeChkError(reportInfo.getChkErrors());
                if (reportInfo.getChkFiles() != null || reportInfo.getChkInf() != null || reportInfo.getChkWrns() != null || reportInfo.getChkErrors() != null) {
                    this.paasAppsMeasureService.updateByPk((Object)measure);
                }
            }
        }
        catch (Exception e) {
            this.logger.error("\u5199\u5165checkstyle\u63d2\u4ef6\u4fe1\u606f\u5f02\u5e38 " + e.getMessage(), e);
        }
        return true;
    }

    @Override
    public boolean validate(String batchId, String taskId, ValidateRtnDTO message) {
        return true;
    }

    @Override
    public boolean copyConfig(String batchId, String taskId, String newTaskId) {
        return true;
    }
}

