/*
 * Decompiled with CFR 0.152.
 */
package com.irdstudio.allinapaas.executor.application.service.impl;

import com.irdstudio.allinapaas.deliver.console.facade.SSrvsCronConfService;
import com.irdstudio.allinapaas.deliver.console.facade.dto.SSrvsCronConfDTO;
import com.irdstudio.allinapaas.executor.application.executor.rest.schedule.QuartzJobEngine;
import com.irdstudio.allinapaas.executor.application.executor.rest.schedule.QuartzManager;
import com.irdstudio.allinapaas.executor.application.executor.rest.schedule.ScheduleJobUtil;
import com.irdstudio.allinapaas.executor.facade.SSrvsCronExecuteService;
import org.quartz.JobKey;
import org.quartz.Scheduler;
import org.quartz.impl.StdSchedulerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="sSrvsCronExecuteServiceImpl")
public class SSrvsCronExecuteServiceImpl
implements SSrvsCronExecuteService {
    @Autowired
    private SSrvsCronConfService sSrvsCronConfService;

    public boolean startTask(SSrvsCronConfDTO sSrvsCronConfVO) {
        StdSchedulerFactory gSchedulerFactory = new StdSchedulerFactory();
        try {
            SSrvsCronConfDTO sSrvsCronConf = new SSrvsCronConfDTO();
            sSrvsCronConfVO.setJobState("A");
            this.sSrvsCronConfService.updateByPk((Object)sSrvsCronConf);
            Scheduler sched = gSchedulerFactory.getScheduler();
            sched.triggerJob(JobKey.jobKey((String)sSrvsCronConfVO.getJobCode(), (String)ScheduleJobUtil.JOB_GROUP_NAME));
            return true;
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
    }

    public boolean doDisable(SSrvsCronConfDTO sSrvsCronConfVO) {
        String jobCode = sSrvsCronConfVO.getJobCode();
        try {
            QuartzManager.removeJob(jobCode, ScheduleJobUtil.JOB_GROUP_NAME, ScheduleJobUtil.TRIGGER_NAME + "-" + jobCode, ScheduleJobUtil.TRIGGER_GROUP_NAME);
            SSrvsCronConfDTO sSrvsCronConf = new SSrvsCronConfDTO();
            sSrvsCronConfVO.setJobState("F");
            this.sSrvsCronConfService.updateByPk((Object)sSrvsCronConf);
            return true;
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
    }

    public boolean doInitial(SSrvsCronConfDTO sSrvsCronConfVO) {
        String subcode = sSrvsCronConfVO.getJobCode();
        try {
            QuartzManager.addJob(subcode, ScheduleJobUtil.JOB_GROUP_NAME, ScheduleJobUtil.TRIGGER_NAME + "-" + subcode, ScheduleJobUtil.TRIGGER_GROUP_NAME, QuartzJobEngine.class, sSrvsCronConfVO.getCronExpression());
            SSrvsCronConfDTO sSrvsCronConf = new SSrvsCronConfDTO();
            sSrvsCronConfVO.setJobState("S");
            this.sSrvsCronConfService.updateByPk((Object)sSrvsCronConf);
            return true;
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
    }
}

