/*
 * Decompiled with CFR 0.152.
 */
package com.irdstudio.allinapaas.executor.application.executor.core.dao;

import com.irdstudio.allinapaas.executor.application.executor.core.dao.AbstractPortalPageDao;
import com.irdstudio.allinapaas.executor.application.executor.core.dao.domain.DictOptionEnum;
import com.irdstudio.allinapaas.executor.application.executor.core.util.db.ProxySQL;
import com.irdstudio.allinrdm.dam.console.types.ObjectType;
import com.irdstudio.sdk.beans.core.util.POJOUtils;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DictOptionEnumDao
extends AbstractPortalPageDao {
    private static final Logger logger = LoggerFactory.getLogger(DictOptionEnumDao.class);
    Connection conn = null;

    public DictOptionEnumDao(Connection conn) {
        super(conn);
        this.conn = conn;
    }

    public List<DictOptionEnum> queryDictOptionEnumListByDictId(final String dictId) throws Exception {
        final ArrayList param = new ArrayList();
        String sql = new ProxySQL(){
            {
                this.SELECT("*");
                this.FROM("`allinrdm_db`.dict_option_enum");
                this.WHERE("dict_id = ?");
                param.add(dictId);
            }
        }.toString();
        PreparedStatement ps = null;
        ResultSet rs = null;
        ArrayList<DictOptionEnum> list = new ArrayList<DictOptionEnum>();
        try {
            ps = this.conn.prepareStatement(sql);
            for (int i = 0; i < param.size(); ++i) {
                ps.setObject(i + 1, param.get(i));
            }
            rs = ps.executeQuery();
            while (rs.next()) {
                DictOptionEnum bean = (DictOptionEnum)((Object)POJOUtils.generatePOJO((ResultSet)rs, DictOptionEnum.class));
                list.add(bean);
            }
        }
        catch (Exception e) {
            throw new RuntimeException("query queryDictOptionEnumList is wrong", e);
        }
        finally {
            if (ps != null) {
                try {
                    ps.close();
                }
                catch (SQLException e) {
                    logger.error(e.getMessage(), (Throwable)e);
                }
            }
        }
        return list;
    }

    public List<DictOptionEnum> queryDictOptionEnumList(final DictOptionEnum paramVO) throws Exception {
        final ArrayList param = new ArrayList();
        String sql = new ProxySQL(){
            {
                this.SELECT("*");
                this.FROM("`allinrdm_db`.dict_option_enum");
                List vals = POJOUtils.getPOJOValues((Object)((Object)paramVO));
                for (Object[] val : vals) {
                    this.WHERE(String.format("%s = ?", val[0].toString()));
                    param.add(val[1]);
                }
            }
        }.toString();
        PreparedStatement ps = null;
        ResultSet rs = null;
        ArrayList<DictOptionEnum> list = new ArrayList<DictOptionEnum>();
        try {
            ps = this.conn.prepareStatement(sql);
            for (int i = 0; i < param.size(); ++i) {
                ps.setObject(i + 1, param.get(i));
            }
            rs = ps.executeQuery();
            while (rs.next()) {
                DictOptionEnum bean = (DictOptionEnum)((Object)POJOUtils.generatePOJO((ResultSet)rs, DictOptionEnum.class));
                list.add(bean);
            }
        }
        catch (Exception e) {
            throw new RuntimeException("query queryDictOptionEnumList is wrong", e);
        }
        finally {
            if (ps != null) {
                try {
                    ps.close();
                }
                catch (SQLException e) {
                    logger.error(e.getMessage(), (Throwable)e);
                }
            }
        }
        return list;
    }

    public DictOptionEnum queryByPk(final String optionId) throws Exception {
        final ArrayList param = new ArrayList();
        String sql = new ProxySQL(){
            {
                this.SELECT("*");
                this.FROM("`allinrdm_db`.dict_option_enum");
                this.WHERE("option_id = ?");
                param.add(optionId);
            }
        }.toString();
        PreparedStatement ps = null;
        ResultSet rs = null;
        ArrayList<DictOptionEnum> list = new ArrayList<DictOptionEnum>();
        try {
            ps = this.conn.prepareStatement(sql);
            for (int i = 0; i < param.size(); ++i) {
                ps.setObject(i + 1, param.get(i));
            }
            rs = ps.executeQuery();
            while (rs.next()) {
                DictOptionEnum bean = (DictOptionEnum)((Object)POJOUtils.generatePOJO((ResultSet)rs, DictOptionEnum.class));
                list.add(bean);
            }
        }
        catch (Exception e) {
            throw new RuntimeException("query queryByPk is wrong", e);
        }
        finally {
            if (ps != null) {
                try {
                    ps.close();
                }
                catch (SQLException e) {
                    logger.error(e.getMessage(), (Throwable)e);
                }
            }
        }
        return list.isEmpty() ? null : (DictOptionEnum)((Object)list.get(0));
    }

    public List<DictOptionEnum> queryAllDictOptionByPage(DictOptionEnum paramVO) throws Exception {
        return this.queryAllDictOption(paramVO, true);
    }

    public List<DictOptionEnum> queryAllDictOption(final DictOptionEnum paramVO, boolean page) throws Exception {
        String sql;
        final List<String> objectType = Arrays.asList(ObjectType.Table.getCode(), ObjectType.Main.getCode(), ObjectType.Second.getCode());
        final ArrayList param = new ArrayList();
        String limitSql = sql = new ProxySQL(){
            {
                this.SELECT("o.dict_code, o.dict_name, e.option_id, e.option_code, e.option_name, e.dict_id, e.last_modify_user, e.last_modify_time, e.option_remarks, ifnull(e.option_enum, concat(o.dict_code, '_', e.option_code)) as option_enum");
                this.FROM("`allinrdm_db`.dict_option_enum e join `allinrdm_db`.dict_option_info o on e.dict_id = o.dict_id");
                if (StringUtils.isBlank((String)paramVO.getAppId()) && StringUtils.isBlank((String)paramVO.getBizDbName())) {
                    param.add(paramVO.getSubsId());
                    ArrayList<String> qus = new ArrayList<String>();
                    for (String val : objectType) {
                        qus.add("?");
                        param.add(val);
                    }
                    this.WHERE(String.format("o.dict_id in (\n    select dict_id from `allinrdm_db`.model_table_field f where f.object_id in (\n        select object_id from `allinrdm_db`.model_table_info where app_id in (\n            select app_id from `allinpaas_db`.paas_apps_info where subs_id = ? \n            ) and object_type in ( %s ) \n        )\n)", StringUtils.join(qus, (String)",")));
                } else if (StringUtils.isNotBlank((String)paramVO.getAppId()) && StringUtils.isBlank((String)paramVO.getBizDbName())) {
                    param.add(paramVO.getSubsId());
                    param.add(paramVO.getAppId());
                    ArrayList<String> qus = new ArrayList<String>();
                    for (String val : objectType) {
                        qus.add("?");
                        param.add(val);
                    }
                    this.WHERE(String.format("o.dict_id in (\n    select dict_id from `allinrdm_db`.model_table_field f where f.object_id in (\n        select object_id from `allinrdm_db`.model_table_info where app_id in (\n            select app_id from `allinpaas_db`.paas_apps_info where subs_id = ? and app_id = ? \n            ) and object_type in ( %s ) \n        )\n)", StringUtils.join(qus, (String)",")));
                } else if (StringUtils.isNotBlank((String)paramVO.getBizDbName()) && StringUtils.isBlank((String)paramVO.getAppId())) {
                    param.add(paramVO.getSubsId());
                    param.add(paramVO.getBizDbName());
                    ArrayList<String> qus = new ArrayList<String>();
                    for (String val : objectType) {
                        qus.add("?");
                        param.add(val);
                    }
                    this.WHERE(String.format("o.dict_id in (\n    select dict_id from `allinrdm_db`.model_table_field f where f.object_id in (\n        select object_id from `allinrdm_db`.model_table_info where app_id in (\n            select app_id from `allinpaas_db`.paas_apps_info where subs_id = ? and biz_db_name = ? \n            ) and object_type in ( %s ) \n        )\n)", StringUtils.join(qus, (String)",")));
                }
                this.ORDER_BY("o.dict_code, e.option_code");
            }
        }.toString();
        if (page) {
            this.queryTotalRecord(sql, paramVO, param);
            paramVO.checkAndSetPageInfo();
            limitSql = this.buildPageSql(paramVO, sql);
        } else {
            limitSql = sql;
        }
        PreparedStatement ps = null;
        ResultSet rs = null;
        ArrayList<DictOptionEnum> list = new ArrayList<DictOptionEnum>();
        try {
            ps = this.conn.prepareStatement(limitSql);
            for (int i = 0; i < param.size(); ++i) {
                ps.setObject(i + 1, param.get(i));
            }
            rs = ps.executeQuery();
            while (rs.next()) {
                DictOptionEnum bean = (DictOptionEnum)((Object)POJOUtils.generatePOJO((ResultSet)rs, DictOptionEnum.class));
                list.add(bean);
            }
        }
        catch (Exception e) {
            throw new RuntimeException("queryAllDictOptionByPage is wrong", e);
        }
        finally {
            if (ps != null) {
                try {
                    ps.close();
                }
                catch (SQLException e) {
                    logger.error(e.getMessage(), (Throwable)e);
                }
            }
        }
        return list;
    }
}

