/*
 * Decompiled with CFR 0.152.
 */
package com.irdstudio.allinapaas.executor.application.executor.core.dao;

import com.irdstudio.allinapaas.executor.application.executor.core.dao.domain.ModelTableIndex;
import com.irdstudio.allinapaas.executor.application.executor.core.util.db.ProxySQL;
import com.irdstudio.sdk.beans.core.util.POJOUtils;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ModelTableIndexDao {
    private static final Logger logger = LoggerFactory.getLogger(ModelTableIndexDao.class);
    Connection conn = null;

    public ModelTableIndexDao(Connection conn) {
        this.conn = conn;
    }

    public List<ModelTableIndex> queryModelTableInfos(final String appId) {
        final ArrayList param = new ArrayList();
        String sql = new ProxySQL(){
            {
                this.SELECT("*");
                this.FROM("`allinrdm_db`.model_table_index ti");
                this.WHERE("exists ( select tb.object_id from `allinrdm_db`.model_table_info tb where tb.app_id = ? and tb.object_id = ti.object_id)");
                param.add(appId);
            }
        }.toString();
        PreparedStatement ps = null;
        ResultSet rs = null;
        ArrayList<ModelTableIndex> list = new ArrayList<ModelTableIndex>();
        try {
            ps = this.conn.prepareStatement(sql);
            for (int i = 0; i < param.size(); ++i) {
                ps.setObject(i + 1, param.get(i));
            }
            rs = ps.executeQuery();
            while (rs.next()) {
                ModelTableIndex bean = (ModelTableIndex)((Object)POJOUtils.generatePOJO((ResultSet)rs, ModelTableIndex.class));
                list.add(bean);
            }
        }
        catch (Exception e) {
            throw new RuntimeException("query queryModelTableInfos is wrong", e);
        }
        return list;
    }

    public List<ModelTableIndex> queryModelTableInfoByObjectId(final String objectId) throws Exception {
        final ArrayList param = new ArrayList();
        String sql = new ProxySQL(){
            {
                this.SELECT("*");
                this.FROM("`allinrdm_db`.model_table_index");
                this.WHERE("object_id = ?");
                param.add(objectId);
            }
        }.toString();
        PreparedStatement ps = null;
        ResultSet rs = null;
        ArrayList<ModelTableIndex> list = new ArrayList<ModelTableIndex>();
        try {
            ps = this.conn.prepareStatement(sql);
            for (int i = 0; i < param.size(); ++i) {
                ps.setObject(i + 1, param.get(i));
            }
            rs = ps.executeQuery();
            while (rs.next()) {
                ModelTableIndex bean = (ModelTableIndex)((Object)POJOUtils.generatePOJO((ResultSet)rs, ModelTableIndex.class));
                list.add(bean);
            }
        }
        catch (Exception e) {
            throw new RuntimeException("query queryModelTableFieldList is wrong", e);
        }
        return list;
    }

    public boolean insert(final ModelTableIndex obj) throws SQLException {
        final ArrayList param = new ArrayList();
        String sql = new ProxySQL(){
            {
                this.INSERT_INTO("`allinrdm_db`.model_table_index");
                List vals = POJOUtils.getPOJOValues((Object)((Object)obj));
                for (Object[] val : vals) {
                    this.VALUES(val[0].toString(), "?");
                    param.add(val[1]);
                }
            }
        }.toString();
        PreparedStatement ps = null;
        Object rs = null;
        try {
            ps = this.conn.prepareStatement(sql);
            for (int i = 0; i < param.size(); ++i) {
                ps.setObject(i + 1, param.get(i));
            }
            int re = ps.executeUpdate();
            if (re == 1) {
                return true;
            }
        }
        catch (Exception e) {
            throw new RuntimeException("insert is wrong", e);
        }
        return false;
    }

    public int deleteByObjectId(final String objectId) throws SQLException {
        final ArrayList param = new ArrayList();
        String sql = new ProxySQL(){
            {
                this.DELETE_FROM("`allinrdm_db`.model_table_index");
                this.WHERE("object_id = ?");
                param.add(objectId);
            }
        }.toString();
        PreparedStatement ps = null;
        Object rs = null;
        try {
            ps = this.conn.prepareStatement(sql);
            for (int i = 0; i < param.size(); ++i) {
                ps.setObject(i + 1, param.get(i));
            }
            int re = ps.executeUpdate();
            return re;
        }
        catch (Exception e) {
            throw new RuntimeException("insert is wrong", e);
        }
    }

    public int deleteByAppId(final String appId) throws SQLException {
        final ArrayList param = new ArrayList();
        String sql = new ProxySQL(){
            {
                this.DELETE_FROM("`allinrdm_db`.model_table_index");
                this.WHERE("object_id in ( select object_id from `allinrdm_db`.model_table_info where app_id = ? )");
                param.add(appId);
            }
        }.toString();
        PreparedStatement ps = null;
        Object rs = null;
        try {
            ps = this.conn.prepareStatement(sql);
            for (int i = 0; i < param.size(); ++i) {
                ps.setObject(i + 1, param.get(i));
            }
            int re = ps.executeUpdate();
            return re;
        }
        catch (Exception e) {
            throw new RuntimeException("deleteByProjectId is wrong", e);
        }
    }
}

