/*
 * Decompiled with CFR 0.152.
 */
package com.irdstudio.allinapaas.executor.application.executor.core.plugin.builder;

import com.irdstudio.allinapaas.executor.application.executor.core.dao.BatInstBatchDao;
import com.irdstudio.allinapaas.executor.application.executor.core.dao.ModelTableIndexDao;
import com.irdstudio.allinapaas.executor.application.executor.core.dao.ModelTableInfoDao;
import com.irdstudio.allinapaas.executor.application.executor.core.dao.PaasAppsInfoDao;
import com.irdstudio.allinapaas.executor.application.executor.core.dao.SrvModelInfoDao;
import com.irdstudio.allinapaas.executor.application.executor.core.dao.SrvModelInoutDao;
import com.irdstudio.allinapaas.executor.application.executor.core.dao.domain.BatInstBatch;
import com.irdstudio.allinapaas.executor.application.executor.core.dao.domain.ModelTableInfo;
import com.irdstudio.allinapaas.executor.application.executor.core.dao.domain.PaasAppsInfo;
import com.irdstudio.allinapaas.executor.application.executor.core.dao.domain.SrvModelInfo;
import com.irdstudio.allinapaas.executor.application.executor.core.dao.domain.SrvModelInout;
import com.irdstudio.allinapaas.executor.application.executor.core.plugin.builder.AbstractBuilderPlugin;
import com.irdstudio.allinapaas.executor.application.executor.core.util.date.CurrentDateUtil;
import com.irdstudio.allinapaas.portal.console.types.YesOrNO;
import com.irdstudio.allinrdm.dam.console.types.ObjectType;
import com.irdstudio.allinrdm.dev.console.types.IOType;
import com.irdstudio.allinrdm.dev.console.types.SrvModelCatalogEnum;
import com.irdstudio.sdk.beans.core.util.MapBeanUtil;
import com.irdstudio.sdk.beans.core.util.TmModelUtil;
import com.irdstudio.sdk.beans.freemarker.bo.CodeTemplateDataBo;
import com.irdstudio.sdk.beans.freemarker.bo.ModelTableInfoBo;
import com.irdstudio.sdk.beans.freemarker.bo.TmProjectInfoBo;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.MapUtils;
import org.apache.commons.lang3.StringUtils;

public class CpnAppCodeGenPlugin
extends AbstractBuilderPlugin {
    private PaasAppsInfo appInfo = null;
    private BatInstBatch batchInst;

    @Override
    protected boolean doReadConfigureFromDB(Connection conn, String szConfIdentify) throws SQLException {
        String batchSerialNo = this.context.getSzBatchSn();
        BatInstBatchDao batInstBatchDao = new BatInstBatchDao(conn);
        this.batchInst = batInstBatchDao.queryByBatchSerialNo(batchSerialNo);
        PaasAppsInfoDao paasAppsInfoDao = new PaasAppsInfoDao(conn);
        this.appInfo = paasAppsInfoDao.queryByAppId(this.batchInst.getAppId());
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean execute() {
        this.logger.info("\u751f\u6210\u7ec4\u4ef6\u5e94\u7528\u5de5\u7a0b\u4ee3\u7801");
        boolean result = true;
        Connection conn = null;
        try {
            conn = this.getPluginConnection();
            SrvModelInfoDao srvModelInfoDao = new SrvModelInfoDao(conn);
            SrvModelInoutDao srvModelInoutDao = new SrvModelInoutDao(conn);
            ModelTableInfoDao modelTableInfoDao = new ModelTableInfoDao(conn);
            ModelTableIndexDao modelTableIndexDao = new ModelTableIndexDao(conn);
            List<ModelTableInfo> tableInfoList = modelTableInfoDao.queryModelTableInfoList(this.appInfo.getAppId());
            ArrayList<CodeTemplateDataBo> dtoList = new ArrayList<CodeTemplateDataBo>(tableInfoList.size());
            for (ModelTableInfo table : tableInfoList) {
                CodeTemplateDataBo bo = new CodeTemplateDataBo();
                TmProjectInfoBo tpib = new TmProjectInfoBo();
                tpib.setProjectId(this.appInfo.getAppCode());
                tpib.setProjectCode(this.appInfo.getAppCode());
                tpib.setProjectName(this.appInfo.getAppName());
                tpib.setProjectType(String.valueOf(table.getObjectType()));
                bo.setTmProjectInfo(tpib);
                bo.getEnvBo().setAuthor(table.getCreateUser());
                bo.getEnvBo().setCurrentDate(CurrentDateUtil.getTodayDate());
                bo.getEnvBo().setDesc(String.format("%s DTO %s-%s", this.appInfo.getAppName(), table.getObjectName(), table.getObjectCode()));
                ModelTableInfoBo tableBo = this.generateTableBO(table, conn);
                bo.setMainTableModel(tableBo);
                ObjectType objectTypeEnum = ObjectType.getType((String)table.getObjectType().toString());
                bo.getMapData().put("tableModelCode", table.getObjectCode());
                dtoList.add(bo);
            }
            for (CodeTemplateDataBo ctdb : dtoList) {
                this.wrapAppsParam(this.appInfo.getAppId(), ctdb, conn);
                String package_prefix = this.getPackagePrefix(ctdb);
                String objectType = MapUtils.getString((Map)ctdb.getMapData(), (Object)"objectType");
                this.produceCodeFile("XXXDTO.java", "XXXDTO", null, "src/main/java/" + package_prefix + "/" + CpnAppCodeGenPlugin.formatClassPath(this.appInfo.getAppCode()) + "/dto/", this.appInfo, ctdb);
            }
            ArrayList<CodeTemplateDataBo> ctdbList = new ArrayList<CodeTemplateDataBo>();
            ArrayList<CodeTemplateDataBo> ctdbInputList = new ArrayList<CodeTemplateDataBo>();
            ArrayList<CodeTemplateDataBo> ctdbOutputList = new ArrayList<CodeTemplateDataBo>();
            SrvModelInfo modelParam = new SrvModelInfo();
            modelParam.setAppId(this.appInfo.getAppId());
            List<SrvModelInfo> modelList = srvModelInfoDao.querySrvModelInfoList(modelParam, Arrays.asList(SrvModelCatalogEnum.SdkServer.getCode(), SrvModelCatalogEnum.ComponentServer.getCode(), SrvModelCatalogEnum.TradeServer.getCode(), SrvModelCatalogEnum.BackServer.getCode()));
            if (CollectionUtils.isNotEmpty(modelList)) {
                String package_prefix;
                for (SrvModelInfo srvModelInfo : modelList) {
                    ModelTableInfo tableInfo;
                    String className;
                    Map prop;
                    ArrayList<Map> properties;
                    HashMap otherFacadeImport;
                    SrvModelInout inoutParam = new SrvModelInout();
                    inoutParam.setSrvModelId(srvModelInfo.getSrvModelId());
                    inoutParam.setIoType(IOType.Input.getCode());
                    List<SrvModelInout> inputParams = srvModelInoutDao.querySrvModelInoutList(inoutParam);
                    inoutParam.setIoType(IOType.Output.getCode());
                    List<SrvModelInout> outputParams = srvModelInoutDao.querySrvModelInoutList(inoutParam);
                    CodeTemplateDataBo bo = new CodeTemplateDataBo();
                    TmProjectInfoBo tpib = new TmProjectInfoBo();
                    tpib.setProjectId(this.appInfo.getAppCode());
                    tpib.setProjectCode(this.appInfo.getAppCode());
                    tpib.setProjectName(this.appInfo.getAppName());
                    bo.setTmProjectInfo(tpib);
                    bo.getEnvBo().setAuthor(srvModelInfo.getCreateUser());
                    bo.getEnvBo().setCurrentDate(CurrentDateUtil.getTodayDate());
                    bo.getEnvBo().setDesc(String.format("%s Component %s", this.appInfo.getAppName(), srvModelInfo.getSrvModelName()));
                    Map dataMap = bo.getMapData();
                    String tableClassName = TmModelUtil.modelCodeToClassName((String)(srvModelInfo.getSrvModelCode() + "Component"));
                    String tableModelCode = TmModelUtil.propertyToField((String)StringUtils.uncapitalize((String)tableClassName));
                    dataMap.put("tableModelCode", tableModelCode);
                    dataMap.put("tableClassName", tableClassName);
                    HashMap<String, String> method = new HashMap<String, String>();
                    dataMap.put("method", method);
                    if (StringUtils.isNotBlank((CharSequence)srvModelInfo.getSrvModelMethod())) {
                        method.put("methodName", srvModelInfo.getSrvModelMethod());
                    } else {
                        method.put("methodName", "handle");
                    }
                    if (CollectionUtils.isNotEmpty(inputParams) && inputParams.size() == 1) {
                        String className2 = inputParams.get(0).getTableModelCode();
                        className2 = TmModelUtil.tableCodeToClassName((String)className2);
                        method.put("input", className2);
                        method.put("inputListFlag", inputParams.get(0).getListFlag());
                    } else if (CollectionUtils.isNotEmpty(inputParams) && inputParams.size() > 1) {
                        method.put("input", MapUtils.getString((Map)dataMap, (Object)"tableClassName") + "ComponentInput");
                        method.put("inputListFlag", YesOrNO.NO.getCode());
                        otherFacadeImport = new HashMap();
                        CodeTemplateDataBo inputBo = new CodeTemplateDataBo();
                        inputBo.setTmProjectInfo(tpib);
                        inputBo.getEnvBo().setAuthor(srvModelInfo.getCreateUser());
                        inputBo.getEnvBo().setCurrentDate(CurrentDateUtil.getTodayDate());
                        inputBo.getEnvBo().setDesc(String.format("%s Component DTO %s", this.appInfo.getAppName(), srvModelInfo.getSrvModelName()));
                        inputBo.getMapData().put("tableModelCode", tableModelCode);
                        inputBo.getMapData().put("tableClassName", tableClassName);
                        properties = new ArrayList<Map>();
                        inputBo.getMapData().put("properties", properties);
                        for (SrvModelInout inout : inputParams) {
                            prop = MapBeanUtil.beanToMap((Object)((Object)inout));
                            className = TmModelUtil.tableCodeToClassName((String)inout.getTableModelCode());
                            prop.put("className", className);
                            prop.put("propName", StringUtils.uncapitalize((String)className));
                            tableInfo = modelTableInfoDao.queryModelTableInfo(inout.getTableModelId());
                            prop.put("import", "Y");
                            properties.add(prop);
                        }
                        inputBo.getMapData().put("otherFacadeImport", otherFacadeImport.values());
                        ctdbInputList.add(inputBo);
                    }
                    if (CollectionUtils.isNotEmpty(outputParams) && outputParams.size() == 1) {
                        String className2 = outputParams.get(0).getTableModelCode();
                        className2 = TmModelUtil.tableCodeToClassName((String)className2);
                        method.put("output", className2);
                        method.put("outputListFlag", outputParams.get(0).getListFlag());
                    } else if (CollectionUtils.isNotEmpty(outputParams) && outputParams.size() > 1) {
                        method.put("output", MapUtils.getString((Map)dataMap, (Object)"tableClassName") + "ComponentOutput");
                        method.put("outputListFlag", YesOrNO.NO.getCode());
                        otherFacadeImport = new HashMap();
                        CodeTemplateDataBo outputBo = new CodeTemplateDataBo();
                        outputBo.setTmProjectInfo(tpib);
                        outputBo.getEnvBo().setAuthor(srvModelInfo.getCreateUser());
                        outputBo.getEnvBo().setCurrentDate(CurrentDateUtil.getTodayDate());
                        outputBo.getEnvBo().setDesc(String.format("%s Component DTO %s", this.appInfo.getAppName(), srvModelInfo.getSrvModelName()));
                        outputBo.getMapData().put("tableModelCode", tableModelCode);
                        outputBo.getMapData().put("tableClassName", tableClassName);
                        properties = new ArrayList();
                        outputBo.getMapData().put("properties", properties);
                        for (SrvModelInout inout : outputParams) {
                            prop = MapBeanUtil.beanToMap((Object)((Object)inout));
                            className = TmModelUtil.tableCodeToClassName((String)inout.getTableModelCode());
                            prop.put("className", className);
                            prop.put("propName", StringUtils.uncapitalize((String)className));
                            tableInfo = modelTableInfoDao.queryModelTableInfo(inout.getTableModelId());
                            prop.put("import", "Y");
                            properties.add(prop);
                        }
                        outputBo.getMapData().put("otherFacadeImport", otherFacadeImport.values());
                        ctdbOutputList.add(outputBo);
                    }
                    ctdbList.add(bo);
                }
                String appCode = this.appInfo.getAppCode();
                for (CodeTemplateDataBo ctdb : ctdbList) {
                    this.wrapAppsParam(this.appInfo.getAppId(), ctdb, conn);
                    package_prefix = this.getPackagePrefix(ctdb);
                    this.produceCodeFile("XXXOsrvAppService.java", "XXXOsrvAppService", null, "src/main/java/" + package_prefix + "/" + CpnAppCodeGenPlugin.formatClassPath(appCode).replaceAll("_|-", ".") + "/", this.appInfo, ctdb);
                }
                for (CodeTemplateDataBo ctdb : ctdbInputList) {
                    this.wrapAppsParam(this.appInfo.getAppId(), ctdb, conn);
                    package_prefix = this.getPackagePrefix(ctdb);
                    this.produceCodeFile("XXXOsrvAppServiceInput.java", "XXXOsrvAppServiceInput", null, "src/main/java/" + package_prefix + "/" + CpnAppCodeGenPlugin.formatClassPath(appCode).replaceAll("_|-", ".") + "/dto/", this.appInfo, ctdb);
                }
                for (CodeTemplateDataBo ctdb : ctdbOutputList) {
                    this.wrapAppsParam(this.appInfo.getAppId(), ctdb, conn);
                    package_prefix = this.getPackagePrefix(ctdb);
                    this.produceCodeFile("XXXOsrvAppServiceOutput.java", "XXXOsrvAppServiceOutput", null, "src/main/java/" + package_prefix + "/" + CpnAppCodeGenPlugin.formatClassPath(appCode).replaceAll("_|-", ".") + "/dto/", this.appInfo, ctdb);
                }
            }
            CodeTemplateDataBo pomBo = new CodeTemplateDataBo();
            TmProjectInfoBo tmProjectInfoBo = new TmProjectInfoBo();
            tmProjectInfoBo.setProjectId(this.appInfo.getAppCode());
            tmProjectInfoBo.setProjectCode(this.appInfo.getAppCode());
            tmProjectInfoBo.setProjectName(this.appInfo.getAppName());
            pomBo.setTmProjectInfo(tmProjectInfoBo);
            this.wrapAppsParam(this.appInfo.getAppId(), pomBo, conn);
            String package_prefix = this.getPackagePrefix(pomBo);
            this.produceCodeFile("pom.xml", "", "", null, "", this.appInfo, pomBo);
        }
        catch (Exception e) {
            this.logger.error("\u751f\u6210 \u7ec4\u4ef6\u5e94\u7528\u5de5\u7a0b\u4ee3\u7801\u9519\u8bef", e);
            result = false;
        }
        finally {
            if (conn != null) {
                this.closePluginConnection(conn);
            }
        }
        return result;
    }
}

