/*
 * Decompiled with CFR 0.152.
 */
package com.irdstudio.allinapaas.executor.application.executor.core.plugin.check;

import com.irdstudio.allinapaas.executor.application.executor.core.dao.domain.AppsCheckLog;
import com.irdstudio.allinapaas.executor.application.executor.core.plugin.check.AbstractCheckPlugin;
import com.irdstudio.allinapaas.portal.console.types.YesOrNO;
import com.irdstudio.allinapaas.quality.console.types.CheckResult;
import com.irdstudio.allinrdm.dev.console.facade.PageModelInfoService;
import com.irdstudio.allinrdm.dev.console.facade.PageModelParamService;
import com.irdstudio.allinrdm.dev.console.facade.dto.PageModelInfoDTO;
import com.irdstudio.allinrdm.dev.console.facade.dto.PageModelParamDTO;
import com.irdstudio.sdk.beans.core.util.SpringContextUtils;
import java.sql.Connection;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.MapUtils;
import org.apache.commons.lang3.StringUtils;

public class PageModelCheckPlugin
extends AbstractCheckPlugin {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean execute() {
        boolean flag = true;
        Connection conn = null;
        try {
            conn = this.getPluginConnection();
            String pageModelId = MapUtils.getString((Map)this.extParam, (Object)"pageModelId");
            conn = this.getPluginConnection();
            PageModelInfoService pageModelInfoService = (PageModelInfoService)SpringContextUtils.getBean(PageModelInfoService.class);
            PageModelInfoDTO param = new PageModelInfoDTO();
            param.setAppId(this.appInfo.getAppId());
            if (StringUtils.isNotBlank((CharSequence)pageModelId)) {
                param.setPageModelId(pageModelId);
            }
            param.setSize(Integer.valueOf(1000));
            List checkList = pageModelInfoService.queryList((Object)param);
            for (PageModelInfoDTO modelInfo : checkList) {
                this.checkPageModelInfo(modelInfo, conn);
            }
        }
        catch (Exception e) {
            this.logger.error("\u524d\u7aef\u9875\u9762\u6a21\u578b\u6821\u9a8c\u5931\u8d25" + e.getMessage(), e);
            flag = false;
        }
        finally {
            if (conn != null) {
                this.closePluginConnection(conn);
            }
        }
        return flag;
    }

    public void checkPageModelInfo(PageModelInfoDTO modelInfo, Connection conn) throws Exception {
        PageModelParamService pageModelParamService = (PageModelParamService)SpringContextUtils.getBean(PageModelParamService.class);
        PageModelParamDTO modelParam = new PageModelParamDTO();
        modelParam.setPageModelId(modelInfo.getPageModelId());
        modelParam.setNeedState(YesOrNO.YES.getCode());
        List paramList = pageModelParamService.queryList((Object)modelParam);
        if (CollectionUtils.isNotEmpty((Collection)paramList)) {
            for (PageModelParamDTO param : paramList) {
                if (!StringUtils.equals((CharSequence)param.getNeedState(), (CharSequence)YesOrNO.YES.getCode()) || !StringUtils.isBlank((CharSequence)param.getParamValue())) continue;
                AppsCheckLog checkLog = new AppsCheckLog();
                checkLog.setCheckRuleId("R3001");
                checkLog.setCheckResult(CheckResult.Fail.getCode());
                checkLog.setCheckDesc(String.format("%s %s %s \u53c2\u6570\u662f\u5fc5\u586b\u9879\u53c2\u6570\uff0c\u4e0d\u80fd\u4e3a\u7a7a", modelInfo.getPageModelName(), modelInfo.getPageModelCode(), param.getParamCode()));
                this.saveAppsCheckLog(checkLog, conn);
            }
        }
    }
}

