/*
 * Decompiled with CFR 0.152.
 */
package com.irdstudio.allinapaas.executor.application.executor.core.plugin.dataexport;

import com.irdstudio.allinapaas.executor.application.executor.core.plugin.dataexport.PluginExportConf;
import com.irdstudio.allinapaas.executor.application.executor.core.tinycore.jdbc.executor.SafeReleaseUtil;
import com.irdstudio.allinapaas.executor.application.executor.core.tinycore.log.ILogger;
import com.irdstudio.allinapaas.executor.application.executor.core.util.pub.PathUtil;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.Statement;
import org.apache.commons.lang3.StringUtils;

public class DataExportExecutor {
    private Connection exportConn = null;
    private PluginExportConf exportConf = null;
    private ILogger logger = null;

    public DataExportExecutor(PluginExportConf exportConf, Connection conn, ILogger logger) {
        this.exportConn = conn;
        this.exportConf = exportConf;
        this.logger = logger;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean run() {
        boolean flag;
        block19: {
            flag = true;
            this.logger.info("\u7ebf\u7a0b[" + Thread.currentThread().getName() + "],begin export........................");
            Statement st = null;
            ResultSet rs = null;
            OutputStreamWriter fos = null;
            try {
                st = this.exportConn.createStatement();
                st.setMaxRows(0);
                st.setFetchSize(Integer.MIN_VALUE);
                rs = "01".equals(this.exportConf.getExportMode()) ? st.executeQuery("SELECT * FROM " + this.exportConf.getExportTarget()) : st.executeQuery(this.exportConf.getExportTarget());
                ResultSetMetaData rsmd = rs.getMetaData();
                String localFileName = this.exportConf.getExportToFile();
                localFileName = localFileName.replace('\\', '/');
                String fileDir = localFileName.substring(0, localFileName.lastIndexOf("/"));
                if (!new File(fileDir).isDirectory()) {
                    PathUtil.checkAndCreate(fileDir);
                    if (!new File(fileDir).isDirectory()) {
                        this.logger.info("\u521b\u5efa\u672c\u5730\u6587\u4ef6\u5939[" + fileDir + "]\u5931\u8d25");
                        throw new Exception("\u521b\u5efa\u672c\u5730\u6587\u4ef6\u5939[" + fileDir + "]\u5931\u8d25");
                    }
                }
                fos = new FileWriter(this.exportConf.getExportToFile());
                int numCols = rsmd.getColumnCount();
                for (int i = 1; i <= numCols; ++i) {
                    this.logger.info("\u5b57\u6bb5\u540d:" + rsmd.getColumnLabel(i));
                }
                int iCount = 0;
                while (rs.next()) {
                    for (int i = 1; i <= numCols; ++i) {
                        String formatStr = this.formatString(rs.getString(i));
                        if ("Y".equals(this.exportConf.getIsDealEmptyStr()) && StringUtils.isEmpty((CharSequence)formatStr)) {
                            formatStr = this.exportConf.getDealEmptyStr();
                        }
                        fos.write(formatStr + this.exportConf.getFieldSeparator());
                    }
                    fos.write("\r\n");
                    ++iCount;
                }
                this.logger.info("\u7ebf\u7a0b[" + Thread.currentThread().getName() + "]\u5bfc\u51fa\u8bb0\u5f55\u603b\u6570:" + iCount);
                SafeReleaseUtil.close(rs);
            }
            catch (Exception e) {
                this.logger.error("\u5bfc\u51fa\u51fa\u9519", e);
                flag = false;
                break block19;
            }
            finally {
                SafeReleaseUtil.close(rs);
                SafeReleaseUtil.close(st);
                if (fos != null) {
                    try {
                        fos.close();
                    }
                    catch (IOException e) {
                        this.logger.error("\u5173\u95ed\u8d44\u6e90\u51fa\u9519", e);
                    }
                }
            }
            SafeReleaseUtil.close(st);
            if (fos != null) {
                try {
                    fos.close();
                }
                catch (IOException e) {
                    this.logger.error("\u5173\u95ed\u8d44\u6e90\u51fa\u9519", e);
                }
            }
        }
        return flag;
    }

    private String formatString(String string) {
        if (string == null) {
            return "";
        }
        return string.replaceAll("[\\n\\r]", "");
    }
}

