/*
 * Decompiled with CFR 0.152.
 */
package com.irdstudio.allinapaas.executor.application.executor.core.plugin.deploy;

import com.irdstudio.allinapaas.executor.application.executor.core.dao.BatInstBatchDao;
import com.irdstudio.allinapaas.executor.application.executor.core.dao.PaasAppsInfoDao;
import com.irdstudio.allinapaas.executor.application.executor.core.dao.PaasAppsParamDao;
import com.irdstudio.allinapaas.executor.application.executor.core.dao.PaasDeployInfoDao;
import com.irdstudio.allinapaas.executor.application.executor.core.dao.PaasEcsInfoDao;
import com.irdstudio.allinapaas.executor.application.executor.core.dao.PaasEnvParamDao;
import com.irdstudio.allinapaas.executor.application.executor.core.dao.domain.BatInstBatch;
import com.irdstudio.allinapaas.executor.application.executor.core.dao.domain.PaasAppsInfo;
import com.irdstudio.allinapaas.executor.application.executor.core.dao.domain.PaasAppsParam;
import com.irdstudio.allinapaas.executor.application.executor.core.dao.domain.PaasDeployInfo;
import com.irdstudio.allinapaas.executor.application.executor.core.dao.domain.PaasEcsInfo;
import com.irdstudio.allinapaas.executor.application.executor.core.dao.domain.PaasEnvParam;
import com.irdstudio.allinapaas.executor.application.executor.core.plugin.AbstractPlugin;
import com.irdstudio.allinapaas.executor.application.executor.core.plugin.apps.SdEnvUtil;
import com.irdstudio.allinapaas.executor.application.executor.core.util.date.CurrentDateUtil;
import com.irdstudio.allintpaas.sdk.sequence.facade.operation.SeqInstInfoService;
import com.irdstudio.sdk.beans.core.util.KeyUtil;
import com.irdstudio.sdk.beans.core.util.SpringContextUtils;
import com.irdstudio.sdk.beans.ssh.io.SSHOutputPrinter;
import com.irdstudio.sdk.beans.ssh.utils.RemoteSSHClient;
import java.io.File;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;

public class AppJarDeployPlugin
extends AbstractPlugin {
    private PaasAppsInfo appInfo = null;
    protected SSHOutputPrinter sshPrinter = new SSHOutputPrinter(){

        public void print(String line) {
            if (AppJarDeployPlugin.this.logger != null) {
                AppJarDeployPlugin.this.logger.info(line);
            } else {
                System.out.println(line);
            }
        }

        public void printError(String line) {
            if (AppJarDeployPlugin.this.logger != null) {
                AppJarDeployPlugin.this.logger.error(line);
            } else {
                System.err.println(line);
            }
        }
    };

    @Override
    protected boolean doReadConfigureFromDB(Connection conn, String szConfIdentify) throws SQLException {
        String batchSerialNo = this.context.getSzBatchSn();
        PaasAppsInfoDao paasAppsInfoDao = new PaasAppsInfoDao(conn);
        this.appInfo = paasAppsInfoDao.queryByBatchSerialNo(batchSerialNo);
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean execute() {
        this.logger.info("\u90e8\u7f72JAR\u5e94\u7528\u670d\u52a1\u5668\uff0c\u90e8\u7f72\u5e94\u7528:" + this.appInfo.getAppCode());
        Connection conn = null;
        try {
            PaasEnvParamDao paasEnvParamDao;
            PaasEnvParam loggingFile;
            conn = this.getPluginConnection();
            BatInstBatchDao batInstBatchDao = new BatInstBatchDao(conn);
            BatInstBatch batInstBatch = batInstBatchDao.queryByBatchSerialNo(this.context.getSzBatchSn());
            String currEnvId = batInstBatch.getEnvId();
            PaasDeployInfoDao paasDeployInfoDao = new PaasDeployInfoDao(conn);
            PaasEcsInfoDao paasEcsInfoDao = new PaasEcsInfoDao(conn);
            PaasEcsInfo ecsParam = new PaasEcsInfo();
            PaasAppsParamDao paasAppsParamDao = new PaasAppsParamDao(conn);
            PaasAppsParam moduleParam = paasAppsParamDao.queryPaasAppsParamByCode(this.appInfo.getAppId(), "module");
            PaasAppsParam jvmOpsParam = paasAppsParamDao.queryPaasAppsParamByCode(this.appInfo.getAppId(), "jvm");
            String jvmOps = "-Xms128M -Xmx1024M -XX:PermSize=2048m -XX:MaxPermSize=2048m";
            if (jvmOpsParam != null && StringUtils.isNotBlank((String)jvmOpsParam.getParamValue())) {
                jvmOps = jvmOpsParam.getParamValue();
            }
            if ((loggingFile = (paasEnvParamDao = new PaasEnvParamDao(conn)).queryByCode("logging_path", currEnvId)) == null) {
                loggingFile = new PaasEnvParam();
                loggingFile.setParamCode("logging_path");
                loggingFile.setEnvId(currEnvId);
                loggingFile.setParamValue("/var/tmp/logs/");
            }
            PaasEnvParam deployRoot = paasEnvParamDao.queryByCode("deploy_root", currEnvId);
            String deployRootDir = deployRoot.getParamValue();
            ecsParam.setSubsId(this.appInfo.getSubsId());
            ecsParam.setAppId(this.appInfo.getAppId());
            ecsParam.setEnvId(currEnvId);
            List<PaasEcsInfo> ecsList = paasEcsInfoDao.queryPaasEcsInfo(ecsParam);
            for (PaasEcsInfo paasEcsInfo : ecsList) {
                String appCode;
                String rootPath;
                File jarFile;
                this.logger.info(String.format("\u5f00\u59cb\u90e8\u7f72\u5e94\u7528%s\u5230\u670d\u52a1\u5668%s,\u7aef\u53e3%s", paasEcsInfo.getAppName(), paasEcsInfo.getEcsIp(), paasEcsInfo.getEcsPort()));
                RemoteSSHClient sshClient = new RemoteSSHClient(paasEcsInfo.getEcsIp(), paasEcsInfo.getEcsLoginUser(), paasEcsInfo.getEcsLoginPwd());
                boolean loginFlag = sshClient.connect();
                if (!loginFlag) {
                    this.logger.error("\u767b\u9646\u670d\u52a1\u5668\u5931\u8d25");
                    boolean bl = loginFlag;
                    return bl;
                }
                String opsPath = SdEnvUtil.getTemplateScriptPath(this.appInfo);
                if (StringUtils.isBlank((String)opsPath)) {
                    this.logger.error("\u65e0\u6cd5\u83b7\u53d6\u8fd0\u7ef4\u6a21\u677f\u6240\u5728\u76ee\u5f55\uff0c\u8bf7\u68c0\u67e5\u8fd0\u7ef4\u6a21\u677f\u4ed3\u5e93\u914d\u7f6e");
                    boolean bl = false;
                    return bl;
                }
                String localAgentPath = opsPath + File.separator;
                if (!sshClient.fileExists(deployRootDir)) {
                    sshClient.executeCommand("mkdir -p " + deployRootDir, this.sshPrinter);
                    sshClient.upload(localAgentPath + "startJarApp.sh", deployRootDir);
                    sshClient.executeCommand("chmod 777 " + deployRootDir + "/startJarApp.sh", this.sshPrinter);
                }
                if (!sshClient.fileExists(deployRootDir + "/startJarApp.sh")) {
                    sshClient.upload(localAgentPath + "startJarApp.sh", deployRootDir);
                    sshClient.executeCommand("chmod 777 " + deployRootDir + "/startJarApp.sh", this.sshPrinter);
                }
                if ((jarFile = this.searchTargetJarFile(rootPath = SdEnvUtil.BUILD_PATH, appCode = SdEnvUtil.wrapperAppCode(this.appInfo.getAppCode()), moduleParam)) == null || !jarFile.exists()) {
                    this.logger.error("\u83b7\u53d6\u4e0d\u5230jar " + rootPath + File.separator + appCode);
                    boolean bl = false;
                    return bl;
                }
                String startModelName = jarFile.getName().substring(0, jarFile.getName().length() - 4);
                this.logger.info("\u672c\u5730jar\u5305: " + jarFile.getAbsolutePath());
                sshClient.upload(jarFile.getAbsolutePath(), deployRootDir);
                this.logger.info("\u6267\u884c\u547d\u4ee4 " + deployRootDir + String.format("/startJarApp.sh %s '%s' %s %s", startModelName, jvmOps, currEnvId, paasEcsInfo.getEcsPort()));
                int status = sshClient.executeCommand("cd " + deployRootDir + String.format(" && bash ./startJarApp.sh  %s '%s' %s %s", startModelName, jvmOps, currEnvId, paasEcsInfo.getEcsPort()), this.sshPrinter);
                if (status != 0) {
                    this.logger.info("\u6267\u884c\u53d1\u5e03\u547d\u4ee4 /agent/startJarApp.sh \u72b6\u6001 " + status);
                    boolean bl = false;
                    return bl;
                }
                if (conn.isClosed()) {
                    this.closePluginConnection(conn);
                    conn = this.getPluginConnection();
                    paasDeployInfoDao = new PaasDeployInfoDao(conn);
                }
                this.updateDeployPath(currEnvId, this.appInfo, paasEcsInfo, deployRootDir + "/" + startModelName + ".jar", loggingFile, paasDeployInfoDao);
            }
            PaasAppsInfoDao paasAppsInfoDao = new PaasAppsInfoDao(conn);
            this.appInfo.setAppActionState("DPL");
            if (StringUtils.isNotBlank((String)this.appInfo.getAppVersion())) {
                String version = this.appInfo.getAppVersion();
                Object[] versions = StringUtils.split((String)version, (String)".");
                versions[versions.length - 1] = String.valueOf(Integer.valueOf(versions[versions.length - 1]) + 1);
                version = StringUtils.join((Object[])versions, (String)".");
                this.appInfo.setAppVersion(version);
            } else {
                this.appInfo.setAppVersion("0.0.1");
            }
            paasAppsInfoDao.updateByPk(this.appInfo);
        }
        catch (Exception e) {
            this.logger.error(e.getMessage(), e);
            boolean bl = false;
            return bl;
        }
        finally {
            if (conn != null) {
                this.closePluginConnection(conn);
            }
        }
        return true;
    }

    private File searchTargetJarFile(String rootPath, String appCode, PaasAppsParam moduleParam) {
        String targetModule;
        File targetFile;
        File targetDir = new File(rootPath + File.separator + appCode + File.separator);
        if (moduleParam != null && StringUtils.isNotBlank((String)moduleParam.getParamValue()) && (targetFile = new File(targetDir, (targetModule = moduleParam.getParamValue()) + File.separator + "target" + File.separator + targetModule + ".jar")).exists() && targetFile.isFile()) {
            return targetFile;
        }
        File jarFile = null;
        if (targetDir.exists() && targetDir.isDirectory()) {
            File[] moduleFiles;
            for (File f : moduleFiles = targetDir.listFiles()) {
                File[] jarFiles;
                if (!f.isDirectory()) continue;
                String name = f.getName();
                if (name.startsWith(appCode)) {
                    File[] jarFiles2;
                    File buildTargetF = new File(f, "target");
                    if (!buildTargetF.exists()) continue;
                    File[] fileArray = jarFiles2 = buildTargetF.listFiles();
                    int n = fileArray.length;
                    for (int i = 0; i < n; ++i) {
                        File jarF = fileArray[i];
                        if (!jarF.isFile() || !jarF.getName().endsWith(".jar.original")) continue;
                        jarFile = new File(jarF.getParentFile(), jarF.getName().substring(0, jarF.getName().length() - 9));
                        return jarFile;
                    }
                    continue;
                }
                if (!name.equals("target")) continue;
                for (File jarF : jarFiles = f.listFiles()) {
                    if (!jarF.isFile() || !jarF.getName().endsWith(".jar.original")) continue;
                    jarFile = new File(jarF.getParentFile(), jarF.getName().substring(0, jarF.getName().length() - 9));
                    return jarFile;
                }
            }
        } else {
            this.logger.error("\u5e94\u7528\u7f16\u8bd1\u76ee\u5f55\u4e0d\u5b58\u5728 " + targetDir.getAbsolutePath());
            return null;
        }
        return null;
    }

    private void updateDeployPath(String envId, PaasAppsInfo appInfo, PaasDeployInfo ecs, String deployPath, PaasDeployInfoDao paasDeployInfoDao) throws Exception {
        PaasDeployInfo deployParam = new PaasDeployInfo();
        deployParam.setAppId(appInfo.getAppId());
        deployParam.setEcsId(ecs.getEcsId());
        deployParam.setEnvId(envId);
        List<PaasDeployInfo> deployList = paasDeployInfoDao.queryAllByCondition(deployParam);
        if (CollectionUtils.isNotEmpty(deployList)) {
            PaasDeployInfo deploy = deployList.get(0);
            deploy.setAppDeployPath(deployPath);
            deploy.setAppState("R");
            paasDeployInfoDao.updateByPk(deploy);
        }
    }

    private void updateDeployPath(String envId, PaasAppsInfo appInfo, PaasEcsInfo ecs, String deployPath, PaasEnvParam loggingFile, PaasDeployInfoDao paasDeployInfoDao) throws Exception {
        boolean flag = true;
        PaasDeployInfo deployInfo = paasDeployInfoDao.queryByAppId(appInfo.getAppId(), envId);
        if (deployInfo == null) {
            deployInfo = new PaasDeployInfo();
            flag = false;
            SeqInstInfoService seqService = (SeqInstInfoService)SpringContextUtils.getBean(SeqInstInfoService.class);
            deployInfo.setAppDeployId(seqService.nextSequence("PAAS-INST-ID", appInfo.getSubsId()));
        }
        deployInfo.setAppDeployId(KeyUtil.createUUIDKey());
        deployInfo.setSubsId(appInfo.getSubsId());
        deployInfo.setAppId(appInfo.getAppId());
        deployInfo.setAppName(appInfo.getAppCode());
        deployInfo.setAppCnname(appInfo.getAppName());
        deployInfo.setAppVersion(appInfo.getAppVersion());
        deployInfo.setAppType(appInfo.getAppType());
        String appCode = SdEnvUtil.wrapperAppCode(this.appInfo.getAppCode());
        deployInfo.setAppLogPath(loggingFile.getParamValue() + appCode);
        deployInfo.setAppDeployPath(deployPath);
        deployInfo.setEnvId(envId);
        deployInfo.setAppOrder(0);
        deployInfo.setEcsId(ecs.getEcsId());
        deployInfo.setEcsIp(ecs.getEcsIp());
        deployInfo.setEcsName(ecs.getEcsName());
        deployInfo.setEcsRegion(ecs.getEcsRegionId());
        deployInfo.setAppPort(ecs.getEcsPort());
        deployInfo.setAppState("R");
        deployInfo.setOperUserid("admin");
        deployInfo.setOperTime(CurrentDateUtil.getTodayDateEx2());
        if (flag) {
            paasDeployInfoDao.updateByPk(deployInfo);
        } else {
            paasDeployInfoDao.insertPaasDeployInfo(deployInfo);
        }
    }
}

