/*
 * Decompiled with CFR 0.152.
 */
package com.irdstudio.allinapaas.executor.application.executor.core.plugin.devops.git;

import com.irdstudio.allinapaas.executor.application.executor.core.dao.BatInstBatchDao;
import com.irdstudio.allinapaas.executor.application.executor.core.dao.PaasAppsInfoDao;
import com.irdstudio.allinapaas.executor.application.executor.core.dao.PaasEnvParamDao;
import com.irdstudio.allinapaas.executor.application.executor.core.dao.SUserProfileDao;
import com.irdstudio.allinapaas.executor.application.executor.core.dao.domain.BatInstBatch;
import com.irdstudio.allinapaas.executor.application.executor.core.dao.domain.PaasAppsInfo;
import com.irdstudio.allinapaas.executor.application.executor.core.dao.domain.SUserProfile;
import com.irdstudio.allinapaas.executor.application.executor.core.plugin.AbstractPlugin;
import com.irdstudio.allinapaas.executor.application.executor.core.plugin.apps.SdEnvUtil;
import com.irdstudio.allinapaas.executor.application.executor.core.plugin.devops.git.PluginGitConf;
import com.irdstudio.allinapaas.executor.application.executor.core.plugin.git.JGitUtil;
import com.irdstudio.allinapaas.executor.application.executor.core.plugin.git.TerminalExecUtil;
import java.io.File;
import java.io.IOException;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.Map;
import org.apache.commons.collections.MapUtils;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang3.StringUtils;

public class TdpGitPlugin
extends AbstractPlugin {
    private PaasAppsInfo appInfo = null;
    private BatInstBatch batchInst;
    private Map<String, Object> extParam = null;
    private PluginGitConf pluginParam = null;
    private String gitLocalPath = null;

    public boolean repositoryCreate(String localPath, String remotePath, String username, String password, String branchName) {
        if (TerminalExecUtil.isWindows()) {
            JGitUtil.shallowClone(localPath, remotePath, username, password, branchName, this.logger::info);
            return true;
        }
        JGitUtil jGitUtil = new JGitUtil(localPath, remotePath, username, password);
        try {
            jGitUtil.pull(branchName);
        }
        catch (Exception e) {
            try {
                jGitUtil.cloneBranch(branchName);
            }
            catch (Exception e1) {
                jGitUtil.close();
                File localRepoFile = new File(localPath);
                if (localRepoFile.exists()) {
                    FileUtils.deleteQuietly((File)localRepoFile);
                }
                try {
                    jGitUtil = new JGitUtil(localPath, remotePath, username, password);
                    jGitUtil.cloneBranch(branchName);
                }
                catch (Exception e2) {
                    this.logger.error("git \u62c9\u53d6\u4ed3\u5e93\u5931\u8d25" + e2.getMessage(), e2);
                    e2.printStackTrace();
                    return false;
                }
            }
        }
        jGitUtil.close();
        return true;
    }

    @Override
    protected boolean doReadConfigureFromDB(Connection connection, String s) throws SQLException {
        String batchSerialNo = this.context.getSzBatchSn();
        PaasAppsInfoDao paasAppsInfoDao = new PaasAppsInfoDao(connection);
        PaasEnvParamDao paasEnvParamDao = new PaasEnvParamDao(connection);
        BatInstBatchDao batInstBatchDao = new BatInstBatchDao(connection);
        this.batchInst = batInstBatchDao.queryByBatchSerialNo(batchSerialNo);
        this.extParam = batInstBatchDao.getExtParam(this.batchInst);
        this.appInfo = paasAppsInfoDao.queryByAppId(this.batchInst.getAppId());
        SUserProfileDao sUserProfileDao = new SUserProfileDao(connection);
        String currentUserId = MapUtils.getString(this.extParam, (Object)"createUserId");
        SUserProfile userProfile = sUserProfileDao.queryByPk(currentUserId);
        if (userProfile == null || StringUtils.isBlank((CharSequence)userProfile.getGitUsername()) || !StringUtils.isNotBlank((CharSequence)userProfile.getGitPassword()) && !StringUtils.isNotBlank((CharSequence)userProfile.getGitAccessToken())) {
            this.logger.error("\u8bf7\u5728\u4e2a\u4eba\u8bbe\u7f6e\u5173\u8054git\u8d26\u53f7\u4fe1\u606f\uff01");
            return false;
        }
        this.pluginParam = new PluginGitConf();
        this.pluginParam.setGitUserName(userProfile.getGitUsername());
        if (StringUtils.isNotBlank((CharSequence)userProfile.getGitAccessToken())) {
            this.pluginParam.setGitPassword(userProfile.getGitAccessToken());
        } else {
            this.pluginParam.setGitPassword(userProfile.getGitPassword());
        }
        this.pluginParam.setGitBranchName(paasEnvParamDao.queryByCodeReturnValue("git.push.branch.name"));
        this.pluginParam.setGitRemotePath(this.appInfo.getAppGitUrl());
        this.gitLocalPath = SdEnvUtil.BUILD_PATH;
        if (this.pluginParam == null || this.gitLocalPath == null) {
            this.context.setSzLastErrorMsg("\u672a\u8bfb\u53d6\u5230\u914d\u7f6e\u6807\u8bc6\u4e3a\uff1a" + s + "\u7684\u6570\u636eGit\u914d\u7f6e!");
            return false;
        }
        return true;
    }

    @Override
    public boolean execute() {
        this.logger.info("........................................................................");
        boolean flag = true;
        if (this.gitLocalPath != null) {
            String project_path = this.gitLocalPath + SdEnvUtil.wrapperAppCode(this.appInfo.getAppCode());
            try {
                FileUtils.deleteDirectory((File)new File(project_path));
            }
            catch (IOException e) {
                this.logger.error("\u5220\u9664\u65e7\u76ee\u5f55\u5f02\u5e38 " + project_path, e);
            }
            flag = this.repositoryCreate(project_path, this.pluginParam.getGitRemotePath(), this.pluginParam.getGitUserName(), this.pluginParam.getGitPassword(), this.pluginParam.getGitBranchName());
            if (flag) {
                this.logger.info("\u4ee3\u7801\u66f4\u65b0\u6210\u529f\uff0c\u672c\u5730\u66f4\u65b0\u8def\u5f84:" + this.gitLocalPath + "\n\u8fdc\u7a0b\u8def\u5f84\u4e3a\uff1a" + this.pluginParam.getGitRemotePath());
            } else {
                this.logger.info("\u4ee3\u7801\u66f4\u65b0\u5931\u8d25\uff0c\u672c\u5730\u66f4\u65b0\u8def\u5f84:" + this.gitLocalPath + "\n\u8fdc\u7a0b\u8def\u5f84\u4e3a\uff1a" + this.pluginParam.getGitRemotePath());
            }
            return flag;
        }
        return false;
    }
}

