/*
 * Decompiled with CFR 0.152.
 */
package com.irdstudio.allinapaas.executor.application.executor.core.plugin.docs;

import com.alibaba.fastjson.JSON;
import com.irdstudio.allinapaas.executor.application.executor.core.dao.PaasEcsInfoDao;
import com.irdstudio.allinapaas.executor.application.executor.core.dao.domain.PaasEcsInfo;
import com.irdstudio.allinapaas.executor.application.executor.core.dao.domain.WikiSubsPage;
import com.irdstudio.allinapaas.executor.application.executor.core.plugin.AbstractPlugin;
import java.sql.Connection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.MapUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.client.HttpClient;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.util.EntityUtils;

public abstract class DocAbstractPlugin
extends AbstractPlugin {
    public static final String designDirName = "02_\u6982\u8981\u8bbe\u8ba1";
    private String dirId;
    private String wikiConsoleUrl = null;
    private HttpClient httpClient = HttpClients.createDefault();

    private void initWikiEcs(Connection conn) {
        if (StringUtils.isNotBlank((CharSequence)this.wikiConsoleUrl)) {
            return;
        }
        PaasEcsInfoDao paasEcsInfoDao = new PaasEcsInfoDao(conn);
        PaasEcsInfo ecsParam = new PaasEcsInfo();
        ecsParam.setEnvId("pedestal");
        ecsParam.setPaasDuId("Z000003");
        try {
            List<PaasEcsInfo> ecsInfos = paasEcsInfoDao.queryPaasEcsInfo(ecsParam);
            String urlString = "";
            if (CollectionUtils.isNotEmpty(ecsInfos)) {
                PaasEcsInfo ecs = ecsInfos.get(0);
                String ecsIpString = ecs.getEcsIp();
                if (ecsIpString.isEmpty()) {
                    return;
                }
                String ecsPortString = ecs.getEcsPort();
                if (ecsPortString.isEmpty()) {
                    return;
                }
                this.wikiConsoleUrl = "http://" + ecsIpString + ":" + ecsPortString + "/allinpaas-wiki-console";
            }
        }
        catch (Exception e) {
            this.wikiConsoleUrl = null;
        }
    }

    public boolean saveToWikiConsole(String subsCode, WikiSubsPage page, Connection conn) {
        this.initWikiEcs(conn);
        String dirId = this.queryDesignDir(subsCode, conn);
        page.setDirId(dirId);
        HttpPost post = new HttpPost(this.wikiConsoleUrl + "/api/wiki/subs/page/batch");
        try {
            StringEntity createEntity = new StringEntity(JSON.toJSONString((Object)((Object)page)), "UTF-8");
            post.setHeader("Content-Type", "application/json;charset=UTF-8");
            post.setEntity((HttpEntity)createEntity);
            HttpResponse response = this.httpClient.execute((HttpUriRequest)post);
            String json = EntityUtils.toString((HttpEntity)response.getEntity(), (String)"UTF-8");
            Map respObj = (Map)JSON.parseObject((String)json, Map.class);
            this.logger.info("\u4fdd\u5b58\u6587\u6863\u5230wiki " + json);
            boolean success = MapUtils.getBooleanValue((Map)respObj, (Object)"success", (boolean)false);
            return success;
        }
        catch (Exception e) {
            this.logger.error(e.getMessage(), e);
            return true;
        }
    }

    public String queryDesignDir(String subsCode, Connection conn) {
        if (StringUtils.isNotBlank((CharSequence)this.dirId)) {
            return this.dirId;
        }
        this.initWikiEcs(conn);
        if (this.wikiConsoleUrl == null) {
            return null;
        }
        HttpPost post = new HttpPost(this.wikiConsoleUrl + "/api/wiki/subs/directory/view");
        try {
            HashMap<String, String> queryParam = new HashMap<String, String>();
            queryParam.put("subsCode", subsCode);
            StringEntity createEntity = new StringEntity(JSON.toJSONString(queryParam), "UTF-8");
            post.setHeader("Content-Type", "application/json;charset=UTF-8");
            post.setEntity((HttpEntity)createEntity);
            HttpResponse response = this.httpClient.execute((HttpUriRequest)post);
            String json = EntityUtils.toString((HttpEntity)response.getEntity(), (String)"UTF-8");
            Map wikiSubsDirectory = (Map)JSON.parseObject((String)json, Map.class);
            List rows = (List)MapUtils.getObject((Map)wikiSubsDirectory, (Object)"rows");
            if (rows != null) {
                for (Map dir : rows) {
                    String dirName = MapUtils.getString((Map)dir, (Object)"dirName");
                    String dirId = MapUtils.getString((Map)dir, (Object)"dirId");
                    String dirPid = MapUtils.getString((Map)dir, (Object)"dirPid");
                    if (!StringUtils.isBlank((CharSequence)dirPid) || !StringUtils.equals((CharSequence)dirName, (CharSequence)designDirName)) continue;
                    this.dirId = dirId;
                    break;
                }
            }
            return this.dirId;
        }
        catch (Exception e) {
            this.logger.error(e.getMessage(), e);
            return null;
        }
    }
}

