/*
 * Decompiled with CFR 0.152.
 */
package com.irdstudio.allinapaas.executor.application.executor.core.plugin.docs;

import com.irdstudio.allinapaas.executor.application.executor.core.dao.BatInstBatchDao;
import com.irdstudio.allinapaas.executor.application.executor.core.dao.PaasDocTemplateDao;
import com.irdstudio.allinapaas.executor.application.executor.core.dao.domain.BatInstBatch;
import com.irdstudio.allinapaas.executor.application.executor.core.dao.domain.PaasDocTemplate;
import com.irdstudio.allinapaas.executor.application.executor.core.plugin.apps.SdEnvUtil;
import com.irdstudio.allinapaas.executor.application.executor.core.plugin.common.SSubsInfo;
import com.irdstudio.allinapaas.executor.application.executor.core.plugin.common.SSubsInfoDao;
import com.irdstudio.allinapaas.executor.application.executor.core.plugin.docs.DocAbstractPlugin;
import com.irdstudio.allinapaas.executor.application.executor.core.plugin.docs.gendoc.DocGenerate;
import com.irdstudio.allinapaas.executor.application.executor.core.plugin.docs.git.queue.WikiRepoCommitQueueExecutor;
import com.irdstudio.allinapaas.executor.application.executor.core.plugin.docs.git.queue.WikiRepoPushTaskImpl;
import com.irdstudio.allinapaas.portal.console.types.YesOrNO;
import java.io.File;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.MapUtils;
import org.apache.commons.lang3.StringUtils;

public class DocsGenPlugin
extends DocAbstractPlugin {
    private BatInstBatch buildLog;
    private Map<String, Object> extParam;

    @Override
    protected boolean doReadConfigureFromDB(Connection conn, String szConfIdentify) throws SQLException {
        String batchSerialNo = this.context.getSzBatchSn();
        BatInstBatchDao batInstBatchDao = new BatInstBatchDao(conn);
        this.buildLog = batInstBatchDao.queryByBatchSerialNo(batchSerialNo);
        this.extParam = batInstBatchDao.getExtParam(this.buildLog);
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean execute() {
        String loginUserId = MapUtils.getString(this.extParam, (Object)"createUserId");
        String docsRootPath = SdEnvUtil.DOCS_PATH;
        boolean flag = true;
        Connection conn = null;
        try {
            conn = this.getPluginConnection();
            PaasDocTemplateDao paasDocTemplateDao = new PaasDocTemplateDao(conn);
            SSubsInfoDao sSubsInfoDao = new SSubsInfoDao(conn);
            String sysCode = this.buildLog.getSubsId();
            File sysDir = new File(docsRootPath + File.separator + sysCode);
            SSubsInfo subsInfo = new SSubsInfo();
            subsInfo.setSubsCode(this.buildLog.getSubsId());
            subsInfo = sSubsInfoDao.querySSubsInfoWithKeys(this.buildLog.getSubsId());
            if (StringUtils.isBlank((CharSequence)subsInfo.getDocLibraryId())) {
                subsInfo.setDocLibraryId("DEFAULT");
            }
            PaasDocTemplate templateParam = new PaasDocTemplate();
            templateParam.setLibId(subsInfo.getDocLibraryId());
            List<PaasDocTemplate> templateList = paasDocTemplateDao.queryList(templateParam);
            if (CollectionUtils.isNotEmpty(templateList)) {
                for (PaasDocTemplate template : templateList) {
                    if (!StringUtils.equals((CharSequence)template.getState(), (CharSequence)YesOrNO.YES.getCode())) continue;
                    template.setLoginUserId(loginUserId);
                    if (!StringUtils.equals((CharSequence)"java", (CharSequence)template.getDocGenType())) continue;
                    try {
                        Class<?> genClass = Class.forName(template.getDocGenContent());
                        DocGenerate genInstance = (DocGenerate)genClass.newInstance();
                        List<File> files = genInstance.generateDoc(template, sysCode, sysDir, this.context.getConnPool(), null);
                        if (!CollectionUtils.isNotEmpty(files)) continue;
                        String dirPath = genInstance.getDocDirPath(template);
                        for (File file : files) {
                            WikiRepoPushTaskImpl task = new WikiRepoPushTaskImpl(sysCode, loginUserId, file, dirPath, String.format("\u63d0\u4ea4wiki\u6587\u6863\u751f\u6210 %s on batchSerialNo#%s", file.getName(), this.context.getSzBatchSn()));
                            WikiRepoCommitQueueExecutor.addTask(task);
                        }
                    }
                    catch (Exception e) {
                        this.logger.error("\u8c03\u7528\u6a21\u677f\u751f\u6210\u7c7b\u5f02\u5e38" + e.getMessage(), e);
                        flag = false;
                    }
                }
            }
        }
        catch (Exception e) {
            this.logger.error(e.getMessage(), e);
            flag = false;
        }
        finally {
            if (conn != null) {
                this.closePluginConnection(conn);
            }
        }
        return flag;
    }
}

