/*
 * Decompiled with CFR 0.152.
 */
package com.irdstudio.allinapaas.executor.application.executor.core.plugin.docs.gendoc;

import com.alibaba.excel.EasyExcel;
import com.alibaba.excel.ExcelWriter;
import com.alibaba.excel.annotation.ExcelProperty;
import com.alibaba.excel.annotation.write.style.HeadFontStyle;
import com.alibaba.excel.annotation.write.style.HeadStyle;
import com.alibaba.excel.enums.BooleanEnum;
import com.alibaba.excel.enums.poi.HorizontalAlignmentEnum;
import com.alibaba.excel.metadata.Head;
import com.alibaba.excel.metadata.data.WriteCellData;
import com.alibaba.excel.write.builder.ExcelWriterBuilder;
import com.alibaba.excel.write.builder.ExcelWriterSheetBuilder;
import com.alibaba.excel.write.builder.ExcelWriterTableBuilder;
import com.alibaba.excel.write.handler.AbstractCellWriteHandler;
import com.alibaba.excel.write.handler.WriteHandler;
import com.alibaba.excel.write.metadata.WriteSheet;
import com.alibaba.excel.write.metadata.WriteTable;
import com.alibaba.excel.write.metadata.holder.WriteSheetHolder;
import com.alibaba.excel.write.metadata.holder.WriteTableHolder;
import com.irdstudio.allinapaas.executor.application.executor.core.dao.DictOptionEnumDao;
import com.irdstudio.allinapaas.executor.application.executor.core.dao.ModelFolderInfoDao;
import com.irdstudio.allinapaas.executor.application.executor.core.dao.ModelTableFieldDao;
import com.irdstudio.allinapaas.executor.application.executor.core.dao.ModelTableIndexDao;
import com.irdstudio.allinapaas.executor.application.executor.core.dao.ModelTableInfoDao;
import com.irdstudio.allinapaas.executor.application.executor.core.dao.PaasAppsInfoDao;
import com.irdstudio.allinapaas.executor.application.executor.core.dao.domain.DictOptionEnum;
import com.irdstudio.allinapaas.executor.application.executor.core.dao.domain.ModelFolderInfo;
import com.irdstudio.allinapaas.executor.application.executor.core.dao.domain.ModelTableField;
import com.irdstudio.allinapaas.executor.application.executor.core.dao.domain.ModelTableIndex;
import com.irdstudio.allinapaas.executor.application.executor.core.dao.domain.ModelTableInfo;
import com.irdstudio.allinapaas.executor.application.executor.core.dao.domain.PaasAppsInfo;
import com.irdstudio.allinapaas.executor.application.executor.core.dao.domain.PaasDocTemplate;
import com.irdstudio.allinapaas.executor.application.executor.core.dao.domain.WikiSubsPage;
import com.irdstudio.allinapaas.executor.application.executor.core.plugin.apps.SdEnvUtil;
import com.irdstudio.allinapaas.executor.application.executor.core.plugin.common.SSubsInfo;
import com.irdstudio.allinapaas.executor.application.executor.core.plugin.common.SSubsInfoDao;
import com.irdstudio.allinapaas.executor.application.executor.core.plugin.docs.gendoc.DocGenerate;
import com.irdstudio.allinapaas.executor.application.executor.core.plugin.docs.git.queue.DocTemplateRepoPullQueueExecutor;
import com.irdstudio.allinapaas.executor.application.executor.core.tinycore.jdbc.dbcp.base.IConnPool;
import com.irdstudio.allinapaas.executor.application.executor.core.util.db.plugin.ModelTableStructVO;
import com.irdstudio.allinapaas.executor.application.executor.core.util.pub.NumberUtil;
import com.irdstudio.allinrdm.dam.console.types.ObjectType;
import com.irdstudio.sdk.beans.core.util.BeanUtility;
import com.irdstudio.sdk.beans.core.util.CurrentDateUtil;
import java.io.File;
import java.io.IOException;
import java.sql.Connection;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.poi.common.usermodel.HyperlinkType;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.CellStyle;
import org.apache.poi.ss.usermodel.CreationHelper;
import org.apache.poi.ss.usermodel.Hyperlink;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.usermodel.Workbook;
import org.apache.poi.ss.util.CellRangeAddress;

public class GenAppTableInfoExcel
implements DocGenerate {
    private final int loadPageSize = 500;

    @Override
    public List<File> generateDoc(PaasDocTemplate template, String subsId, File baseDir, IConnPool connTool, Map<String, Object> extParams) {
        Connection conn = null;
        try {
            conn = connTool.getConnection();
            PaasAppsInfoDao paasAppsInfoDao = new PaasAppsInfoDao(conn);
            List<PaasAppsInfo> appList = paasAppsInfoDao.queryPaasAppsInfoListBySysCode(subsId);
            if (CollectionUtils.isNotEmpty(appList)) {
                ArrayList<File> returnFiles = new ArrayList<File>(appList.size());
                for (PaasAppsInfo appInfo : appList) {
                    File file = this.generateAppDoc(template, appInfo.getAppId(), baseDir, connTool, extParams);
                    if (file == null) continue;
                    returnFiles.add(file);
                }
                ArrayList<File> arrayList = returnFiles;
                return arrayList;
            }
        }
        catch (Exception e) {
            logger.error("\u5e94\u7528\u8868\u6a21\u578b\u6e05\u5355\u751f\u6210\u5f02\u5e38 " + e.getMessage(), (Throwable)e);
            throw new RuntimeException("\u5e94\u7528\u8868\u6a21\u578b\u6e05\u5355\u751f\u6210\u5f02\u5e38 " + e.getMessage(), e);
        }
        finally {
            connTool.releaseConnection(conn);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public File generateAppDoc(PaasDocTemplate template, String appId, File baseDir, IConnPool connTool, Map<String, Object> extParams) {
        Connection conn = null;
        try {
            File currentFile;
            conn = connTool.getConnection();
            SSubsInfoDao sSubsInfoDao = new SSubsInfoDao(conn);
            PaasAppsInfoDao paasAppsInfoDao = new PaasAppsInfoDao(conn);
            PaasAppsInfo appInfo = paasAppsInfoDao.queryByAppId(appId);
            SSubsInfo subsInfo = sSubsInfoDao.querySSubsInfoWithKeys(appInfo.getSubsId());
            Map subsInfoMap = BeanUtility.bean2Map((Object)((Object)subsInfo));
            String userId = template.getLoginUserId();
            Map appInfoMap = BeanUtility.bean2Map((Object)((Object)appInfo));
            String fileName = template.getDocName();
            if (StringUtils.isNotBlank((CharSequence)template.getDocNameTemplate())) {
                appInfoMap.putAll(subsInfoMap);
                fileName = this.renderDocName(template.getDocNameTemplate(), appInfoMap);
            }
            if ((currentFile = this.getDocDirPath(template, baseDir, conn)) == null) {
                logger.error("\u751f\u6210\u6587\u4ef6\u4fdd\u5b58\u76ee\u5f55\u8def\u5f84\u5931\u8d25");
                File file = null;
                return file;
            }
            if (!currentFile.exists()) {
                currentFile.mkdirs();
            }
            List<ModelTableStructVO> tableStructs = this.queryModelTableStructByProjectId(appInfo.getAppId(), conn);
            DocTemplateRepoPullQueueExecutor.syncRun();
            String templateRootPath = DocTemplateRepoPullQueueExecutor.getDocTemplatePath();
            File file = this.generateProjectExcel(tableStructs, templateRootPath + File.separator + template.getDocFile(), SdEnvUtil.TEMPLATE_PATH, fileName, appInfo.getSubsId(), appInfo.getAppId(), null, connTool);
            File targetFile = new File(currentFile, fileName);
            FileUtils.copyFile((File)file, (File)targetFile);
            WikiSubsPage wikiPage = new WikiSubsPage();
            wikiPage.setDocTitle(fileName.replaceAll(".xlsx", ""));
            wikiPage.setSubsId(appInfo.getSubsId());
            wikiPage.setDocType("xlsx");
            wikiPage.setDocVersion(CurrentDateUtil.getTodayDateEx2());
            wikiPage.setLoginUserId(template.getLoginUserId());
            this.saveToWikiConsole(appInfo.getSubsId(), template, targetFile, wikiPage, conn);
            File file2 = targetFile;
            return file2;
        }
        catch (Exception e) {
            logger.error("\u5e94\u7528\u8868\u7ed3\u6784excel\u751f\u6210\u5f02\u5e38 " + e.getMessage(), (Throwable)e);
        }
        finally {
            connTool.releaseConnection(conn);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public File generateGroupDoc(PaasDocTemplate template, String subsId, String groupName, File baseDir, IConnPool connTool, Map<String, Object> extParams) {
        Connection conn = null;
        try {
            conn = connTool.getConnection();
            SSubsInfoDao sSubsInfoDao = new SSubsInfoDao(conn);
            PaasAppsInfoDao paasAppsInfoDao = new PaasAppsInfoDao(conn);
            PaasAppsInfo appParam = new PaasAppsInfo();
            appParam.setSubsId(subsId);
            appParam.setBizDbName(groupName);
            List<PaasAppsInfo> appList = paasAppsInfoDao.queryPaasAppsInfoList(appParam);
            if (CollectionUtils.isNotEmpty(appList)) {
                File currentFile;
                PaasAppsInfo appInfo = appList.get(0);
                SSubsInfo subsInfo = sSubsInfoDao.querySSubsInfoWithKeys(appInfo.getSubsId());
                Map subsInfoMap = BeanUtility.bean2Map((Object)((Object)subsInfo));
                String userId = template.getLoginUserId();
                appInfo.setAppCode(appInfo.getBizDbName());
                appInfo.setAppName(appInfo.getBizDbCnname());
                Map appInfoMap = BeanUtility.bean2Map((Object)((Object)appInfo));
                String fileName = template.getDocName();
                if (StringUtils.isNotBlank((CharSequence)template.getDocNameTemplate())) {
                    appInfoMap.putAll(subsInfoMap);
                    fileName = this.renderDocName(template.getDocNameTemplate(), appInfoMap);
                }
                if ((currentFile = this.getDocDirPath(template, baseDir, conn)) == null) {
                    logger.error("\u751f\u6210\u6587\u4ef6\u4fdd\u5b58\u76ee\u5f55\u8def\u5f84\u5931\u8d25");
                    File file = null;
                    return file;
                }
                if (!currentFile.exists()) {
                    currentFile.mkdirs();
                }
                ArrayList<ModelTableStructVO> tableStructs = new ArrayList<ModelTableStructVO>();
                for (PaasAppsInfo app : appList) {
                    List<ModelTableStructVO> appTableList = this.queryModelTableStructByProjectId(app.getAppId(), conn);
                    if (!CollectionUtils.isNotEmpty(appTableList)) continue;
                    tableStructs.addAll(appTableList);
                }
                DocTemplateRepoPullQueueExecutor.syncRun();
                String templateRootPath = DocTemplateRepoPullQueueExecutor.getDocTemplatePath();
                File file = this.generateProjectExcel(tableStructs, templateRootPath + File.separator + template.getDocFile(), SdEnvUtil.TEMPLATE_PATH, fileName, subsId, null, groupName, connTool);
                File targetFile = new File(currentFile, fileName);
                FileUtils.copyFile((File)file, (File)targetFile);
                WikiSubsPage wikiPage = new WikiSubsPage();
                wikiPage.setDocTitle(fileName.replaceAll(".xlsx", ""));
                wikiPage.setSubsId(appInfo.getSubsId());
                wikiPage.setDocType("xlsx");
                wikiPage.setDocVersion(CurrentDateUtil.getTodayDateEx2());
                wikiPage.setLoginUserId(template.getLoginUserId());
                this.saveToWikiConsole(appInfo.getSubsId(), template, targetFile, wikiPage, conn);
                File file2 = targetFile;
                return file2;
            }
            File file = null;
            return file;
        }
        catch (Exception e) {
            logger.error("\u5e94\u7528\u8868\u7ed3\u6784excel\u751f\u6210\u5f02\u5e38 " + e.getMessage(), (Throwable)e);
        }
        finally {
            connTool.releaseConnection(conn);
        }
        return null;
    }

    private List<ModelTableStructVO> queryModelTableStructByProjectId(String projectId, Connection conn) throws Exception {
        if (StringUtils.isBlank((CharSequence)projectId)) {
            return Collections.emptyList();
        }
        ModelFolderInfoDao projectTmPackageDao = new ModelFolderInfoDao(conn);
        ModelTableInfoDao modelTableInfoDao = new ModelTableInfoDao(conn);
        ModelTableFieldDao modelTableFieldDao = new ModelTableFieldDao(conn);
        ModelTableIndexDao modelTableIndexDao = new ModelTableIndexDao(conn);
        ArrayList<ModelTableStructVO> sqlScripts = new ArrayList<ModelTableStructVO>();
        ModelTableInfo tableParam = new ModelTableInfo();
        tableParam.setAppId(projectId);
        tableParam.setObjectType(ObjectType.Table.getIntCode());
        List<ModelTableInfo> tableInfoVOs = modelTableInfoDao.queryTableListWithCond(tableParam);
        List<ModelTableField> tableFieldVOs = modelTableFieldDao.queryFieldByAppId(projectId);
        List<ModelTableIndex> tableIndexVOs = modelTableIndexDao.queryModelTableInfos(projectId);
        ModelTableStructVO sqlScript = null;
        ArrayList<ModelTableField> tableFieldVOs2 = null;
        for (ModelTableInfo tableInfoVO : tableInfoVOs) {
            ModelFolderInfo packageInfo = projectTmPackageDao.queryByPk(tableInfoVO.getFolderId());
            if (packageInfo != null && !StringUtils.equals((CharSequence)packageInfo.getFolderAbvId(), (CharSequence)projectId)) {
                tableInfoVO.setFolderName(packageInfo.getFolderName());
            }
            sqlScript = new ModelTableStructVO();
            sqlScript.setTable(tableInfoVO);
            sqlScript.setIndexs(new ArrayList<ModelTableIndex>());
            tableFieldVOs2 = new ArrayList<ModelTableField>();
            for (int i = 0; i < tableFieldVOs.size(); ++i) {
                if (!tableFieldVOs.get(i).getObjectId().equals(tableInfoVO.getObjectId())) continue;
                tableFieldVOs2.add(tableFieldVOs.get(i));
                tableFieldVOs.remove(i);
                --i;
            }
            for (int k = 0; k < tableIndexVOs.size(); ++k) {
                if (!tableInfoVO.getObjectId().equals(tableIndexVOs.get(k).getObjectId())) continue;
                sqlScript.getIndexs().add(tableIndexVOs.get(k));
                tableIndexVOs.remove(k);
                --k;
            }
            sqlScript.setFields(tableFieldVOs2);
            sqlScripts.add(sqlScript);
        }
        return sqlScripts;
    }

    public File generateProjectExcel(List<ModelTableStructVO> tableStructs, String excelTemplatePath, String excelResultPath, String projectName, String subsId, String appId, String groupName, IConnPool connTool) {
        String fileName = excelResultPath + projectName + ".xlsx";
        String templateFileName = excelTemplatePath;
        String excelTempFile = excelResultPath + projectName + "-temp.xlsx";
        ExcelWriterBuilder writerBuilder = EasyExcel.write((String)fileName);
        ExcelWriter excelWriter = writerBuilder.withTemplate(templateFileName).build();
        WriteSheet writeSheet = ((ExcelWriterSheetBuilder)EasyExcel.writerSheet().registerWriteHandler((WriteHandler)new AbstractCellWriteHandler(){

            public void afterCellDispose(WriteSheetHolder writeSheetHolder, WriteTableHolder writeTableHolder, List<WriteCellData<?>> cellDataList, Cell cell, Head head, Integer relativeRowIndex, Boolean isHead) {
                if (cell.getRowIndex() > 0 && cell.getColumnIndex() == 3) {
                    CreationHelper createHelper = writeSheetHolder.getSheet().getWorkbook().getCreationHelper();
                    Hyperlink hyperlink = createHelper.createHyperlink(HyperlinkType.DOCUMENT);
                    hyperlink.setAddress("'" + cellDataList.get(0).getStringValue() + "'!A1");
                    cell.setHyperlink(hyperlink);
                }
            }
        })).build();
        ArrayList<ProjectIndex> projectIndices = new ArrayList<ProjectIndex>(tableStructs.size());
        for (int i = 0; i < tableStructs.size(); ++i) {
            ModelTableStructVO structVO = tableStructs.get(i);
            ProjectIndex index = new ProjectIndex();
            index.setSeq(String.valueOf(i + 1));
            index.setObjectCode(structVO.getTable().getObjectCode());
            index.setObjectName(structVO.getTable().getObjectName());
            index.setFolderName(structVO.getTable().getFolderName());
            projectIndices.add(index);
        }
        excelWriter.fill(projectIndices, writeSheet);
        WriteSheet dataMarkFieldSheet = EasyExcel.writerSheet((String)"\u5b57\u6bb5\u843d\u6807\u6e05\u5355").build();
        this.dataMarkerFieldFill(excelWriter, dataMarkFieldSheet, subsId, appId, groupName, connTool);
        WriteSheet fieldOptionSheet = EasyExcel.writerSheet((String)"\u4ee3\u7801\u9879\u6e05\u5355").build();
        this.dictOptionListFill(excelWriter, fieldOptionSheet, subsId, appId, groupName, connTool);
        HashMap<String, String> sheetMap = new HashMap<String, String>();
        Workbook workbook = excelWriter.writeContext().writeWorkbookHolder().getCachedWorkbook();
        for (int i = 0; i < tableStructs.size(); ++i) {
            String sheetName;
            ModelTableStructVO table = tableStructs.get(i);
            if (i >= 1) {
                Sheet sheet = excelWriter.writeContext().writeWorkbookHolder().getCachedWorkbook().cloneSheet(i + 2);
            }
            if (StringUtils.isBlank((CharSequence)(sheetName = table.getTable().getObjectName()))) {
                sheetName = table.getTable().getObjectCode();
            }
            if (sheetMap.get(sheetName) != null) {
                sheetName = table.getTable().getObjectCode();
            }
            try {
                workbook.setSheetName(i + 3, sheetName);
                sheetMap.put(sheetName, sheetName);
                continue;
            }
            catch (IllegalArgumentException e) {
                logger.error("\u8bbe\u7f6eExcel sheetName \u9519\u8bef " + sheetName);
            }
        }
        excelWriter.finish();
        try {
            FileUtils.copyFile((File)new File(fileName), (File)new File(excelTempFile));
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        writerBuilder = EasyExcel.write((String)fileName);
        writerBuilder.head(ModelTableFieldData.class);
        excelWriter = writerBuilder.withTemplate(excelTempFile).build();
        final CellStyle cellStyle = excelWriter.writeContext().writeWorkbookHolder().getCachedWorkbook().getSheetAt(1).getRow(1).getCell(1).getCellStyle();
        int startSheet = 3;
        for (final ModelTableStructVO structVO : tableStructs) {
            logger.info("fill index {}", (Object)startSheet);
            ExcelWriterSheetBuilder builder = EasyExcel.writerSheet((Integer)startSheet);
            builder.registerWriteHandler((WriteHandler)new AbstractCellWriteHandler(){

                public void afterCellDispose(WriteSheetHolder writeSheetHolder, WriteTableHolder writeTableHolder, List<WriteCellData<?>> cellDataList, Cell cell, Head head, Integer relativeRowIndex, Boolean isHead) {
                    Row row;
                    if (cell.getRowIndex() > 2) {
                        cell.setCellStyle(cellStyle);
                    }
                    if ((row = cell.getRow()) == null) {
                        return;
                    }
                    if (structVO.getIndexs() != null) {
                        int indexLen = structVO.getIndexs().size();
                        if (row.getRowNum() > 4 && row.getRowNum() < indexLen + 4 && cell.getColumnIndex() == 2) {
                            if (cell.getStringCellValue().contains("\u6570\u636e\u7c7b\u578b")) {
                                return;
                            }
                            for (int i = 3; i < 5; ++i) {
                                if (row.getCell(i) != null) continue;
                                row.createCell(i);
                                row.getCell(i).setCellStyle(cellStyle);
                            }
                            CellRangeAddress cellRangeAddress = new CellRangeAddress(row.getRowNum(), row.getRowNum(), 2, 4);
                            writeSheetHolder.getSheet().addMergedRegion(cellRangeAddress);
                        }
                    }
                }
            });
            WriteSheet writeTableSheet = builder.build();
            HashMap<String, String> headMap = new HashMap<String, String>();
            headMap.put("objectCode", structVO.getTable().getObjectCode());
            headMap.put("objectName", structVO.getTable().getObjectName());
            if (structVO.getIndexs() != null) {
                for (Object index : structVO.getIndexs()) {
                    if (index.getIndexTypePrimary() == null || !index.getIndexTypePrimary().equals("Y")) continue;
                    headMap.put("primaryKey", index.getIndexFields());
                    break;
                }
            }
            excelWriter.fill(headMap, writeTableSheet);
            ArrayList<ModelTableIndexData> indexs = new ArrayList<ModelTableIndexData>();
            if (structVO.getIndexs() != null) {
                Object index;
                index = structVO.getIndexs().iterator();
                while (index.hasNext()) {
                    Object indexVO = (ModelTableIndex)((Object)index.next());
                    if (indexVO.getIndexTypePrimary() != null && indexVO.getIndexTypePrimary().equals("Y")) continue;
                    ModelTableIndexData index2 = new ModelTableIndexData();
                    if (indexVO.getIndexTypeUnique() != null && indexVO.getIndexTypeUnique().equals("Y")) {
                        index2.setIndexType("\u552f\u4e00\u7d22\u5f15");
                    } else {
                        index2.setIndexType("\u666e\u901a\u7d22\u5f15");
                    }
                    index2.setIndexFields(indexVO.getIndexFields());
                    index2.setIndexName(indexVO.getIndexName());
                    indexs.add(index2);
                }
            }
            excelWriter.fill(indexs, writeTableSheet);
            ArrayList<ModelTableFieldData> fields = new ArrayList<ModelTableFieldData>();
            if (CollectionUtils.isNotEmpty(structVO.getFields())) {
                for (ModelTableField fieldVO : structVO.getFields()) {
                    ModelTableFieldData field = new ModelTableFieldData();
                    field.setFieldCode(fieldVO.getFieldCode());
                    field.setFieldDesc(fieldVO.getFieldDesc());
                    field.setFieldName(fieldVO.getFieldName());
                    if (fieldVO.getFieldLength() == null || fieldVO.getFieldLength() == 0) {
                        field.setFieldType(String.format("%s", fieldVO.getFieldType()));
                    } else if (fieldVO.getFieldPrecision() == null || fieldVO.getFieldPrecision() == 0) {
                        field.setFieldType(String.format("%s(%s)", fieldVO.getFieldType(), fieldVO.getFieldLength() == 0 ? "" : fieldVO.getFieldLength()));
                    } else {
                        field.setFieldType(String.format("%s(%s, %s)", fieldVO.getFieldType(), fieldVO.getFieldLength() == 0 ? "" : fieldVO.getFieldLength(), fieldVO.getFieldPrecision() == 0 ? "" : fieldVO.getFieldPrecision()));
                    }
                    field.setIsAllowNull(fieldVO.getIsAllowNull() != null && fieldVO.getIsAllowNull().equalsIgnoreCase("Y") ? "\u662f" : "\u5426");
                    fields.add(field);
                }
            }
            WriteTable writeTable = ((ExcelWriterTableBuilder)EasyExcel.writerTable((Integer)0).needHead(Boolean.TRUE)).build();
            excelWriter.write(fields, writeTableSheet, writeTable);
            ++startSheet;
        }
        excelWriter.writeContext().writeWorkbookHolder().getWorkbook().setActiveSheet(0);
        excelWriter.finish();
        FileUtils.deleteQuietly((File)new File(excelTempFile));
        return new File(fileName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void dataMarkerFieldFill(ExcelWriter excelWriter, WriteSheet sheet, String subsId, String appId, String groupName, IConnPool connPool) {
        Connection conn = null;
        try {
            conn = connPool.getConnection();
            ModelTableFieldDao modelTableFieldDao = new ModelTableFieldDao(conn);
            ModelTableField param = new ModelTableField();
            param.setSubsId(subsId);
            param.setAppId(appId);
            param.setBizDbName(groupName);
            param.setSize(500);
            List<ModelTableField> list = modelTableFieldDao.queryDataMarkerFieldByPage(param);
            int total = param.getTotal();
            if (total < 500) {
                excelWriter.fill(list, sheet);
            } else {
                excelWriter.fill(list, sheet);
                int loop = NumberUtil.calcLoop(total);
                int i = 2;
                while (i <= loop) {
                    int page = i++;
                    param.setPage(page);
                    list = modelTableFieldDao.queryDataMarkerFieldByPage(param);
                    excelWriter.fill(list, sheet);
                }
            }
        }
        catch (Exception e) {
            logger.error("\u586b\u5145\u5b57\u6bb5\u843d\u6807\u6e05\u5355\u5f02\u5e38 " + e.getMessage(), (Throwable)e);
        }
        finally {
            if (conn != null) {
                connPool.releaseConnection(conn);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void dictOptionListFill(ExcelWriter excelWriter, WriteSheet sheet, String subsId, String appId, String groupName, IConnPool connPool) {
        Connection conn = null;
        try {
            conn = connPool.getConnection();
            DictOptionEnumDao dictOptionEnumDao = new DictOptionEnumDao(conn);
            DictOptionEnum param = new DictOptionEnum();
            param.setSubsId(subsId);
            param.setAppId(appId);
            param.setBizDbName(groupName);
            param.setSize(500);
            List<DictOptionEnum> list = dictOptionEnumDao.queryAllDictOptionByPage(param);
            int total = param.getTotal();
            if (total < 500) {
                excelWriter.fill(list, sheet);
            } else {
                excelWriter.fill(list, sheet);
                int loop = NumberUtil.calcLoop(total);
                int i = 2;
                while (i <= loop) {
                    int page = i++;
                    param.setPage(page);
                    list = dictOptionEnumDao.queryAllDictOptionByPage(param);
                    excelWriter.fill(list, sheet);
                }
            }
        }
        catch (Exception e) {
            logger.error("\u586b\u5145\u4ee3\u7801\u9879\u6e05\u5355\u5f02\u5e38 " + e.getMessage(), (Throwable)e);
        }
        finally {
            if (conn != null) {
                connPool.releaseConnection(conn);
            }
        }
    }

    @HeadFontStyle(fontHeightInPoints=11, bold=BooleanEnum.FALSE, fontName="Calibri")
    @HeadStyle(fillBackgroundColor=55, horizontalAlignment=HorizontalAlignmentEnum.LEFT)
    public static class ModelTableFieldData {
        @ExcelProperty(value={"\u5b57\u6bb5\u540d\u79f0"})
        private String fieldCode;
        @ExcelProperty(value={"\u5b57\u6bb5\u63cf\u8ff0"})
        private String fieldName;
        @ExcelProperty(value={"\u6570\u636e\u7c7b\u578b"})
        private String fieldType;
        @ExcelProperty(value={"\u5141\u7a7a"})
        private String isAllowNull;
        @ExcelProperty(value={"\u5b57\u6bb5\u8bf4\u660e"})
        private String fieldDesc;

        public String getFieldCode() {
            return this.fieldCode;
        }

        public void setFieldCode(String fieldCode) {
            this.fieldCode = fieldCode;
        }

        public String getFieldName() {
            return this.fieldName;
        }

        public void setFieldName(String fieldName) {
            this.fieldName = fieldName;
        }

        public String getFieldType() {
            return this.fieldType;
        }

        public void setFieldType(String fieldType) {
            this.fieldType = fieldType;
        }

        public String getIsAllowNull() {
            return this.isAllowNull;
        }

        public void setIsAllowNull(String isAllowNull) {
            this.isAllowNull = isAllowNull;
        }

        public String getFieldDesc() {
            return this.fieldDesc;
        }

        public void setFieldDesc(String fieldDesc) {
            this.fieldDesc = fieldDesc;
        }
    }

    public static class ModelTableIndexData {
        @ExcelProperty(value={"\u7d22\u5f15\u540d"})
        private String indexName;
        @ExcelProperty(value={"\u7d22\u5f15\u5b57\u6bb5"})
        private String indexFields;
        @ExcelProperty(value={"\u7d22\u5f15\u7c7b\u578b"})
        private String indexType;

        public String getIndexName() {
            return this.indexName;
        }

        public void setIndexName(String indexName) {
            this.indexName = indexName;
        }

        public String getIndexFields() {
            return this.indexFields;
        }

        public void setIndexFields(String indexFields) {
            this.indexFields = indexFields;
        }

        public String getIndexType() {
            return this.indexType;
        }

        public void setIndexType(String indexType) {
            this.indexType = indexType;
        }
    }

    public static class ProjectIndex {
        @ExcelProperty(value={"\u5e8f\u53f7"})
        private String seq;
        @ExcelProperty(value={"\u4e1a\u52a1\u6a21\u5757"})
        private String folderName;
        @ExcelProperty(value={"\u8868\u540d"})
        private String objectCode;
        @ExcelProperty(value={"\u8868\u4e2d\u6587\u540d"})
        private String objectName;

        public String getSeq() {
            return this.seq;
        }

        public void setSeq(String seq) {
            this.seq = seq;
        }

        public String getObjectCode() {
            return this.objectCode;
        }

        public void setObjectCode(String objectCode) {
            this.objectCode = objectCode;
        }

        public String getObjectName() {
            return this.objectName;
        }

        public void setObjectName(String objectName) {
            this.objectName = objectName;
        }

        public String getFolderName() {
            return this.folderName;
        }

        public void setFolderName(String packageName) {
            this.folderName = packageName;
        }
    }
}

