/*
 * Decompiled with CFR 0.152.
 */
package com.irdstudio.allinapaas.executor.application.executor.core.plugin.gencode;

import com.irdstudio.allinapaas.executor.application.executor.core.dao.PaasAppsInfoDao;
import com.irdstudio.allinapaas.executor.application.executor.core.dao.PaasAppsParamDao;
import com.irdstudio.allinapaas.executor.application.executor.core.dao.domain.PaasAppsInfo;
import com.irdstudio.allinapaas.executor.application.executor.core.dao.domain.PaasAppsParam;
import com.irdstudio.allinapaas.executor.application.executor.core.plugin.AbstractPlugin;
import com.irdstudio.allinapaas.executor.application.executor.core.plugin.apps.SdEnvUtil;
import com.irdstudio.allinapaas.executor.application.executor.core.plugin.util.MyFileUtil;
import com.irdstudio.allinapaas.executor.application.executor.core.plugin.util.bean.FileReplacePattern;
import com.irdstudio.allinapaas.executor.application.executor.core.plugin.util.bean.ReplaceDirAndFileBean;
import com.irdstudio.allinapaas.executor.application.executor.core.util.parse.ExpressionUtil;
import java.io.File;
import java.io.IOException;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.MapUtils;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang.StringUtils;

public class AppProjectGenRenameDirNamePlugin
extends AbstractPlugin {
    private PaasAppsInfo appInfo = null;
    private List<PaasAppsParam> appsParam = null;

    @Override
    protected boolean doReadConfigureFromDB(Connection conn, String szConfIdentify) throws SQLException {
        String batchSerialNo = this.context.getSzBatchSn();
        PaasAppsInfoDao paasAppsInfoDao = new PaasAppsInfoDao(conn);
        this.appInfo = paasAppsInfoDao.queryByBatchSerialNo(batchSerialNo);
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean execute() {
        this.logger.info("\u8c03\u7528\u521d\u59cb\u5316\u5e94\u7528\u539f\u578b\u5de5\u7a0b\u63d2\u4ef6,\u590d\u5236\u5e76\u66ff\u6362\u5e94\u7528\u6a21\u677f\uff0c\u751f\u6210{}\u5de5\u7a0b" + this.appInfo.getAppCode());
        String appCode = SdEnvUtil.wrapperAppCode(this.appInfo.getAppCode());
        String outFilePath = SdEnvUtil.PROJECT_PATH + appCode;
        if (MyFileUtil.checkFileExist(outFilePath).booleanValue()) {
            try {
                FileUtils.forceDelete((File)new File(outFilePath));
            }
            catch (IOException e) {
                e.printStackTrace();
                return false;
            }
        }
        String srcStr = "allinpaas-fadpaas";
        Map<String, Object> appParams = null;
        Connection conn = null;
        try {
            File[] subDirs;
            conn = this.getPluginConnection();
            appParams = this.wrapAppsParam(this.appInfo.getAppId(), conn);
            String package_prefix = MapUtils.getString(appParams, (Object)"package_prefix", (String)"com.irdstudio");
            srcStr = MapUtils.getString(appParams, (Object)"app_code_replace", (String)"allinpaas-fadpaas");
            String srcPackagePrefix = MapUtils.getString(appParams, (Object)"src_package_prefix", (String)"com.irdstudio.fadpaas.console");
            String srcPomGroupId = MapUtils.getString(appParams, (Object)"src_pom_group_id", (String)"com.irdstudio.allinpaas.worker");
            String srcFilePath = SdEnvUtil.TEMPLATE_PATH + File.separator + this.appInfo.getAppTemplateId() + "-template";
            String replaceStr = appCode;
            HashMap<String, Object> expRoot = new HashMap<String, Object>();
            expRoot.put("appCode", appCode);
            srcPackagePrefix = ExpressionUtil.parse(srcPackagePrefix, expRoot);
            srcPomGroupId = ExpressionUtil.parse(srcPomGroupId, expRoot);
            String newAppCode = StringUtils.replace((String)appCode, (String)"-", (String)".");
            String replacePackage = package_prefix + "." + newAppCode;
            this.logger.info(String.format("\u4ece%s\u590d\u5236\u5e76\u91cd\u547d\u4ee4\u5de5\u7a0b\u5230%s...", srcFilePath, outFilePath));
            srcFilePath = new File(srcFilePath).getAbsolutePath();
            outFilePath = new File(outFilePath).getAbsolutePath();
            ReplaceDirAndFileBean rdfb = new ReplaceDirAndFileBean(srcFilePath, outFilePath, srcStr, replaceStr);
            rdfb.addFileReplacePattern(new FileReplacePattern("*", srcStr.replace(".", "-"), replaceStr.replaceAll("_|\\.", "-")));
            rdfb.addFileReplacePattern(new FileReplacePattern("*", srcPackagePrefix, replacePackage));
            rdfb.addFileReplacePattern(new FileReplacePattern("*", srcPackagePrefix.replaceAll("\\.", "/"), replacePackage.replaceAll("\\.", "/")));
            rdfb.addFileReplacePattern(new FileReplacePattern("*", srcPomGroupId, replacePackage));
            rdfb.setIgnorePostfix("html,css,js,zip");
            rdfb.execute();
            this.logger.info(String.format("\u4ece%s\u590d\u5236\u5e76\u91cd\u547d\u4ee4\u5de5\u7a0b\u5230%s\u5b8c\u6210!", srcFilePath, outFilePath));
            String newDirPath = StringUtils.replace((String)replacePackage, (String)".", (String)File.separator);
            File targetFile = new File(outFilePath);
            String[] srcPaths = StringUtils.split((String)srcPackagePrefix, (String)".");
            String[] targetPaths = StringUtils.split((String)replacePackage, (String)".");
            for (File subDir : subDirs = targetFile.listFiles()) {
                this.renameMultipleDir(subDir, srcPaths, targetPaths, 0);
            }
        }
        catch (Exception e) {
            this.logger.error(e.getMessage(), e);
            boolean bl = false;
            return bl;
        }
        finally {
            if (conn != null) {
                this.closePluginConnection(conn);
            }
        }
        try {
            FileUtils.deleteDirectory((File)new File(outFilePath + File.separator + ".git"));
        }
        catch (IOException e) {
            this.logger.error("\u590d\u5236\u76ee\u5f55\u5f02\u5e38 " + outFilePath, e);
            return false;
        }
        return true;
    }

    private void renameMultipleDir(File root, String[] srcPaths, String[] targetPaths, int pathIndex) throws Exception {
        if (pathIndex >= srcPaths.length && pathIndex < targetPaths.length) {
            File[] subFiles;
            File newDir = new File(root, targetPaths[pathIndex]);
            newDir.mkdirs();
            for (File subFile : subFiles = root.listFiles()) {
                if (subFile.getName().equals(".git") || subFile.getName().equals(newDir.getName())) continue;
                if (subFile.isDirectory()) {
                    FileUtils.copyDirectoryToDirectory((File)subFile, (File)newDir);
                    FileUtils.deleteQuietly((File)subFile);
                    continue;
                }
                FileUtils.copyFileToDirectory((File)subFile, (File)newDir);
                FileUtils.deleteQuietly((File)subFile);
            }
            this.renameMultipleDir(newDir, srcPaths, targetPaths, ++pathIndex);
        } else if (pathIndex < srcPaths.length && root.isDirectory()) {
            File[] subFiles;
            for (File subFile : subFiles = root.listFiles()) {
                if (subFile.getName().equals(".git") || !subFile.isDirectory()) continue;
                if (StringUtils.equals((String)srcPaths[pathIndex], (String)subFile.getName())) {
                    if (!StringUtils.equals((String)srcPaths[pathIndex], (String)targetPaths[pathIndex])) {
                        File[] list;
                        File newDir = new File(root, targetPaths[pathIndex]);
                        newDir.mkdirs();
                        for (File f : list = subFile.listFiles()) {
                            FileUtils.moveDirectoryToDirectory((File)f, (File)newDir, (boolean)false);
                        }
                        FileUtils.deleteQuietly((File)subFile);
                        subFile = newDir;
                    }
                    ++pathIndex;
                }
                this.renameMultipleDir(subFile, srcPaths, targetPaths, pathIndex);
            }
        }
    }

    private Map<String, Object> wrapAppsParam(String appId, Connection conn) throws Exception {
        PaasAppsParamDao paasAppsParamDao = new PaasAppsParamDao(conn);
        PaasAppsParam param = new PaasAppsParam();
        param.setAppId(appId);
        List<PaasAppsParam> paramList = paasAppsParamDao.queryPaasAppsParamList(param);
        HashMap<String, Object> appsParam = new HashMap<String, Object>();
        if (CollectionUtils.isNotEmpty(paramList)) {
            for (PaasAppsParam p : paramList) {
                appsParam.put(p.getParamCode(), p.getParamValue());
            }
        }
        return appsParam;
    }
}

