/*
 * Decompiled with CFR 0.152.
 */
package com.irdstudio.allinapaas.executor.application.executor.core.plugin.market;

import com.alibaba.fastjson.JSON;
import com.irdstudio.allinapaas.executor.application.executor.core.dao.PaasEnvParamDao;
import com.irdstudio.allinapaas.executor.application.executor.core.dao.SrvEvalFuncDao;
import com.irdstudio.allinapaas.executor.application.executor.core.dao.domain.PaasAppsInfo;
import com.irdstudio.allinapaas.executor.application.executor.core.dao.domain.PaasMarketAppinfo;
import com.irdstudio.allinapaas.executor.application.executor.core.dao.domain.SrvEvalFunc;
import com.irdstudio.allinapaas.executor.application.executor.core.tinycore.jdbc.dbcp.TConnPool;
import com.irdstudio.allinapaas.executor.application.executor.core.tinycore.jdbc.dbcp.base.IConnPool;
import com.irdstudio.allinapaas.executor.application.executor.core.util.db.ProxySQL;
import com.irdstudio.allinapaas.executor.application.executor.core.util.pub.NumberUtil;
import com.irdstudio.sdk.beans.core.spring.SpringPropertyUtils;
import com.irdstudio.sdk.beans.core.util.POJOUtils;
import java.io.File;
import java.io.IOException;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.MapUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.ContentType;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.util.EntityUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractMarketTask {
    protected Logger logger = LoggerFactory.getLogger(AbstractMarketTask.class);
    private static final String SQLITE_DRIVER = "org.sqlite.JDBC";
    private String sdTemplate = null;
    private static final String marketPath = SpringPropertyUtils.getProperty((String)"tdp.project.path");
    private static final String repoPath = SpringPropertyUtils.getProperty((String)"tdp.template.path");
    public static final String SYS_COPY_BATCH = "MKT-SYS-IMP";
    public static final String STD_COPY_BATCH = "MKT-STD-IMP";
    private IConnPool connPool = TConnPool.getDefaultPool();
    private Connection conn = null;

    public abstract boolean initTask(Map<String, Object> var1, Connection var2) throws SQLException;

    public abstract boolean execute();

    public Connection getConnection() {
        try {
            this.conn = this.connPool.getConnection(this.conn);
        }
        catch (SQLException e) {
            this.logger.error("\u83b7\u53d6\u8fde\u63a5\u5931\u8d25!" + e.getMessage());
        }
        return this.conn;
    }

    public void closeConnection(Connection conn) {
        if (conn != null) {
            this.connPool.releaseConnection(conn);
        }
    }

    public String getMarketPath() {
        return marketPath + File.separator + "sqlite" + File.separator;
    }

    public String getRepoPath(String marketUrl) {
        int firstIndex = marketUrl.lastIndexOf("/");
        int lastIndex = marketUrl.lastIndexOf(".");
        marketUrl = marketUrl.substring(firstIndex, lastIndex);
        return repoPath + File.separator + marketUrl + File.separator;
    }

    public String getSdTemplatePath(Connection conn) {
        if (this.sdTemplate != null) {
            return this.sdTemplate;
        }
        try {
            String value;
            PaasEnvParamDao paasEnvParamDao = new PaasEnvParamDao(conn);
            this.sdTemplate = value = paasEnvParamDao.queryByCodeReturnValue("git.sdtemplate.remote.path");
        }
        catch (Exception e) {
            this.logger.error(e.getMessage(), (Throwable)e);
            return null;
        }
        return this.sdTemplate;
    }

    public File getSqliteFile(PaasAppsInfo appInfo) {
        String subsId = appInfo.getSubsId();
        String appCode = appInfo.getAppCode();
        String version = appInfo.getAppVersion();
        version = StringUtils.isNotBlank((CharSequence)version) ? "_" + version : "";
        File destSqliteFile = new File(this.getMarketPath() + String.format("%s_%s%s.db", subsId, appCode, version));
        return destSqliteFile;
    }

    public File getSqliteFile(Map<String, Object> extParam, String version) {
        String subsId = MapUtils.getString(extParam, (Object)"marketSubsId");
        String appCode = MapUtils.getString(extParam, (Object)"marketAppCode");
        String string = version = StringUtils.isNotBlank((CharSequence)version) ? "_" + version : "";
        if (StringUtils.isNotBlank((CharSequence)subsId)) {
            File destSqliteFile = new File(this.getMarketPath() + String.format("%s_%s%s.db", subsId, appCode, version));
            return destSqliteFile;
        }
        File destSqliteFile = new File(this.getMarketPath() + String.format("%s%s.db", appCode, version));
        return destSqliteFile;
    }

    public File getSysSqliteFile(Map<String, Object> extParam, String version) {
        String subsId = MapUtils.getString(extParam, (Object)"marketSubsId");
        version = StringUtils.isNotBlank((CharSequence)version) ? "_" + version : "";
        File destSqliteFile = new File(this.getMarketPath() + String.format("%s%s.db", subsId, version));
        return destSqliteFile;
    }

    public File getStdSqliteFile(Map<String, Object> extParam) {
        String stdCode = MapUtils.getString(extParam, (Object)"marketStdCode");
        String stdName = MapUtils.getString(extParam, (Object)"marketStdName");
        File destSqliteFile = new File(this.getMarketPath() + String.format("std_%s.db", stdCode));
        return destSqliteFile;
    }

    public File getSqliteFile(PaasMarketAppinfo appInfo) {
        String batchSerialNo = appInfo.getMarketAppId();
        String subsId = appInfo.getSubsId();
        String appId = appInfo.getAppId();
        String appCode = appInfo.getAppCode();
        String version = appInfo.getAppVersion();
        version = StringUtils.isNotBlank((CharSequence)version) ? "_" + version : "";
        File destSqliteFile = new File(this.getMarketPath() + String.format("%s_%s_%s.db", appCode, appId, batchSerialNo));
        return destSqliteFile;
    }

    public File getIMPSysSqliteFile(Map<String, Object> extParam, String marketUrl, String version) {
        String subsId = MapUtils.getString(extParam, (Object)"marketSubsId");
        version = StringUtils.isNotBlank((CharSequence)version) ? "_" + version : "";
        File destSqliteFile = new File(this.getRepoPath(marketUrl) + File.separator + subsId + File.separator + String.format("%s%s.db", subsId, version));
        return destSqliteFile;
    }

    public File getIMPProdSqliteFile(Map<String, Object> extParam, String marketUrl, String version) {
        String subsId = MapUtils.getString(extParam, (Object)"marketSubsId");
        String appCode = MapUtils.getString(extParam, (Object)"marketAppCode");
        version = StringUtils.isNotBlank((CharSequence)version) ? "_" + version : "";
        File destSqliteFile = new File(this.getRepoPath(marketUrl) + File.separator + subsId + File.separator + String.format("%s%s.db", appCode, version));
        return destSqliteFile;
    }

    public File getIMPStdSqliteFile(Map<String, Object> extParam, String marketUrl) {
        String stdCode = MapUtils.getString(extParam, (Object)"marketStdCode");
        String stdName = MapUtils.getString(extParam, (Object)"marketStdName");
        File destSqliteFile = new File(this.getRepoPath(marketUrl) + File.separator + "data-std" + File.separator + String.format("std_%s.db", stdCode));
        return destSqliteFile;
    }

    public Connection getSqliteConnection(File sqliteFile) {
        String sqlitePath = sqliteFile.getAbsolutePath();
        Connection conn = null;
        String url = "jdbc:sqlite:" + sqlitePath;
        this.logger.debug("\u83b7\u53d6\u6570\u636e\u5e93\u8fde\u63a5\uff0curl\uff1a" + url);
        try {
            Class.forName(SQLITE_DRIVER);
            conn = DriverManager.getConnection(url);
        }
        catch (ClassNotFoundException e) {
            this.logger.error("\u83b7\u53d6sqlite\u8fde\u63a5\u51fa\u73b0\u5f02\u5e38\uff01", (Throwable)e);
        }
        catch (SQLException e) {
            this.logger.error("\u83b7\u53d6sqlite\u8fde\u63a5\u51fa\u73b0\u5f02\u5e38\uff01", (Throwable)e);
        }
        return conn;
    }

    public void closeSqliteConnection(Connection conn) {
        try {
            if (conn != null) {
                conn.close();
            }
        }
        catch (SQLException e) {
            this.logger.error("\u5173\u95edsqlite\u8fde\u63a5\u51fa\u73b0\u5f02\u5e38\uff01", (Throwable)e);
            e.printStackTrace();
        }
    }

    public <T> int batchInsertPage(String tableName, List<T> list, Connection conn) {
        if (CollectionUtils.isEmpty(list)) {
            return 0;
        }
        int num = 0;
        if (list.size() < 200) {
            num += this.batchInsert(tableName, list, conn);
        } else {
            int loop = NumberUtil.calcLoop(list.size());
            int cur = 0;
            for (int i = 1; i <= loop; ++i) {
                int end = 200 * i;
                if (end > list.size()) {
                    end = list.size();
                }
                List<T> sub = list.subList(cur, end);
                cur += 200;
                num += this.batchInsert(tableName, sub, conn);
            }
        }
        return num;
    }

    public <T> int batchInsert(String tableName, List<T> vos, Connection conn) {
        List[] insertInfos = POJOUtils.generateInsertInfo(vos);
        if (insertInfos == null) {
            return -1;
        }
        ArrayList param = new ArrayList();
        StringBuffer sqlSb = new StringBuffer();
        sqlSb.append("INSERT INTO ").append(tableName).append(" (");
        Object[] columns = insertInfos[0].toArray(new String[0]);
        String[] values = insertInfos[1].toArray(new String[0]);
        sqlSb.append(StringUtils.join((Object[])columns, (String)","));
        sqlSb.append(")\n").append(" VALUES \n");
        for (int i = 2; i < insertInfos.length; ++i) {
            sqlSb.append("(");
            for (int j = 0; j < insertInfos[i].size(); ++j) {
                Object obj = insertInfos[i].get(j);
                if (obj == null) {
                    sqlSb.append("NULL");
                } else if (obj.toString().contains("'") || obj.toString().contains("\\\"")) {
                    sqlSb.append("?");
                    param.add(obj);
                } else {
                    sqlSb.append("'").append(obj).append("'");
                }
                if (j >= insertInfos[i].size() - 1) continue;
                sqlSb.append(",");
            }
            sqlSb.append(")");
            if (i >= insertInfos.length - 1) continue;
            sqlSb.append(", \n");
        }
        String sql = sqlSb.toString();
        ProxySQL.log.debug("SQL generate result \n{}", (Object)sql);
        PreparedStatement ps = null;
        int rs = 0;
        try {
            ps = conn.prepareStatement(sql);
            for (int i = 0; i < param.size(); ++i) {
                ps.setObject(i + 1, param.get(i));
            }
            rs = ps.executeUpdate();
        }
        catch (Exception e) {
            throw new RuntimeException("insert batch " + tableName + " is wrong", e);
        }
        return rs;
    }

    public <T> boolean updateByPk(T vo, String pkKey, String pkVal, Connection conn) {
        String className = vo.getClass().getSimpleName();
        className = StringUtils.uncapitalize((String)className);
        String tableName = POJOUtils.javaPropToColName((String)className);
        HashMap<String, String> pks = new HashMap<String, String>();
        pks.put(pkKey, pkVal);
        return this.updateByPk(tableName.toLowerCase(), vo, pks, conn);
    }

    public <T> boolean updateByPk(T vo, Map<String, String> pks, Connection conn) {
        String className = vo.getClass().getSimpleName();
        className = StringUtils.uncapitalize((String)className);
        String tableName = POJOUtils.javaPropToColName((String)className);
        return this.updateByPk(tableName.toLowerCase(), vo, pks, conn);
    }

    public <T> boolean updateByPk(final String tableName, final T vo, final Map<String, String> pks, Connection conn) {
        final ArrayList param = new ArrayList();
        String sql = new ProxySQL(){
            {
                this.UPDATE(tableName);
                List vals = POJOUtils.getPOJOValues((Object)vo);
                for (Object[] objectArray : vals) {
                    this.SET(String.format("%s = ?", objectArray[0].toString()));
                    param.add(objectArray[1]);
                }
                for (Map.Entry entry : pks.entrySet()) {
                    this.WHERE(String.format("%s = ?", POJOUtils.javaPropToColName((String)((String)entry.getKey()))));
                    param.add(entry.getValue());
                }
            }
        }.toString();
        PreparedStatement ps = null;
        try {
            int i;
            ps = conn.prepareStatement(sql);
            for (i = 0; i < param.size(); ++i) {
                ps.setObject(i + 1, param.get(i));
            }
            i = ps.executeUpdate();
        }
        catch (Exception e) {
            throw new RuntimeException("update by pk is wrong " + tableName, e);
        }
        return true;
    }

    public ResultSet queryAll(Class<?> cls, Connection conn) throws Exception {
        String className = cls.getSimpleName();
        className = StringUtils.uncapitalize((String)className);
        String tableName = POJOUtils.javaPropToColName((String)className);
        return this.queryAll(tableName.toLowerCase(), conn);
    }

    public ResultSet queryAll(final String tableName, Connection conn) throws Exception {
        ArrayList param = new ArrayList();
        String sql = new ProxySQL(){
            {
                this.SELECT("*");
                this.FROM(tableName);
            }
        }.toString();
        PreparedStatement ps = null;
        ResultSet rs = null;
        ArrayList list = new ArrayList();
        try {
            ps = conn.prepareStatement(sql);
            for (int i = 0; i < param.size(); ++i) {
                ps.setObject(i + 1, param.get(i));
            }
            rs = ps.executeQuery();
        }
        catch (Exception e) {
            throw new RuntimeException(tableName + " queryAll is wrong", e);
        }
        return rs;
    }

    public int queryCount(Class<?> cls, Connection conn) throws Exception {
        String className = cls.getSimpleName();
        className = StringUtils.uncapitalize((String)className);
        String tableName = POJOUtils.javaPropToColName((String)className);
        return this.queryCount(tableName.toLowerCase(), conn);
    }

    public int queryCount(final String tableName, Connection conn) throws Exception {
        ArrayList param = new ArrayList();
        String sql = new ProxySQL(){
            {
                this.SELECT("count(1)");
                this.FROM(tableName);
            }
        }.toString();
        PreparedStatement ps = null;
        ResultSet rs = null;
        int count = 0;
        try {
            ps = conn.prepareStatement(sql);
            rs = ps.executeQuery();
            count = rs.getInt(1);
        }
        catch (Exception e) {
            throw new RuntimeException(tableName + " queryCount is wrong", e);
        }
        return count;
    }

    public int deleteAll(final String tableName, Connection conn) throws Exception {
        ArrayList param = new ArrayList();
        String sql = new ProxySQL(){
            {
                this.DELETE_FROM(tableName);
            }
        }.toString();
        PreparedStatement ps = null;
        int count = 0;
        try {
            ps = conn.prepareStatement(sql);
            count = ps.executeUpdate();
        }
        catch (Exception e) {
            throw new RuntimeException(tableName + " deleteAll is wrong", e);
        }
        return count;
    }

    public void cpSrvEvalFunc(String srvModelId, Class<?> tableCls, SrvEvalFuncDao srvEvalFuncDao, Connection Conn) throws Exception {
        List<SrvEvalFunc> funcList = srvEvalFuncDao.querySrvEvalFuncList(srvModelId, tableCls);
        this.batchInsertPage("`allinrdm_db`.srv_eval_func", funcList, Conn);
    }

    public String requestOpenApi(String url, Object param) {
        CloseableHttpClient httpClient = HttpClients.createDefault();
        HttpPost postMethod = new HttpPost(url);
        HttpResponse response = null;
        try {
            String reqJson = JSON.toJSONString((Object)param);
            StringEntity entity = new StringEntity(reqJson, ContentType.APPLICATION_JSON);
            postMethod.setEntity((HttpEntity)entity);
            response = httpClient.execute((HttpUriRequest)postMethod);
            String json = EntityUtils.toString((HttpEntity)response.getEntity());
            return json;
        }
        catch (IOException e) {
            e.printStackTrace();
            this.logger.error(e.getMessage(), (Throwable)e);
            return null;
        }
    }
}

