/*
 * Decompiled with CFR 0.152.
 */
package com.irdstudio.allinapaas.executor.application.executor.core.plugin.market;

import com.alibaba.fastjson.JSON;
import com.irdstudio.allinapaas.design.console.types.MarketSource;
import com.irdstudio.allinapaas.executor.application.executor.core.dao.PaasEnvParamDao;
import com.irdstudio.allinapaas.executor.application.executor.core.dao.PaasMarketAppinfoDao;
import com.irdstudio.allinapaas.executor.application.executor.core.dao.domain.PaasMarketAppinfo;
import com.irdstudio.allinapaas.executor.application.executor.core.plugin.market.AbstractMarketTask;
import java.io.File;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Map;
import org.apache.commons.collections.MapUtils;
import org.apache.commons.lang3.StringUtils;

public class CPNSqliteCpDataTask
extends AbstractMarketTask {
    private PaasMarketAppinfo appInfo = null;
    private Map<String, Object> extParam = null;

    @Override
    public boolean initTask(Map<String, Object> extParam, Connection conn) throws SQLException {
        this.extParam = extParam;
        PaasMarketAppinfoDao paasAppsInfoDao = new PaasMarketAppinfoDao(conn);
        this.appInfo = paasAppsInfoDao.queryPaasMarketAppinfo(MapUtils.getString(extParam, (Object)"marketAppId"));
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public boolean execute() {
        boolean bl;
        Connection sqliteConn;
        Connection conn;
        block12: {
            block13: {
                boolean flag = true;
                conn = null;
                sqliteConn = null;
                try {
                    conn = this.getConnection();
                    PaasEnvParamDao paasEnvParamDao = new PaasEnvParamDao(conn);
                    String marketSource = MapUtils.getString(this.extParam, (Object)"marketSource");
                    ArrayList<PaasMarketAppinfo> appInfoList = new ArrayList<PaasMarketAppinfo>();
                    if (StringUtils.equals((CharSequence)marketSource, (CharSequence)MarketSource.Inside.getCode())) {
                        appInfoList.add(this.appInfo);
                    } else {
                        String apiUrl = paasEnvParamDao.queryByCodeReturnValue("allinpaas.open.api.http.url");
                        PaasMarketAppinfo param = new PaasMarketAppinfo();
                        param.setMarketAppId(MapUtils.getString(this.extParam, (Object)"marketAppId"));
                        String respJson = this.requestOpenApi(apiUrl + "/om/paas/market/appinfo", (Object)param);
                        if (StringUtils.isBlank((CharSequence)respJson)) {
                            bl = flag = false;
                            if (conn == null) break block12;
                            break block13;
                        }
                        PaasMarketAppinfo marketApp = (PaasMarketAppinfo)((Object)JSON.parseObject((String)respJson, PaasMarketAppinfo.class));
                        appInfoList.add(marketApp);
                    }
                    Iterator iterator = appInfoList.iterator();
                    while (iterator.hasNext()) {
                        PaasMarketAppinfo srcApp = (PaasMarketAppinfo)((Object)iterator.next());
                        File sqliteFile = this.getSqliteFile(srcApp);
                        sqliteConn = this.getSqliteConnection(sqliteFile);
                        PaasMarketAppinfoDao keyMapDao = new PaasMarketAppinfoDao(sqliteConn);
                        String appId = keyMapDao.queryKeyMap(srcApp.getAppId());
                        this.closeSqliteConnection(sqliteConn);
                    }
                    return flag;
                }
                catch (Exception e) {
                    this.logger.error("\u4ecesqlite\u590d\u5236\u7ec4\u4ef6\u6570\u636e\u5230\u5e73\u53f0\u5931\u8d25", (Throwable)e);
                    flag = false;
                    return flag;
                }
            }
            this.closeConnection(conn);
        }
        if (sqliteConn == null) return bl;
        this.closeSqliteConnection(sqliteConn);
        return bl;
        finally {
            if (conn != null) {
                this.closeConnection(conn);
            }
            if (sqliteConn != null) {
                this.closeSqliteConnection(sqliteConn);
            }
        }
    }
}

