/*
 * Decompiled with CFR 0.152.
 */
package com.irdstudio.allinapaas.executor.application.executor.core.plugin.market;

import com.alibaba.fastjson.JSON;
import com.irdstudio.allinapaas.design.console.types.MarketSource;
import com.irdstudio.allinapaas.executor.application.executor.core.dao.DictOptionEnumDao;
import com.irdstudio.allinapaas.executor.application.executor.core.dao.DictOptionInfoDao;
import com.irdstudio.allinapaas.executor.application.executor.core.dao.ModelTableFieldDao;
import com.irdstudio.allinapaas.executor.application.executor.core.dao.PaasEnvParamDao;
import com.irdstudio.allinapaas.executor.application.executor.core.dao.PaasMarketAppinfoDao;
import com.irdstudio.allinapaas.executor.application.executor.core.dao.domain.DictOptionEnum;
import com.irdstudio.allinapaas.executor.application.executor.core.dao.domain.DictOptionInfo;
import com.irdstudio.allinapaas.executor.application.executor.core.dao.domain.ModelTableField;
import com.irdstudio.allinapaas.executor.application.executor.core.dao.domain.PaasMarketAppinfo;
import com.irdstudio.allinapaas.executor.application.executor.core.plugin.market.AbstractMarketTask;
import com.irdstudio.allinapaas.portal.console.types.YesOrNO;
import java.io.File;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.MapUtils;
import org.apache.commons.lang3.StringUtils;

public class CPSqliteDictOptionTask
extends AbstractMarketTask {
    private PaasMarketAppinfo appInfo = null;
    private Map<String, Object> extParam = null;

    @Override
    public boolean initTask(Map<String, Object> extParam, Connection conn) throws SQLException {
        this.extParam = extParam;
        PaasMarketAppinfoDao paasAppsInfoDao = new PaasMarketAppinfoDao(conn);
        this.appInfo = paasAppsInfoDao.queryPaasMarketAppinfo(MapUtils.getString(extParam, (Object)"marketAppId"));
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean execute() {
        boolean flag;
        block24: {
            Connection sqliteConn;
            block23: {
                flag = true;
                Connection conn = null;
                sqliteConn = null;
                try {
                    conn = this.getConnection();
                    PaasEnvParamDao paasEnvParamDao = new PaasEnvParamDao(conn);
                    String subsFlag = MapUtils.getString(this.extParam, (Object)"subsFlag");
                    String marketSource = MapUtils.getString(this.extParam, (Object)"marketSource");
                    String subsId = MapUtils.getString(this.extParam, (Object)"marketSubsId");
                    ArrayList<PaasMarketAppinfo> appInfoList = new ArrayList<PaasMarketAppinfo>();
                    if (StringUtils.equals((CharSequence)marketSource, (CharSequence)MarketSource.Inside.getCode())) {
                        if (StringUtils.equals((CharSequence)subsFlag, (CharSequence)YesOrNO.YES.getCode())) {
                            PaasMarketAppinfoDao paasAppsInfoDao = new PaasMarketAppinfoDao(conn);
                            PaasMarketAppinfo appParam = new PaasMarketAppinfo();
                            appParam.setSubsId(subsId);
                            List<PaasMarketAppinfo> sysApps = paasAppsInfoDao.queryPaasMarketAppinfoList(appParam);
                            appInfoList.addAll(sysApps);
                        } else {
                            appInfoList.add(this.appInfo);
                        }
                    } else {
                        String respJson;
                        PaasMarketAppinfo param;
                        String apiUrl = paasEnvParamDao.queryByCodeReturnValue("allinpaas.open.api.http.url");
                        if (StringUtils.equals((CharSequence)subsFlag, (CharSequence)YesOrNO.YES.getCode())) {
                            param = new PaasMarketAppinfo();
                            param.setSubsId(subsId);
                            respJson = this.requestOpenApi(apiUrl + "/om/paas/market/appinfo/index", (Object)param);
                            if (StringUtils.isBlank((CharSequence)respJson)) {
                                boolean bl = flag = false;
                                return bl;
                            }
                            List sysApps = JSON.parseArray((String)respJson, PaasMarketAppinfo.class);
                            appInfoList.addAll(sysApps);
                        } else {
                            param = new PaasMarketAppinfo();
                            param.setMarketAppId(MapUtils.getString(this.extParam, (Object)"marketAppId"));
                            respJson = this.requestOpenApi(apiUrl + "/om/paas/market/appinfo", (Object)param);
                            if (StringUtils.isBlank((CharSequence)respJson)) {
                                boolean sysApps = flag = false;
                                return sysApps;
                            }
                            PaasMarketAppinfo marketApp = (PaasMarketAppinfo)((Object)JSON.parseObject((String)respJson, PaasMarketAppinfo.class));
                            appInfoList.add(marketApp);
                        }
                    }
                    HashMap<String, DictOptionInfo> optionInfoMap = new HashMap<String, DictOptionInfo>();
                    ArrayList<DictOptionInfo> optionInfoList = new ArrayList<DictOptionInfo>();
                    ArrayList<DictOptionEnum> optionEnumList = new ArrayList<DictOptionEnum>();
                    for (PaasMarketAppinfo srcApp : appInfoList) {
                        File sqliteFile = null;
                        if (StringUtils.equals((CharSequence)subsFlag, (CharSequence)YesOrNO.YES.getCode())) {
                            String marketUrl = paasEnvParamDao.queryByCodeReturnValue("git.market.remote.path");
                            sqliteFile = this.getIMPSysSqliteFile(this.extParam, marketUrl, null);
                        } else {
                            sqliteFile = this.getSqliteFile(srcApp);
                        }
                        sqliteConn = this.getSqliteConnection(sqliteFile);
                        PaasMarketAppinfoDao keyMapDao = new PaasMarketAppinfoDao(sqliteConn);
                        String appId = keyMapDao.queryKeyMap(srcApp.getAppId());
                        ModelTableFieldDao modelTableFieldDao = new ModelTableFieldDao(sqliteConn);
                        DictOptionInfoDao dictOptionInfoDao = new DictOptionInfoDao(sqliteConn);
                        DictOptionEnumDao dictOptionEnumDao = new DictOptionEnumDao(sqliteConn);
                        DictOptionEnumDao descDB_dictOptionEnumDao = new DictOptionEnumDao(conn);
                        DictOptionInfoDao descDB_dictOptionInfoDao = new DictOptionInfoDao(conn);
                        List<ModelTableField> optionsList = modelTableFieldDao.queryModelTableFieldAllOptions(appId);
                        if (CollectionUtils.isNotEmpty(optionsList)) {
                            ArrayList codeBoList = new ArrayList(optionsList.size());
                            for (ModelTableField option : optionsList) {
                                if (StringUtils.isBlank((CharSequence)option.getDictId()) || optionInfoMap.get(option.getDictId()) != null) continue;
                                List<DictOptionEnum> dicts = dictOptionEnumDao.queryDictOptionEnumListByDictId(option.getDictId());
                                DictOptionInfo optionInfo = dictOptionInfoDao.queryByPk(option.getDictId());
                                if (descDB_dictOptionInfoDao.queryByPk(optionInfo.getDictId()) != null) continue;
                                optionInfoMap.put(optionInfo.getDictId(), optionInfo);
                                optionInfoList.add(optionInfo);
                                optionEnumList.addAll(dicts);
                            }
                        }
                        this.closeSqliteConnection(sqliteConn);
                    }
                    this.batchInsertPage("`allinrdm_db`.dict_option_info", optionInfoList, conn);
                    this.batchInsertPage("`allinrdm_db`.dict_option_enum", optionEnumList, conn);
                    if (conn == null) break block23;
                }
                catch (Exception e) {
                    this.logger.error("\u4ecesqlite\u590d\u5236\u6570\u636e\u9009\u9879\u5230\u5e73\u53f0", (Throwable)e);
                    flag = false;
                    break block24;
                }
                finally {
                    if (conn != null) {
                        this.closeConnection(conn);
                    }
                    if (sqliteConn != null) {
                        this.closeSqliteConnection(sqliteConn);
                    }
                }
                this.closeConnection(conn);
            }
            if (sqliteConn != null) {
                this.closeSqliteConnection(sqliteConn);
            }
        }
        return flag;
    }
}

