/*
 * Decompiled with CFR 0.152.
 */
package com.irdstudio.allinapaas.executor.application.executor.core.plugin.scan;

import com.irdstudio.allinapaas.executor.application.executor.core.tinycore.log.ILogger;
import com.irdstudio.allinapaas.quality.console.facade.dto.PluginCheckstyleRptDTO;
import com.irdstudio.allinapaas.quality.console.types.PluginReportStat;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Base64;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import org.jsoup.Jsoup;
import org.jsoup.nodes.Document;
import org.jsoup.nodes.Element;
import org.jsoup.select.Elements;

public class CheckstyleReportParser {
    public static PluginCheckstyleRptDTO parse(String reportId, String appId, File rootDir, File reportFile, ILogger logger) {
        PluginCheckstyleRptDTO reportInfo;
        block34: {
            reportInfo = null;
            try {
                reportInfo = new PluginCheckstyleRptDTO();
                if (reportFile.exists()) {
                    Document doc = Jsoup.parse((File)reportFile.getAbsoluteFile(), (String)"UTF-8", (String)"");
                    Elements elements = ((Element)doc.getElementsByClass("b").get(0)).getElementsByTag("td");
                    for (int i = 0; i < elements.size(); ++i) {
                        logger.info("checkstyle\u7edf\u8ba1\u6267\u884c\u7ed3\u679c:" + ((Element)elements.get(i)).text());
                        if (i == 0) {
                            reportInfo.setChkFiles(Integer.valueOf(((Element)elements.get(i)).text()));
                            continue;
                        }
                        if (i == 1) {
                            reportInfo.setChkInf(Integer.valueOf(((Element)elements.get(i)).text()));
                            continue;
                        }
                        if (i == 2) {
                            reportInfo.setChkWrns(Integer.valueOf(((Element)elements.get(i)).text()));
                            continue;
                        }
                        if (i != 3) continue;
                        reportInfo.setChkErrors(Integer.valueOf(((Element)elements.get(i)).text()));
                    }
                    String directoryPath = reportFile.getParentFile().getAbsolutePath();
                    boolean cpExitCode = false;
                    try (ByteArrayOutputStream baos = new ByteArrayOutputStream();
                         ZipOutputStream zos = new ZipOutputStream(baos);){
                        Path directory = Paths.get(directoryPath, new String[0]);
                        PluginCheckstyleRptDTO finalReportInfo = reportInfo;
                        Files.walk(directory, new FileVisitOption[0]).filter(x$0 -> Files.isRegularFile(x$0, new LinkOption[0])).forEach(file -> {
                            try {
                                String entryName = directory.relativize((Path)file).toString();
                                zos.putNextEntry(new ZipEntry(entryName));
                                Files.copy(file, zos);
                                zos.closeEntry();
                            }
                            catch (IOException e) {
                                logger.error("\u89e3\u6790\u62a5\u544a\u6570\u636e\u53d1\u751f\u5f02\u5e38:" + finalReportInfo.getReportId(), e);
                                finalReportInfo.setErrInf("\u89e3\u6790\u62a5\u544a\u6570\u636e\u53d1\u751f\u5f02\u5e38:" + e.getMessage());
                                finalReportInfo.setReqSts(PluginReportStat.FAIL.getCode());
                            }
                        });
                        zos.finish();
                        byte[] zipData = baos.toByteArray();
                        String base64String = Base64.getEncoder().encodeToString(zipData);
                        reportInfo.setRptData(base64String);
                    }
                    catch (Exception e) {
                        logger.error("\u89e3\u6790\u62a5\u544a\u6570\u636e\u53d1\u751f\u5f02\u5e38:" + reportInfo.getReportId(), e);
                        reportInfo.setErrInf("\u89e3\u6790\u62a5\u544a\u6570\u636e\u53d1\u751f\u5f02\u5e38:" + e.getMessage());
                        reportInfo.setReqSts(PluginReportStat.FAIL.getCode());
                    }
                    reportInfo.setReqSts(PluginReportStat.DONE.getCode());
                    break block34;
                }
                reportInfo.setReqSts(PluginReportStat.FAIL.getCode());
                logger.error("reportId:" + reportInfo.getReportId() + " html\u62a5\u544a\u4e0d\u5b58\u5728");
                reportInfo.setErrInf("html\u62a5\u544a\u4e0d\u5b58\u5728");
            }
            catch (Exception e) {
                logger.error("\u89e3\u6790\u62a5\u544a\u53d1\u751f\u5f02\u5e38:" + reportInfo.getReportId(), e);
                reportInfo.setErrInf("\u89e3\u6790\u62a5\u544a\u53d1\u751f\u5f02\u5e38:" + e.getMessage());
                reportInfo.setReqSts(PluginReportStat.FAIL.getCode());
            }
        }
        return reportInfo;
    }
}

