/*
 * Decompiled with CFR 0.152.
 */
package com.irdstudio.allinapaas.executor.application.executor.core.plugin.util;

import com.irdstudio.allinapaas.executor.application.executor.core.plugin.util.bean.FileReplacePattern;
import com.irdstudio.allinapaas.executor.application.executor.core.plugin.util.bean.ReplaceDirAndFileBean;
import java.io.File;
import java.io.IOException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ProjectGenerateUtil {
    private static Logger logger = LoggerFactory.getLogger(ProjectGenerateUtil.class);

    public static void main(String[] args) throws IOException {
        String srcFilePath = "esaas.member.all";
        String outFilePath = "efp.limit";
        String srcStr = "esaas.member";
        String replaceStr = "efp.limit";
        ProjectGenerateUtil.copyAndRenameProject(srcFilePath, outFilePath, srcStr, replaceStr);
    }

    public static void copyAndRenameProject(String srcFilePath, String outFilePath, String srcStr, String dstStr) {
        logger.info("\u4ece{}\u590d\u5236\u5e76\u91cd\u547d\u4ee4\u5de5\u7a0b\u5230{}...", (Object)srcFilePath, (Object)outFilePath);
        srcFilePath = new File(srcFilePath).getAbsolutePath();
        outFilePath = new File(outFilePath).getAbsolutePath();
        ReplaceDirAndFileBean rdfb = new ReplaceDirAndFileBean(srcFilePath, outFilePath, srcStr, dstStr);
        rdfb.addFileReplacePattern(new FileReplacePattern("*", srcStr.replace(".", "-"), dstStr.replaceAll("_|\\.", "-")));
        rdfb.addFileReplacePattern(new FileReplacePattern("pom.xml", "fdb." + dstStr, "fdb." + dstStr.split("\\.")[0].replaceAll("_|-", ".")));
        rdfb.setIgnorePostfix("html,css,js");
        rdfb.execute();
        logger.info("\u4ece{}\u590d\u5236\u5e76\u91cd\u547d\u4ee4\u5de5\u7a0b\u5230{}\u5b8c\u6210!", (Object)srcFilePath, (Object)outFilePath);
    }
}

