/*
 * Decompiled with CFR 0.152.
 */
package com.irdstudio.allinapaas.executor.application.executor.core.batch;

import com.irdstudio.allinapaas.deliver.console.facade.BatBatchSourceService;
import com.irdstudio.allinapaas.deliver.console.facade.dto.BatBatchSourceDTO;
import com.irdstudio.allinapaas.executor.application.executor.core.batch.BatchDataUtil;
import com.irdstudio.allinapaas.executor.application.executor.core.batch.BatchTaskThread;
import com.irdstudio.allinapaas.executor.application.executor.core.batch.RepoPullTask;
import com.irdstudio.allinapaas.executor.application.executor.core.dao.BatBatchStageConfigDao;
import com.irdstudio.allinapaas.executor.application.executor.core.dao.BatInstBatchDao;
import com.irdstudio.allinapaas.executor.application.executor.core.dao.BatInstTaskDao;
import com.irdstudio.allinapaas.executor.application.executor.core.dao.BatTaskUnitConfigDao;
import com.irdstudio.allinapaas.executor.application.executor.core.dao.domain.BatBatchInfoConfig;
import com.irdstudio.allinapaas.executor.application.executor.core.dao.domain.BatBatchStageConfig;
import com.irdstudio.allinapaas.executor.application.executor.core.dao.domain.BatInstBatch;
import com.irdstudio.allinapaas.executor.application.executor.core.dao.domain.BatInstTask;
import com.irdstudio.allinapaas.executor.application.executor.core.dao.domain.BatTaskUnitConfig;
import com.irdstudio.allinapaas.executor.application.executor.core.tinycore.jdbc.dbcp.TConnPool;
import com.irdstudio.allinapaas.executor.application.executor.core.tinycore.log.ILogger;
import com.irdstudio.allinapaas.executor.application.executor.core.tinycore.log.LoggerFactory;
import com.irdstudio.allinapaas.executor.application.executor.core.tinycore.log.TLogger;
import com.irdstudio.allinapaas.executor.application.executor.core.tinycore.thread.TThreadPools;
import com.irdstudio.allinapaas.executor.application.executor.core.util.date.CurrentDateUtil;
import com.irdstudio.allinapaas.executor.application.executor.core.util.pub.Convert;
import com.irdstudio.allinapaas.executor.types.ExecutorInstInfo;
import com.irdstudio.framework.beans.core.util.SpringContextUtils;
import java.io.File;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import org.apache.commons.lang3.StringUtils;

public class BatchRunProcess
extends Thread {
    private String batchId = "";
    private String batchSerialNo = "";
    private BatBatchInfoConfig batchConfig = null;
    private BatInstBatch batchInst = null;
    private Map<String, BatTaskUnitConfig> taskConfigMap = null;
    private int runState = 8;
    private int equallyTaskAmount = 0;
    private Integer taskThreadAmount = 0;
    private Connection conn = null;
    private ILogger logger = null;
    private ExecutorService threadPool = null;
    private static final Object taskThreadAmountLock = new Object();
    private BatBatchSourceDTO batBatchSource;

    public BatchRunProcess(BatBatchInfoConfig batchConfig) {
        this.batchConfig = batchConfig;
    }

    public BatchRunProcess(String batchSerialNo, BatBatchInfoConfig batchConfig) {
        this.batchSerialNo = batchSerialNo;
        this.batchConfig = batchConfig;
    }

    public BatchRunProcess(String batchId) {
        this.batchId = batchId;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        block19: {
            BatInstBatchDao batchInstDao = null;
            try {
                this.conn = TConnPool.getDefaultPool().getConnection();
                if (null == this.batchConfig) {
                    this.batchConfig = BatchDataUtil.getBatBatchInfoConfig(this.conn, this.batchId);
                } else {
                    this.batchId = this.batchConfig.getBatchId();
                }
                this.batchInst = StringUtils.isNotBlank((CharSequence)this.batchSerialNo) ? BatchDataUtil.getBatInstBatchByBatchSerialNo(this.conn, this.batchSerialNo) : BatchDataUtil.getBatInstBatch(this.conn, this.batchId);
                if (this.batchInst == null) {
                    throw new SQLException("\u672a\u8bfb\u53d6\u5230\u6279\u6b21\u5b9e\u4f8b:" + this.batchId);
                }
                String fullLogFileName = ExecutorInstInfo.BATCH_LOG_PATH + File.separator + this.batchInst.getBatchSerialNo() + ".log";
                System.err.println(fullLogFileName);
                ILogger fileLogger = LoggerFactory.makeTxtFileLogger(fullLogFileName, true);
                fileLogger.setName(this.batchInst.getBatchSerialNo());
                TLogger.registerCategoryLogger(this.batchInst.getBatchSerialNo(), fileLogger);
                this.logger = TLogger.getLogger(this.batchInst.getBatchSerialNo());
                this.logger.info("[" + this.batchId + "]\u6279\u6b21\u5f00\u59cb...");
                this.threadPool = TThreadPools.getThreadPool(this.batchInst.getBatchSerialNo());
                if (!this.loadBatchSource()) {
                    throw new RuntimeException("\u52a0\u8f7d\u6d41\u6c34\u7ebf\u6570\u636e\u6e90\u5f02\u5e38");
                }
                this.equallyTaskAmount = this.batchConfig.getEquallyTaskAmount();
                this.batchInst.setStartTime(CurrentDateUtil.getTodayDateEx2());
                String szCondition = "where batch_id = '" + this.batchId + "' ";
                this.taskConfigMap = new Hashtable<String, BatTaskUnitConfig>();
                BatTaskUnitConfigDao taskConfigDao = new BatTaskUnitConfigDao(this.conn);
                List<BatTaskUnitConfig> btucList = taskConfigDao.queryWithCond(szCondition, " and task_use_state='0'");
                for (int k = 0; k < btucList.size(); ++k) {
                    this.taskConfigMap.put(btucList.get(k).getTaskId(), btucList.get(k));
                }
                BatBatchStageConfigDao stageDao = new BatBatchStageConfigDao(this.conn);
                String szOrderBy = "order by stage_order asc";
                List<BatBatchStageConfig> stageList = stageDao.queryWithCond(szCondition, szOrderBy);
                batchInstDao = new BatInstBatchDao(this.conn);
                for (int i = 0; i < stageList.size(); ++i) {
                    if (this.conn.isClosed()) {
                        this.conn = TConnPool.getDefaultPool().getConnection();
                        batchInstDao = new BatInstBatchDao(this.conn);
                    }
                    String stageId = stageList.get(i).getStageId();
                    this.logger.info("Stage:" + stageId);
                    this.batchInst.setStageId(stageId);
                    batchInstDao.updateStage(this.batchInst);
                    while (!this.doFinishStageAllTask(this.conn, stageId) && this.runState != 1) {
                        this.logger.info(Thread.currentThread().getName() + " Sleep 10 second!!!");
                        Thread.sleep(10000L);
                    }
                    if (this.runState != 1) continue;
                    this.batchInst.setBatchState(String.valueOf(this.runState));
                    batchInstDao.updateBatchToEnd(this.batchInst);
                    break;
                }
                if (this.runState != 1) {
                    this.batchInst.setBatchState(String.valueOf(9));
                    batchInstDao.updateBatchToEnd(this.batchInst);
                }
            }
            catch (Exception e) {
                this.logger.error(e.getMessage(), e);
                this.runState = 1;
                if (null != this.batchInst) {
                    this.batchInst.setBatchState(String.valueOf(this.runState));
                    this.batchInst.setRemark(e.getMessage());
                    try {
                        if (batchInstDao != null) {
                            batchInstDao.updateBatchToEnd(this.batchInst);
                        }
                        break block19;
                    }
                    catch (SQLException e1) {
                        this.logger.error("\u66f4\u65b0\u6d41\u6c34\u7ebf\u5b9e\u4f8b\u72b6\u6001\u5f02\u5e38 " + e1.getMessage(), e1);
                    }
                    break block19;
                }
                this.logger.error("\u6279\u6b21\u8fd0\u884c\u5b9e\u4f8b\u4fe1\u606f  batchInst \u4e3a\u7a7a\u6307\u9488\uff0c\u65e0\u6cd5\u66f4\u65b0\u6279\u6b21\u72b6\u6001");
            }
            finally {
                TConnPool.getDefaultPool().releaseConnection(this.conn);
                if (null != this.batchInst) {
                    TThreadPools.showdownThreadPool(this.batchInst.getBatchSerialNo());
                }
                this.logger.info("\u6279\u6b21\u7ed3\u675f..." + Thread.currentThread().getName());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean doFinishStageAllTask(Connection conn, String stageId) throws SQLException, InterruptedException {
        boolean bFinished = true;
        Object object = taskThreadAmountLock;
        synchronized (object) {
            if (this.taskThreadAmount >= this.equallyTaskAmount) {
                this.logger.info("\u8fbe\u5230\u6700\u5927\u5e76\u53d1\u6570--->taskThreadAmount[" + this.taskThreadAmount + "] >= equallyTaskAmount[" + this.taskThreadAmount + "]");
                return false;
            }
        }
        String allTaskCond = "where batch_id = '" + this.batchId + "' and batch_serial_no = '" + this.batchSerialNo + "' and stage_id = '" + stageId + "' order by task_run_state desc,task_id asc";
        if (conn.isClosed()) {
            conn = TConnPool.getDefaultPool().getConnection();
        }
        BatInstTaskDao instTaskDao = new BatInstTaskDao(conn);
        List<BatInstTask> allTaskList = instTaskDao.queryWithCond(allTaskCond, "");
        for (int i = 0; i < allTaskList.size(); ++i) {
            BatInstTask taskInst = allTaskList.get(i);
            BatTaskUnitConfig taskConf = this.taskConfigMap.get(taskInst.getTaskId());
            this.runState = this.getBatchRunStateWithTask(taskInst, taskConf);
            if (this.runState == 1) {
                this.logger.info("[" + stageId + "]\u4e0b\u6279\u6b21\u4efb\u52a1\u8fd0\u884c\u5931\u8d25...");
                return false;
            }
            if (this.isTaskCanRun(taskInst, taskConf)) {
                Object object2 = taskThreadAmountLock;
                synchronized (object2) {
                    if (this.taskThreadAmount >= this.equallyTaskAmount) {
                        this.logger.info("\u542f\u52a8\u4e00\u4e2a\u7ebf\u7a0b\u8fd0\u884c\u4efb\u52a1\u65f6\uff0c\u8fbe\u5230\u6700\u5927\u7ebf\u7a0b --> taskThreadAmount[" + this.taskThreadAmount + "] >= equallyTaskAmount[" + this.taskThreadAmount + "]");
                        return false;
                    }
                    this.doTaskTheadCalc(1);
                    this.logger.info(taskInst.getTaskName() + "[" + taskInst.getTaskId() + "]\u542f\u52a8\u7ebf\u7a0b\u5904\u7406...\u4efb\u52a1\u7ebf\u7a0b\u6570\uff1a" + this.taskThreadAmount);
                    BatchTaskThread taskThread = new BatchTaskThread(this.batchInst, taskInst, taskConf, this);
                    if (this.threadPool == null || this.threadPool.isTerminated()) {
                        this.threadPool = TThreadPools.getThreadPool(this.batchInst.getBatchSerialNo());
                    }
                    this.threadPool.execute(taskThread);
                    this.logger.info(taskInst.getTaskName() + "[" + taskInst.getTaskId() + "]\u542f\u52a8\u7ebf\u7a0b\u5904\u7406\u6210\u529f...");
                }
                bFinished = false;
                continue;
            }
            bFinished = bFinished && this.isTaskRunSuccess(taskInst);
        }
        return bFinished;
    }

    private boolean isTaskCanRun(BatInstTask taskInst, BatTaskUnitConfig taskConf) throws SQLException, InterruptedException {
        boolean isCanRun = false;
        int state = Convert.StrToInt(taskInst.getTaskRunState(), 7);
        if ((state == 0 || state == 1) && taskConf != null) {
            if (taskConf.getPreviousTaskId() == null || "".equals(taskConf.getPreviousTaskId())) {
                isCanRun = true;
            } else {
                this.logger.info(taskInst.getTaskName() + "[" + taskInst.getTaskId() + "]\u5224\u65ad\u524d\u7f6e\u4efb\u52a1\u662f\u5426\u5b8c\u6210 [" + taskConf.getPreviousTaskId() + "]");
                if (this.isPreviousTaskOk(taskConf.getPreviousTaskId())) {
                    this.logger.info(taskInst.getTaskName() + "[" + taskInst.getTaskId() + "]\u5224\u65ad\u524d\u7f6e\u4efb\u52a1\u662f\u5426\u5b8c\u6210 [" + taskConf.getPreviousTaskId() + "] \u6267\u884c\u5b8c\u6210 \u7ebf\u7a0b\u7761\u7720\u4e00\u4e0b");
                    Thread.sleep(2000L);
                    isCanRun = true;
                }
            }
        }
        return isCanRun;
    }

    private int getBatchRunStateWithTask(BatInstTask taskInst, BatTaskUnitConfig taskConf) {
        int batchState = this.runState;
        int state = Convert.StrToInt(taskInst.getTaskRunState(), 7);
        if (7 == state) {
            int skipTactic = Convert.StrToInt(taskConf.getTaskSkipTactic(), 2);
            if (skipTactic != 0) {
                if (skipTactic == 1) {
                    int interveneState = Convert.StrToInt(taskInst.getTaskInterveneState());
                    if (interveneState != 1) {
                        batchState = 1;
                    }
                } else {
                    batchState = 1;
                }
            }
        } else {
            batchState = 3;
        }
        return batchState;
    }

    private boolean isPreviousTaskOk(String previousTaskId) throws SQLException {
        BatInstTaskDao instTaskDao = new BatInstTaskDao(this.conn);
        BatInstTask taskInst = instTaskDao.queryWithKeys(this.batchInst.getBatchId(), this.batchInst.getBatchSerialNo(), this.batchInst.getBatchOrder(), previousTaskId);
        if (taskInst == null) {
            return true;
        }
        return this.isTaskRunSuccess(taskInst);
    }

    private boolean isTaskRunSuccess(BatInstTask taskInst) {
        int state = Convert.StrToInt(taskInst.getTaskRunState(), 7);
        int interveneState = Convert.StrToInt(taskInst.getTaskInterveneState(), 0);
        return state == 6 || interveneState == 1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doTaskTheadCalc(int i) {
        Object object = taskThreadAmountLock;
        synchronized (object) {
            this.taskThreadAmount = this.taskThreadAmount + i;
        }
    }

    private boolean loadBatchSource() {
        boolean flag = true;
        BatBatchSourceService batBatchSourceService = (BatBatchSourceService)SpringContextUtils.getBean(BatBatchSourceService.class);
        this.batBatchSource = new BatBatchSourceDTO();
        this.batBatchSource.setBatchId(this.batchId);
        this.batBatchSource = (BatBatchSourceDTO)batBatchSourceService.queryByPk((Object)this.batBatchSource);
        if (this.batBatchSource == null) {
            this.batBatchSource = new BatBatchSourceDTO();
            this.batBatchSource.setBatchId(this.batchId);
        }
        RepoPullTask pullTask = new RepoPullTask(this.batchSerialNo, this.batBatchSource);
        pullTask.syncRun();
        if (!pullTask.getStatus()) {
            throw new RuntimeException("\u6d41\u6c34\u7ebf\u6570\u636e\u6e90\u52a0\u8f7d\u5f02\u5e38");
        }
        this.batBatchSource.setRepoLocalPath(pullTask.getRepoLocalPath());
        return flag;
    }

    public BatBatchSourceDTO getBatBatchSource() {
        return this.batBatchSource;
    }
}

