/*
 * Decompiled with CFR 0.152.
 */
package com.irdstudio.allinapaas.executor.application.executor.core.dao;

import com.alibaba.fastjson.JSON;
import com.irdstudio.allinapaas.executor.application.executor.core.dao.AbstractPortalPageDao;
import com.irdstudio.allinapaas.executor.application.executor.core.dao.domain.ModelTableField;
import com.irdstudio.allinapaas.executor.application.executor.core.util.db.ProxySQL;
import com.irdstudio.allinrdm.dam.console.types.ObjectType;
import com.irdstudio.sdk.beans.core.util.POJOUtils;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ModelTableFieldDao
extends AbstractPortalPageDao {
    private static final Logger logger = LoggerFactory.getLogger(ModelTableFieldDao.class);
    Connection conn = null;

    public ModelTableFieldDao(Connection conn) {
        super(conn);
        this.conn = conn;
    }

    public List<ModelTableField> queryModelTableFieldList(final String objectId) throws Exception {
        final ArrayList param = new ArrayList();
        String sql = new ProxySQL(){
            {
                this.SELECT("*");
                this.FROM("`allinrdm_db`.model_table_field");
                this.WHERE("object_id = ?");
                param.add(objectId);
                this.ORDER_BY("field_order");
            }
        }.toString();
        PreparedStatement ps = null;
        ResultSet rs = null;
        ArrayList<ModelTableField> list = new ArrayList<ModelTableField>();
        try {
            ps = this.conn.prepareStatement(sql);
            for (int i = 0; i < param.size(); ++i) {
                ps.setObject(i + 1, param.get(i));
            }
            rs = ps.executeQuery();
            while (rs.next()) {
                ModelTableField bean = (ModelTableField)((Object)POJOUtils.generatePOJO((ResultSet)rs, ModelTableField.class));
                list.add(bean);
            }
        }
        catch (Exception e) {
            throw new RuntimeException("query queryModelTableFieldList is wrong", e);
        }
        finally {
            if (ps != null) {
                try {
                    ps.close();
                }
                catch (SQLException e) {
                    logger.error(e.getMessage(), (Throwable)e);
                }
            }
        }
        return list;
    }

    public List<ModelTableField> queryModelTableFieldList(final String objectId, final String srvModelCatalog, final String srvModelType) throws Exception {
        final ArrayList param = new ArrayList();
        String sql = new ProxySQL(){
            {
                this.SELECT("t.*, ( select field_flag from `allinrdm_db`.srv_field_flag f where t.field_id = f.field_id and f.srv_model_catalog=? AND f.srv_model_type=? limit 1 ) as field_flag");
                param.add(srvModelCatalog);
                param.add(srvModelType);
                this.FROM("`allinrdm_db`.model_table_field t");
                this.WHERE("t.object_id = ?");
                param.add(objectId);
                this.ORDER_BY("field_order");
            }
        }.toString();
        PreparedStatement ps = null;
        ResultSet rs = null;
        ArrayList<ModelTableField> list = new ArrayList<ModelTableField>();
        try {
            ps = this.conn.prepareStatement(sql);
            for (int i = 0; i < param.size(); ++i) {
                ps.setObject(i + 1, param.get(i));
            }
            rs = ps.executeQuery();
            while (rs.next()) {
                ModelTableField bean = (ModelTableField)((Object)POJOUtils.generatePOJO((ResultSet)rs, ModelTableField.class));
                list.add(bean);
            }
        }
        catch (Exception e) {
            throw new RuntimeException("query queryModelTableFieldList is wrong", e);
        }
        finally {
            if (ps != null) {
                try {
                    ps.close();
                }
                catch (SQLException e) {
                    logger.error(e.getMessage(), (Throwable)e);
                }
            }
        }
        return list;
    }

    public ModelTableField queryModelTableFieldByFieldId(final String fieldId) throws Exception {
        final ArrayList param = new ArrayList();
        String sql = new ProxySQL(){
            {
                this.SELECT("*");
                this.FROM("`allinrdm_db`.model_table_field");
                this.WHERE("field_id = ?");
                param.add(fieldId);
            }
        }.toString();
        PreparedStatement ps = null;
        ResultSet rs = null;
        ArrayList<ModelTableField> list = new ArrayList<ModelTableField>(2);
        try {
            ps = this.conn.prepareStatement(sql);
            for (int i = 0; i < param.size(); ++i) {
                ps.setObject(i + 1, param.get(i));
            }
            rs = ps.executeQuery();
            while (rs.next()) {
                ModelTableField bean = (ModelTableField)((Object)POJOUtils.generatePOJO((ResultSet)rs, ModelTableField.class));
                list.add(bean);
            }
        }
        catch (Exception e) {
            throw new RuntimeException("query queryModelTableInfoList is wrong", e);
        }
        finally {
            if (ps != null) {
                try {
                    ps.close();
                }
                catch (SQLException e) {
                    logger.error(e.getMessage(), (Throwable)e);
                }
            }
        }
        return list.isEmpty() ? null : (ModelTableField)((Object)list.get(0));
    }

    public List<ModelTableField> queryModelTableFieldAllOptions(String appId) throws SQLException {
        PreparedStatement ps = null;
        ResultSet rs = null;
        ArrayList<ModelTableField> result = new ArrayList<ModelTableField>();
        try {
            String sql = "select distinct item_id, field_option, dict_id from `allinrdm_db`.model_table_field t where exists ( select object_id from `allinrdm_db`.model_table_info tb where tb.app_id = ? and t.object_id = tb.object_id ) and ifnull(field_option, '') <> ''";
            ps = this.conn.prepareStatement(sql);
            ps.setString(1, appId);
            rs = ps.executeQuery();
            while (rs.next()) {
                ModelTableField obj = (ModelTableField)((Object)POJOUtils.generatePOJO((ResultSet)rs, ModelTableField.class));
                result.add(obj);
            }
        }
        catch (SQLException e) {
            throw new SQLException("update MigrateTableField is Wrong!" + e.getMessage());
        }
        finally {
            if (ps != null) {
                try {
                    ps.close();
                }
                catch (SQLException e) {
                    logger.error(e.getMessage(), (Throwable)e);
                }
            }
        }
        return result;
    }

    public int updateByPk(final ModelTableField field) throws SQLException {
        final ArrayList param = new ArrayList();
        String sql = new ProxySQL(){
            {
                this.UPDATE("`allinrdm_db`.model_table_field");
                List vals = POJOUtils.getPOJOValues((Object)((Object)field), (boolean)true);
                for (Object[] val : vals) {
                    if (val[0].toString().equals("field_id")) continue;
                    this.SET(String.format("%s = ?", val[0].toString()));
                    param.add(val[1]);
                }
                this.WHERE("field_id = ?");
                param.add(field.getFieldId());
            }
        }.toString();
        if (param.size() < 2) {
            return 0;
        }
        PreparedStatement ps = null;
        Object rs = null;
        int result = 0;
        try {
            ps = this.conn.prepareStatement(sql);
            for (int i = 0; i < param.size(); ++i) {
                ps.setObject(i + 1, param.get(i));
            }
            result = ps.executeUpdate();
        }
        catch (Exception e) {
            throw new RuntimeException("query queryModelTableInfoList is wrong", e);
        }
        finally {
            if (ps != null) {
                try {
                    ps.close();
                }
                catch (SQLException e) {
                    logger.error(e.getMessage(), (Throwable)e);
                }
            }
        }
        return result;
    }

    public ResultSet queryFieldByAppId(final String appId, final Integer objectType) throws Exception {
        final ArrayList param = new ArrayList();
        String sql = new ProxySQL(){
            {
                this.SELECT("ff.*");
                this.FROM("`allinrdm_db`.model_table_field ff");
                this.WHERE("exists ( select tb.object_id from `allinrdm_db`.model_table_info tb where tb.app_id = ? and tb.object_id = ff.object_id and tb.object_type = ?)");
                param.add(appId);
                param.add(objectType);
            }
        }.toString();
        PreparedStatement ps = null;
        ResultSet rs = null;
        ArrayList list = new ArrayList();
        try {
            ps = this.conn.prepareStatement(sql);
            for (int i = 0; i < param.size(); ++i) {
                ps.setObject(i + 1, param.get(i));
            }
            rs = ps.executeQuery();
        }
        catch (Exception e) {
            throw new RuntimeException("query queryFieldByProjectId is wrong", e);
        }
        finally {
            if (ps != null) {
                try {
                    ps.close();
                }
                catch (SQLException e) {
                    logger.error(e.getMessage(), (Throwable)e);
                }
            }
        }
        return rs;
    }

    public List<ModelTableField> queryFieldByAppId(final String appId) throws Exception {
        final ArrayList param = new ArrayList();
        String sql = new ProxySQL(){
            {
                this.SELECT("ff.*");
                this.FROM("`allinrdm_db`.model_table_field ff");
                this.WHERE("exists ( select tb.object_id from `allinrdm_db`.model_table_info tb where tb.app_id = ? and tb.object_id = ff.object_id)");
                param.add(appId);
                this.ORDER_BY("FIELD_ORDER");
            }
        }.toString();
        PreparedStatement ps = null;
        ResultSet rs = null;
        ArrayList<ModelTableField> list = new ArrayList<ModelTableField>();
        try {
            ps = this.conn.prepareStatement(sql);
            for (int i = 0; i < param.size(); ++i) {
                ps.setObject(i + 1, param.get(i));
            }
            rs = ps.executeQuery();
            while (rs.next()) {
                ModelTableField bean = (ModelTableField)((Object)POJOUtils.generatePOJO((ResultSet)rs, ModelTableField.class));
                list.add(bean);
            }
        }
        catch (Exception e) {
            throw new RuntimeException("query queryFieldByProjectId is wrong", e);
        }
        finally {
            if (ps != null) {
                try {
                    ps.close();
                }
                catch (SQLException e) {
                    logger.error(e.getMessage(), (Throwable)e);
                }
            }
        }
        return list;
    }

    public ModelTableField queryByPk(final String fieldId) throws Exception {
        final ArrayList param = new ArrayList();
        String sql = new ProxySQL(){
            {
                this.SELECT("*");
                this.FROM("`allinrdm_db`.model_table_field");
                this.WHERE("field_id = ?");
                param.add(fieldId);
            }
        }.toString();
        PreparedStatement ps = null;
        ResultSet rs = null;
        ArrayList<ModelTableField> list = new ArrayList<ModelTableField>();
        try {
            ps = this.conn.prepareStatement(sql);
            for (int i = 0; i < param.size(); ++i) {
                ps.setObject(i + 1, param.get(i));
            }
            rs = ps.executeQuery();
            while (rs.next()) {
                ModelTableField bean = (ModelTableField)((Object)POJOUtils.generatePOJO((ResultSet)rs, ModelTableField.class));
                list.add(bean);
            }
        }
        catch (Exception e) {
            throw new RuntimeException("query queryModelTableFieldList is wrong", e);
        }
        finally {
            if (ps != null) {
                try {
                    ps.close();
                }
                catch (SQLException e) {
                    logger.error(e.getMessage(), (Throwable)e);
                }
            }
        }
        return list.isEmpty() ? null : (ModelTableField)((Object)list.get(0));
    }

    public int updateOsrvEvalIsrvFieldCode(final String isrvFieldId, final String oldIsrvFieldCode, final String newIsrvFieldCode) {
        final ArrayList param = new ArrayList();
        String sql = new ProxySQL(){
            {
                this.UPDATE("`allinrdm_db`.osrv_eval_isrv");
                this.SET("eval_content = REPLACE(eval_content,?, ?)");
                param.add(oldIsrvFieldCode);
                param.add(newIsrvFieldCode);
                this.WHERE("eval_content like concat('%',?,'%')");
                param.add(isrvFieldId);
            }
        }.toString();
        if (param.size() < 2) {
            return 0;
        }
        PreparedStatement ps = null;
        Object rs = null;
        int result = 0;
        try {
            ps = this.conn.prepareStatement(sql);
            for (int i = 0; i < param.size(); ++i) {
                ps.setObject(i + 1, param.get(i));
            }
            result = ps.executeUpdate();
        }
        catch (Exception e) {
            throw new RuntimeException("query queryModelTableInfoList is wrong", e);
        }
        finally {
            if (ps != null) {
                try {
                    ps.close();
                }
                catch (SQLException e) {
                    logger.error(e.getMessage(), (Throwable)e);
                }
            }
        }
        return result;
    }

    public int updateIsrvValidateRuleFieldCode(final String isrvFieldId, final String oldIsrvFieldCode, final String newIsrvFieldCode) {
        final ArrayList param = new ArrayList();
        String sql = new ProxySQL(){
            {
                this.UPDATE("`allinrdm_db`.srv_model_validate");
                this.SET("rule_expression = REPLACE(rule_expression,?, ?)");
                param.add(oldIsrvFieldCode);
                param.add(newIsrvFieldCode);
                this.WHERE("rule_expression like concat('%',?,'%')");
                param.add(isrvFieldId);
            }
        }.toString();
        if (param.size() < 2) {
            return 0;
        }
        PreparedStatement ps = null;
        Object rs = null;
        int result = 0;
        try {
            ps = this.conn.prepareStatement(sql);
            for (int i = 0; i < param.size(); ++i) {
                ps.setObject(i + 1, param.get(i));
            }
            result = ps.executeUpdate();
        }
        catch (Exception e) {
            throw new RuntimeException("query queryModelTableInfoList is wrong", e);
        }
        finally {
            if (ps != null) {
                try {
                    ps.close();
                }
                catch (SQLException e) {
                    logger.error(e.getMessage(), (Throwable)e);
                }
            }
        }
        return result;
    }

    public int updateIsrv(final String tableName, final ModelTableField field) {
        final ArrayList param = new ArrayList();
        String sql = new ProxySQL(){
            {
                this.UPDATE(tableName);
                this.SET("table_field_code=?");
                param.add(field.getFieldCode());
                this.SET("eval_content=?");
                param.add(field.getFieldCode());
                this.SET("table_field_name=?");
                param.add(field.getFieldName());
                this.SET("eval_desc=?");
                param.add(field.getFieldName());
                this.WHERE("table_field_id = ? and field_eval_way = '1'");
                param.add(field.getFieldId());
            }
        }.toString();
        if (param.size() < 2) {
            return 0;
        }
        PreparedStatement ps = null;
        Object rs = null;
        int result = 0;
        try {
            ps = this.conn.prepareStatement(sql);
            for (int i = 0; i < param.size(); ++i) {
                ps.setObject(i + 1, param.get(i));
            }
            result = ps.executeUpdate();
        }
        catch (Exception e) {
            throw new RuntimeException("query updateIsrv is wrong", e);
        }
        finally {
            if (ps != null) {
                try {
                    ps.close();
                }
                catch (SQLException e) {
                    logger.error(e.getMessage(), (Throwable)e);
                }
            }
        }
        return result;
    }

    public int updateIsrvDomainField(final String tableName, final ModelTableField field) {
        final ArrayList param = new ArrayList();
        String sql = new ProxySQL(){
            {
                this.UPDATE(tableName);
                this.SET("domain_field_id=?");
                param.add(field.getFieldId());
                this.SET("domain_field_code=?");
                param.add(field.getFieldCode());
                this.SET("domain_field_name=?");
                param.add(field.getFieldName());
                this.SET("eval_content=?");
                param.add(field.getFieldCode());
                this.SET("eval_desc=?");
                param.add(field.getFieldName());
                this.WHERE("domain_field_id = ? and field_eval_way in ('1', '5')");
                param.add(field.getFieldId());
            }
        }.toString();
        if (param.size() < 2) {
            return 0;
        }
        PreparedStatement ps = null;
        Object rs = null;
        int result = 0;
        try {
            ps = this.conn.prepareStatement(sql);
            for (int i = 0; i < param.size(); ++i) {
                ps.setObject(i + 1, param.get(i));
            }
            result = ps.executeUpdate();
        }
        catch (Exception e) {
            throw new RuntimeException("query updateIsrv is wrong", e);
        }
        finally {
            if (ps != null) {
                try {
                    ps.close();
                }
                catch (SQLException e) {
                    logger.error(e.getMessage(), (Throwable)e);
                }
            }
        }
        return result;
    }

    public int updateIsrvWay(final String tableName, final ModelTableField field) {
        final ArrayList param = new ArrayList();
        String sql = new ProxySQL(){
            {
                this.UPDATE(tableName);
                this.SET("table_field_code=?");
                param.add(field.getFieldCode());
                this.SET("table_field_name=?");
                param.add(field.getFieldName());
                this.WHERE("table_field_id = ? and field_eval_way != '1'");
                param.add(field.getFieldId());
            }
        }.toString();
        if (param.size() < 2) {
            return 0;
        }
        PreparedStatement ps = null;
        Object rs = null;
        int result = 0;
        try {
            ps = this.conn.prepareStatement(sql);
            for (int i = 0; i < param.size(); ++i) {
                ps.setObject(i + 1, param.get(i));
            }
            result = ps.executeUpdate();
        }
        catch (Exception e) {
            throw new RuntimeException("query updateIsrvWay is wrong", e);
        }
        finally {
            if (ps != null) {
                try {
                    ps.close();
                }
                catch (SQLException e) {
                    logger.error(e.getMessage(), (Throwable)e);
                }
            }
        }
        return result;
    }

    public int updateOsrvEvalIsrv(final ModelTableField field) {
        final ArrayList param = new ArrayList();
        String sql = new ProxySQL(){
            {
                this.UPDATE("`allinrdm_db`.osrv_eval_isrv");
                this.SET("isrv_field_code=?");
                param.add(field.getFieldCode());
                this.SET("isrv_field_name=?");
                param.add(field.getFieldName());
                this.WHERE("isrv_field_id = ?");
                param.add(field.getFieldId());
            }
        }.toString();
        if (param.size() < 2) {
            return 0;
        }
        PreparedStatement ps = null;
        Object rs = null;
        int result = 0;
        try {
            ps = this.conn.prepareStatement(sql);
            for (int i = 0; i < param.size(); ++i) {
                ps.setObject(i + 1, param.get(i));
            }
            result = ps.executeUpdate();
        }
        catch (Exception e) {
            throw new RuntimeException("query updateIsrv is wrong", e);
        }
        finally {
            if (ps != null) {
                try {
                    ps.close();
                }
                catch (SQLException e) {
                    logger.error(e.getMessage(), (Throwable)e);
                }
            }
        }
        return result;
    }

    public int updateOsrvEvalVar(final ModelTableField field) {
        final ArrayList param = new ArrayList();
        String sql = new ProxySQL(){
            {
                this.UPDATE("`allinrdm_db`.osrv_eval_var");
                this.SET("domain_field_code=?");
                param.add(field.getFieldCode());
                this.SET("domain_field_name=?");
                param.add(field.getFieldName());
                this.WHERE("domain_field_id = ?");
                param.add(field.getFieldId());
            }
        }.toString();
        if (param.size() < 2) {
            return 0;
        }
        PreparedStatement ps = null;
        Object rs = null;
        int result = 0;
        try {
            ps = this.conn.prepareStatement(sql);
            for (int i = 0; i < param.size(); ++i) {
                ps.setObject(i + 1, param.get(i));
            }
            result = ps.executeUpdate();
        }
        catch (Exception e) {
            throw new RuntimeException("query updateOsrvEvalVar is wrong", e);
        }
        finally {
            if (ps != null) {
                try {
                    ps.close();
                }
                catch (SQLException e) {
                    logger.error(e.getMessage(), (Throwable)e);
                }
            }
        }
        return result;
    }

    public boolean insert(final ModelTableField obj) throws SQLException {
        final ArrayList param = new ArrayList();
        String sql = new ProxySQL(){
            {
                this.INSERT_INTO("`allinrdm_db`.model_table_field");
                List vals = POJOUtils.getPOJOValues((Object)((Object)obj));
                for (Object[] val : vals) {
                    this.VALUES(val[0].toString(), "?");
                    param.add(val[1]);
                }
            }
        }.toString();
        PreparedStatement ps = null;
        Object rs = null;
        try {
            ps = this.conn.prepareStatement(sql);
            for (int i = 0; i < param.size(); ++i) {
                ps.setObject(i + 1, param.get(i));
            }
            int re = ps.executeUpdate();
            if (re == 1) {
                boolean bl = true;
                return bl;
            }
        }
        catch (Exception e) {
            throw new RuntimeException("insert is wrong " + JSON.toJSON((Object)((Object)obj)), e);
        }
        finally {
            if (ps != null) {
                try {
                    ps.close();
                }
                catch (SQLException e) {
                    logger.error(e.getMessage(), (Throwable)e);
                }
            }
        }
        return false;
    }

    public int deleteByObjectId(final String objectId) throws SQLException {
        final ArrayList param = new ArrayList();
        String sql = new ProxySQL(){
            {
                this.DELETE_FROM("`allinrdm_db`.model_table_field");
                this.WHERE("object_id = ?");
                param.add(objectId);
            }
        }.toString();
        PreparedStatement ps = null;
        Object rs = null;
        try {
            int re;
            ps = this.conn.prepareStatement(sql);
            for (int i = 0; i < param.size(); ++i) {
                ps.setObject(i + 1, param.get(i));
            }
            int n = re = ps.executeUpdate();
            return n;
        }
        catch (Exception e) {
            throw new RuntimeException("insert is wrong", e);
        }
        finally {
            if (ps != null) {
                try {
                    ps.close();
                }
                catch (SQLException e) {
                    logger.error(e.getMessage(), (Throwable)e);
                }
            }
        }
    }

    public int deleteByAppId(final String appId) throws SQLException {
        final ArrayList param = new ArrayList();
        String sql = new ProxySQL(){
            {
                this.DELETE_FROM("`allinrdm_db`.model_table_field");
                this.WHERE("object_id in ( select object_id from `allinrdm_db`.model_table_info where app_id = ? )");
                param.add(appId);
            }
        }.toString();
        PreparedStatement ps = null;
        Object rs = null;
        try {
            int re;
            ps = this.conn.prepareStatement(sql);
            for (int i = 0; i < param.size(); ++i) {
                ps.setObject(i + 1, param.get(i));
            }
            int n = re = ps.executeUpdate();
            return n;
        }
        catch (Exception e) {
            throw new RuntimeException("deleteByAppId is wrong", e);
        }
        finally {
            if (ps != null) {
                try {
                    ps.close();
                }
                catch (SQLException e) {
                    logger.error(e.getMessage(), (Throwable)e);
                }
            }
        }
    }

    public List<ModelTableField> queryDuplicateField(final String appId) throws Exception {
        final ArrayList param = new ArrayList();
        String sql = new ProxySQL(){
            {
                this.SELECT("field_code, object_id");
                this.FROM("`allinrdm_db`.model_table_field t");
                this.WHERE("exists (  select object_id from `allinrdm_db`.model_table_info where app_id = ?  and object_id = t.object_id  )");
                param.add(appId);
                this.GROUP_BY("field_code, object_id");
                this.HAVING("count(1) > 1");
            }
        }.toString();
        PreparedStatement ps = null;
        ResultSet rs = null;
        ArrayList<ModelTableField> list = new ArrayList<ModelTableField>();
        try {
            ps = this.conn.prepareStatement(sql);
            for (int i = 0; i < param.size(); ++i) {
                ps.setObject(i + 1, param.get(i));
            }
            rs = ps.executeQuery();
            while (rs.next()) {
                ModelTableField bean = (ModelTableField)((Object)POJOUtils.generatePOJO((ResultSet)rs, ModelTableField.class));
                list.add(bean);
            }
        }
        catch (Exception e) {
            throw new RuntimeException("queryDuplicateTable is wrong", e);
        }
        finally {
            if (ps != null) {
                try {
                    ps.close();
                }
                catch (SQLException e) {
                    logger.error(e.getMessage(), (Throwable)e);
                }
            }
        }
        return list;
    }

    public List<ModelTableField> queryFieldWithoutFieldLength(final String appId) throws Exception {
        final ArrayList param = new ArrayList();
        String sql = new ProxySQL(){
            {
                this.SELECT("t.*, mt.object_code, mt.object_name");
                this.FROM("`allinrdm_db`.model_table_field t");
                this.LEFT_OUTER_JOIN("`allinrdm_db`.pub_dbms_datatype pd on t.field_type = pd.DBMS_DATATYPE_CODE and dbms_id = (select biz_db_dbms from `allinpaas_db`.paas_apps_info where app_id =  ?)");
                param.add(appId);
                this.JOIN("`allinrdm_db`.model_table_info mt on mt.app_id = ? and mt.object_id = t.object_id");
                param.add(appId);
                this.WHERE("ifnull(field_length, '') = ''");
                this.WHERE("pd.IS_NEED_LENGTH = 'Y'");
            }
        }.toString();
        PreparedStatement ps = null;
        ResultSet rs = null;
        ArrayList<ModelTableField> list = new ArrayList<ModelTableField>();
        try {
            ps = this.conn.prepareStatement(sql);
            for (int i = 0; i < param.size(); ++i) {
                ps.setObject(i + 1, param.get(i));
            }
            rs = ps.executeQuery();
            while (rs.next()) {
                ModelTableField bean = (ModelTableField)((Object)POJOUtils.generatePOJO((ResultSet)rs, ModelTableField.class));
                list.add(bean);
            }
        }
        catch (Exception e) {
            throw new RuntimeException("queryFieldWithoutFieldLength is wrong", e);
        }
        finally {
            if (ps != null) {
                try {
                    ps.close();
                }
                catch (SQLException e) {
                    logger.error(e.getMessage(), (Throwable)e);
                }
            }
        }
        return list;
    }

    public List<ModelTableField> queryModelTableFieldListWithCond(final ModelTableField paramVO) {
        final ArrayList param = new ArrayList();
        String sql = new ProxySQL(){
            {
                this.SELECT("*");
                this.FROM("`allinrdm_db`.model_table_field");
                List vals = POJOUtils.getPOJOValues((Object)((Object)paramVO));
                for (Object[] val : vals) {
                    this.WHERE(String.format("%s = ?", val[0].toString()));
                    param.add(val[1]);
                }
            }
        }.toString();
        PreparedStatement ps = null;
        ResultSet rs = null;
        ArrayList<ModelTableField> list = new ArrayList<ModelTableField>();
        try {
            ps = this.conn.prepareStatement(sql);
            for (int i = 0; i < param.size(); ++i) {
                ps.setObject(i + 1, param.get(i));
            }
            rs = ps.executeQuery();
            while (rs.next()) {
                ModelTableField bean = (ModelTableField)((Object)POJOUtils.generatePOJO((ResultSet)rs, ModelTableField.class));
                list.add(bean);
            }
        }
        catch (Exception e) {
            throw new RuntimeException("queryModelTableFieldListWithCond is wrong", e);
        }
        finally {
            if (ps != null) {
                try {
                    ps.close();
                }
                catch (SQLException e) {
                    logger.error(e.getMessage(), (Throwable)e);
                }
            }
        }
        return list;
    }

    public List<ModelTableField> queryInoutPkFieldList(final String inoutObjectId, final String tableModelId, final String srvModelIoflag) {
        final ArrayList param = new ArrayList();
        String sql = new ProxySQL(){
            {
                this.SELECT("*");
                this.FROM("`allinrdm_db`.model_table_field f ");
                this.WHERE("field_code in ( select field_code from `allinrdm_db`.model_table_field tf where tf.object_id = ? and is_pk = 'Y' )");
                param.add(tableModelId);
                this.OR();
                this.WHERE("field_code in ( select field_code from `allinrdm_db`.model_table_field tf where tf.object_id in (select object_id from `allinpaas_db`.model_join_detail jd where jd.join_detail_id = ? ) and is_pk = 'Y' )");
                param.add(tableModelId);
                this.AND();
                this.WHERE("object_id = ?");
                param.add(inoutObjectId);
                if (srvModelIoflag != null) {
                    this.WHERE("srv_model_ioflag = ?");
                    param.add(srvModelIoflag);
                }
            }
        }.toString();
        PreparedStatement ps = null;
        ResultSet rs = null;
        ArrayList<ModelTableField> list = new ArrayList<ModelTableField>();
        try {
            ps = this.conn.prepareStatement(sql);
            for (int i = 0; i < param.size(); ++i) {
                ps.setObject(i + 1, param.get(i));
            }
            rs = ps.executeQuery();
            while (rs.next()) {
                ModelTableField bean = (ModelTableField)((Object)POJOUtils.generatePOJO((ResultSet)rs, ModelTableField.class));
                list.add(bean);
            }
        }
        catch (Exception e) {
            throw new RuntimeException("queryModelTableFieldListWithCond is wrong", e);
        }
        finally {
            if (ps != null) {
                try {
                    ps.close();
                }
                catch (SQLException e) {
                    logger.error(e.getMessage(), (Throwable)e);
                }
            }
        }
        return list;
    }

    public ResultSet queryFieldBySubsId(final String subsId, final List<Integer> objectType) throws Exception {
        final ArrayList param = new ArrayList();
        String sql = new ProxySQL(){
            {
                this.SELECT("ff.*");
                this.FROM("`allinrdm_db`.model_table_field ff");
                param.add(subsId);
                ArrayList<String> qus = new ArrayList<String>();
                for (Integer val : objectType) {
                    qus.add("?");
                    param.add(val);
                }
                this.WHERE(String.format("exists ( select tb.object_id from `allinrdm_db`.model_table_info tb where tb.app_id in  ( SELECT app_id FROM `allinpaas_db`.paas_apps_info WHERE subs_id = ? )  and tb.object_id = ff.object_id and tb.object_type in ( %s ))", StringUtils.join((Object[])qus.toArray(new String[0]), (String)",")));
            }
        }.toString();
        PreparedStatement ps = null;
        ResultSet rs = null;
        ArrayList list = new ArrayList();
        try {
            ps = this.conn.prepareStatement(sql);
            for (int i = 0; i < param.size(); ++i) {
                ps.setObject(i + 1, param.get(i));
            }
            rs = ps.executeQuery();
        }
        catch (Exception e) {
            throw new RuntimeException("query queryFieldBySubsId is wrong", e);
        }
        return rs;
    }

    public List<ModelTableField> batchQueryInoutPkFieldList(List<String> inoutObjectIds, List<String> tableModelIds, String SrvParamFlag) {
        String querySql = "SELECT *\nFROM `allinrdm_db`.model_table_field\nWHERE (field_code in (select field_code from `allinrdm_db`.model_table_field tf where tf.object_id in( '" + tableModelIds.stream().map(s -> "?").collect(Collectors.joining(",")) + "') and is_pk = 'Y'))\n   OR (field_code in (select field_code\n                      from `allinrdm_db`.model_table_field tf\n                      where tf.object_id in\n                            (select object_id from `allinpaas_db`.model_join_detail jd where jd.join_detail_id in( '" + tableModelIds.stream().map(s -> "?").collect(Collectors.joining(",")) + "'))\n                        and is_pk = 'Y'))  AND (object_id in( '" + inoutObjectIds.stream().map(s -> "?").collect(Collectors.joining(",")) + "'))";
        if (StringUtils.isNotEmpty((String)SrvParamFlag)) {
            querySql = querySql + " srv_model_ioflag = ?";
        }
        PreparedStatement ps = null;
        ResultSet rs = null;
        ArrayList<ModelTableField> list = new ArrayList<ModelTableField>();
        try {
            ps = this.conn.prepareStatement(querySql);
            int paramIndex = 1;
            for (String tableModelId : tableModelIds) {
                ps.setObject(paramIndex, tableModelId);
                ++paramIndex;
            }
            for (String tableModelId : tableModelIds) {
                ps.setObject(paramIndex, tableModelId);
                ++paramIndex;
            }
            for (String objectId : inoutObjectIds) {
                ps.setObject(paramIndex, objectId);
                ++paramIndex;
            }
            if (StringUtils.isNotEmpty((String)SrvParamFlag)) {
                ps.setObject(paramIndex, SrvParamFlag);
                ++paramIndex;
            }
            rs = ps.executeQuery();
            while (rs.next()) {
                ModelTableField bean = (ModelTableField)((Object)POJOUtils.generatePOJO((ResultSet)rs, ModelTableField.class));
                list.add(bean);
            }
        }
        catch (Exception e) {
            throw new RuntimeException("queryModelTableFieldListWithCond is wrong", e);
        }
        finally {
            if (ps != null) {
                try {
                    ps.close();
                }
                catch (SQLException e) {
                    logger.error(e.getMessage(), (Throwable)e);
                }
            }
        }
        return list;
    }

    public List<ModelTableField> queryDataMarkerFieldByPage(final ModelTableField paramVO) throws Exception {
        final List<String> objectType = Arrays.asList(ObjectType.Table.getCode(), ObjectType.Main.getCode(), ObjectType.Second.getCode());
        final ArrayList param = new ArrayList();
        String sql = new ProxySQL(){
            {
                this.SELECT("t.object_code, t.object_name, ff.*, (select dict_code from `allinrdm_db`.dict_option_info where dict_id = ff.pre_dict_id limit 1) as pre_field_option");
                this.FROM("`allinrdm_db`.model_table_field ff join `allinrdm_db`.model_table_info t on ff.object_id = t.object_id ");
                if (StringUtils.isBlank((String)paramVO.getAppId()) && StringUtils.isBlank((String)paramVO.getBizDbName())) {
                    this.WHERE("t.app_id in ( SELECT app_id FROM `allinpaas_db`.paas_apps_info WHERE subs_id = ? ) ");
                    param.add(paramVO.getSubsId());
                } else if (StringUtils.isNotBlank((String)paramVO.getAppId()) && StringUtils.isBlank((String)paramVO.getBizDbName())) {
                    this.WHERE("t.app_id in ( SELECT app_id FROM `allinpaas_db`.paas_apps_info WHERE subs_id = ? and app_id = ? ) ");
                    param.add(paramVO.getSubsId());
                    param.add(paramVO.getAppId());
                } else if (StringUtils.isNotBlank((String)paramVO.getBizDbName()) && StringUtils.isBlank((String)paramVO.getAppId())) {
                    this.WHERE("t.app_id in ( SELECT app_id FROM `allinpaas_db`.paas_apps_info WHERE subs_id = ? and biz_db_name = ? ) ");
                    param.add(paramVO.getSubsId());
                    param.add(paramVO.getBizDbName());
                }
                ArrayList<String> qus = new ArrayList<String>();
                for (String val : objectType) {
                    qus.add("?");
                    param.add(val);
                }
                this.WHERE(String.format("t.object_type in ( %s )", StringUtils.join(qus, (String)",")));
                this.WHERE("ff.data_mark_flag is not null");
                this.ORDER_BY("t.order_value, ff.field_order");
            }
        }.toString();
        this.queryTotalRecord(sql, paramVO, param);
        paramVO.checkAndSetPageInfo();
        String limitSql = this.buildPageSql(paramVO, sql);
        PreparedStatement ps = null;
        ResultSet rs = null;
        ArrayList<ModelTableField> list = new ArrayList<ModelTableField>();
        try {
            ps = this.conn.prepareStatement(limitSql);
            for (int i = 0; i < param.size(); ++i) {
                ps.setObject(i + 1, param.get(i));
            }
            rs = ps.executeQuery();
            while (rs.next()) {
                ModelTableField bean = (ModelTableField)((Object)POJOUtils.generatePOJO((ResultSet)rs, ModelTableField.class));
                list.add(bean);
            }
        }
        catch (Exception e) {
            throw new RuntimeException("querySysFieldCheckByPage is wrong", e);
        }
        finally {
            if (ps != null) {
                try {
                    ps.close();
                }
                catch (SQLException e) {
                    logger.error(e.getMessage(), (Throwable)e);
                }
            }
        }
        return list;
    }
}

