/*
 * Decompiled with CFR 0.152.
 */
package com.irdstudio.allinapaas.executor.application.executor.core.dao;

import com.irdstudio.allinapaas.executor.application.executor.core.dao.domain.PaasEnvParam;
import com.irdstudio.allinapaas.executor.application.executor.core.util.db.ProxySQL;
import com.irdstudio.sdk.beans.core.util.POJOUtils;
import com.irdstudio.sdk.beans.core.util.PropertiesUtil;
import com.irdstudio.sdk.beans.core.util.RSAUtility;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PaasEnvParamDao {
    private static final Logger logger = LoggerFactory.getLogger(PaasEnvParamDao.class);
    Connection conn = null;
    private boolean localDebugModel = false;

    public PaasEnvParamDao(Connection conn) {
        this.conn = conn;
        this.localDebugModel = Boolean.valueOf(PropertiesUtil.getPropertyByKey((String)"application", (String)"localDebugModel"));
    }

    public List<PaasEnvParam> queryPaasEnvParamList(final PaasEnvParam paramVO) {
        final ArrayList param = new ArrayList();
        String sql = new ProxySQL(){
            {
                this.SELECT("*");
                this.FROM("paas_env_param");
                List vals = POJOUtils.getPOJOValues((Object)((Object)paramVO));
                for (Object[] val : vals) {
                    this.WHERE(String.format("%s = ?", val[0].toString()));
                    param.add(val[1]);
                }
            }
        }.toString();
        PreparedStatement ps = null;
        ResultSet rs = null;
        ArrayList<PaasEnvParam> list = new ArrayList<PaasEnvParam>();
        try {
            ps = this.conn.prepareStatement(sql);
            for (int i = 0; i < param.size(); ++i) {
                ps.setObject(i + 1, param.get(i));
            }
            rs = ps.executeQuery();
            while (rs.next()) {
                PaasEnvParam bean = (PaasEnvParam)((Object)POJOUtils.generatePOJO((ResultSet)rs, PaasEnvParam.class));
                list.add(bean);
            }
        }
        catch (Exception e) {
            throw new RuntimeException("query queryPaasEnvParamList is wrong", e);
        }
        return list;
    }

    public PaasEnvParam queryByCode(final String paramCode, final String envId) {
        if (this.localDebugModel) {
            String value = PropertiesUtil.getPropertyByKey((String)"application", (String)paramCode);
            PaasEnvParam envParam = new PaasEnvParam();
            envParam.setParamCode(paramCode);
            envParam.setParamValue(value);
            if (StringUtils.isNotBlank((CharSequence)value)) {
                return envParam;
            }
        }
        final ArrayList param = new ArrayList();
        String sql = new ProxySQL(){
            {
                this.SELECT("*");
                this.FROM("paas_env_param");
                this.WHERE("param_code = ?");
                param.add(paramCode);
                if (envId != null) {
                    this.WHERE("env_id = ?");
                    param.add(envId);
                }
            }
        }.toString();
        PreparedStatement ps = null;
        ResultSet rs = null;
        ArrayList<PaasEnvParam> list = new ArrayList<PaasEnvParam>();
        try {
            ps = this.conn.prepareStatement(sql);
            for (int i = 0; i < param.size(); ++i) {
                ps.setObject(i + 1, param.get(i));
            }
            rs = ps.executeQuery();
            while (rs.next()) {
                PaasEnvParam bean = (PaasEnvParam)((Object)POJOUtils.generatePOJO((ResultSet)rs, PaasEnvParam.class));
                list.add(bean);
                if (!bean.getParamCode().equals("git.password")) continue;
                try {
                    String password = RSAUtility.decryptByBase64((String)bean.getParamValue(), (String)PropertiesUtil.getPropertyByKey((String)"key", (String)"rsa.privateKey"));
                    bean.setParamValue(password);
                }
                catch (Exception e) {
                    logger.error("\u89e3\u5bc6\u5931\u8d25", (Throwable)e);
                }
            }
        }
        catch (Exception e) {
            throw new RuntimeException("query queryByCode is wrong", e);
        }
        return list.isEmpty() ? null : (PaasEnvParam)((Object)list.get(0));
    }

    public String queryByCodeReturnValue(String paramCode) {
        PaasEnvParam envParam = this.queryByCode(paramCode, "paas");
        return envParam == null ? null : envParam.getParamValue();
    }

    public String queryByCodeReturnValue(String paramCode, String envId) {
        PaasEnvParam envParam = this.queryByCode(paramCode, envId);
        return envParam == null ? null : envParam.getParamValue();
    }

    public boolean updateByPk(final PaasEnvParam paramVO) throws Exception {
        int rs;
        final ArrayList param = new ArrayList();
        String sql = new ProxySQL(){
            {
                this.UPDATE("paas_env_param");
                List vals = POJOUtils.getPOJOValues((Object)((Object)paramVO));
                for (Object[] val : vals) {
                    if (val[0].toString().equals("param_code")) continue;
                    this.SET(String.format("%s = ?", val[0].toString()));
                    param.add(val[1]);
                }
                this.WHERE("param_code = ? ");
                param.add(paramVO.getParamCode());
                this.WHERE("env_id = ? ");
                param.add(paramVO.getEnvId());
            }
        }.toString();
        PreparedStatement ps = null;
        try {
            ps = this.conn.prepareStatement(sql);
            for (int i = 0; i < param.size(); ++i) {
                ps.setObject(i + 1, param.get(i));
            }
            rs = ps.executeUpdate();
        }
        catch (Exception e) {
            throw new RuntimeException("query updateByPk is wrong", e);
        }
        return rs == 1;
    }

    public boolean insert(final PaasEnvParam paramVO) throws Exception {
        int rs;
        final ArrayList param = new ArrayList();
        String sql = new ProxySQL(){
            {
                this.INSERT_INTO("paas_env_param");
                List vals = POJOUtils.getPOJOValues((Object)((Object)paramVO));
                for (Object[] val : vals) {
                    this.VALUES(val[0].toString(), "?");
                    param.add(val[1]);
                }
            }
        }.toString();
        PreparedStatement ps = null;
        try {
            ps = this.conn.prepareStatement(sql);
            for (int i = 0; i < param.size(); ++i) {
                ps.setObject(i + 1, param.get(i));
            }
            rs = ps.executeUpdate();
        }
        catch (Exception e) {
            throw new RuntimeException("insert is wrong", e);
        }
        return rs == 1;
    }
}

